"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 表单组件
 * @param {[type]} dataModel [description]
 */
var Form = /*#__PURE__*/function (_ContainerComponent) {
  (0, _inherits2["default"])(Form, _ContainerComponent);

  var _super = _createSuper(Form);

  function Form(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, Form);
    _this = _super.call(this, __tfp, "Form", dataModel, parent);
    _this._data = null;
    return _this;
  } //loadDataService属性


  (0, _createClass2["default"])(Form, [{
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    } //dataBindingMember属性

  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    } //submitService属性

  }, {
    key: "submitService",
    get: function get() {
      return this.dataModel.submitService;
    },
    set: function set(value) {
      this.dataModel.submitService = value;
    } //是否显示提交成功提示

  }, {
    key: "showSubmitSuccessHint",
    get: function get() {
      return this.dataModel.showSubmitSuccessHint ? true : false;
    },
    set: function set(value) {
      this.dataModel.showSubmitSuccessHint = value ? true : false;
    }
    /**
     * 批量设置输入项属性
     * @param {*} components 
     * @param {*} attrName 
     * @param {*} attrVal 
     */

  }, {
    key: "batchSetIptAttr",
    value: function batchSetIptAttr(components, attrName, attrVal) {
      var _this2 = this;

      if (components) {
        components.forEach(function (cdm) {
          var cpt = _this2._tfp.get(cdm.id);

          if (cpt.isFormInput) {
            cpt[attrName] = attrVal;
          }

          if (cdm.components) _this2.batchSetIptAttr(cdm.components, attrName, attrVal);
        });
      }
    }
    /**
     * 禁用所有输入项
     */

  }, {
    key: "disableAllInputs",
    value: function disableAllInputs() {
      this.batchSetIptAttr(this.dataModel.components, "disabled", true);
    }
    /**
     * 启用所有输入项
     */

  }, {
    key: "enableAllInputs",
    value: function enableAllInputs() {
      this.batchSetIptAttr(this.dataModel.components, "disabled", false);
    }
    /**
     * 设置所有输入项只读
     */

  }, {
    key: "setAllInputsReadOnly",
    value: function setAllInputsReadOnly() {
      this.batchSetIptAttr(this.dataModel.components, "readonly", true);
    }
    /**
     * 设置所有输入项可写
     */

  }, {
    key: "setAllInputsWritable",
    value: function setAllInputsWritable() {
      this.batchSetIptAttr(this.dataModel.components, "readonly", false);
    }
    /**
     * 设置所有输入项必填
     */

  }, {
    key: "setAllInputsRequired",
    value: function setAllInputsRequired() {
      this.batchSetIptAttr(this.dataModel.components, "required", true);
    }
    /**
     * 取消所有输入项必填
     */

  }, {
    key: "cancelAllInputsRequired",
    value: function cancelAllInputsRequired() {
      this.batchSetIptAttr(this.dataModel.components, "required", false);
    }
    /**
     * 校验表单输入项的数据是否符合要求
     * @param  {[type]} ipt  [description]
     * @param  {[type]} args [description]
     * @return {[type]}      [description]
     */

  }, {
    key: "checkInputData",
    value: function checkInputData(cdm, args) {
      var cpt = this._tfp.get(cdm.id);

      var cptTypeInfo = this._tfp.type(cpt.type);

      if (cpt.isFormInput) {
        if (cpt.required && (isNull(cpt.value) || (cpt.value + "").trim() == "" || Array.isArray(cpt.value) && cpt.value.length == 0)) {
          if (cpt.comment) {
            this._tfp.showMsg(cpt.comment + "不能为空！", function () {
              if (cpt.focus) cpt.focus();
            });
          } else {
            this._tfp.showMsg(cpt.id + "不能为空！", function () {
              if (cpt.focus) cpt.focus();
            });
          }

          return false;
        }

        if (!isNull(cpt.value) && cpt.dataModel.verify && (0, _typeof2["default"])(cpt.dataModel.verify) == 'object' && cpt.dataModel.verify.verify && cpt.dataModel.verify.verifyMsg) {
          var reg = new RegExp(cpt.dataModel.verify.verify);

          if (!reg.test(cpt.value.toString())) {
            this._tfp.showMsg(cpt.dataModel.verify.verifyMsg, function () {
              if (cpt.focus) cpt.focus();
            });

            return false;
          }
        }

        if (!isNull(cpt.value) && cpt.type == "Text" && cpt.dataModel.subDataType) {
          if (cpt.focus) cpt.focus();
          if (!this._tfp.runVerify(cpt)) return false;
        }

        if (!isNull(cpt.value)) {
          args[cpt.id] = cpt.value;
          /*if(ipt.type=="DateTime" && ipt.value.length<19) {
            args[ipt.id] = ipt.value + ":00";
          } else if(ipt.type=="Date" && ipt.value.length<19) {
            args[ipt.id] = ipt.value + " 0:00:00";
          }*/
        } //如果该组件的数据需要加密发送


        if (cpt.dataModel.encrypted && this.dataModel.dataSubmitSetting) {
          if (!this.dataModel.dataSubmitSetting.encryptRequestArgs) this.dataModel.dataSubmitSetting.encryptRequestArgs = "";
          var encArgs = this.dataModel.dataSubmitSetting.encryptRequestArgs.split(',');
          if (!encArgs.contains(cpt.id)) encArgs.push(cpt.id);
          this.dataModel.dataSubmitSetting.encryptRequestArgs = encArgs.join(",");
        }
      } else if (cpt.type == "DataSet") {
        var rows = cpt.getRowsData({
          checkRequired: true
        });
        if (!rows) return false;
        args[cpt.id] = rows;
      }

      var isOK = true;

      if (cdm.components) {
        for (var i = 0; i < cdm.components.length; i++) {
          isOK = this.checkInputData(cdm.components[i], args);
          if (!isOK) return false;
        }
      }

      return isOK;
    }
  }, {
    key: "submit",
    value: function submit() {
      if (!this.dataModel.submitService && !(this.dataModel.dataSubmitSetting && (this.dataModel.dataSubmitSetting.serviceCpt || this.dataModel.dataSubmitSetting.servicePath))) {
        this._tfp.showMsg("请为[" + this.id + "]设置数据提交有关参数！");

        return;
      }

      if (this.dataModel.onBeforeSubmit) {
        var ret = eval(this.dataModel.onBeforeSubmit);
        if (!ret) return;
      } //对表单内的输入项的数据进行校验，并生成请求参数


      var args = {};
      var isOK = true;

      if (this.dataModel.components) {
        for (var i = 0; i < this.dataModel.components.length; i++) {
          isOK = this.checkInputData(this.dataModel.components[i], args);
          if (!isOK) return;
        }
      }

      var that = this;

      if (this.dataModel.dataSubmitSetting && this.dataModel.dataSubmitSetting.servicePath) {
        var options = {
          servicePath: this.dataModel.dataSubmitSetting.servicePath,
          autoShowError: true,
          showLoading: true,
          //encryptRequestArgs,
          args: args
        };

        if (that.dataModel.dataSubmitSetting.requestArgs && that.dataModel.dataSubmitSetting.requestArgs.length > 0) {
          options.argSettings = that.dataModel.dataSubmitSetting.requestArgs;
        }

        if (that.dataModel.dataSubmitSetting.encryptRequestArgs) options.encryptRequestArgs = that.dataModel.dataSubmitSetting.encryptRequestArgs;
        if (that.dataModel.dataSubmitSetting.encryptResponseArgs) options.encryptResponseArgs = that.dataModel.dataSubmitSetting.encryptResponseArgs;

        this._tfp.request(options, function (req, res) {
          if (that.dataModel.showSubmitSuccessHint) that._tfp.showMsg("提交成功！");
          that.exeEventHandler("onAfterSubmit", req, res);
        });

        return;
      }

      var serviceId = this.dataModel.submitService;

      if (this.dataModel.dataSubmitSetting && this.dataModel.dataSubmitSetting.serviceCpt) {
        serviceId = this.dataModel.dataSubmitSetting.serviceCpt;
      }

      var serviceCpt = this._tfp.get(serviceId);

      if (!serviceCpt) {
        this._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");

        return;
      }

      serviceCpt.request(args, function (req, res) {
        if (that.dataModel.showSubmitSuccessHint) that._tfp.showMsg("提交成功！");
        that.exeEventHandler("onAfterSubmit", req, res);
        /*if(that._tfp.curPage.pagetype=="dialog") {
          onDialogOK({req: req, res: res});
          closeCurDialog();
        }*/
      });
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (!this.dataModel.components || !data) return;
      var formData = data; //如果绑定数据是数组，则取数组的第一个元素作为绑定数据对象

      if (Array.isArray(formData)) {
        if (formData.length == 0) return;
        formData = data[0];
      }

      this._data = formData;

      for (var i = 0; i < this.dataModel.components.length; i++) {
        this._tfp.bindCptData(this.dataModel.components[i], formData);
      }

      this.exeEventHandler("onAfterBindData");
    }
  }, {
    key: "onLoadData",
    value: function onLoadData(req, res) {
      var data = res; //如果设置了数据绑定成员名称，则从服务响应对象中取这个成员对象作为表单的数据源
      //否则，将整个响应对象作为表单的数据源

      if (this.dataModel.dataBindingMember) {
        data = res[this.dataModel.dataBindingMember];
      } else if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
        data = res[this.dataModel.dataQuerySetting.dataMember];
      } //如果是翻页的数据


      if (data.rows && data.pageCount) data = data.rows; //如果是数组

      if (Array.isArray(data)) data = data[0]; //把表单的数据先缓存起来，以便后续某些场景需要继续使用

      this.dataModel.data = data;
      this.bindData(data);
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
      if (this.dataModel.loadDataService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      }
    }
  }]);
  return Form;
}(_controller.ContainerComponent);

exports["default"] = Form;