"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "FlexBox",
  "comment": "弹性栅格",
  "attrs": [{
    "name": "direction",
    "comment": "排列方向",
    "type": "Select",
    "options": [{
      "value": "row",
      "text": "水平方向"
    }, {
      "value": "column",
      "text": "垂直方向"
    }]
  }, {
    "name": "wrap",
    "comment": "换行",
    "type": "Switch"
  }, {
    "name": "align",
    "comment": "水平对齐方式",
    "type": "Select",
    "options": [{
      "value": "flex-start",
      "text": "左对齐"
    }, {
      "value": "flex-end",
      "text": "右对齐"
    }, {
      "value": "center",
      "text": "居中对齐"
    }, {
      "value": "space-between",
      "text": "两端对齐"
    }, {
      "value": "space-around",
      "text": "等距对齐"
    }]
  }, {
    "name": "valign",
    "comment": "垂直对齐方式",
    "type": "Select",
    "options": [{
      "value": "flex-start",
      "text": "顶部对齐"
    }, {
      "value": "flex-end",
      "text": "底部对齐"
    }, {
      "value": "center",
      "text": "居中对齐"
    }, {
      "value": "baseline",
      "text": "文字基线对齐"
    }, {
      "value": "stretch",
      "text": "自动伸展"
    }]
  }, {
    "name": "items",
    "comment": "元素集合",
    "type": "Dataset",
    "special": true,
    "columns": [{
      "id": "id",
      "name": "ID",
      "type": "String",
      "width": "250px",
      "readonly": true
    }, {
      "id": "flex-grow",
      "name": "扩展量",
      "type": "Int",
      "width": "60px",
      "default": "1",
      "required": true
    }, {
      "id": "flex-shrink",
      "name": "收缩量",
      "type": "Int",
      "width": "60px",
      "default": "0",
      "required": true
    }, {
      "id": "flex-basis",
      "name": "基础值",
      "type": "String",
      "width": "80px",
      "default": "auto",
      "required": true
    }]
  }],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {},
  "events": [{
    "name": "onClick",
    "comment": "点击时"
  }, {
    "name": "onMouseOver",
    "comment": "鼠标经过时"
  }, {
    "name": "onMouseOut",
    "comment": "鼠标移出时"
  }]
};
exports["default"] = _default;