"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 弹性栅格组件
 * @param {[type]} dataModel [description]
 */
var FlexBox = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(FlexBox, _VisibleComponent);

  var _super = _createSuper(FlexBox);

  function FlexBox(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, FlexBox);
    _this = _super.call(this, __tfp, "FlexBox", dataModel, parent);

    if (_this._tfp.isDesigning && (!_this.dataModel.components || _this.dataModel.components.length == 0)) {
      _this.dataModel.components = [{
        id: _this.id + "_panel1",
        type: "Panel",
        isAttached: true,
        styles: {
          // "flex-grow": 0,
          // "flex-shrink": 0,
          "flex-basis": "30%" // "height": "30px",
          // "line-height": "30px"

        }
      }, {
        id: _this.id + "_panel2",
        type: "Panel",
        isAttached: true,
        styles: {
          // "flex-grow": 1,
          // "flex-shrink": 0,
          //"flex-basis": "auto",
          "flex-basis": "60%" // "height": "30px",
          // "line-height": "30px"

        }
      }];
    }

    return _this;
  } //不是容器组件，但可以添加子组件


  (0, _createClass2["default"])(FlexBox, [{
    key: "containerEl",
    get: function get() {
      return this.el;
    }
  }, {
    key: "items",
    get: function get() {
      var items = [];

      if (this.dataModel.components) {
        for (var i = 0; i < this.dataModel.components.length; i++) {
          var itemDM = this.dataModel.components[i];
          items.push({
            id: itemDM.id,
            "flex-grow": itemDM.styles["flex-grow"],
            "flex-shrink": itemDM.styles["flex-shrink"],
            "flex-basis": itemDM.styles["flex-basis"]
          });
        }
      }

      return items;
    },
    set: function set(value) {
      var items = [];
      if (value) items = value;
      var components = [];

      for (var i = 0; i < items.length; i++) {
        var item = items[i];
        var cdm = null;
        var flexGrow = 1;
        if (!isNull(item["flex-grow"])) flexGrow = item["flex-grow"];
        var flexShrink = 0;
        if (!isNull(item["flex-shrink"])) flexShrink = item["flex-shrink"];
        var flexBasis = "auto";
        if (!isNull(item["flex-basis"])) flexBasis = item["flex-basis"];

        if (item.id) {
          var panelChild = this._tfp.components[item.id];
          cdm = panelChild.dataModel;
          cdm.styles["flex-grow"] = flexGrow;
          cdm.styles["flex-shrink"] = flexShrink;
          cdm.styles["flex-basis"] = flexBasis; //delete this._tfp.components[panelChild.id];
        } else {
          cdm = {
            type: "Panel",
            isAttached: true,
            styles: {
              "flex-grow": flexGrow,
              "flex-shrink": flexShrink,
              "flex-basis": flexBasis,
              "height": "30px",
              "line-height": "30px"
            }
          }; //if(i>0) cdm.styles["margin-left"] = "10px";
        }

        components.push(cdm);
      }

      this.clear();
      this.dataModel.components = components;

      this._jqObj.empty(); //this.isRendered = false;
      //this.render();


      for (var i = 0; i < this.dataModel.components.length; i++) {
        var cdmChild = this.dataModel.components[i];

        var cptChild = this._tfp.render(cdmChild, this);
      }
    }
  }, {
    key: "direction",
    get: function get() {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "flex-direction": "row"
        };
      }

      return this.dataModel.styles["flex-direction"];
    },
    set: function set(value) {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "flex-direction": "row"
        };
      }

      this.dataModel.styles["flex-direction"] = value;
      if (this._jqObj) this._jqObj.css("flex-direction", value);
    }
  }, {
    key: "wrap",
    get: function get() {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "flex-wrap": "nowrap"
        };
      }

      return this.dataModel.styles["flex-wrap"];
    },
    set: function set(value) {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "flex-wrap": "nowrap"
        };
      }

      this.dataModel.styles["flex-wrap"] = value ? "wrap" : "nowrap";
      if (this._jqObj) this._jqObj.css("flex-wrap", value);
    }
  }, {
    key: "align",
    get: function get() {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "justify-content": "flex-start"
        };
      }

      return this.dataModel.styles["justify-content"];
    },
    set: function set(value) {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "justify-content": "flex-start"
        };
      }

      this.dataModel.styles["justify-content"] = value;
      if (this._jqObj) this._jqObj.css("justify-content", value);
    }
  }, {
    key: "valign",
    get: function get() {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "align-items": "stretch"
        };
      }

      return this.dataModel.styles["align-items"];
    },
    set: function set(value) {
      if (!this.dataModel.styles) {
        this.dataModel.styles = {
          "align-items": "stretch"
        };
      }

      this.dataModel.styles["align-items"] = value;
      if (this._jqObj) this._jqObj.css("align-items", value);
    }
  }, {
    key: "hasAttachedChilds",
    get: function get() {
      return true;
    }
  }, {
    key: "show",
    value: function show() {
      if (this._jqObj) this._jqObj.css("display", "flex");
    }
  }]);
  return FlexBox;
}(_controller.VisibleComponent);

exports["default"] = FlexBox;