"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "FileUpload",
  "comment": "文件上传",
  "cssFiles": ["style.css", "../button/style.{bgColorMode}.css"],
  "attrs": [{
    "name": "uploadSetting",
    "comment": "上传设置",
    "type": "group",
    "items": [{
      "name": "btnText",
      "comment": "按钮文本",
      "type": "String",
      "default": "上传文件"
    }, {
      "name": "comment",
      "comment": "组件备注",
      "type": "String"
    }, {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    }, {
      "name": "fileType",
      "comment": "文件类型",
      "type": "String"
    }, {
      "name": "appCode",
      "comment": "应用代码",
      "type": "String"
    }, {
      "name": "appDataId",
      "comment": "应用数据ID",
      "type": "String"
    }, {
      "name": "enIde",
      "comment": "启用身份验证",
      "type": "Switch"
    }, {
      "name": "showStyle",
      "comment": "显示样式",
      "type": "Select",
      "default": "defaultMode",
      "options": [{
        "value": "defaultMode",
        "text": "详情列表"
      }, {
        "value": "bigIconMode",
        "text": "大图标"
      }]
    }, {
      "name": "size",
      "comment": "文件总数",
      "type": "Number",
      "default": 10
    }, {
      "name": "required",
      "comment": "必填",
      "type": "Switch"
    }, {
      "name": "allowUpload",
      "comment": "允许上传",
      "type": "Switch",
      "default": true
    }, {
      "name": "allowDelete",
      "comment": "允许删除",
      "type": "Switch",
      "default": true
    }, {
      "name": "transverse",
      "comment": "横向显示",
      "type": "Switch"
    }]
  }],
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "defaultStyles": {
    "overflow": "auto"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击时"
  }, {
    "name": "onChange",
    "comment": "值发生变化时",
    "isNotHtmlEvent": true
  }, {
    "name": "onBeforeUpload",
    "comment": "上传前",
    "isNotHtmlEvent": true
  }, {
    "name": "onAfterUpload",
    "comment": "上传后",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;