"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 文件上传组件
 * @param {[type]} dataModel [description]
 */
var FileUpload = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(FileUpload, _FormInput);

  var _super = _createSuper(FileUpload);

  function FileUpload(__tfp, dataModel, parent, inputType) {
    var _this;

    (0, _classCallCheck2["default"])(this, FileUpload);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "FileUpload", dataModel, parent);
    }

    return (0, _possibleConstructorReturn2["default"])(_this);
  } //应用代码


  (0, _createClass2["default"])(FileUpload, [{
    key: "appCode",
    get: function get() {
      return this.dataModel.appCode;
    },
    set: function set(value) {
      this.dataModel.appCode = value;
    } //应用数据ID

  }, {
    key: "appDataId",
    get: function get() {
      return this.dataModel.appDataId;
    },
    set: function set(value) {
      this.dataModel.appDataId = value;
    } //是否验证身份

  }, {
    key: "enIde",
    get: function get() {
      return this.dataModel.enIde;
    },
    set: function set(value) {
      this.dataModel.enIde = value;
    } //文件类型

  }, {
    key: "fileType",
    get: function get() {
      return this.dataModel.fileType;
    },
    set: function set(value) {
      this.dataModel.fileType = value;
    } //文件总数

  }, {
    key: "size",
    get: function get() {
      return this.dataModel.size;
    },
    set: function set(value) {
      this.dataModel.size = value;
    } //允许上传

  }, {
    key: "allowUpload",
    get: function get() {
      return this.dataModel.allowUpload;
    },
    set: function set(value) {
      this.dataModel.allowUpload = value;
    } //允许删除

  }, {
    key: "allowDelete",
    get: function get() {
      return this.dataModel.allowDelete;
    },
    set: function set(value) {
      this.dataModel.allowDelete = value;
    } // 按钮文本

  }, {
    key: "btnText",
    get: function get() {
      return this.dataModel.btnText;
    },
    set: function set(value) {
      this.dataModel.btnText = value;

      if (this._jqObj) {
        this._jqObj.find(".tfp-button").val(value);

        this.exeEventHandler("onChange");
      }
    }
  }, {
    key: "transverse",
    get: function get() {
      return this.dataModel.transverse;
    },
    set: function set(value) {
      this.dataModel.transverse = value ? true : false;
    }
  }, {
    key: "showStyle",
    get: function get() {
      return this.dataModel.showStyle;
    },
    set: function set(value) {
      this.dataModel.showStyle = value;
    }
  }, {
    key: "value",
    get: function get() {
      var val = [];
      if (!this.files) this.files = [];

      for (var i = 0; i < this.files.length; i++) {
        var f = this.files[i];
        val.push({
          name: f.name,
          code: f.code,
          size: f.size,
          appCode: this.appCode,
          appDataId: this.appDataId
        });
      }

      this.dataModel.value = val;
      return val;
    },
    set: function set(value) {
      if (!value) return;
      var val = value;

      if (typeof val == "string") {
        if (val.startsWith("[") && val.endsWith("]")) {
          val = JSON.parse(val);
        } else {
          //如果绑定的是某一个附件的附件代码，则查询该附件的信息
          var regex = /^[A-Za-z0-9]{32}$/;

          if (regex.test(val)) {
            this.onAfterBindData({
              fileCode: val
            });
            return;
          }
        }
      }

      if (!Array.isArray(val)) return;
      this.files = val;
      this.dataModel.value = val;

      if (this._jqObj) {
        this._jqObj.find(".tfp-fileupload-fileinfo").each(function () {
          $(this).parent().remove();
        });

        for (var i = 0; i < this.dataModel.value.length; i++) {
          var fileInfo = this.dataModel.value[i];
          var fileHtml = "<div class=\"tfp-fileupload-row\"><p class=\"tfp-fileupload-fileinfo";
          if (this.dataModel.showStyle == "bigIconMode") fileHtml += " tfp-fileupload-row-p";
          fileHtml += "\">";

          if (this.dataModel.showStyle == "bigIconMode") {
            fileHtml += "<img style=\"width:40px;\" src=\"" + this.getBigIcon(fileInfo.name) + "\" align=\"absmiddle\" />";
          } else {
            fileHtml += "<img src=\"/node_modules/tfp/src/components/fileupload/images/attach.png\" align=\"absmiddle\" />&nbsp;&nbsp;";
          } //任讯的文件下载需要调用扩展


          if (typeof tmClient != "undefined" && (tmClient.clientOSType == "iOS" && typeof window.webkit != "undefined" || tmClient.clientOSType == "Android" && typeof window.TMAndroidClient != "undefined")) {
            fileHtml += "<a href=\"javascript:void(0)\" onclick=\"tmClient.downFromUrl({url:'/Download?fileCode=" + fileInfo.code + "', fileName:'" + fileInfo.name + "', fileCode: '" + fileInfo.code + "'})\"";
            if (this.dataModel.showStyle == "bigIconMode") fileHtml += " class=\"tfp-fileupload-row-a\"";
            fileHtml += ">";
          } else {
            fileHtml += "<a href=\"/Download?fileCode=" + fileInfo.code + "\"";
            if (this.dataModel.showStyle == "bigIconMode") fileHtml += " title=\"" + fileInfo.name + "\"  class=\"tfp-fileupload-row-a\"";
            fileHtml += ">";
          }

          fileHtml += fileInfo.name + "</a>";

          if (this.dataModel.allowDelete) {
            if (this.dataModel.showStyle == "bigIconMode") fileHtml += "<a href=\"javascript:void(0)\" ";else fileHtml += "&nbsp;&nbsp;<a href=\"javascript:void(0)\" ";
            fileHtml += "file-code=\"" + fileInfo.code + "\">删除</a>";
          }

          fileHtml += "</p></div>";

          this._jqObj.append(fileHtml);
        }

        if (this.dataModel.allowDelete) {
          var that = this;

          this._jqObj.find("a").click(function () {
            var fileCodeDel = $(this).attr("file-code");
            if (fileCodeDel) that.deleteFile(this, fileCodeDel);
          });
        }

        this.exeEventHandler("onChange");
      }
    }
  }, {
    key: "selectFile",
    value: function selectFile() {
      if (!this.dataModel.size) this.dataModel.size = 10;

      if (this.files && this.files.length >= this.dataModel.size) {
        this._tfp.showMsg("最多只能上传" + this.dataModel.size + "个文件！");

        return;
      }

      var that = this; //如果是任讯APP，需要调用扩展上传文件

      if (typeof tmClient != "undefined" && (tmClient.clientOSType == "iOS" && typeof window.webkit != "undefined" || tmClient.clientOSType == "Android" && typeof window.TMAndroidClient != "undefined")) {
        tmClient.showFilePicker(false, function (files) {
          that.onTMClientSelectFile(files[0]);
        });
      } else {
        var uploadHtml = "<div class=\"tfp-fileupload-row\" style=\"display:none\">" + "<input type=\"file\" style=\"display:none\" /><p class=\"tfp-fileupload-fileinfo";
        if (this.dataModel.showStyle == "bigIconMode") uploadHtml += " tfp-fileupload-row-p";
        uploadHtml += "\">";
        uploadHtml += "<img src=\"/node_modules/tfp/src/components/fileupload/images/attach.png\" align=\"absmiddle\" /></p>";
        uploadHtml += "<p><progress value=\"0\" max=\"100\"></progress>&nbsp;" + "<span class=\"uploaderPercent\">0%</span></p></div>";

        this._jqObj.append(uploadHtml);

        var uploadIpt = this._jqObj.find(".tfp-fileupload-row").last().find("input");

        var _that = this;

        uploadIpt.change(function () {
          _that.uploadFile(this);
        });
        uploadIpt.click();
      }
    }
  }, {
    key: "onTMClientSelectFile",
    value: function onTMClientSelectFile(file) {
      if (!this.files) this.files = [];

      for (var i = 0; i < this.files.length; i++) {
        var f = this.files[i];

        if (f.path == file.path) {
          this._tfp.showMsg("该文件已添加！");

          return;
        }
      } //检查文件类型


      var fileName = file.path.substr(file.path.lastIndexOf("/") + 1);

      if (this.dataModel.fileType) {
        var isValidType = true;
        var end = fileName.lastIndexOf(".");

        if (end >= 0) {
          var filetype = fileName.substr(end);
          if (!this.dataModel.fileType.toLowerCase().split(",").contains(filetype.toLowerCase())) isValidType = false;
        } else {
          isValidType = false;
        }

        if (!isValidType) {
          this._tfp.showMsg("文件格式必须为：" + this.dataModel.fileType + "。");

          iptFile.parent().remove();
          return;
        }
      }

      this.exeEventHandler("onBeforeUpload");
      var args = {
        path: file.path,
        appDataId: 0
      };
      if (this.dataModel.appCode) args.appCode = this.dataModel.appCode;
      if (this.dataModel.appDataId) args.appDataId = this.dataModel.appDataId;
      var that = this;
      tmClient.uploadAttachs({
        files: [args],
        isShowProgress: true
      }, function (ret) {
        try {
          var fileTmp = {};
          fileTmp.name = fileName;
          fileTmp.code = ret[0].code;
          fileTmp.path = file.path;
          if (!that.files) that.files = [];
          that.files.push(fileTmp);
          var fileHtml = "<div class=\"tfp-fileupload-row\" style=\"height:40px;\"><p class=\"tfp-fileupload-fileinfo";
          if (that.dataModel.showStyle == "bigIconMode") fileHtml += " tfp-fileupload-row-p";
          fileHtml += "\">";

          if (that.dataModel.showStyle == "bigIconMode") {
            fileHtml += "<img style=\"width:40px;\" src=\"" + that.getBigIcon(fileName) + "\" align=\"absmiddle\" />";
          } else {
            fileHtml += "<img src=\"/node_modules/tfp/src/components/fileupload/images/attach.png\" align=\"absmiddle\" />";
          }

          if (that.dataModel.showStyle == "bigIconMode") fileHtml += '<span class="tfp-fileupload-row-a">' + fileName + '</span></p></div>';else fileHtml += "&nbsp;&nbsp;" + fileName + "</p></div>";

          that._jqObj.append(fileHtml);

          if (that.dataModel.allowDelete) {
            var pFile = that._jqObj.find(".tfp-fileupload-fileinfo").last();

            var nbspHtml = "&nbsp;&nbsp;";
            if (that.dataModel.showStyle == "bigIconMode") nbspHtml = "";
            pFile.append("" + nbspHtml + "<a href=\"javascript:void(0)\">删除</a>");
            pFile.find("a").click(function () {
              that.deleteFile(this, fileTmp.code);
            });
          }

          if (that.onChange) eval(that.onChange);
          that.exeEventHandler("onAfterUpload");
        } catch (err) {
          alert(err.message);
        }
      });
    }
  }, {
    key: "uploadFile",
    value: function uploadFile(ipt) {
      var iptFile = $(ipt);
      var filePath = iptFile.val();

      if (this.files) {
        for (var i = 0; i < this.files.length; i++) {
          var f = this.files[i];

          if (f.path == filePath) {
            this._tfp.showMsg("该文件已添加！");

            iptFile.parent().remove();
            return;
          }
        }
      }

      var fileName = filePath.substr(filePath.lastIndexOf("\\") + 1);
      if (this.type == "PhotoUpload" && !this.dataModel.fileType) this.dataModel.fileType = ".jpg,.jpeg,.gif,.png,.bmp";

      if (this.dataModel.fileType) {
        var isValidType = true;
        var end = fileName.lastIndexOf(".");

        if (end >= 0) {
          var filetype = fileName.substr(end);
          if (!this.dataModel.fileType.toLowerCase().split(",").contains(filetype.toLowerCase())) isValidType = false;
        } else {
          isValidType = false;
        }

        if (!isValidType) {
          this._tfp.showMsg("文件格式必须为：" + this.dataModel.fileType + "。");

          iptFile.parent().remove();
          return;
        }
      }

      this.exeEventHandler("onBeforeUpload");
      var fileObj = ipt.files[0];

      if (this.type == "PhotoUpload") {
        var reader = new FileReader();

        reader.onload = function (e) {
          iptFile.parent().find("img").attr("src", e.target.result);
        };

        reader.readAsDataURL(fileObj);
      } else {
        var fileHtml = "&nbsp;&nbsp;" + fileName;
        if (this.dataModel.showStyle == "bigIconMode") fileHtml = '<span title=\"' + fileName + '\" class="tfp-fileupload-row-a">' + fileName + '</span>';
        iptFile.parent().find(".tfp-fileupload-fileinfo").append(fileHtml);
        iptFile.parent().find(".tfp-fileupload-fileinfo img").attr("src", this.getBigIcon(fileName));
        iptFile.parent().find(".tfp-fileupload-fileinfo img").css("width", "40px");
      }

      iptFile.parent().show();
      var uploaderUrl = "/Upload"; //设计时从tb后台添加身份验证信息，预览时和运行时从top页面获得

      if ((navigator.userAgent + "").indexOf("TaskBuilder") >= 0 && top.location.href.indexOf("/dev/pc/console.html") < 0) {
        uploaderUrl = top.taskBuilder.formatUrl("/Upload");
      } else {
        uploaderUrl = this._tfp.setUrlAuthData(uploaderUrl);
      }

      if (this.dataModel.appCode) {
        uploaderUrl += uploaderUrl.indexOf("?") < 0 ? "?" : "&";
        uploaderUrl += "appCode=" + this.dataModel.appCode;
        if (this.dataModel.appDataId) uploaderUrl += "&appDataId=" + this.dataModel.appDataId;
        if (this.dataModel.onlyOne) uploaderUrl += "&onlyOne=true";
      }

      if (this.type == "PhotoUpload" && this.dataModel.compress) {
        uploaderUrl += uploaderUrl.indexOf("?") < 0 ? "?" : "&";
        uploaderUrl += "compressImage=true";
        if (this.dataModel.maxSize) uploaderUrl += "&maxSize=" + this.dataModel.maxSize;
      }

      if (this.dataModel.service) {
        uploaderUrl += uploaderUrl.indexOf("?") < 0 ? "?" : "&";
        uploaderUrl += "service=" + this.dataModel.service;
      }

      if (this.dataModel.enIde) {
        uploaderUrl += uploaderUrl.indexOf("?") < 0 ? "?" : "&";
        uploaderUrl += "enIde=1";
      }

      var that = this;
      var form = new FormData();
      form.append("file", fileObj);
      var xhr = new XMLHttpRequest();
      xhr.open("post", uploaderUrl, true);

      xhr.onload = function () {
        var response = null;

        try {
          response = JSON.parse(xhr.responseText);
        } catch (e) {
          that._tfp.showMsg("文件[" + fileName + "]上传失败，错误描述：" + e.message);

          iptFile.parent().hide();
          iptFile.parent().remove();
          return;
        }

        if (response.code != 0) {
          that._tfp.showMsg("文件[" + fileName + "]上传失败，错误描述：" + response.message);

          iptFile.parent().hide();
          iptFile.parent().remove();
          return;
        }

        var file = {};
        file.name = fileName;
        if (response.fileId) file.id = response.fileId;

        if (response.fileCode) {
          file.code = response.fileCode;
        } else {
          file.code = response.path;
        }

        if (response.fileSize) {
          file.size = response.fileSize;
        } else {
          file.size = response.size;
        }

        file.path = filePath;
        if (!that.files) that.files = [];
        that.files.push(file);
        iptFile.parent().find("progress").parent().remove();

        if (that.dataModel.allowDelete) {
          if (that.type == "PhotoUpload") {
            iptFile.parent().append("<p align=\"center\"><a href=\"javascript:void(0)\">删除</a></p>");
          } else {
            var _fileHtml = "&nbsp;&nbsp;";
            if (that.dataModel.showStyle == "bigIconMode") _fileHtml = "";
            iptFile.parent().find(".tfp-fileupload-fileinfo").append("" + _fileHtml + "<a href=\"javascript:void(0)\">删除</a>");
          }

          iptFile.parent().find("a").click(function () {
            that.deleteFile(this, file.code);
          });
        }
        /*if(that.type=="PhotoUpload") {
          iptFile.parent().css("height", "100px");
        } else {
          iptFile.parent().css("height", "24px");
        }*/


        iptFile.remove();
        if (that.onChange) eval(that.onChange);
        that.exeEventHandler("onAfterUpload");
      };

      xhr.upload.fileInput = iptFile;
      xhr.upload.addEventListener("progress", this.onUploaderProgressChange, false);
      xhr.send(form);
    }
  }, {
    key: "getBigIcon",
    value: function getBigIcon(filename) {
      var suffix = filename.toLowerCase().split('.').pop();
      suffix += '';
      if (suffix != 'avi' && suffix != 'doc' && suffix != 'docx' && suffix != 'eps' && suffix != 'xls' && suffix != 'xlsx' && suffix != 'exe' && suffix != 'gif' && suffix != 'mp3' && suffix != 'pdf' && suffix != 'ppt' && suffix != 'pptx' && suffix != 'psd' && suffix != 'sql' && suffix != 'swf' && suffix != 'zip') suffix = 'default';
      return "/node_modules/tfp/src/components/fileupload/images/" + suffix + ".png";
    }
  }, {
    key: "deleteFile",
    value: function deleteFile(ipt, fileCode) {
      var _this2 = this;

      $(ipt).parent().parent().remove();

      if (this.files) {
        this.files.forEach(function (fileInfo, index) {
          if (fileInfo.code == fileCode) {
            _this2.files.splice(index, 1);

            return;
          }
        });
      }
    }
  }, {
    key: "onUploaderProgressChange",
    value: function onUploaderProgressChange(evt) {
      var ipt = evt.srcElement.fileInput;
      var uploadProgress = ipt.parent().find("progress").get(0);
      var uploadPercent = ipt.parent().find(".uploaderPercent").get(0);

      if (evt.lengthComputable) {
        uploadProgress.max = evt.total;
        uploadProgress.value = evt.loaded;
        uploadPercent.innerHTML = Math.round(evt.loaded / evt.total * 100) + "%";
      }
    }
  }, {
    key: "onAfterBindData",
    value: function onAfterBindData(data) {
      var args = {};

      if (data && data.fileCode) {
        args.file_code = data.fileCode;
      } else if (this.dataModel.appCode && this.dataModel.appDataId) {
        args.app_code = this.dataModel.appCode;
        args.app_data_id = this.dataModel.appDataId;
      } //应用代码和应用数据id都设置了才能自动查询附件信息


      if (!(args.file_code || args.app_code && args.app_data_id)) return;
      var that = this;

      this._tfp.use("Service", function () {
        var service = that._tfp["new"]("Service");

        service.path = "sys/service/app_attach/getUploadCptVal.tbs";
        service.request(args, function (req, res) {
          if (!res.data) return;
          that.value = res.data;
        });
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;
      if (this.dataModel.transverse || this.dataModel.showStyle == "bigIconMode") this._jqObj.css({
        "display": "flex",
        "flex-wrap": "wrap"
      });

      this._jqObj.find(".tfp-fileupload-row").eq(0).find(".tfp-button").click(function () {
        if (that.readonly || that.disabled) return;
        that.selectFile();
      });
    }
  }]);
  return FileUpload;
}(_controller.FormInput);

exports["default"] = FileUpload;