"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 文件组组件
 * @param {[type]} dataModel [description]
 */
var FileList = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(FileList, _FormInput);

  var _super = _createSuper(FileList);

  function FileList(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, FileList);
    return _super.call(this, __tfp, "FileList", dataModel, parent);
  }

  (0, _createClass2["default"])(FileList, [{
    key: "value",
    get: function get() {
      if (!this.dataModel.value) return [];
      return this.dataModel.value;
    },
    set: function set(value) {
      if (!value) {
        this.dataModel.value = [];
      } else {
        this._jqObj.find(".tfp-filelist-box").children(".tfp-filelist-row").remove();

        if (this.dataModel.appCode && this.dataModel.appDataId) {
          if (!Array.isArray(value)) return;
          this.dataModel.value = value;
          this.setAppHtml(value);
        } else {
          if (value.indexOf(",") >= 0) {
            this.dataModel.value = value.split(',');
            this.setHtml(value.split(','), 0);
          } else {
            this.dataModel.value = [value];
            this.setHtml([value], 0);
          }
        }

        if (!this._tfp.isDesigning) {
          this.exeEventHandler("onChange");
        }
      }
    }
  }, {
    key: "appCode",
    get: function get() {
      return this.dataModel.appCode;
    },
    set: function set(value) {
      this.dataModel.appCode = value;
    }
  }, {
    key: "appDataId",
    get: function get() {
      return this.dataModel.appDataId;
    },
    set: function set(value) {
      this.dataModel.appDataId = value;
    }
  }, {
    key: "transverse",
    get: function get() {
      return this.dataModel.transverse;
    },
    set: function set(value) {
      this.dataModel.transverse = value ? true : false;
    }
  }, {
    key: "showStyle",
    get: function get() {
      return this.dataModel.showStyle;
    },
    set: function set(value) {
      this.dataModel.showStyle = value;
    }
  }, {
    key: "setHtml",
    value: function setHtml(data, index) {
      var that = this;

      if (data && data.length > index) {
        this.onAfterBindData({
          fileCode: data[index]
        }, function (fileInfo) {
          that.addHtml(fileInfo);
          index++;
          that.setHtml(data, index);
        });
      } else {
        return;
      }
    }
  }, {
    key: "setAppHtml",
    value: function setAppHtml(value) {
      for (var i = 0; i < value.length; i++) {
        this.addHtml(value[i]);
      }
    }
  }, {
    key: "addHtml",
    value: function addHtml(fileInfo) {
      var html = '';
      var that = this;

      var filesDiv = that._jqObj.find(".tfp-filelist-box");

      var src = that._tfp.getUrlRealPath(fileInfo.code);

      html += "<div class=\"tfp-filelist-row\"><p class=\"tfp-filelist-fileinfo";
      if (this.dataModel.showStyle == "bigIconMode") html += " tfp-filelist-row-p";
      html += "\">";

      if (this.dataModel.showStyle == "bigIconMode") {
        html += "<img style=\"width:40px;\" src=\"" + this.getBigIcon(fileInfo.name) + "\" align=\"absmiddle\" />";
      } else {
        html += "<img src=\"/node_modules/tfp/src/components/fileupload/images/attach.png\" align=\"absmiddle\" />&nbsp;&nbsp;";
      }

      html += "<a href=\"/Download?fileCode=" + src + "\"";
      if (this.dataModel.showStyle == "bigIconMode") html += " title=\"" + fileInfo.name + "\"  class=\"tfp-filelist-row-a\"";
      html += ">" + fileInfo.name + "</a>";
      html += "</p></div>";
      filesDiv.append(html);
    }
  }, {
    key: "getBigIcon",
    value: function getBigIcon(filename) {
      var suffix = filename.toLowerCase().split('.').pop();
      suffix += '';
      if (suffix != 'avi' && suffix != 'doc' && suffix != 'docx' && suffix != 'eps' && suffix != 'xls' && suffix != 'xlsx' && suffix != 'exe' && suffix != 'gif' && suffix != 'mp3' && suffix != 'pdf' && suffix != 'ppt' && suffix != 'pptx' && suffix != 'psd' && suffix != 'sql' && suffix != 'swf' && suffix != 'zip') suffix = 'default';
      return "/node_modules/tfp/src/components/fileupload/images/" + suffix + ".png";
    }
  }, {
    key: "onAfterBindData",
    value: function onAfterBindData(data, cb) {
      var args = {};

      if (data && data.fileCode) {
        args.file_code = data.fileCode;
      } else if (this.dataModel.appCode && this.dataModel.appDataId) {
        args.app_code = this.dataModel.appCode;
        args.app_data_id = this.dataModel.appDataId;
      } //应用代码和应用数据id都设置了才能自动查询附件信息


      if (!(args.file_code || args.app_code && args.app_data_id)) return;
      var that = this;

      this._tfp.use("Service", function () {
        var service = that._tfp["new"]("Service");

        service.path = "sys/service/app_attach/getUploadCptVal.tbs";
        service.request(args, function (req, res) {
          if (!res.data) return;
          if (cb) cb(res.data[0]);else that.value = res.data;
        });
      });
    }
  }]);
  return FileList;
}(_controller.FormInput);

exports["default"] = FileList;