"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "ExcelImport",
  "comment": "Excel导入",
  "cssFiles": ["../button/style.{bgColorMode}.css", "style.css"],
  "attrs": [{
    "name": "text",
    "comment": "按钮文本",
    "type": "String",
    "default": "导入"
  }, {
    "name": "theme",
    "comment": "按钮风格",
    "type": "Select",
    "special": true,
    "default": "rect",
    "options": [{
      "value": "rect",
      "text": "矩形"
    }, {
      "value": "round",
      "text": "圆角矩形"
    }, {
      "value": "circle",
      "text": "椭圆形"
    }]
  }, {
    "name": "dataImportSetting",
    "comment": "数据导入设置",
    "type": "Dialog",
    "path": "taskbuilder-tfp-designer/DataImportSetting.tfp",
    "width": "860px",
    "height": "640px"
  }, {
    "name": "template",
    "comment": "导入模板文件路径(.xlsx)",
    "type": "PathPicker",
    "fileTypes": ["excel"]
  }],
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onImport",
    "comment": "完成导入后",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;