"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controllerPc = _interopRequireDefault(require("../excelexport/controller.pc.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Excel导入组件
 * @param {[type]} dataModel [description]
 */
var ExcelImport = /*#__PURE__*/function (_ExcelExport) {
  (0, _inherits2["default"])(ExcelImport, _ExcelExport);

  var _super = _createSuper(ExcelImport);

  function ExcelImport(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, ExcelImport);
    return _super.call(this, __tfp, dataModel, parent, "ExcelImport");
  }

  (0, _createClass2["default"])(ExcelImport, [{
    key: "template",
    get: function get() {
      return this.dataModel.template;
    },
    set: function set(value) {
      this.dataModel.template = value;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.click(function () {
        if (!that.dataModel.service && !that.dataModel.dataImportSetting) {
          that._tfp.showMsg("请为[" + that.id + "]设置数据导入有关参数！");

          return;
        }

        var args = {};
        if (that.dataModel.template) args._templatePath = that.dataModel.template;
        var servicePath = "";
        var encryptRequestArgs = "";
        var encryptResponseArgs = "";

        if (that.dataModel.dataImportSetting) {
          if (that.dataModel.dataImportSetting.servicePath) {
            if (that.dataModel.dataImportSetting.requestArgs && that.dataModel.dataImportSetting.requestArgs.length > 0) {
              that._tfp.getRequestArgs(args, that.dataModel.dataImportSetting.requestArgs);
            }

            servicePath = that.dataModel.dataImportSetting.servicePath;
            encryptRequestArgs = that.dataModel.dataImportSetting.encryptRequestArgs;
            encryptResponseArgs = that.dataModel.dataImportSetting.encryptResponseArgs;
          } else if (that.dataModel.dataImportSetting.serviceCpt) {
            var serviceCpt = that._tfp.get(that.dataModel.dataImportSetting.serviceCpt);

            if (!serviceCpt) {
              that._tfp.showMsg("没有找到id为[" + that.dataModel.dataImportSetting.serviceCpt + "]的组件！");

              return;
            }

            servicePath = serviceCpt.dataModel.path;
            encryptRequestArgs = serviceCpt.dataModel.encryptRequestArgs;
            encryptResponseArgs = serviceCpt.dataModel.encryptResponseArgs;
            if (serviceCpt.dataModel.argSettings && serviceCpt.dataModel.argSettings.length > 0) that._tfp.getRequestArgs(args, serviceCpt.dataModel.argSettings);
          }
        } else if (that.dataModel.service) {
          servicePath = that.dataModel.service;
          encryptRequestArgs = that.dataModel.encryptRequestArgs;
          encryptResponseArgs = that.dataModel.encryptResponseArgs;
        }

        if (!servicePath) {
          that._tfp.showMsg("请为[" + that.id + "]设置数据导入有关参数！");

          return;
        }

        var url = "/node_modules/tfp/src/components/excelimport/tfp/importExcel.tfp?servicePath=" + servicePath;
        if (that.dataModel.onImport) url += "&cb=" + that._tfp.getCptEventFuncName(that.dataModel.onImport);

        that._tfp.openDialog("导入Excel数据", url, "480px", "350px", {
          args: args
        }, window);
      });
    }
  }]);
  return ExcelImport;
}(_controllerPc["default"]);

exports["default"] = ExcelImport;