"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "ExcelExport",
  "comment": "Excel导出",
  "cssFiles": ["../button/style.{bgColorMode}.css", "style.css"],
  "attrs": [{
    "name": "text",
    "comment": "按钮文本",
    "type": "String",
    "default": "导出"
  }, {
    "name": "theme",
    "comment": "按钮风格",
    "type": "Select",
    "special": true,
    "default": "rect",
    "options": [{
      "value": "rect",
      "text": "矩形"
    }, {
      "value": "round",
      "text": "圆角矩形"
    }, {
      "value": "circle",
      "text": "椭圆形"
    }]
  }, {
    "name": "dataExportSetting",
    "comment": "数据导出设置",
    "type": "Dialog",
    "path": "taskbuilder-tfp-designer/DataExportSetting.tfp",
    "width": "900px",
    "height": "640px"
  }, // {
  //   "name": "allowFilterFields",
  //   "comment": "允许选择导出字段",
  //   "type": "Switch"
  // }
  {
    "name": "enIde",
    "comment": "启用身份验证",
    "type": "Switch"
  }],
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onExport",
    "comment": "完成导出后",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;