"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Excel导出组件
 * @param {[type]} dataModel [description]
 */
var ExcelExport = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(ExcelExport, _VisibleComponent);

  var _super = _createSuper(ExcelExport);

  function ExcelExport(__tfp, dataModel, parent, inputType) {
    var _this;

    (0, _classCallCheck2["default"])(this, ExcelExport);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "ExcelExport", dataModel, parent);
    }

    return (0, _possibleConstructorReturn2["default"])(_this);
  } //属性


  (0, _createClass2["default"])(ExcelExport, [{
    key: "text",
    get: function get() {
      return this.dataModel.text;
    },
    set: function set(value) {
      this.dataModel.text = value;

      if (this._jqObj) {
        this._jqObj.html(value);
      }
    }
  }, {
    key: "theme",
    get: function get() {
      return this.dataModel.theme;
    },
    set: function set(value) {
      var theme = "rect";
      if (value) theme = value;

      if (!this.checkAttrOption("theme", theme)) {
        this._tfp.showMsg("不支持风格：" + theme + "！");

        return;
      }

      this.dataModel.theme = theme;

      if (this._jqObj) {
        this._jqObj.removeClass("tfp-button-round tfp-button-rect tfp-button-circle");

        this._jqObj.addClass("tfp-button-" + theme);
      }
    }
  }, {
    key: "service",
    get: function get() {
      return this.dataModel.service;
    },
    set: function set(value) {
      this.dataModel.service = value;
    }
  }, {
    key: "allowFilterFields",
    get: function get() {
      return this.dataModel.allowFilterFields;
    },
    set: function set(value) {
      this.dataModel.allowFilterFields = value ? true : false;
    } //是否验证身份

  }, {
    key: "enIde",
    get: function get() {
      return this.dataModel.enIde;
    },
    set: function set(value) {
      this.dataModel.enIde = value;
    }
  }, {
    key: "onExport",
    value: function onExport(res) {
      if (res.code != 0) {
        this._tfp.showMsg(res.message);

        return;
      }

      $('.exportlink').remove();
      $('body').append('<a class="exportlink" style="display:none;" href="javascript:"></a>');
      var that = this;
      $('.exportlink').click(function () {
        var url = "/Download?fileCode=" + res.fileCode;
        window.location.href = that._tfp.setUrlAuthData(url);
      });
      $('.exportlink').click();
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.click(function () {
        if (that.dataModel.allowFilterFields) {
          that._tfp.openDialog("选择导出字段", that._tfp.rootPath + "/src/components/excelexport/exportPicker.tfp?checkedFields=" + JSON.stringify(that.dataModel.dataExportSetting.fields), "540px", "260px", null, function (ret) {
            that.callingMethod(ret);
          });
        } else {
          that.callingMethod();
        }
      });
    }
  }, {
    key: "callingMethod",
    value: function callingMethod(ret) {
      var that = this;

      if (!that.dataModel.service && !that.dataModel.dataExportSetting) {
        that._tfp.showMsg("请为[" + that.id + "]设置数据导出有关参数！");

        return;
      }

      if (that.dataModel.service || that.dataModel.dataExportSetting && that.dataModel.dataExportSetting.serviceCpt) {
        var serviceCptId = that.dataModel.service; //兼容老版本组件

        if (!serviceCptId) serviceCptId = that.dataModel.dataExportSetting.serviceCpt;
        var serviceCpt = that._tfp.components[serviceCptId];

        if (!serviceCpt) {
          that._tfp.showMsg("没有找到id为[" + serviceCptId + "]的组件！");

          return;
        }

        var args = {};
        if (ret && ret.length > 0) args.checkedFields = ret;
        if (that.enIde) args.enIde = 1;
        serviceCpt.request(args, function (req, res) {
          that.onExport(res);
        });
        return;
      }

      if (that.dataModel.dataExportSetting && that.dataModel.dataExportSetting.servicePath) {
        var options = {
          servicePath: that.dataModel.dataExportSetting.servicePath,
          autoShowError: true,
          showLoading: true
        };

        if (that.dataModel.dataExportSetting.requestArgs && that.dataModel.dataExportSetting.requestArgs.length > 0) {
          options.argSettings = that.dataModel.dataExportSetting.requestArgs;
        } else options.argSettings = [];

        if (that.dataModel.dataExportSetting.encryptRequestArgs) options.encryptRequestArgs = that.dataModel.dataExportSetting.encryptRequestArgs;
        if (that.dataModel.dataExportSetting.encryptResponseArgs) options.encryptResponseArgs = that.dataModel.dataExportSetting.encryptResponseArgs;
        if (ret && ret.length > 0) options.checkedFields = ret;
        if (that.enIde) options.argSettings.push({
          name: 'enIde',
          type: 'Default',
          value: '1',
          encrypt: 'false'
        });

        that._tfp.request(options, function (req, res) {
          that.onExport(res);
        });
      } else {
        that._tfp.showMsg("请为[" + that.id + "]设置数据导出有关参数！");
      }
    }
  }]);
  return ExcelExport;
}(_controller.VisibleComponent);

exports["default"] = ExcelExport;