"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = _interopRequireDefault(require("../text/controller.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 编码规则
 * @param {[type]} dataModel [description]
 */
var EncodingRule = /*#__PURE__*/function (_Text) {
  (0, _inherits2["default"])(EncodingRule, _Text);

  var _super = _createSuper(EncodingRule);

  function EncodingRule(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, EncodingRule);
    return _super.call(this, __tfp, dataModel, parent, "EncodingRule");
  }

  (0, _createClass2["default"])(EncodingRule, [{
    key: "ruleCode",
    get: function get() {
      return this.dataModel.ruleCode;
    },
    set: function set(value) {
      this.dataModel.ruleCode = value;
    }
  }, {
    key: "loadCode",
    value: function loadCode(cb) {
      //需要设置规则代码
      if (!this.dataModel.ruleCode) {
        console.log("请设置规则代码！");
        return;
      }

      var that = this;

      this._tfp.use("Service", function () {
        var service = that._tfp["new"]("Service");

        service.path = "sys/service/encoding_rule/getCurCode.tbs";
        service.request({
          rule_code: that.dataModel.ruleCode,
          update_mode: 'R'
        }, function (req, res) {
          that.value = res.data.code;
          if (cb) cb();
        });
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(EncodingRule.prototype), "initRuntime", this).call(this); //如果设置了数据绑定格式，则不需要再从后台查询

      if (this.dataModel.dataBindingFormat) return;
      this.loadCode();
    }
  }]);
  return EncodingRule;
}(_controller["default"]);

exports["default"] = EncodingRule;