"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "DropdownBox",
  "comment": "下拉树列表",
  "cssFiles": ["style.{bgColorMode}.pc.css", "dtreefont.css"],
  "attrs": [{
    "name": "dataBindSetting",
    "comment": "数据绑定设置",
    "type": "group",
    "items": [{
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    }, {
      "name": "storageType",
      "comment": "存储格式",
      "type": "Select",
      "options": [{
        "value": "string",
        "text": "字符串格式"
      }, {
        "value": "json",
        "text": "JSON格式"
      }],
      "default": "json"
    }, {
      "name": "loadDataListService",
      "comment": "加载节点数据服务",
      "type": "Service"
    }, {
      "name": "nodeDataMember",
      "comment": "节点数据成员",
      "type": "String"
    }, {
      "name": "rootNodeParentId",
      "comment": "根节点父节点ID",
      "type": "String",
      "default": "0"
    }, {
      "name": "nodeIdFieldName",
      "comment": "节点ID字段",
      "type": "String",
      "default": "id"
    }, {
      "name": "nodeNameFieldName",
      "comment": "节点名称字段",
      "type": "String",
      "default": "name"
    }, {
      "name": "nodeParentIdFieldName",
      "comment": "父节点ID字段",
      "type": "String",
      "default": "parent_id"
    }, {
      "name": "nodechildrenNum",
      "comment": "子节点数量字段",
      "type": "String",
      "default": "child_num"
    }, {
      "name": "spreadLevel",
      "comment": "展开级数",
      "type": "String",
      "default": "1"
    }, {
      "name": "isLeaf",
      "comment": "叶节点判断字段",
      "type": "String",
      "default": "isLeaf"
    }, {
      "name": "dataListDivWidth",
      "comment": "弹出列表宽度",
      "type": "Int",
      "default": "200"
    }, {
      "name": "dataListDivHeight",
      "comment": "弹出列表高度",
      "type": "Int",
      "default": "240"
    }]
  }, {
    "name": "treeSetting",
    "comment": "树形组件设置",
    "type": "group",
    "items": [{
      "name": "showNodeCheckbox",
      "comment": "显示节点选择框",
      "type": "Switch"
    }, {
      "name": "multiCheck",
      "comment": "允许多选",
      "type": "Switch"
    }, {
      "name": "loadList",
      "comment": "加载单级列表",
      "type": "Switch"
    }]
  }, {
    "name": "inputSetting",
    "comment": "输入项设置",
    "type": "group",
    "items": [{
      "name": "enableFilter",
      "comment": "启用搜索",
      "type": "Switch",
      "isHtmlAttr": true
    }, {
      "name": "selectDataListService",
      "comment": "搜索节点数据服务",
      "type": "Service"
    }, {
      "name": "inputSelectinfo",
      "comment": "输入项搜索字段",
      "type": "String",
      "default": "keyWord"
    }, {
      "name": "nodeDataMember2",
      "comment": "节点数据成员",
      "type": "String"
    }, {
      "name": "nodeIdFieldName2",
      "comment": "节点ID字段",
      "type": "String",
      "default": "id"
    }, {
      "name": "nodeNameFieldName2",
      "comment": "节点名称字段",
      "type": "String",
      "default": "name"
    }, {
      "name": "nodeParentIdFieldName2",
      "comment": "父节点ID字段",
      "type": "String",
      "default": "parent_id"
    }]
  }],
  "styles": ["size", "position", "font", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "200px",
    "height": "30px",
    "line-height": "30px",
    "padding-left": "2px",
    "padding-right": "2px"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击时"
  }, {
    "name": "onChange",
    "comment": "值发生变化时",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;