"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 弹出菜单组件
 * @param {[type]} dataModel [description]
 */
var Dropdown = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Dropdown, _FormInput);

  var _super = _createSuper(Dropdown);

  function Dropdown(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Dropdown);
    return _super.call(this, __tfp, "Dropdown", dataModel, parent);
  }

  (0, _createClass2["default"])(Dropdown, [{
    key: "value",
    get: function get() {
      if (!this.dataModel.value) return "";
      return this.dataModel.value;
    },
    set: function set(value) {
      var val = value;

      if (isNull(value)) {
        val = "";
        this.dataModel.value = null;
      } else {
        this.dataModel.value = val;
      }
    }
  }, {
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(value) {
      this.dataModel.options = value;
      return;
    }
  }, {
    key: "dataListValueFormat",
    get: function get() {
      return this.dataModel.dataListValueFormat;
    },
    set: function set(value) {
      this.dataModel.dataListValueFormat = value;
    }
  }, {
    key: "dataListTextFormat",
    get: function get() {
      return this.dataModel.dataListTextFormat;
    },
    set: function set(value) {
      this.dataModel.dataListTextFormat = value;
    }
    /**
     * 检查数据加载参数是否设置正确
     * @returns 
     */

  }, {
    key: "checkLoadDataArg",
    value: function checkLoadDataArg() {
      if (!this.dataModel.dataListValueFormat) {
        alert("请为[" + this.id + "]设置选项值数据格式！");
        return false;
      }

      return true;
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (isNull(data) || !Array.isArray(data)) return;
      this.options = [];

      for (var i = 0; i < data.length; i++) {
        var row = data[i];
        var option = {};

        try {
          var valueFormat = this.dataModel.dataListValueFormat;
          if (valueFormat.indexOf("{") < 0 && valueFormat.indexOf("#[") < 0) valueFormat = "{" + valueFormat + "}";
          option.value = this._tfp.replaceDataField(row, valueFormat);
          if (option.value) option.value = this._tfp.exeExpress(option.value);
        } catch (e) {
          console.log(e);
          return;
        }

        if (isNull(option.value)) continue;
        option.text = option.value;

        if (this.dataModel.dataListTextFormat) {
          try {
            var textFormat = this.dataModel.dataListTextFormat;
            if (textFormat.indexOf("{") < 0 && textFormat.indexOf("#[") < 0) textFormat = "{" + textFormat + "}";
            option.text = this._tfp.replaceDataField(row, textFormat);
            if (option.text) option.text = this._tfp.exeExpress(option.text);
          } catch (e) {
            console.log(e);
            return;
          }
        }

        if (isNull(option.text)) continue;
        this.options.push(option);
      }

      if (this.options.length == 0) return;
    }
  }, {
    key: "addOptionDiv",
    value: function addOptionDiv(divDataList, option) {
      var html = '';

      if (option.href) {
        html += "<a ";

        if (!this._tfp.isDesigning) {
          if (option.target == "self") {
            html += " href=\"" + option.href + "\"";
          } else {
            html += " href=\"javascript:void(0)\" onclick=\"";
            var title = "Tasgine - 任擎";
            if (option.targetTitle) title = option.targetTitle;

            if (option.target == "page") {
              html += "tfp.openPage('" + title + "', '" + option.href + "')";
            } else if (option.target == "dialog") {
              var width = option.dialogWidth;
              if (!width) width = "480px";
              if ((width + "").indexOf("px") < 0) width += "px";
              var height = option.dialogHeight;
              if (!height) height = "480px";
              if ((height + "").indexOf("px") < 0) height += "px";
              html += "tfp.openDialog('" + title + "', '" + option.href + "'" + ", '" + width + "', '" + height + "')";
            } else if (option.target == "window") {
              html += "window.open('" + option.href + "', '" + title + "')";
            }

            html += "\"";
          }
        }

        html += ">";
      }

      html += "<label>" + (option.text ? option.text : option.value) + "</label>";

      if (option.href) {
        html += "</a>";
      }

      divDataList.append("<div data-value=\"" + option.value + "\">" + html + "</div > ");
    }
  }, {
    key: "showOptions",
    value: function showOptions() {
      if (!this.options || this.options.length == 0) return;
      var divDataList = $("#" + this.id + "_dropdownDiv");
      var leg = divDataList.find("div").length;

      if (leg == 0) {
        for (var i = 0; i < this.options.length; i++) {
          var option = this.options[i];
          this.addOptionDiv(divDataList, option);
        }
      }

      var that = this;
      divDataList.find("div").click(function () {
        event.stopPropagation();
        var value = $(this).attr("data-value");
        var index = $(this).index();
        that.value = value;
        that.valueOnChange();
        that.exeEventHandler("onChange", value);

        try {
          if (that.dataModel.onClickOption) eval(that.dataModel.onClickOption);
        } catch (err) {
          console.log(err.message);
        }

        divDataList.find("div").unbind("click");
        divDataList.hide();
      });
      divDataList.css("left", that._jqObj.offset().left + "px");
      divDataList.css("top", that._jqObj.offset().top + 31 + "px");
      divDataList.show();
      document.addEventListener("click", function () {
        if (!$(event.target).is(divDataList)) divDataList.hide();
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this; //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载

      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      }

      this._jqObj.find("input").click(function () {
        that.showOptions();
        event.stopPropagation();
      });

      var dataListDivWidth = this._jqObj.width() + 6; //添加数据列表层

      $("body").append("<div id=\"" + this.id + "_dropdownDiv\" " + "class=\"tfp-dropdown-datalist\" style=\"width:" + dataListDivWidth + "px;\"></div>");
    }
  }]);
  return Dropdown;
}(_controller.FormInput);

exports["default"] = Dropdown;