"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Dep",
  "comment": "部门选择",
  "cssFiles": "../org/style.{bgColorMode}.pc.css",
  "attrs": [{
    "name": "inputSetting",
    "comment": "输入项设置",
    "type": "group",
    "items": [{
      "name": "comment",
      "comment": "组件备注",
      "type": "String"
    }, {
      "name": "placeHolder",
      "comment": "输入提示",
      "type": "String",
      "isHtmlAttr": true
    }, {
      "name": "showIcon",
      "comment": "显示图标",
      "type": "Switch",
      "default": true
    }, {
      "name": "multiCheck",
      "comment": "多选",
      "type": "Switch"
    }, {
      "name": "valueType",
      "comment": "值类型",
      "type": "Select",
      "options": [{
        "value": "id",
        "text": "部门编号"
      }, {
        "value": "code",
        "text": "部门编码"
      }, {
        "value": "name",
        "text": "部门名称"
      }, {
        "value": "obj",
        "text": "部门对象"
      }, {
        "value": "str",
        "text": "部门字符串"
      }],
      "default": "id",
      "notnull": true
    }, {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    }, {
      "name": "required",
      "comment": "必填",
      "type": "Switch"
    }, {
      "name": "readonly",
      "comment": "只读",
      "type": "Switch"
    }, {
      "name": "disabled",
      "comment": "禁用",
      "type": "Switch"
    }, {
      "name": "encrypted",
      "comment": "加密发送",
      "type": "Switch"
    }]
  }],
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "defaultStyles": {
    "width": "120px",
    "height": "30px"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onChange",
    "comment": "值发生变化时",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;