"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "DateRange",
  "comment": "日期范围",
  "cssFiles": ["style.{bgColorMode}.css", "datepicker.{bgColorMode}.css"],
  "attrs": [{
    "name": "inputSetting",
    "comment": "输入项设置",
    "type": "group",
    "items": [{
      "name": "value",
      "comment": "组件值",
      "type": "String",
      "default": ""
    }, {
      "name": "comment",
      "comment": "组件备注",
      "type": "String"
    }, {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    }, {
      "name": "formula",
      "comment": "自动计算表达式",
      "type": "Formula"
    }, {
      "name": "required",
      "comment": "必填",
      "type": "Switch"
    }, {
      "name": "readonly",
      "comment": "只读",
      "type": "Switch",
      "isHtmlAttr": true
    }, {
      "name": "disabled",
      "comment": "禁用",
      "type": "Switch",
      "isHtmlAttr": true
    }, {
      "name": "encrypted",
      "comment": "加密发送",
      "type": "Switch"
    }]
  }, {
    "name": "dateTimeSetting",
    "comment": "日期时间设置",
    "type": "group",
    "items": [{
      "name": "startDate",
      "comment": "开始日期",
      "type": "String"
    }, {
      "name": "endDate",
      "comment": "截止日期",
      "type": "String"
    }, {
      "name": "showIcon",
      "comment": "显示图标",
      "type": "Switch",
      "default": true
    }, {
      "name": "defaultNow",
      "comment": "默认当前时间",
      "type": "Switch"
    }, {
      "name": "showMode",
      "comment": "显示格式",
      "type": "Select",
      "default": "defaultMode",
      "options": [{
        "value": "defaultMode",
        "text": "选择日期范围"
      }, {
        "value": "monthMode",
        "text": "选择月份范围"
      }]
    }]
  }],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "247px",
    "height": "30px"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击时"
  }, {
    "name": "onFocus",
    "comment": "获得焦点时",
    "isNotHtmlEvent": true
  }, {
    "name": "onBlur",
    "comment": "失去焦点时",
    "isNotHtmlEvent": true
  }, {
    "name": "onChange",
    "comment": "值发生变化时",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;