"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 可编辑表格
 * @param {[type]} dataModel [description]
 */
var DataSet = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(DataSet, _VisibleComponent);

  var _super = _createSuper(DataSet);

  function DataSet(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, DataSet);
    _this = _super.call(this, __tfp, "DataSet", dataModel, parent);

    if (_this._tfp.isDesigning && (!_this.dataModel.columns || _this.dataModel.columns.length == 0)) {
      //默认创建3行
      _this.dataModel.columns = [{
        id: "input1",
        name: "输入项1",
        type: "text",
        proportion: "1:2"
      }, {
        id: "input2",
        name: "输入项2",
        type: "text",
        proportion: "1:2"
      }, {
        id: "input3",
        name: "输入项3",
        type: "text",
        proportion: "1:2"
      }];
    }

    return _this;
  } //属性


  (0, _createClass2["default"])(DataSet, [{
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    }
  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    }
  }, {
    key: "columns",
    get: function get() {
      return this.dataModel.columns;
    },
    set: function set(value) {
      this.dataModel.columns = value;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "rows",
    get: function get() {
      return this.getRowsData({
        checkRequired: false
      });
    },
    set: function set(value) {
      this.dataModel.rows = value;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "showAddButton",
    get: function get() {
      return this.dataModel.showAddButton;
    },
    set: function set(value) {
      this.dataModel.showAddButton = value ? true : false;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "addButtonText",
    get: function get() {
      if (!this.dataModel.addButtonText) this.dataModel.addButtonText = "添加";
      return this.dataModel.addButtonText;
    },
    set: function set(value) {
      this.dataModel.addButtonText = value;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "enableInsert",
    get: function get() {
      return this.dataModel.enableInsert ? true : false;
    },
    set: function set(value) {
      this.dataModel.enableInsert = value ? true : false;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "enableDelete",
    get: function get() {
      return this.dataModel.enableDelete ? true : false;
    },
    set: function set(value) {
      this.dataModel.enableDelete = value ? true : false;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "enableMove",
    get: function get() {
      return this.dataModel.enableMove ? true : false;
    },
    set: function set(value) {
      this.dataModel.enableMove = value ? true : false;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "titleName",
    get: function get() {
      return this.dataModel.titleName;
    },
    set: function set(value) {
      this.dataModel.titleName = value;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "reRenderBody",
    value: function reRenderBody() {
      this._jqObj.empty();

      this._jqObj.append(this.getBodyHtml());
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml() {
      var _this2 = this;

      var _this$dataModel = this.dataModel,
          id = _this$dataModel.id,
          _this$dataModel$rows = _this$dataModel.rows,
          rows = _this$dataModel$rows === void 0 ? [] : _this$dataModel$rows,
          titleName = _this$dataModel.titleName,
          showAddButton = _this$dataModel.showAddButton,
          addButtonText = _this$dataModel.addButtonText,
          enableInsert = _this$dataModel.enableInsert;
      var iconPath = this._tfp.rootPath + "/src/components/dataset/images/"; // 设计时添加一行

      if (this._tfp.isDesigning) rows.push({});
      var html = "\n      <div class=\"tfp-dataset-toolbar\">\n        <div class=\"tfp-dataset-title\">".concat(titleName || id, "</div>\n        <div class=\"tfp-dataset-tool\">\n          <div class=\"tfp-dataset-button-insert\" style=\"").concat(enableInsert ? '' : 'display:none', "\"><img src=\"").concat(iconPath, "add-blue-24.png\"/></div>\n        </div>\n      </div>\n    ");
      rows.forEach(function (row, index) {
        html += _this2.getRowHtml(index, row);
      });
      html += "<div class=\"tfp-dataset-button\" style=\"".concat(showAddButton ? '' : 'display:none', "\">\n      <div class=\"tfp-dataset-button-add\">").concat(addButtonText, "</div>\n    </div>");
      return html;
    }
  }, {
    key: "getRowHtml",
    value: function getRowHtml(rowIndex, rowData) {
      var _this3 = this;

      if ((0, _typeof2["default"])(rowData) !== 'object') rowData = {};
      var _this$dataModel2 = this.dataModel,
          id = _this$dataModel2.id,
          titleName = _this$dataModel2.titleName,
          columns = _this$dataModel2.columns,
          _this$dataModel2$enab = _this$dataModel2.enableInsert,
          enableInsert = _this$dataModel2$enab === void 0 ? false : _this$dataModel2$enab,
          _this$dataModel2$enab2 = _this$dataModel2.enableMove,
          enableMove = _this$dataModel2$enab2 === void 0 ? false : _this$dataModel2$enab2,
          _this$dataModel2$enab3 = _this$dataModel2.enableDelete,
          enableDelete = _this$dataModel2$enab3 === void 0 ? false : _this$dataModel2$enab3;
      var iconPath = this._tfp.rootPath + "/src/components/dataset/images/";
      var html = $("\n      <div class=\"tfp-dataset-row\">\n        <div class=\"tfp-dataset-row-header\">\n          <div class=\"tfp-dataset-row-header-title\">".concat(titleName || id, "(").concat(rowIndex + 1, ")</div>\n          <div class=\"tfp-dataset-row-header-btns\">\n            <div class=\"tfp-dataset-button-insert\"><img src=\"").concat(iconPath, "add-blue-24.png\"/></div>\n            <div class=\"tfp-dataset-button-moveUp\"><img src=\"").concat(iconPath, "up-blue-24.png\"/></div>\n            <div class=\"tfp-dataset-button-moveDown\"><img src=\"").concat(iconPath, "down-blue-24.png\"/></div>\n            <div class=\"tfp-dataset-button-delete\"><img src=\"").concat(iconPath, "delete-blue-24.png\"/></div>\n          </div>\n        </div>\n      </div>\n    "));
      if (!enableInsert) html.find('.tfp-dataset-button-insert').remove();
      if (!enableMove) html.find('.tfp-dataset-button-moveUp,.tfp-dataset-button-moveDown').remove();
      if (!enableDelete) html.find('.tfp-dataset-button-delete').remove();
      (columns || []).forEach(function (_input, index) {
        var input = _objectSpread({}, _input);

        var item = $("\n        <div class=\"tfp-dataset-item\">\n          <div class=\"tfp-dataset-item-left\" style=\"flex-basis:50%;\"><label>".concat(input.name || input.id, "</label></div>\n          <div class=\"tfp-dataset-item-right\" style=\"flex-basis:50%;\"></div>\n        </div>\n      "));
        var itemLeft = item.find('.tfp-dataset-item-left');
        var itemright = item.find('.tfp-dataset-item-right'); // 组件值

        var cellValue = function () {
          if (rowData[input.id]) return rowData[input.id];
          if (!input["default"]) return '';

          switch (input.dataType) {
            case 'int':
              return parseInt(input["default"]);

            case 'float':
              return parseFloat(input["default"]);

            case 'money':
              return _this3._tfp.formatMoney(input["default"]);

            case 'date':
              return _this3._tfp.formatDate(input["default"], "yyyy-MM-dd");

            case 'time':
              return _this3._tfp.formatDate(input["default"], "HH:mm:ss");

            case 'datetime':
              return _this3._tfp.formatDate(input["default"], "yyyy-MM-dd HH:mm:ss");
          }

          return '';
        }(); // 比例


        if (input.proportion) {
          var separator = ":";
          var proportionLeft = parseFloat(input.proportion.slice(0, input.proportion.indexOf(separator)));
          var proportionRight = parseFloat(input.proportion.slice(input.proportion.indexOf(separator) + 1));
          itemLeft.css('flex-basis', "calc(100% / ".concat(proportionLeft + proportionRight, " * ").concat(proportionLeft, ")"));
          itemright.css('flex-basis', "calc(100% / ".concat(proportionLeft + proportionRight, " * ").concat(proportionRight, ")"));
        } // 隐藏


        if (input.hidden) item.hide(); // 添加控件

        var cptId = "".concat(_this3.id, "_").concat(input.type.toLowerCase(), "_").concat(index);

        switch (input.type.toLowerCase()) {
          case 'date':
          case 'time':
          case 'datetime':
            var datetimeCpt = $("<input type=\"text\" readonly inpId=\"".concat(input.id, "\">"));
            if (!_this3._tfp.isDesigning) datetimeCpt.attr('onclick', "".concat(_this3.id, ".dateOnClick(this)"));
            if (cellValue) datetimeCpt.attr('value', cellValue);
            itemright.append(datetimeCpt);
            break;

          case 'switch':
            itemright.css('text-align', 'right');

            if (input.readonly) {
              var switchCpt = $("<input type=\"text\" style=\"background-color:#eeeeee;\" disabled inpId=\"".concat(input.id, "\">"));
              if (cellValue) switchCpt.val(cellValue);
              itemright.append(switchCpt);
            } else {
              var _switchCpt = $("<div class=\"switch\" value=\"".concat(cellValue, "\" inpId=\"").concat(input.id, "\"><div></div></div>"));

              if (!_this3._tfp.isDesigning) _switchCpt.attr('onclick', "".concat(_this3.id, ".switchOnClick(this)"));
              itemright.append(_switchCpt);
              var enable = cellValue == true || cellValue == 'true' || input.options && cellValue == input.options[1];
              if (enable) _switchCpt.find('div').css({
                'float': 'right',
                'background-color': '#0099ff'
              });
              itemright.append(_switchCpt);
            }

            break;

          case 'select':
            var selectCpt = $("<input type=\"text\" readonly inpId=\"".concat(input.id, "\">"));
            if (input.style) selectCpt.attr('style', input.style);
            if (!_this3._tfp.isDesigning) selectCpt.attr('onclick', "".concat(_this3.id, ".selectOnClick(this)"));

            if (cellValue) {
              selectCpt.attr('value', cellValue).attr('data-value', cellValue);

              if (input.options) {
                for (var i = 0; i < input.options.length; i++) {
                  var option = input.options[i];

                  if (option.value == cellValue) {
                    selectCpt.attr('value', option.text).attr('data-value', option.value);
                    break;
                  }
                }
              }
            }

            itemright.append(selectCpt);
            break;

          case 'text':
          case 'password':
            var iptType = input.type.toLowerCase();
            if (input.dataType == "int" || input.dataType == "float" || input.dataType == "money") iptType = "number";
            var textCpt = $("<input type=\"".concat(iptType, "\" inpId=\"").concat(input.id, "\" value=\"").concat(cellValue, "\">"));
            if (input.style) textCpt.attr('style', input.style);
            if (_this3._tfp.isDesigning || input.readonly) textCpt.attr('readonly', '');
            if (cellValue) textCpt.val(cellValue);
            itemright.append(textCpt);
            break;

          case 'textarea':
            var textareaCpt = $("<textarea inpId=\"".concat(input.id, "\"></textarea>"));
            if (input.style) textareaCpt.attr('style', input.style);
            if (_this3._tfp.isDesigning || input.readonly) textareaCpt.attr('readonly', '');
            if (cellValue) textareaCpt.html(cellValue);
            itemright.append(textareaCpt);
            break;

          case 'radio':
            var radioCpt = $("<div class=\"radio\" inpId=\"".concat(input.id, "\"></div>"));

            if (input.options) {
              input.options.forEach(function (option) {
                var radio = $('<div class="radioitem"><div style="display: none"></div></div>');
                var label = $('<label></label>');
                if (!option.value) return true;
                radio.attr('data-option', option.value);
                if (!_this3._tfp.isDesigning) radio.attr('onclick', "".concat(_this3.id, ".radioOnClick(this)"));
                if (cellValue.split(",").contains(option.value)) radio.find('div').css('display', 'inline-block');
                label.html(option.text || option.value);
                radioCpt.append(radio).append(label);
              });
              itemright.append(radioCpt);
            } else {
              var radio = $('<div class="radioitem"><div style="display: none" data-option="1"></div></div>');
              if (!_this3._tfp.isDesigning) radio.attr('onclick', "".concat(_this3.id, ".radioOnClick(this)"));
              radioCpt.append(radio).append(label);
              itemright.append(radioCpt);
            }

            break;

          case 'checkbox':
            var checkboxCpt = $("<div class=\"checkbox\" inpId=\"".concat(input.id, "\"></div>"));

            if (input.options) {
              input.options.forEach(function (option) {
                var checkbox = $('<div class="checkboxitem"><div style="display: none"></div></div>');
                var label = $('<label></label>');
                if (!option.value) return true;
                checkbox.attr('data-option', option.value);
                if (!_this3._tfp.isDesigning) checkbox.attr('onclick', "".concat(_this3.id, ".checkboxOnClick(this)"));
                if (cellValue.split(",").contains(option.value)) checkbox.find('div').css('display', 'inline-block');
                label.html(option.text || option.value);
                checkboxCpt.append(checkbox).append(label);
              });
              itemright.append(checkboxCpt);
            } else {
              var checkbox = $('<div class="checkboxitem"><div style="display: none" data-option="1"></div></div>');
              if (!_this3._tfp.isDesigning) checkbox.attr('onclick', "".concat(_this3.id, ".checkboxOnClick(this)"));
              checkboxCpt.append(checkbox).append(label);
              itemright.append(checkboxCpt);
            }

            break;

          default:
            break;
        }

        html.append(item);
      });
      return html.prop("outerHTML");
    }
    /**
     * 点击单选时
     * @param  {[type]} divRadio [description]
     * @return {[type]}           [description]
     */

  }, {
    key: "radioOnClick",
    value: function radioOnClick(divRadio) {
      var that = this;
      $(divRadio).siblings(".radioitem").find('div').css('display', 'none');
      $(divRadio).find('div').css('display', 'inline-block');
      that.setRowsData();
    }
    /**
     * 点击多选时
     * @param  {[type]} divCheckbox [description]
     * @return {[type]}           [description]
     */

  }, {
    key: "checkboxOnClick",
    value: function checkboxOnClick(divCheckbox) {
      var that = this;
      var divCheckboxItem = $(divCheckbox).find('div');
      if (divCheckboxItem.css('display') == 'inline-block') divCheckboxItem.css('display', 'none');else divCheckboxItem.css('display', 'inline-block');
      that.setRowsData();
    }
    /**
     * 点击开关时
     * @param  {[type]} divSwitch [description]
     * @return {[type]}           [description]
     */

  }, {
    key: "switchOnClick",
    value: function switchOnClick(divSwitch) {
      var that = this;
      var dateItem = this.dataModel.columns[$(divSwitch).closest(".tfp-dataset-item").index() - 1];

      if ($(divSwitch).find("div").css("float") == "left") {
        $(divSwitch).find("div").css("float", "right");
        $(divSwitch).find("div").css("background-color", "#0099ff");
        $(divSwitch).attr("value", dateItem.options ? dateItem.options[1] : "true");
      } else {
        $(divSwitch).find("div").css("float", "left");

        if (this._tfp.curPage.bgColorMode == "dark") {
          $(divSwitch).find("div").css("background-color", "#666666");
        } else {
          $(divSwitch).find("div").css("background-color", "#999999");
        }

        $(divSwitch).attr("value", dateItem.options ? dateItem.options[0] : "false");
      }

      this.setRowsData();
      var rowIndex = $(divSwitch).closest(".tfp-dataset-row").index() - 1;
      var colIndex = $(divSwitch).closest(".tfp-dataset-item").index() - 1;
      var cellData = $(divSwitch).attr("value");

      if (this.dataModel.onCellClick) {
        try {
          eval(that.dataModel.onCellClick);
        } catch (err) {
          console.log(err);
        }
      }

      if (this.dataModel.onCellDataChange) {
        try {
          eval(that.dataModel.onCellDataChange);
        } catch (err) {
          console.error(err);
        }
      }
    }
    /**
    * 点击日期、日期时间时
    * @param  {[type]} divDate [description]
    * @return {[type]}           [description]
    */

  }, {
    key: "dateOnClick",
    value: function dateOnClick(divDate) {
      var that = this;
      var dateItem = this.dataModel.columns[$(divDate).closest(".tfp-dataset-item").index() - 1];
      var dateValue = $(divDate).val();
      var optionsList = [];

      if (dateItem.type == "datetime") {
        that.getDateOptions(optionsList, dateItem, dateValue);
        that.getTimeOptions(optionsList, dateItem, dateValue);
      } else if (dateItem.type == "date") {
        that.getDateOptions(optionsList, dateItem, dateValue);
      } else if (dateItem.type == "time") {
        that.getTimeOptions(optionsList, dateItem, dateValue);
      }

      window.popupList.show(optionsList, function (vals) {
        var val = '';

        if (dateItem.type == "datetime") {
          val = vals[0] + "-" + vals[1] + "-" + vals[2] + " " + vals[3] + ":" + vals[4];
        } else if (dateItem.type == "date") {
          val = vals[0] + "-" + vals[1] + "-" + vals[2];
        } else if (dateItem.type == "time") {
          val = vals[0] + ":" + vals[1];
        }

        if (vals.length > 0) $(divDate).val(val);else $(divDate).val("");
        that.setRowsData();
        var rowIndex = $(divDate).closest(".tfp-dataset-row").index() - 1;
        var colIndex = $(divDate).closest(".tfp-dataset-item").index() - 1;
        var cellData = $(divDate).val();

        if (that.dataModel.onCellDataChange) {
          try {
            eval(that.dataModel.onCellDataChange);
          } catch (err) {
            console.error(err);
          }
        }
      });
    }
  }, {
    key: "getDateOptions",
    value: function getDateOptions(optionsList, dateItem, dateValue) {
      var dateVal = new Date();
      if (dateItem["default"]) dateVal = new Date(dateItem["default"]);
      var yearOptions = {
        options: [],
        width: "80px",
        value: dateVal.getFullYear() + ""
      };

      for (var i = 1973; i <= 2073; i++) {
        yearOptions.options.push(i + "");
      }

      var curMonth = dateVal.getMonth() + 1;
      curMonth = curMonth < 10 ? "0" + curMonth : curMonth + "";
      var monthOptions = {
        options: [],
        width: dateItem.type == "DateTime" ? "60px" : "80px",
        value: curMonth
      };

      for (var i = 1; i <= 12; i++) {
        var month = i < 10 ? "0" + i : i + "";
        monthOptions.options.push(month);
      }

      monthOptions.onChange = function () {
        var month = window.popupList.getColumnVal(1);
        var dayCol = $(".tfp-popuplist-content-column").get(2);
        var items = $(dayCol).find(".tfp-popuplist-content-item");

        if (month == "02") {
          items.eq(32).hide();
          items.eq(33).hide();
          var year = parseInt(window.popupList.getColumnVal(0));

          if (year % 4 == 0) {
            items.eq(31).show();
          } else {
            items.eq(31).hide();
          }
        } else if (["04", "06", "09", "11"].contains(month)) {
          items.eq(31).show();
          items.eq(32).show();
          items.eq(33).hide();
        } else {
          items.eq(31).show();
          items.eq(32).show();
          items.eq(33).show();
        }
      };

      var curDay = dateVal.getDate();
      curDay = curDay < 10 ? "0" + curDay : curDay + "";
      var dateOptions = {
        options: [],
        width: dateItem.type == "DateTime" ? "60px" : "80px",
        value: curDay
      };

      for (var i = 1; i <= 31; i++) {
        var day = i < 10 ? "0" + i : i + "";
        dateOptions.options.push(day);
      }

      if (dateValue && new Date(dateValue) != 'Invalid Date') {
        dateVal = new Date(dateValue);
        yearOptions.value = dateVal.getFullYear().toString();
        monthOptions.value = (dateVal.getMonth() + 1).toString().padStart(2, 0);
        dateOptions.value = dateVal.getDate().toString().padStart(2, 0);
      }

      optionsList.push(yearOptions);
      optionsList.push(monthOptions);
      optionsList.push(dateOptions);
    }
  }, {
    key: "getTimeOptions",
    value: function getTimeOptions(optionsList, dateItem, dateValue) {
      var dateVal = new Date();
      if (dateItem["default"]) dateVal = new Date(dateItem["default"]);
      var curHour = dateVal.getHours();
      curHour = curHour < 10 ? "0" + curHour : curHour + "";
      var hourOptions = {
        options: [],
        width: "60px",
        value: curHour
      };

      for (var i = 0; i <= 23; i++) {
        var hour = i < 10 ? "0" + i : i + "";
        hourOptions.options.push(hour);
      }

      var curMinute = dateVal.getMinutes();
      curMinute = curMinute < 10 ? "0" + curMinute : curMinute + "";
      var minuteOptions = {
        options: [],
        width: "60px",
        value: curMinute
      };

      for (var i = 0; i <= 59; i++) {
        var day = i < 10 ? "0" + i : i + "";
        minuteOptions.options.push(day);
      }

      if (dateValue && /^\d{2}\:\d{2}$/.test(dateValue)) {
        dateVal = new Date('1970-01-01 ' + dateValue);
        hourOptions.value = dateVal.getHours().toString().padStart(2, 0);
        minuteOptions.value = dateVal.getMinutes().toString().padStart(2, 0);
      }

      optionsList.push(hourOptions);
      optionsList.push(minuteOptions);
    }
    /**
    * 点击下拉列表时
    * @param  {[type]} divSelect [description]
    * @return {[type]}           [description]
    */

  }, {
    key: "selectOnClick",
    value: function selectOnClick(divSelect) {
      if (!window.popupList) {
        this._tfp.use(["PopupList"], function () {
          var popupListClass = this._tfp.controllers["PopupList"];
          window.popupList = new popupListClass(this._tfp, {
            "id": "popupList",
            "type": "PopupList"
          });
          this.showPopupList(divSelect);
        });

        return;
      }

      this.showPopupList(divSelect);
    }
  }, {
    key: "showPopupList",
    value: function showPopupList(divSelect) {
      var that = this;
      var selectVal = this.dataModel.columns[$(divSelect).closest(".tfp-dataset-item").index() - 1];
      if (selectVal.readonly || !selectVal.options) return;
      that.loadOptionData(selectVal, divSelect, function () {
        window.popupList.show([{
          options: selectVal.options,
          value: divSelect.dataset.value
        }], function (vals) {
          var value = vals && vals.length > 0 ? vals[0] : "";
          $(divSelect).val(value).attr('data-value', value);

          for (var i = 0; i < selectVal.options.length; i++) {
            var option = selectVal.options[i];

            if (option.value == value) {
              $(divSelect).val(option.text).attr('data-value', option.value);
              break;
            }
          }

          that.setRowsData();
          var rowIndex = $(divSelect).closest(".tfp-dataset-row").index() - 1;
          var colIndex = $(divSelect).closest(".tfp-dataset-item").index() - 1;
          var cellData = $(divSelect).attr("data-value");

          if (that.dataModel.onCellDataChange) {
            try {
              eval(that.dataModel.onCellDataChange);
            } catch (err) {
              console.error(err);
            }
          }

          that.formulaCell($(divSelect), selectVal);
        });
      });
    }
  }, {
    key: "loadOptionData",
    value: function loadOptionData(selectVal, divSelect, cb) {
      if (!selectVal.loadDataListService) {
        return cb();
      }

      var serviceCpt = this._tfp.get(selectVal.loadDataListService);

      if (!serviceCpt) {
        alert("ID为[" + selectVal.loadDataListService + "]的组件不存在！");
        return;
      }

      if (!selectVal.dataListBindingMember) {
        alert("请为[" + this.id + "]设置数据绑定成员！");
        return;
      }

      if (!selectVal.dataListValueFormat) {
        alert("请为[" + this.id + "]设置选项值字段格式！");
        return;
      }

      var that = this;
      serviceCpt.request(null, function (req, res) {
        var data = res[selectVal.dataListBindingMember];
        that.bindOptionData(data, selectVal, divSelect, cb);
      });
    }
  }, {
    key: "bindOptionData",
    value: function bindOptionData(data, selectVal, divSelect, cb) {
      if (isNull(data) || !Array.isArray(data)) return;
      var options = [];

      for (var i = 0; i < data.length; i++) {
        var row = data[i];
        var option = {};

        try {
          option.value = this._tfp.replaceDataField(row, "" + selectVal.dataListValueFormat + "");
        } catch (e) {
          console.log(e);
          return;
        }

        if (isNull(option.value)) continue;

        if (selectVal.dataListTextFormat) {
          try {
            option.text = this._tfp.replaceDataField(row, "" + selectVal.dataListTextFormat + "");
          } catch (e) {
            console.log(e);
            return;
          }
        }

        options.push(option);
        selectVal.options = options;
      }

      if (cb) cb();
    } // 初始化行样式，添加行

  }, {
    key: "initRowChange",
    value: function initRowChange() {
      var that = this;
      changeRow(); // 绑定添加按钮的点击事件

      this._jqObj.find(".tfp-dataset-button-add,.tfp-dataset-tool>.tfp-dataset-button-insert").off('click').click(function () {
        that._jqObj.find(".tfp-dataset-button").before(that.getRowHtml(that.value.length, {}));

        changeRow();
      });

      function changeRow() {
        // 删除外边框
        that._jqObj.find(".tfp-dataset-item,.tfp-dataset-item-left,.tfp-dataset-item-right").css("outline", "none"); // 判断是否删除表格头


        if (that._jqObj.find(".tfp-dataset-row").length) that._jqObj.find('.tfp-dataset-toolbar').hide();else that._jqObj.find('.tfp-dataset-toolbar').show(); // 遍历表格行

        that._jqObj.find(".tfp-dataset-row").each(function (rowIndex) {
          // 重置标题
          $(this).find('.tfp-dataset-row-header-title').text("".concat(that.dataModel.titleName || that.dataModel.id, "(").concat(rowIndex + 1, ")")); // 插入按钮

          $(this).find('.tfp-dataset-button-insert').off('click').on('click', function () {
            $(this).parents('.tfp-dataset-row').eq(0).after(that.getRowHtml(that.value.length, {}));
            changeRow();
            that.setRowsData();
          }); // 上移按钮

          $(this).find('.tfp-dataset-button-moveUp').off('click').on('click', function () {
            if (rowIndex == 0) return;
            var thisRow = $(this).parents('.tfp-dataset-row').eq(0);
            var prevRow = thisRow.prev();
            prevRow.before(thisRow);
            changeRow();
            that.setRowsData();
          }); // 下移按钮

          $(this).find('.tfp-dataset-button-moveDown').off('click').on('click', function () {
            if (rowIndex == that._jqObj.find(".tfp-dataset-row").length - 1) return;
            var thisRow = $(this).parents('.tfp-dataset-row').eq(0);
            var nextRow = thisRow.next();
            nextRow.after(thisRow);
            changeRow();
            that.setRowsData();
          }); // 删除按钮

          $(this).find('.tfp-dataset-button-delete').off('click').on('click', function () {
            $(this).parents('.tfp-dataset-row').remove();
            changeRow();
            that.setRowsData();
          });
        });

        that._jqObj.find("input").change(function () {
          that.setRowsData($(this));
        });

        that.setRowsData();
        that.bindInpEvent();
      }
    }
  }, {
    key: "setRowsData",
    value: function setRowsData(divInput) {
      var rowsData = [];

      this._jqObj.find(".tfp-dataset-row").each(function () {
        var that = $(this);
        var rowsDataItem = {};
        that.find(".tfp-dataset-item-right").children().each(function () {
          var inpId = $(this).attr("inpId");

          switch ($(this).attr('class')) {
            case 'switch':
              rowsDataItem[inpId] = $(this).attr("value");
              break;

            case 'radio':
              $(this).find('.radioitem div').each(function () {
                if ($(this).css('display') == 'inline-block') {
                  rowsDataItem[inpId] = $(this).parent().attr("data-option");
                }
              });
              break;

            case 'checkbox':
              var temp = [];
              $(this).find('.checkboxitem div').each(function () {
                if ($(this).css('display') == 'inline-block') {
                  temp.push($(this).parent().attr("data-option"));
                }
              });
              rowsDataItem[inpId] = temp.join();
              break;

            default:
              rowsDataItem[inpId] = this.dataset.value || $(this).val();
              break;
          }
        });
        rowsData.push(rowsDataItem);
      });

      this.value = rowsData;

      if (divInput) {
        var that = this;
        var rowIndex = $(divInput).closest(".tfp-dataset-row").index() - 1;
        var colIndex = $(divInput).closest(".tfp-dataset-item").index() - 1;
        var cellData = $(divInput).val();

        if (this.dataModel.onCellDataChange) {
          try {
            eval(that.dataModel.onCellDataChange);
          } catch (err) {
            console.error(err);
          }
        }
      }
    }
  }, {
    key: "bindInpEvent",
    value: function bindInpEvent() {
      var that = this;

      this._jqObj.find("input").click(function () {
        var input = that.dataModel.columns[$(this).closest(".tfp-dataset-item").index() - 1];
        var rowIndex = $(this).closest(".tfp-dataset-row").index() - 1;
        var cellData = $(this).val();
        if (input.type.toLowerCase() == 'select') cellData = $(this).attr("data-value") || '';

        if (that.dataModel.onCellClick) {
          try {
            eval(that.dataModel.onCellClick);
          } catch (err) {
            console.error(err);
          }
        }
      });

      this._jqObj.find("input").dblclick(function () {
        var input = that.dataModel.columns[$(this).closest(".tfp-dataset-item").index() - 1];
        var rowIndex = $(this).closest(".tfp-dataset-row").index() - 1;
        var cellData = $(this).val();
        if (input.type.toLowerCase() == 'select') cellData = $(this).attr("data-value") || '';

        if (that.dataModel.onCellDblClick) {
          try {
            eval(that.dataModel.onCellDblClick);
          } catch (err) {
            console.error(err);
          }
        }
      });

      this._jqObj.find("input").focus(function () {
        var input = that.dataModel.columns[$(this).closest(".tfp-dataset-item").index() - 1];
        var rowIndex = $(this).closest(".tfp-dataset-row").index() - 1;
        var cellData = $(this).val();
        if (input.type.toLowerCase() == 'select') cellData = $(this).attr("data-value") || '';

        if (that.dataModel.onCellFocus) {
          try {
            eval(that.dataModel.onCellFocus);
          } catch (err) {
            console.error(err);
          }
        }
      });

      this._jqObj.find("input").blur(function () {
        var input = that.dataModel.columns[$(this).closest(".tfp-dataset-item").index() - 1];
        var rowIndex = $(this).closest(".tfp-dataset-row").index() - 1;
        var cellData = $(this).val();
        if (input.type.toLowerCase() == 'select') cellData = $(this).attr("data-value") || '';

        if (that.dataModel.onCellBlur) {
          try {
            eval(that.dataModel.onCellBlur);
          } catch (err) {
            console.error(err);
          }
        }

        that.formulaCell($(this), that.dataModel.columns[$(this).closest(".tfp-dataset-item").index() - 1]);
      });

      this._jqObj.find("input").keypress(function () {
        var input = that.dataModel.columns[$(this).closest(".tfp-dataset-item").index() - 1];
        var rowIndex = $(this).closest(".tfp-dataset-row").index() - 1;
        var cellData = $(this).val();
        if (input.type.toLowerCase() == 'select') cellData = $(this).attr("data-value") || '';

        if (that.dataModel.onCellKeyPress) {
          try {
            eval(that.dataModel.onCellKeyPress);
          } catch (err) {
            console.error(err);
          }
        }
      });
    }
  }, {
    key: "formulaCell",
    value: function formulaCell(ipt, input) {
      if (this.calcRows && this.calcRows[input.id]) {
        //获得当前行的数据
        var curRowDiv = $(ipt).parent().parent().parent();
        var rowData = this.value[$(ipt).parent().parent().parent().index()];
        var rowDataTmp = {};

        for (var k in rowData) {
          if (rowData[k] != "") {
            rowDataTmp[k] = rowData[k];
          }
        }

        var arr = this.calcRows[input.id];

        for (var j = 0; j < arr.length; j++) {
          for (var k = 0; k < this.dataModel.columns.length; k++) {
            var rowR = this.dataModel.columns[k];

            if (arr[j] == rowR.id && rowR.formula) {
              this.exeFormula(rowR, rowDataTmp, curRowDiv, k);
              break;
            }
          }
        }
      }
    }
    /**
     * 执行计算表达式
     * @param  {[type]} rowR      [description]
     * @param  {[type]} rowData   [description]
     * @param  {[type]} curRowDiv [description]
     * @param  {[type]} rowIndex  [description]
     * @return {[type]}           [description]
     */

  }, {
    key: "exeFormula",
    value: function exeFormula(rowR, rowData, curRowDiv, rowIndex) {
      var rowRFormula = this._tfp.replaceDataField(rowData, rowR.formula, 0);

      var formulaVal = null;

      try {
        formulaVal = eval(rowRFormula);
      } catch (error) {
        console.error(error.message);
        return;
      }

      if (rowR.type == "text" && (rowR.dataType == "int" || rowR.dataType == "float" || rowR.dataType == "money")) {
        if (rowR.dataType == "int") {
          formulaVal = parseInt(formulaVal);
        } else if (rowR.dataType == "float") {
          formulaVal = parseFloat(formulaVal);
        } else if (rowR.dataType == "money") {
          formulaVal = this._tfp.formatMoney(formulaVal);
        }
      }

      var rowRDivIndex = rowIndex;
      curRowDiv.children().eq(rowRDivIndex).find("input").val(formulaVal);
      this.setRowsData();
    }
    /**
    * form表单提交校验
    * @param  {[type]}   options [description]
    * @return {[type]}           [description]
    */

  }, {
    key: "getRowsData",
    value: function getRowsData(options, cb) {
      var values = [];
      this.setRowsData();
      this.value.forEach(function (item) {
        for (var key in item) {
          values.push((0, _defineProperty2["default"])({}, key, item[key]));
        }
      });

      for (var i = 0; i < this.dataModel.columns.length; i++) {
        if (i < values.length) {
          var input = this.dataModel.columns[i];
          var obj = values[i];

          if (input.required == true && obj[input.id] == "") {
            var rowType = input.type;
            var rowName = input.id;
            if (input.name) rowName = input.name;

            if (options && options.checkRequired) {
              this._tfp.showMsg(rowName + "不能为空！");

              if (rowType == "text" || rowType == "select" || rowType == "password" || rowType == "date" || rowType == "datetime") {
                this._jqObj.find(".tfp-dataset-row").children().eq(i).find("input").focus();
              }

              return null;
            }
          }
        }
      }

      if (cb) {
        cb(this.value);
      } else {
        return this.value;
      }
    }
    /**
     * 绑定数据
     * @param  {[type]} data [description]
     * @return {[type]}      [description]
     */

  }, {
    key: "bindData",
    value: function bindData(data) {
      this.rows = data;
    }
  }, {
    key: "onLoadData",
    value: function onLoadData(req, res) {
      var dataMember = this.dataModel.dataBindingMember;

      if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
        dataMember = this.dataModel.dataQuerySetting.dataMember;
      }

      var data = res[dataMember];
      if (!data) return;

      if (data.pageSize && data.rows) {
        this.bindData(data.rows);
      } else {
        this.bindData(data);
      }

      this.initRowChange();
    }
  }, {
    key: "submit",
    value: function submit(options) {
      if (!this.dataModel.submitService && !this.dataModel.dataSubmitSetting) {
        this._tfp.showMsg("请为[" + this.id + "]设置数据提交有关参数！");

        return;
      }

      this.exeEventHandler("onBeforeSubmit");
      var that = this;
      var args = {};
      args[that.id] = this.getRowsData(options);

      if (this.dataModel.dataSubmitSetting && this.dataModel.dataSubmitSetting.servicePath) {
        var optionsReq = {
          servicePath: this.dataModel.dataSubmitSetting.servicePath,
          autoShowError: true,
          showLoading: true,
          args: args
        };

        if (that.dataModel.dataSubmitSetting.requestArgs && that.dataModel.dataSubmitSetting.requestArgs.length > 0) {
          optionsReq.argSettings = that.dataModel.dataSubmitSetting.requestArgs;
        }

        if (that.dataModel.dataSubmitSetting.encryptRequestArgs) optionsReq.encryptRequestArgs = that.dataModel.dataSubmitSetting.encryptRequestArgs;
        if (that.dataModel.dataSubmitSetting.encryptResponseArgs) optionsReq.encryptResponseArgs = that.dataModel.dataSubmitSetting.encryptResponseArgs;

        that._tfp.request(optionsReq, function (req, res) {
          that.exeEventHandler("onAfterSubmit", res);
        });

        return;
      }

      var serviceId = this.dataModel.submitService;

      if (this.dataModel.dataSubmitSetting && this.dataModel.dataSubmitSetting.serviceCpt) {
        serviceId = this.dataModel.dataSubmitSetting.serviceCpt;
      }

      var serviceCpt = that._tfp.get(serviceId);

      if (!serviceCpt) {
        that._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");

        return;
      }

      serviceCpt.request(args, function (req, res) {
        that.exeEventHandler("onAfterSubmit", res);
      });
    }
  }, {
    key: "setColOptions",
    value: function setColOptions(col, cb) {
      if (col.type.toLowerCase() != "select" && col.type.toLowerCase() != "popuplist") {
        if (cb) cb();
        return;
      }

      if (col.jsonDataSet) {
        col.loadDataListService = col.jsonDataSet.loadDataListService;
        col.dataListBindingMember = col.jsonDataSet.dataListBindingMember;
        col.valueField = col.jsonDataSet.valueField;
        col.textField = col.jsonDataSet.textField;
        col.parentIdField = col.jsonDataSet.parentIdField;
        col.options = col.jsonDataSet.options; // this.dataModel.defaultValue = this.dataModel.jsonDataSet.defaultValue;
      } //如果设置了数据加载服务，则从后台加载数据


      if (col.loadDataListService && col.dataListBindingMember) {
        var serviceCpt = this._tfp.get(col.loadDataListService);

        if (!serviceCpt) {
          alert("ID为[" + col.loadDataListService + "]的组件不存在！");
          return;
        }

        if (!col.dataListBindingMember) {
          alert("请为[" + this.id + "]设置数据绑定成员！");
          return;
        }

        var that = this;
        serviceCpt.status = 0;
        serviceCpt.request(null, function (req, res) {
          var data = res[col.dataListBindingMember];
          if (!data) return; //let options = [];

          if (data.pageSize && data.rows) {
            data = data.rows;
          }

          if (col.valueField) {
            var optionsTmp = [];

            for (var i = 0; i < data.length; i++) {
              var rowTmp = data[i];
              var optionTmp = {};

              try {
                optionTmp.value = that._tfp.replaceDataField(rowTmp, "{" + col.valueField + "}");
              } catch (e) {}

              if (isNull(optionTmp.value)) continue;

              if (col.textField) {
                try {
                  optionTmp.text = that._tfp.replaceDataField(rowTmp, "{" + col.textField + "}");
                } catch (e) {}
              }

              optionsTmp.push(optionTmp);
            }

            col.options = optionsTmp;
          } else {
            col.options = data;
          }

          if (cb) cb();
        });
      } else if (col.options) {
        //否则，如果该列设置了固定的可选项
        var options = [];

        try {
          col.options = JSON.parse(col.options);
        } catch (error) {}

        if (Array.isArray(col.options)) {
          for (var j = 0; j < col.options.length; j++) {
            var option = col.options[j];

            if (typeof option == "string") {
              options.push({
                value: option,
                text: option
              });
            } else if (Object.prototype.toString.call(option) === '[object Object]') {
              if (!option.text && option.text != 0) option.text = option.value;
              options.push(option);
            }
          }
        } else if (typeof col.options == "string") {
          var arr = (col.options + '').split(",");

          for (var j = 0; j < arr.length; j++) {
            options.push({
              value: arr[j],
              text: arr[j]
            });
          }
        }

        col.options = options;
        if (cb) cb();
      } else {
        col.options = [];
        if (cb) cb();
      }
    }
  }, {
    key: "setColOptionsLoop",
    value: function setColOptionsLoop(cb) {
      var that = this;

      if (that.tmp_index >= this.dataModel.columns.length) {
        cb();
      } else {
        //加载下拉列表列和弹出列表列的可选项
        this.setColOptions(this.dataModel.columns[that.tmp_index], function () {
          that.tmp_index++;
          that.setColOptionsLoop(cb);
        });
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      if (this.dataModel.columns) {
        this.tmp_index = 0;
        this.setColOptionsLoop(function () {
          that.initRuntimeGoon();
        });
      } else {
        that.initRuntimeGoon();
      }
    }
  }, {
    key: "getRowData",
    value: function getRowData(index) {
      if (this.value.length > 0 && this.value.length > index) return this.value[index];else return '';
    }
  }, {
    key: "getCellData",
    value: function getCellData(rowIndex, colIndex) {
      if (this.value.length > 0 && this.value.length > rowIndex) {
        var obj = this.value[rowIndex];
        var objArray = Object.values(obj);
        var thirdElement = '';
        if (objArray.length > 0 && objArray.length > colIndex) thirdElement = objArray[colIndex];
        return thirdElement;
      } else {
        return '';
      }
    }
  }, {
    key: "initRuntimeGoon",
    value: function initRuntimeGoon() {
      //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      } else {
        this.bindData([]);
        this.initRowChange();
      } //设置计算行关联的行，以便当关联行的数据发生变化时，自动执行计算行的值


      if (this.dataModel.columns) {
        //存在关联计算的行
        this.calcRows = {};

        for (var i = 0; i < this.dataModel.columns.length; i++) {
          var input = this.dataModel.columns[i]; // 如果是计算行

          if (input.formula) {
            var arr = input.formula.match(/\{[\w]+\}/g);

            if (arr.length > 0) {
              for (var j = 0; j < arr.length; j++) {
                for (var k = 0; k < this.dataModel.columns.length; k++) {
                  var rowR = this.dataModel.columns[k]; //如果当前行与计算行有关联，则标示为计算关联行

                  if ("{" + rowR.id + "}" == arr[j]) {
                    if (!this.calcRows[rowR.id]) {
                      this.calcRows[rowR.id] = [];
                    }

                    if (!this.calcRows[rowR.id].contains(input.id)) this.calcRows[rowR.id].push(input.id);
                  }
                }
              }
            }
          }
        }
      }
    }
  }]);
  return DataSet;
}(_controller.VisibleComponent);

exports["default"] = DataSet;