"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 数据集组件
 * @param {[type]} dataModel [description]
 */
var DataSet = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(DataSet, _VisibleComponent);

  var _super = _createSuper(DataSet);

  function DataSet(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, DataSet);
    _this = _super.call(this, __tfp, "DataSet", dataModel, parent);

    if (_this._tfp.isDesigning && (!_this.dataModel.columns || _this.dataModel.columns.length == 0)) {
      //默认创建1行3列
      _this.dataModel.columns = [{
        id: "col1",
        name: "第1列",
        type: "text",
        width: "60px"
      }, {
        id: "col2",
        name: "第2列",
        type: "text",
        width: "60px"
      }, {
        id: "col3",
        name: "第3列",
        type: "text",
        width: "60px"
      }];
    }

    _this.curRowIndex = -1;
    _this.curCellRowIndex = -1;
    _this.curCellColIndex = -1;
    _this.rowNumColWidth = 40;
    _this.subCptIndex = 0; //子组件索引，不能用rowIndex，因为会删除行，造成重复

    return _this;
  }

  (0, _createClass2["default"])(DataSet, [{
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    }
  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    }
  }, {
    key: "columns",
    get: function get() {
      return this.dataModel.columns;
    },
    set: function set(value) {
      this.dataModel.columns = value;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "rows",
    get: function get() {
      return this.getRows({
        checkRequired: false
      });
    },
    set: function set(value) {
      this.dataModel.rows = value;

      if (this._jqObj) {
        var that = this;
        this.reRenderBody(function () {
          if (that.dataModel.onAfterBindData) {
            try {
              var data = value;
              eval(that.dataModel.onAfterBindData);
            } catch (err) {
              console.log(err);
            }
          }
        });
      }
    }
  }, {
    key: "keyCol",
    get: function get() {
      return this.dataModel.keyCol;
    },
    set: function set(value) {
      this.dataModel.keyCol = value;

      if (this._jqObj) {//
      }
    }
  }, {
    key: "rowHeight",
    get: function get() {
      return this.dataModel.rowHeight;
    },
    set: function set(value) {
      if (!this._tfp.isInt(value)) return;
      this.dataModel.rowHeight = parseInt(value);

      if (this._jqObj) {
        var that = this;

        this._jqObj.children(".tfp-dataset-list").children("div").children("div").each(function () {
          $(this).css("height", that.dataModel.rowHeight + "px");
        });
      }
    }
  }, {
    key: "showAddButton",
    get: function get() {
      return this.dataModel.showAddButton;
    },
    set: function set(value) {
      this.dataModel.showAddButton = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showAddButton) {
          this._jqObj.find(".tfp-dataset-header").css("height", "70px");

          this._jqObj.find(".tfp-dataset-list").css("top", "71px");

          this._jqObj.find(".tfp-dataset-button-list").show();

          this._jqObj.find(".tfp-dataset-button-add").show();
        } else {
          this._jqObj.find(".tfp-dataset-button-add").hide();

          if (!this.dataModel.showAddFromDialogButton) {
            this._jqObj.find(".tfp-dataset-button-list").hide();

            this._jqObj.find(".tfp-dataset-header").css("height", "30px");

            this._jqObj.find(".tfp-dataset-list").css("top", "31px");
          }
        }
      }
    }
  }, {
    key: "showDelRowConfirm",
    get: function get() {
      return this.dataModel.showDelRowConfirm;
    },
    set: function set(value) {
      this.dataModel.showDelRowConfirm = value ? true : false;
    }
  }, {
    key: "addButtonText",
    get: function get() {
      if (!this.dataModel.addButtonText) this.dataModel.addButtonText = "添加";
      return this.dataModel.addButtonText;
    },
    set: function set(value) {
      this.dataModel.addButtonText = value;

      if (this._jqObj) {
        this._jqObj.find(".tfp-dataset-button-add").html(value);
      }
    }
  }, {
    key: "showAddFromDialogButton",
    get: function get() {
      return this.dataModel.showAddFromDialogButton;
    },
    set: function set(value) {
      this.dataModel.showAddFromDialogButton = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showAddFromDialogButton) {
          this._jqObj.find(".tfp-dataset-header").css("height", "70px");

          this._jqObj.find(".tfp-dataset-list").css("top", "71px");

          this._jqObj.find(".tfp-dataset-button-list").show();

          this._jqObj.find(".tfp-dataset-button-add-from-dialog").show();
        } else {
          this._jqObj.find(".tfp-dataset-button-add-from-dialog").hide();

          if (!this.dataModel.showAddButton) {
            this._jqObj.find(".tfp-dataset-button-list").hide();

            this._jqObj.find(".tfp-dataset-header").css("height", "30px");

            this._jqObj.find(".tfp-dataset-list").css("top", "31px");
          }
        }
      }
    }
  }, {
    key: "addFromDialogButtonText",
    get: function get() {
      if (!this.dataModel.addFromDialogButtonText) this.dataModel.addFromDialogButtonText = "弹窗选择";
      return this.dataModel.addFromDialogButtonText;
    },
    set: function set(value) {
      this.dataModel.addFromDialogButtonText = value;

      if (this._jqObj) {
        this._jqObj.find(".tfp-dataset-button-add-from-dialog").html(value);
      }
    }
  }, {
    key: "addFromDialogPath",
    get: function get() {
      return this.dataModel.addFromDialogPath;
    },
    set: function set(value) {
      this.dataModel.addFromDialogPath = value;
    }
  }, {
    key: "addFromDialogWidth",
    get: function get() {
      return this.dataModel.addFromDialogWidth;
    },
    set: function set(value) {
      this.dataModel.addFromDialogWidth = value;
    }
  }, {
    key: "addFromDialogHeight",
    get: function get() {
      return this.dataModel.addFromDialogHeight;
    },
    set: function set(value) {
      this.dataModel.addFromDialogHeight = value;
    }
  }, {
    key: "showRowNum",
    get: function get() {
      return this.dataModel.showRowNum;
    },
    set: function set(value) {
      this.dataModel.showRowNum = value ? true : false;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "showCheckbox",
    get: function get() {
      return this.dataModel.showCheckbox;
    },
    set: function set(value) {
      this.dataModel.showCheckbox = value ? true : false;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "enableInsert",
    get: function get() {
      return this.dataModel.enableInsert ? true : false;
    },
    set: function set(value) {
      this.dataModel.enableInsert = value ? true : false;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "enableClear",
    get: function get() {
      return this.dataModel.enableClear ? true : false;
    },
    set: function set(value) {
      this.dataModel.enableClear = value ? true : false;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "enableDelete",
    get: function get() {
      return this.dataModel.enableDelete ? true : false;
    },
    set: function set(value) {
      this.dataModel.enableDelete = value ? true : false;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "enableMove",
    get: function get() {
      return this.dataModel.enableMove ? true : false;
    },
    set: function set(value) {
      this.dataModel.enableMove = value ? true : false;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "showMoveButton",
    get: function get() {
      return this.dataModel.showMoveButton ? true : false;
    },
    set: function set(value) {
      this.dataModel.showMoveButton = value ? true : false;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "showDelButton",
    get: function get() {
      return this.dataModel.showDelButton ? true : false;
    },
    set: function set(value) {
      this.dataModel.showDelButton = value ? true : false;

      if (this._jqObj) {
        this.reRenderBody();
      }
    }
  }, {
    key: "enterKeyMode",
    get: function get() {
      return this.dataModel.enterKeyMode;
    },
    set: function set(value) {
      this.dataModel.enterKeyMode = value;
    }
  }, {
    key: "enterKeyAddRow",
    get: function get() {
      return this.dataModel.enterKeyAddRow ? true : false;
    },
    set: function set(value) {
      this.dataModel.enterKeyAddRow = value ? true : false;
    }
  }, {
    key: "reRenderBody",
    value: function reRenderBody(cb) {
      this.dataModel.components = [];
      this.newCpts = [];

      this._jqObj.find(".tfp-dataset-titlerow").remove();

      this._jqObj.find(".tfp-dataset-header").append(this.getTitleHtml());

      this._jqObj.find(".tfp-dataset-list").remove();

      this._jqObj.append(this.getBodyHtml());

      this.bindEventHandler(); //this.initRuntime();

      if (cb) cb();
    }
  }, {
    key: "getHeaderHtml",
    value: function getHeaderHtml() {
      var indent = this.getHtmlIndent();
      var headerHeight = 0;
      var showButtonList = false;

      if (this.dataModel.showAddButton || this.dataModel.showAddFromDialogButton) {
        showButtonList = true;
        headerHeight = 40;
      }

      var html = indent + "\t\t<div class=\"tfp-dataset-button-list\"";
      if (!showButtonList) html += " style=\"display:none;\"";
      html += ">\r\n";
      html += indent + "\t\t\t<div class=\"tfp-dataset-button-add\"";
      if (!this.dataModel.showAddButton) html += " style=\"display:none;\"";
      html += ">" + this.addButtonText + "</div>\r\n";
      html += indent + "\t\t\t<div class=\"tfp-dataset-button-add-from-dialog\"";
      if (!this.dataModel.showAddFromDialogButton) html += " style=\"display:none;\"";
      html += ">" + this.addFromDialogButtonText + "</div>\r\n";
      html += indent + "\t\t</div>\r\n";
      var htmlTooBar = "";
      var iconPath = this._tfp.rootPath + "/src/components/dataset/images/";

      if (this.dataModel.enableInsert) {
        htmlTooBar += indent + "\t\t\t<div class=\"tfp-dataset-button-icon\"";
        if (!this._tfp.isDesigning) htmlTooBar += " onclick=\"" + this.id + ".addRow({})\"";
        htmlTooBar += "><img src='" + iconPath + "add-" + this._tfp.curPage.bgColorMode + ".png' title=\"在底部插入新行\"></div>\r\n";
        htmlTooBar += indent + "\t\t\t<div class=\"tfp-dataset-button-icon\"";
        if (!this._tfp.isDesigning) htmlTooBar += " onclick=\"" + this.id + ".insertRowBeforeCurRow({})\"";
        htmlTooBar += "><img src='" + iconPath + "insert-before-" + this._tfp.curPage.bgColorMode + ".png' title=\"在当前行前面插入新行\"></div>\r\n";
        htmlTooBar += indent + "\t\t\t<div class=\"tfp-dataset-button-icon\"";
        if (!this._tfp.isDesigning) htmlTooBar += " onclick=\"" + this.id + ".insertRowAfterCurRow({})\"";
        htmlTooBar += "><img src='" + iconPath + "insert-after-" + this._tfp.curPage.bgColorMode + ".png' title=\"在当前行后面插入新行\"></div>\r\n";
        /*if(htmlTooBar!="") htmlTooBar += "<span style=\"flex-grow:0;flex-shrink:0;flex-basis:1px;"
          +"height:16px;background-color:#cccccc;margin:5px;\"></span>\r\n";
          htmlTooBar += indent + "\t\t\t<div class=\"tfp-dataset-button-icon\"";
          if (!this._tfp.isDesigning) htmlTooBar += " onclick=\"" + this.id + ".cuteRow({})\"";
          htmlTooBar += "><img src='" + iconPath + "cut-"+this._tfp.curPage.bgColorMode+".png' title=\"剪切\"></div>\r\n";
        htmlTooBar += indent + "\t\t\t<div class=\"tfp-dataset-button-icon\"";
        if (!this._tfp.isDesigning) htmlTooBar += " onclick=\"" + this.id + ".copyRow({})\"";
        htmlTooBar += "><img src='" + iconPath + "copy-"+this._tfp.curPage.bgColorMode+".png' title=\"复制\"></div>\r\n";
        htmlTooBar += indent + "\t\t\t<div class=\"tfp-dataset-button-icon\"";
        if (!this._tfp.isDesigning) htmlTooBar += " onclick=\"" + this.id + ".pasteRow({})\"";
        htmlTooBar += "><img src='" + iconPath + "paste-"+this._tfp.curPage.bgColorMode+".png' title=\"粘贴\"></div>\r\n";*/
      }

      if (this.dataModel.enableMove) {
        if (htmlTooBar != "") htmlTooBar += "<span style=\"flex-grow:0;flex-shrink:0;flex-basis:1px;" + "height:16px;background-color:#cccccc;margin:5px;\"></span>\r\n";
        htmlTooBar += indent + "\t\t\t<div class=\"tfp-dataset-button-icon\"";
        if (!this._tfp.isDesigning) htmlTooBar += " onclick=\"" + this.id + ".moveCurRowToFirst({})\"";
        htmlTooBar += "><img src='" + iconPath + "move-to-top-" + this._tfp.curPage.bgColorMode + ".png' title=\"移到顶部\"></div>\r\n";
        htmlTooBar += indent + "\t\t\t<div class=\"tfp-dataset-button-icon\"";
        if (!this._tfp.isDesigning) htmlTooBar += " onclick=\"" + this.id + ".moveCurRowUp({})\"";
        htmlTooBar += "><img src='" + iconPath + "up-" + this._tfp.curPage.bgColorMode + ".png' title=\"上移\"></div>\r\n";
        htmlTooBar += indent + "\t\t\t<div class=\"tfp-dataset-button-icon\"";
        if (!this._tfp.isDesigning) htmlTooBar += " onclick=\"" + this.id + ".moveCurRowDown({})\"";
        htmlTooBar += "><img src='" + iconPath + "down-" + this._tfp.curPage.bgColorMode + ".png' title=\"下移\"></div>\r\n";
        htmlTooBar += indent + "\t\t\t<div class=\"tfp-dataset-button-icon\"";
        if (!this._tfp.isDesigning) htmlTooBar += " onclick=\"" + this.id + ".moveCurRowToLast({})\"";
        htmlTooBar += "><img src='" + iconPath + "move-to-bottom-" + this._tfp.curPage.bgColorMode + ".png' title=\"移到底部\"></div>\r\n";
      }

      if (this.dataModel.enableClear) {
        if (htmlTooBar != "") htmlTooBar += "<span style=\"flex-grow:0;flex-shrink:0;flex-basis:1px;" + "height:16px;background-color:#cccccc;margin:5px;\"></span>\r\n";
        htmlTooBar += indent + "\t\t\t<div class=\"tfp-dataset-button-icon btn-clear-data\" style=\"flex-basis: 34px;\"";
        if (!this._tfp.isDesigning) htmlTooBar += " onmouseover=\"" + this.id + ".showClearDataMenu(this)\" onmouseout=\"" + this.id + ".hideClearDataMenu()\"";
        htmlTooBar += "><img src='" + iconPath + "clear-" + this._tfp.curPage.bgColorMode + ".png' title=\"清除数据\">\r\n";
        htmlTooBar += indent + "\t<img style=\"flex-basis: 6px;height:6px; margin-left:4px;\" src=\"" + iconPath + "arrow-down-" + this._tfp.curPage.bgColorMode + ".png\" />\r\n";
        htmlTooBar += "</div>\r\n";
      }

      if (this.dataModel.enableDelete) {
        if (htmlTooBar != "") htmlTooBar += "<span style=\"flex-grow:0;flex-shrink:0;flex-basis:1px;" + "height:16px;background-color:#cccccc;margin:5px;\"></span>\r\n";
        htmlTooBar += indent + "\t\t\t<div class=\"tfp-dataset-button-icon btn-remove-row\" style=\"flex-basis: 34px;\"";
        if (!this._tfp.isDesigning) htmlTooBar += " onmouseover=\"" + this.id + ".showRemoveRowMenu()\" onmouseout=\"" + this.id + ".hideRemoveRowMenu()\"";
        htmlTooBar += "><img src='" + iconPath + "del-" + this._tfp.curPage.bgColorMode + ".png' title=\"删除行\">\r\n";
        htmlTooBar += indent + "\t<img style=\"flex-basis: 6px;height:6px; margin-left:4px;\" src=\"" + iconPath + "arrow-down-" + this._tfp.curPage.bgColorMode + ".png\" />\r\n";
        htmlTooBar += "</div>\r\n";
      }

      if (htmlTooBar != "") html += indent + "\t\t<div class=\"tfp-dataset-toolbar\">\r\n" + indent + "\t" + htmlTooBar + "\r\n\t" + indent + "</div>";
      html += indent + "\t<div class=\"tfp-dataset-header\">"; // style=\"top:"+headerHeight+"px;\">\r\n";

      html += this.getTitleHtml();
      html += indent + "\t</div>\r\n";
      return html;
    }
  }, {
    key: "showClearDataMenu",
    value: function showClearDataMenu() {
      var btnEl = this._jqObj.children(".tfp-dataset-toolbar").find(".btn-clear-data");

      var offset = $(btnEl).offset();
      var menuEl = $("#" + this.id + "_ClearDataMenu");

      if (menuEl.length == 0) {
        $("body").append("<div id=\"" + this.id + "_ClearDataMenu\" class=\"tfp-dataset-toolbar-menu\"" + " onmouseover=\"" + this.id + ".showClearDataMenu()\" onmouseout=\"" + this.id + ".hideClearDataMenu()\"" + "style=\"display:none;top:" + (offset.top + 22) + ";left:" + offset.left + "px;\">" + "<div onclick=\"" + this.id + ".clearCurRowData()\">清空当前行数据</div>" + "<div onclick=\"" + this.id + ".clearCheckedRowsData()\">清空选中行数据</div>" + "<div onclick=\"" + this.id + ".clearAllData()\">清空全部数据</div></div>");
      }

      menuEl.css("top", offset.top + 22 + "px");
      menuEl.css("left", offset.left + "px");
      menuEl.css('display', "flex");
    }
  }, {
    key: "hideClearDataMenu",
    value: function hideClearDataMenu() {
      var menuEl = $("#" + this.id + "_ClearDataMenu");
      if (menuEl.length == 0) return;
      menuEl.hide();
    }
  }, {
    key: "showRemoveRowMenu",
    value: function showRemoveRowMenu() {
      var btnEl = this._jqObj.children(".tfp-dataset-toolbar").find(".btn-remove-row");

      var offset = $(btnEl).offset();
      var menuEl = $("#" + this.id + "_RemoveRowMenu");

      if (menuEl.length == 0) {
        $("body").append("<div id=\"" + this.id + "_RemoveRowMenu\" class=\"tfp-dataset-toolbar-menu\"" + " onmouseover=\"" + this.id + ".showRemoveRowMenu()\" onmouseout=\"" + this.id + ".hideRemoveRowMenu()\"" + "style=\"display:none;top:" + (offset.top + 22) + ";left:" + offset.left + "px;\">" + "<div onclick=\"" + this.id + ".removeCurRow()\">删除当前行</div>" + "<div onclick=\"" + this.id + ".removeCheckedRows()\">删除选中行</div>" + "<div onclick=\"" + this.id + ".removeAll()\">删除全部行</div></div>");
      }

      menuEl.css("top", offset.top + 22 + "px");
      menuEl.css("left", offset.left + "px");
      menuEl.css('display', "flex");
    }
  }, {
    key: "hideRemoveRowMenu",
    value: function hideRemoveRowMenu() {
      var menuEl = $("#" + this.id + "_RemoveRowMenu");
      if (menuEl.length == 0) return;
      menuEl.hide();
    }
  }, {
    key: "getTitleHtml",
    value: function getTitleHtml() {
      var indent = this.getHtmlIndent();
      var html = indent + "\t\t<div class=\"tfp-dataset-titlerow\">";
      this.rowWidth = 6; //if (this.dataModel.enableInsert) this.rowWidth += 30;
      //if (this.dataModel.enableDelete) this.rowWidth += 30;
      //if (this.dataModel.enableMove) this.rowWidth += 60;

      if (this.dataModel.columns) {
        if (this.dataModel.showCheckbox) {
          this.rowWidth += 24;
          html += indent + "\t\t\t<div style=\"flex-basis:24px; text-align: center;\">" + "<input type=\"checkbox\" class=\"tfp-checkbox tfp-dataset-checkall\" " + "style=\"margin-top:12px;\" onclick=\"" + this.id + ".checkAllOnClick(this)\" /></div>\r\n";
        }

        if (this.dataModel.showRowNum) {
          this.rowWidth += this.rowNumColWidth;
          html += indent + "\t\t\t<div style=\"flex-basis:" + this.rowNumColWidth + "px; text-align: center;\">序号</div>\r\n";
        }

        for (var i = 0; i < this.dataModel.columns.length; i++) {
          var col = this.dataModel.columns[i];
          html += indent + "\t\t\t<div";

          if (col.hidden) {
            html += " style='display:none;'";
          } else {
            if (col.width) {
              html += " style='flex-basis:" + (col.width + "").replace("px", "") + "px;'";
              this.rowWidth += parseInt((col.width + '').replace("px", ""));
            } else {
              if (col.type.toLowerCase() == "switch") {
                html += " style='flex-basis:40px;text-align:center;'";
                this.rowWidth += 40;
              } else {
                html += " style='flex-basis:100px;'";
                this.rowWidth += 100;
              }
            }
          }

          var colName = col.id;
          if (col.name) colName = col.name;
          html += ">" + colName + "</div>\r\n";
        }

        if (this.dataModel.showMoveButton) {
          html += indent + "\t\t\t<div style=\"flex-basis:48px;\"></div>";
        }

        if (this.dataModel.showDelButton) {
          html += indent + "\t\t\t<div style=\"flex-basis:24px;\"></div>";
        }
        /*if (this.dataModel.enableInsert) {
          html += indent + "\t\t\t<div style=\"flex-basis:30px;\"></div>\r\n";
        }
        if (this.dataModel.enableMove) {
          html += indent + "\t\t\t<div style=\"flex-basis:60px;\"></div>\r\n";
        }
        if (this.dataModel.enableDelete) {
          html += indent + "\t\t\t<div style=\"flex-basis:30px;\"></div>\r\n";
        }*/

      }

      html += indent + "\t\t</div>\r\n";
      return html;
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml() {
      var headerHeight = 30;
      if (this._tfp.curPage.bgColorMode == "light") headerHeight = 40;

      if (this.dataModel.showAddButton || this.dataModel.showAddFromDialogButton) {
        headerHeight = 70;
        if (this._tfp.curPage.bgColorMode == "light") headerHeight = 80;
      }

      var indent = this.getHtmlIndent();
      var html = indent + "\t<div class=\"tfp-dataset-list\">"; // style=\"top:"+(headerHeight+1)+"px;\">\r\n";

      if (this.dataModel.columns) {
        if (this.dataModel.rows && this.dataModel.rows.length > 0) {
          for (var i = 0; i < this.dataModel.rows.length; i++) {
            html += this.getRowHtml(i, this.dataModel.rows[i], indent, this.rowWidth);
          }
        } else if (this._tfp.isDesigning) {
          //设计时添加三行空行
          html += this.getRowHtml(0, null, indent, this.rowWidth);
          html += this.getRowHtml(1, null, indent, this.rowWidth);
          html += this.getRowHtml(2, null, indent, this.rowWidth);
        }
      }

      html += indent + "\t</div>\r\n";
      return html;
    }
  }, {
    key: "getRowWidth",
    value: function getRowWidth() {
      var rowWidth = 6; //if (this.dataModel.enableInsert) rowWidth += 30;
      //if (this.dataModel.enableDelete) rowWidth += 30;
      //if (this.dataModel.enableMove) rowWidth += 60;

      if (this.dataModel.columns) {
        if (this.dataModel.showCheckbox) rowWidth += 30;
        if (this.dataModel.showRowNum) rowWidth += this.rowNumColWidth;

        for (var i = 0; i < this.dataModel.columns.length; i++) {
          var col = this.dataModel.columns[i];

          if (col.width) {
            rowWidth += parseInt((col.width + '').replace("px", ""));
          } else {
            if (col.type.toLowerCase() == "switch") {
              rowWidth += 40;
            } else {
              rowWidth += 100;
            }
          }
        }
      }

      return rowWidth;
    }
    /**
     * 添加数据集行
     * @param {[type]} data [description]
     */

  }, {
    key: "getRowHtml",
    value: function getRowHtml(rowIndex, rowData, indent, rowWidth) {
      if (!this.dataModel.columns) return "";
      var htmlStr = indent + "\t\t<div class=\"tfp-dataset-row\">\r\n";
      var bgColor = this._tfp.curPage.bgColorMode == "dark" ? "#444444" : "#EEEEEE";

      if (this.dataModel.showCheckbox) {
        htmlStr += indent + "\t\t\t<div class=\"row-checkbox\" style=\"flex-basis:24px; text-align: center;";
        if (this.dataModel.showRowNum) htmlStr += "border-right:0; background-color:" + bgColor + ";";
        if (this.dataModel.rowHeight) htmlStr += "height:" + this.dataModel.rowHeight + "px;";
        htmlStr += "\"><input type=\"checkbox\" class=\"tfp-checkbox tfp-dataset-checkbox\" style=\"margin-top:10px;\" ";
        if (rowData && rowData.checked) htmlStr += " checked";
        htmlStr += "/></div>\r\n";
      }

      if (this.dataModel.showRowNum) {
        htmlStr += indent + "\t\t\t<div class=\"row-num\" style=\"flex-basis:" + this.rowNumColWidth + "px; text-align: center; background-color:" + bgColor + ";";

        if (this.dataModel.rowHeight) {
          htmlStr += "height:" + this.dataModel.rowHeight + "px;line-height:" + this.dataModel.rowHeight + "px;\"";
        } else {
          htmlStr += "line-height:34px;";
        }

        htmlStr += "\">" + (rowIndex + 1) + "</div>\r\n";
      }

      this.newCpts = [];

      for (var i = 0; i < this.dataModel.columns.length; i++) {
        var col = this.dataModel.columns[i];
        var cellValue = ""; //为了兼容MSSQL查询到的数据字段名自动将大写转换为小写
        //需要将当前行所有字段的名改成小写

        if (rowData) {
          for (var p in rowData) {
            if (p.toLowerCase() == col.id.toLowerCase()) {
              cellValue = rowData[p];
              if (cellValue + "" == "null") cellValue = "";
              break;
            }
          }
        }

        htmlStr += indent + "\t\t\t<div class=\"tfp-dataset-cell\" style=\"";
        if (col.hidden) htmlStr += "display:none;";

        if (col.width) {
          htmlStr += "flex-basis:" + this._tfp.formatPx(col.width) + ";";
        } else {
          if (col.type.toLowerCase() == "switch") {
            htmlStr += "flex-basis:40px;text-align:center;";
          } else {
            htmlStr += "flex-basis:100px;";
          }
        }

        if (this.dataModel.rowHeight) htmlStr += "height:" + this.dataModel.rowHeight + "px;";
        var cptIdPrefix = this.id + "_" + col.type.toLowerCase() + "_" + i + "_";

        if (col.type.toLowerCase() == "date" || col.type.toLowerCase() == "time" || col.type.toLowerCase() == "datetime") {
          var cptId = cptIdPrefix + this.subCptIndex;
          this.subCptIndex++;
          htmlStr += "position:relative;\" id=\"" + cptId + "\" class=\"tfp-" + col.type.toLowerCase() + "\"";

          if (!this._tfp.isDesigning) {
            var dtype = "";
            if (col.type.toLowerCase() == "date") dtype = "Date";else if (col.type.toLowerCase() == "time") dtype = "Time";else dtype = "DateTime";
            var cdmDateTime = {
              id: cptId,
              type: dtype,
              colIndex: i
            };
            if (!this._tfp.isNull(cellValue)) cdmDateTime.value = cellValue;
            if (dtype == "DateTime" && col.showSecond) cdmDateTime.showSecond = true;

            if (col.readonly) {
              cdmDateTime.readonly = true;
            } else {
              if (this.dataModel.onCellDataChange) {
                cdmDateTime.onChange = this.id + ".cptDataOnChange('" + cptId + "', " + i + ")";
              }
            }

            if (!this.dataModel.components) this.dataModel.components = [];
            this.dataModel.components.push(cdmDateTime);
            this.newCpts.push(cdmDateTime);
          }
        } else if (col.type.toLowerCase() == "user" || col.type.toLowerCase() == "dep") {
          var _cptId = cptIdPrefix + this.subCptIndex;

          this.subCptIndex++;
          htmlStr += "position:relative;\" id=\"" + _cptId + "\" class=\"tfp-" + col.type.toLowerCase() + "\"";

          if (!this._tfp.isDesigning) {
            var dtype = "";
            if (col.type.toLowerCase() == "dep") dtype = "Dep";else if (col.type.toLowerCase() == "user") dtype = "User";else dtype = "Org";
            var cdmOrg = {
              id: _cptId,
              type: dtype,
              valueType: 'obj',
              multiCheck: col.multiCheck,
              colIndex: i
            };
            if (!this._tfp.isNull(cellValue)) cdmOrg.value = cellValue;

            if (col.readonly) {
              cdmOrg.readonly = true;
            } else {
              if (this.dataModel.onCellDataChange) {
                cdmOrg.onChange = this.id + ".cptDataOnChange('" + _cptId + "', " + i + ")";
              }
            }

            if (!this.dataModel.components) this.dataModel.components = [];
            this.dataModel.components.push(cdmOrg);
            this.newCpts.push(cdmOrg);
          }
        } else if (col.type.toLowerCase() == "popuplist") {
          var _cptId2 = cptIdPrefix + this.subCptIndex;

          this.subCptIndex++;
          htmlStr += "\" id=\"" + _cptId2 + "\"";

          if (!this._tfp.isDesigning) {
            var cdmPopupList = {
              id: _cptId2,
              type: "PopupList",
              required: false,
              enableFilter: false,
              colIndex: i,
              dataSet: this.id
            };
            if (!this._tfp.isNull(cellValue)) cdmPopupList.value = cellValue;
            if (col.multiCheck) cdmPopupList.multiCheck = true;
            if (col.enableFilter) cdmPopupList.enableFilter = true;
            if (col.filterArgName) cdmPopupList.filterArgName = col.filterArgName;
            if (col.dataQuerySetting) cdmPopupList.dataQuerySetting = col.dataQuerySetting;
            if (col.dataListValueFormat) cdmPopupList.dataListValueFormat = col.dataListValueFormat;
            if (col.dataListTextFormat) cdmPopupList.dataListTextFormat = col.dataListTextFormat;
            if (col.dataListDivWidth) cdmPopupList.dataListDivWidth = col.dataListDivWidth;
            if (col.dataListDivHeight) cdmPopupList.dataListDivHeight = col.dataListDivHeight;
            if (col.showTable) cdmPopupList.showTable = col.showTable;
            if (col.showRowNum) cdmPopupList.showRowNum = col.showRowNum;
            if (col.allowPaging) cdmPopupList.allowPaging = col.allowPaging;
            if (col.pageSize) cdmPopupList.pageSize = col.pageSize;
            if (col.rowHeight) cdmPopupList.rowHeight = col.rowHeight;
            if (col.columns) cdmPopupList.columns = col.columns;
            if (col.inputs) cdmPopupList.inputs = col.inputs;
            if (col.required) cdmPopupList.required = true;

            if (col.readonly) {
              cdmPopupList.readonly = true;
            } else {
              if (this.dataModel.onCellDataChange) {
                cdmPopupList.onChange = this.id + ".cptDataOnChange('" + _cptId2 + "', " + i + ")";
              }
            }

            if (!this.dataModel.components) this.dataModel.components = [];
            this.dataModel.components.push(cdmPopupList);
            this.newCpts.push(cdmPopupList);
          }
        } else {
          htmlStr += "\"";
        }

        htmlStr += ">";

        if ((col.type.toLowerCase() == "select" || col.type.toLowerCase() == "datadic") && !col.readonly) {
          htmlStr += "<select";
          if (col.style) htmlStr += " style=\"" + col.style + "\"";
          htmlStr += ">";

          if (!this._tfp.isDesigning) {
            if (!col.required) htmlStr += "<option value=\"\"></option>";

            if (col.options) {
              if (typeof col.options == "string") {
                try {
                  col.options = JSON.parse(col.options);
                } catch (e) {}
              }

              var options = [];

              if (Array.isArray(col.options)) {
                for (var j = 0; j < col.options.length; j++) {
                  var option = col.options[j];

                  if (typeof option == "string") {
                    options.push({
                      value: option
                    });
                  } else if (Object.prototype.toString.call(option) === '[object Object]') {
                    if (col.loadDataListService && col.dataListBindingMember) {
                      var o = {};

                      if (col.dataListValueFormat) {
                        if (col.dataListValueFormat.indexOf("{") < 0 && col.dataListValueFormat.indexOf("}") < 0) {
                          o.value = this._tfp.replaceDataField(option, "{" + col.dataListValueFormat + "}");
                        } else {
                          o.value = this._tfp.replaceDataField(option, col.dataListValueFormat);
                        }
                      } else {
                        o.value = option.value;
                      }

                      if (col.dataListTextFormat) {
                        if (col.dataListTextFormat.indexOf("{") < 0 && col.dataListTextFormat.indexOf("}") < 0) {
                          o.text = this._tfp.replaceDataField(option, "{" + col.dataListTextFormat + "}");
                        } else {
                          o.text = this._tfp.replaceDataField(option, col.dataListTextFormat);
                        }
                      } else {
                        o.text = option.text;
                      }

                      options.push(o);
                    } else {
                      options.push(option);
                    }
                  }
                }
              } else if (typeof col.options == "string") {
                var arr = (col.options + '').split(",");

                for (var j = 0; j < arr.length; j++) {
                  options.push({
                    value: arr[j]
                  });
                }
              }

              for (var j = 0; j < options.length; j++) {
                var _option = options[j];
                htmlStr += "<option value='" + _option.value + "'";
                if (cellValue && cellValue == _option.value || col["default"] == _option.value && !cellValue) htmlStr += " selected";
                var text = _option.value;
                if (_option.text) text = _option.text;
                htmlStr += ">" + text + "</option>";
              }
            }
          }

          htmlStr += "</select>";
        } else if (col.type.toLowerCase() == "switch" && !col.readonly) {
          var _options = [false, true];
          if (col.options) _options = col.options;
          var checked = _options[0];
          if (rowData && cellValue + "" == _options[1] + "" || col["default"] && col["default"] + "" == _options[1] + "" && (!rowData || isNull(cellValue))) checked = _options[1];
          htmlStr += "<div class=\"switch\" value=\"" + checked + "\" style=\"height: 16px;\"";
          if (this._tfp.isRuntime) htmlStr += " onclick=\"" + this.id + ".switchOnClick(this,'" + _options[0] + "','" + _options[1] + "')\"";
          htmlStr += ">";
          htmlStr += "<div";
          if (checked == _options[1]) htmlStr += " style=\"float: right; background-color:#0099ff;\"";
          htmlStr += "></div>";
          htmlStr += "</div>";
        } else if (col.type.toLowerCase() == "checkbox" && !col.readonly) {
          htmlStr += "<div class=\"checkbox\" ";
          if (cellValue && cellValue) htmlStr += " value=\"" + cellValue + "\"";
          htmlStr += ">";

          if (col.jsonDataSet) {
            col.options = col.jsonDataSet.options;
          }

          if (col.options) {
            if (typeof col.options == "string") {
              try {
                col.options = JSON.parse(col.options);
              } catch (e) {}
            }

            var _options2 = [];

            if (Array.isArray(col.options)) {
              for (var j = 0; j < col.options.length; j++) {
                var _option2 = col.options[j];

                if (typeof _option2 == "string") {
                  _options2.push({
                    value: _option2
                  });
                } else if (Object.prototype.toString.call(_option2) === '[object Object]') {
                  _options2.push(_option2);
                }
              }
            } else if (typeof col.options == "string") {
              var _arr = (col.options + '').split(",");

              for (var j = 0; j < _arr.length; j++) {
                _options2.push({
                  value: _arr[j]
                });
              }
            }

            for (var j = 0; j < _options2.length; j++) {
              var _option3 = _options2[j];
              var optionDisplay = "none";
              if (cellValue && (cellValue + "").split(",").contains(_option3.value)) optionDisplay = "inline-block";
              htmlStr += "<div class=\"checkboxitem\" data-option=\"" + _option3.value + "\"";
              if (this._tfp.isRuntime) htmlStr += " onclick=\"" + this.id + ".checkboxOnClick(this)\"";
              htmlStr += ">";
              htmlStr += "<div";
              htmlStr += " style=\"display:" + optionDisplay + ";\"";
              htmlStr += "></div>";
              htmlStr += "</div>";

              if (_option3.text) {
                htmlStr += "<label>" + _option3.text + "</label>";
              } else {
                htmlStr += "<label>" + _option3.value + "</label>";
              }
            }
          } else {
            var _optionDisplay = "none";
            if (cellValue && (cellValue + "").split(",").contains('1')) _optionDisplay = "inline-block";
            htmlStr += "<div class=\"checkboxitem\" data-option=\"1\"";
            if (this._tfp.isRuntime) htmlStr += "  onclick=\"" + this.id + ".checkboxOnClick(this)\"";
            htmlStr += ">";
            htmlStr += "<div";
            htmlStr += " style=\"display:" + _optionDisplay + ";\"";
            htmlStr += "></div>";
            htmlStr += "</div>";
          }

          htmlStr += "</div>";
        } else if (col.type.toLowerCase() == "radio" && !col.readonly) {
          htmlStr += "<div class=\"radio\" ";
          if (cellValue && cellValue) htmlStr += " value=\"" + cellValue + "\"";
          htmlStr += ">";

          if (col.jsonDataSet) {
            col.options = col.jsonDataSet.options;
          }

          if (col.options) {
            if (typeof col.options == "string") {
              try {
                col.options = JSON.parse(col.options);
              } catch (e) {}
            }

            var _options3 = [];

            if (Array.isArray(col.options)) {
              for (var j = 0; j < col.options.length; j++) {
                var _option4 = col.options[j];

                if (typeof _option4 == "string") {
                  _options3.push({
                    value: _option4
                  });
                } else if (Object.prototype.toString.call(_option4) === '[object Object]') {
                  _options3.push(_option4);
                }
              }
            } else if (typeof col.options == "string") {
              var _arr2 = (col.options + '').split(",");

              for (var j = 0; j < _arr2.length; j++) {
                _options3.push({
                  value: _arr2[j]
                });
              }
            }

            for (var j = 0; j < _options3.length; j++) {
              var _option5 = _options3[j];
              var _optionDisplay2 = "none";
              if (cellValue && (cellValue + "").split(",").contains(_option5.value)) _optionDisplay2 = "inline-block";
              htmlStr += "<div class=\"radioitem\" data-option=\"" + _option5.value + "\"";
              if (this._tfp.isRuntime) htmlStr += "  onclick=\"" + this.id + ".radioOnClick(this)\"";
              htmlStr += ">";
              htmlStr += "<div";
              htmlStr += " style=\"display:" + _optionDisplay2 + ";\"";
              htmlStr += "></div>";
              htmlStr += "</div>";

              if (_option5.text) {
                htmlStr += "<label>" + _option5.text + "</label>";
              } else {
                htmlStr += "<label>" + _option5.value + "</label>";
              }
            }
          } else {
            var _optionDisplay3 = "none";
            if (cellValue && (cellValue + "").split(",").contains('1')) _optionDisplay3 = "inline-block";
            htmlStr += "<div class=\"radioitem\" data-option=\"1\"";
            if (this._tfp.isRuntime) htmlStr += " onclick=\"" + this.id + ".radioOnClick(this)\"";
            htmlStr += ">";
            htmlStr += "<div";
            htmlStr += " style=\"display:" + _optionDisplay3 + ";\"";
            htmlStr += "></div>";
            htmlStr += "</div>";
          }

          htmlStr += "</div>";
        } else if (col.type.toLowerCase() == "textarea") {
          var class_ = col["class"] ? ' class="' + col["class"] + '"' : '';
          var readonly = this._tfp.isDesigning || col.readonly ? ' readonly' : '';
          var style = "";

          if (col.style) {
            style = col.style.trim();
            if (!style.endsWith(";")) style += ";";
          }

          if (col.readonly && this._tfp.curPage.bgColorMode == "light" && style.indexOf("background-color") < 0) {
            style += "background-color:#EEEEEE;";
          }

          if (style) style = " style=\"" + style + "\"";
          htmlStr += "<textarea " + class_ + readonly + " rows=\"3\">" + (cellValue || '') + "</textarea>";
        } else {
          var iptType = "text";

          if (col.dataType && (col.dataType.toLowerCase() == "int" || col.dataType.toLowerCase() == "float" || col.dataType.toLowerCase() == "money")) {
            iptType = "number";
          } else if (col.type.toLowerCase() == "password") {
            iptType = "password";
          }

          htmlStr += "<input type=\"" + iptType + "\"";
          if (col["class"]) htmlStr += ' class="' + col["class"] + '"'; //if(col.onchange) htmlStr += " onchange='"+col.onchange+"'";

          if (col.type.toLowerCase() == "date" || col.type.toLowerCase() == "time" || col.type.toLowerCase() == "datetime" || col.type.toLowerCase() == "user" || col.type.toLowerCase() == "dep") htmlStr += " readonly";else if (this._tfp.isDesigning || col.readonly || col.type.toLowerCase() == "popuplist" && !col.enableFilter) htmlStr += " readonly";
          var _style = "";

          if (col.style) {
            _style = col.style.trim();
            if (!_style.endsWith(";")) _style += ";";
          }

          if (col.readonly && this._tfp.curPage.bgColorMode == "light" && _style.indexOf("background-color") < 0) {
            _style += "background-color:#EEEEEE;";
          }

          if (col.type.toLowerCase() == "text" && col.align) {
            _style += "text-align: " + col.align + ";";
          } else if (col.type.toLowerCase() == "popuplist") {
            _style += "float:left; width: calc(100% - 15px);";
          }

          if (_style) htmlStr += " style=\"" + _style + "\"";

          if (cellValue && !isNull(cellValue)) {
            if (col.dataType == "int") {
              cellValue = parseInt(cellValue);
            } else if (col.dataType == "float") {
              cellValue = parseFloat(cellValue);
            } else if (col.dataType == "money") {
              cellValue = this._tfp.formatMoney(cellValue);
            } else if (col.dataType == "date") {
              cellValue = this._tfp.formatDate(cellValue, "yyyy-MM-dd");
            } else if (col.dataType == "time") {
              cellValue = this._tfp.formatDate(cellValue, "HH:mm:ss");
            } else if (col.dataType == "datetime") {
              cellValue = this._tfp.formatDate(cellValue, "yyyy-MM-dd HH:mm:ss");
            }
          } else if (col["default"]) {
            cellValue = col["default"];
          }

          if (typeof cellValue == "string" && cellValue.indexOf("\"") >= 0) {
            htmlStr += " value='" + cellValue + "'";
          } else {
            htmlStr += " value=\"" + cellValue + "\"";
          }

          htmlStr += " />";
        }

        if (col.type.toLowerCase() == "popuplist") {
          htmlStr += indent + "\t<img style=\"float:right; margin-left:0px; margin-right:3px;\" src=\"" + this._tfp.rootPath + "/src/components/select/images/arrow-down-" + this._tfp.curPage.contentColorMode + ".png\" />\r\n";
        } else if (col.type.toLowerCase() == "date" || col.type.toLowerCase() == "time" || col.type.toLowerCase() == "datetime") {
          htmlStr += indent + "\t<img style=\"width:20px;height:20px;\" src=\"" + this._tfp.rootPath + "/src/components/" + col.type.toLowerCase() + "/images/icon-24-" + this._tfp.curPage.contentColorMode + ".png\" />\r\n";
        } else if (col.type.toLowerCase() == "user" || col.type.toLowerCase() == "dep") {
          htmlStr += indent + "\t<img style=\"width:20px;height:20px;\" src=\"" + this._tfp.rootPath + "/src/components/" + col.type.toLowerCase() + "/images/icon-24-" + this._tfp.curPage.contentColorMode + ".png\" />\r\n";
        }

        htmlStr += "</div>\r\n";
      }

      var iconPath = this._tfp.rootPath + "/src/components/dataset/images/";
      /*if (this.dataModel.enableInsert) {
        htmlStr += indent + "\t\t\t<div class=\"tfp-dataset-row-button-icon\">"
          + "<img src='" + iconPath + "add-blue-24.png' title=\"插入\"";
        if (this._tfp.isRuntime) htmlStr += " onclick=\"" + this.id + ".insertRow(this)\"";
        htmlStr += " /></div>\r\n";
      }*/

      if (this.dataModel.showMoveButton) {
        htmlStr += indent + "\t\t\t<div class=\"tfp-dataset-row-button-icon\" style=\"border-right:0;border-bottom: 0;";
        if (this.dataModel.rowHeight) htmlStr += "height:" + this.dataModel.rowHeight + "px;";
        htmlStr += "\"><img src='" + iconPath + "up-blue-24.png' title=\"上移\" style=\"width:20px;height:20px;margin:0;\"";
        if (this._tfp.isRuntime) htmlStr += " onclick=\"" + this.id + ".moveUpRow(this)\"";
        htmlStr += " /></div>\r\n";
        htmlStr += indent + "\t\t\t<div class=\"tfp-dataset-row-button-icon\" style=\"border-right:0;border-bottom: 0;";
        if (this.dataModel.rowHeight) htmlStr += "height:" + this.dataModel.rowHeight + "px;";
        htmlStr += "\"><img src='" + iconPath + "down-blue-24.png' title=\"下移\" style=\"width:20px;height:20px;margin:0;\"";
        if (this._tfp.isRuntime) htmlStr += " onclick=\"" + this.id + ".moveDownRow(this)\"";
        htmlStr += " /></div>\r\n";
      }

      if (this.dataModel.showDelButton) {
        htmlStr += indent + "\t\t\t<div class=\"tfp-dataset-row-button-icon\" style=\"border-right:0;border-bottom: 0;";
        if (this.dataModel.rowHeight) htmlStr += "height:" + this.dataModel.rowHeight + "px;";
        htmlStr += "\"><img src='" + iconPath + "delete-blue-24.png' title=\"删除\" style=\"width:20px;height:20px;margin:0;\"";
        if (this._tfp.isRuntime) htmlStr += " onclick=\"" + this.id + ".deleteRow(this)\"";
        htmlStr += " /></div>\r\n";
      }

      htmlStr += indent + "\t\t</div>\r\n";
      return htmlStr;
    }
    /**
     * 点击开关时
     * @param  {[type]} divSwitch [description]
     * @return {[type]}           [description]
     */

  }, {
    key: "switchOnClick",
    value: function switchOnClick(divSwitch, val1, val2) {
      if ($(divSwitch).attr("cpt-disable") == "true") return;

      if ($(divSwitch).find("div").css("float") == "left") {
        $(divSwitch).find("div").css("float", "right");
        $(divSwitch).find("div").css("background-color", "#0099ff");
        $(divSwitch).attr("value", val2);
      } else {
        $(divSwitch).find("div").css("float", "left");

        if (this._tfp.curPage.bgColorMode == "dark") {
          $(divSwitch).find("div").css("background-color", "#999999");
        } else {
          $(divSwitch).find("div").css("background-color", "#999999");
        }

        $(divSwitch).attr("value", val1);
      }

      var rowIndex = $(divSwitch).closest(".tfp-dataset-row").index();
      var colIndex = $(divSwitch).parent().index();
      if (this.dataModel.showCheckbox) colIndex--;
      if (this.dataModel.showRowNum) colIndex--;
      var cellData = $(divSwitch).attr("value");
      var that = this;

      if (this.dataModel.onCellClick) {
        $(divSwitch).click(function () {
          //try {
          eval(that.dataModel.onCellClick); //} catch (err) {
          //  console.log(err);
          //}
        });
      }

      if (this.dataModel.onCellDataChange) {
        try {
          eval(that.dataModel.onCellDataChange);
        } catch (err) {
          console.error(err);
        }
      }
    }
    /**
     * 点击复选框时
     * @param {*} divCheckbox 
     */

  }, {
    key: "checkboxOnClick",
    value: function checkboxOnClick(divCheckbox) {
      if ($(divCheckbox).attr("cpt-disable") == "true") return;

      if ($(divCheckbox).find("div").css("display") == "inline-block") {
        $(divCheckbox).find("div").css("display", "none");
      } else {
        $(divCheckbox).find("div").css("display", "inline-block");
      }

      var val = "";
      $(divCheckbox).parent().find(".checkboxitem").each(function () {
        if ($(this).find("div").css("display") == "inline-block") {
          if (val != "") val += ",";
          val += $(this).attr("data-option");
        }
      });
      $(divCheckbox).parent().attr("value", val);
    }
    /**
     * 点击单选框时
     * @param {*} divRadio 
     */

  }, {
    key: "radioOnClick",
    value: function radioOnClick(divRadio) {
      if ($(divRadio).attr("cpt-disable") == "true") return;
      $(divRadio).parent().find(".radioitem").each(function () {
        $(this).find("div").css("display", "none");
      });
      $(divRadio).find("div").css("display", "inline-block");
      var val = $(divRadio).attr("data-option");
      $(divRadio).parent().attr("value", val);
    }
    /**
     * 执行计算表达式
     * @param  {[type]} colR      [description]
     * @param  {[type]} rowData   [description]
     * @param  {[type]} curRowDiv [description]
     * @param  {[type]} colIndex  [description]
     * @return {[type]}           [description]
     */

  }, {
    key: "exeFormula",
    value: function exeFormula(colR, rowData, curRowDiv, colIndex) {
      var colRFormula = this._tfp.replaceDataField(rowData, colR.formula, 0);

      var formulaVal = null;

      try {
        formulaVal = eval(colRFormula);
      } catch (error) {
        console.error(error.message);
        return;
      }

      if (colR.type == "text" && (colR.dataType == "int" || colR.dataType == "float" || colR.dataType == "money")) {
        if (colR.dataType == "int") {
          formulaVal = parseInt(formulaVal);
        } else if (colR.dataType == "float") {
          formulaVal = parseFloat(formulaVal);
        } else if (colR.dataType == "money") {
          formulaVal = this._tfp.formatMoney(formulaVal);
        }
      }

      var colRDivIndex = colIndex;
      if (this.dataModel.showCheckbox) colRDivIndex++;
      if (this.dataModel.showRowNum) colRDivIndex++;
      curRowDiv.children().eq(colRDivIndex).find("input").val(formulaVal);
    }
    /**
     * 添加新行：该方法已废除，请使用addRow
     * @param {[type]} data [description]
     */

  }, {
    key: "addNewRow",
    value: function addNewRow(data) {
      this.addRow(data);
    }
  }, {
    key: "bindScrollEvent",
    value: function bindScrollEvent() {
      var divHeader = this._jqObj.find(".tfp-dataset-header").get(0);

      var divDataList = this._jqObj.find(".tfp-dataset-list").get(0);

      if (!divDataList) return;
      divDataList.scrollTop = 0;
      divDataList.addEventListener('scroll', function () {
        divHeader.scrollLeft = divDataList.scrollLeft;
      });
    }
  }, {
    key: "bindEventHandler",
    value: function bindEventHandler() {
      var _this2 = this;

      this.bindScrollEvent();
      var that = this;

      this._jqObj.find(".tfp-dataset-row").each(function () {
        var rowEl = $(this);
        that.bindRowEventHandler(rowEl, rowEl.index());
      });

      if (this.dataModel.components) {
        var _loop = function _loop() {
          var cdm = _this2.dataModel.components[i];

          _this2._tfp.use([cdm.type], function () {
            that._tfp.parseCpt(cdm, that);

            var cpt = that._tfp.components[cdm.id];
            cpt._jqObj = $("#" + cpt.id);
            var col = that.dataModel.columns[cdm.colIndex];

            if (col.options) {
              //如果设置了数据加载服务，则绑定数据
              if (col.loadDataListService && col.dataListBindingMember) {
                cpt.bindData(col.options);
              } else {
                cpt.options = col.options;
              }
            }

            cpt.initRuntime();
          });
        };

        for (var i = 0; i < this.dataModel.components.length; i++) {
          _loop();
        }
      }

      this.isBindEventHandler = true;
    }
    /**
     * 选中指定行
     * @param {*} rowIndex 
     * @returns 
     */

  }, {
    key: "selectRow",
    value: function selectRow(rowIndex) {
      var rowEl = this.getRowEl(rowIndex);
      if (rowEl.length == 0) return; //this._jqObj.children(".tfp-dataset-list").children().css("outline", "0");
      //rowEl.css("outline", "1px solid #6666ff");

      if (this.showRowNum) {
        var bgColor = "#EEEEEE";
        var bgColorSelected = "#DDDDDD";

        if (this._tfp.curPage.bgColorMode == "dark") {
          bgColor = "#444444";
          bgColorSelected = "#555555";
        }

        var cellCheckBox = rowEl.children(".row-checkbox");

        if (cellCheckBox.length > 0) {
          rowEl.parent().find(".row-checkbox").css("background-color", bgColor);
          rowEl.children(".row-checkbox").css("background-color", bgColorSelected);
        }

        var cellRowNum = rowEl.children(".row-num");

        if (cellRowNum.length > 0) {
          rowEl.parent().find(".row-num").css("background-color", bgColor);
          rowEl.children(".row-num").css("background-color", bgColorSelected);
        }
      }

      this.curRowIndex = rowIndex;
    }
  }, {
    key: "selectCell",
    value: function selectCell(rowIndex, colIndex) {
      this._jqObj.children(".tfp-dataset-list").children(".tfp-dataset-row").children("div").removeClass("tfp-dataset-cell-selected"); //if (this.curCellRowIndex >= 0 && this.curCellColIndex >= 0) {
      //  this.getCellEl(this.curCellRowIndex, this.curCellColIndex).removeClass("tfp-dataset-cell-selected");
      //}


      var cellEl = this.getCellEl(rowIndex, colIndex);

      if (cellEl.length > 0) {
        //原来单元格里的输入框要失去焦点
        if (this.curCellRowIndex >= 0 && this.curCellColIndex >= 0 && this.curCellRowIndex != rowIndex && this.curCellColIndex != colIndex) {
          var cellElOld = this.getCellEl(this.curCellRowIndex, this.curCellColIndex);
          cellElOld.find("input").blur();
          cellElOld.find("select").blur();
        }

        cellEl.addClass("tfp-dataset-cell-selected");
        this.curCellRowIndex = rowIndex;
        this.curCellColIndex = colIndex;
        this.selectRow(rowIndex); //新选中单元格里的输入框要得到焦点

        if (cellEl.find("input").length > 0 && !cellEl.find("input").prop("disabled") && !cellEl.find("input").is(':focus')) cellEl.find("input").focus();
        if (cellEl.find("select").length > 0 && !cellEl.find("select").prop("disabled") && !cellEl.find("select").is(':focus')) cellEl.find("select").focus();
      }
    }
  }, {
    key: "bindRowEventHandler",
    value: function bindRowEventHandler(rowEl, rowIndex) {
      var _this3 = this;

      var that = this;

      if (this.dataModel.showCheckbox) {
        var checkBoxColIndex = 0;
        if (this.dataModel.showRowNum) checkBoxColIndex++;
        rowEl.children().eq(checkBoxColIndex).find("input").click(function () {
          if ($(this).get(0).checked) {
            if (that.dataModel.onAfterCheckedRow) {
              try {
                eval(that.dataModel.onAfterCheckedRow);
              } catch (err) {
                console.log(err);
              }
            }
          } else {
            if (that.dataModel.onAfterUnCheckedRow) {
              try {
                eval(that.dataModel.onAfterUnCheckedRow);
              } catch (err) {
                console.log(err);
              }
            }
          }
        });
      }

      rowEl.children().click(function () {
        that.selectRow(rowEl.index());

        if ($(this).hasClass("tfp-dataset-cell")) {
          var colIndex = $(this).index();
          if (that.showCheckbox) colIndex--;
          if (that.showRowNum) colIndex--;
          that.selectCell(rowEl.index(), colIndex);
        }
      }); //挂载单元格事件

      var _loop2 = function _loop2() {
        var col = _this3.dataModel.columns[i];
        var colIndex = i;
        var _colIndex = colIndex;
        if (_this3.dataModel.showCheckbox) _colIndex++;
        if (_this3.dataModel.showRowNum) _colIndex++;
        var cellEl = rowEl.children().eq(_colIndex);
        if (cellEl.attr('bindRowEventHandlerFinish') == 'Y') return "continue";
        cellEl.find("input").each(function () {
          that.bindCellEventHandler(cellEl, this, colIndex);
        });
        cellEl.find("textarea").each(function () {
          that.bindCellEventHandler(cellEl, this, colIndex);
        });
        cellEl.find(".dep").each(function () {
          that.bindCellEventHandler(cellEl, this, colIndex);
        });
        cellEl.find(".user").each(function () {
          that.bindCellEventHandler(cellEl, this, colIndex);
        });
        cellEl.find("select").each(function () {
          that.bindCellEventHandler(cellEl, this, colIndex);
        });
        /*cellEl.find(".switch").each(function () {
          that.bindCellEventHandler(cellEl, this, colIndex);
        });
        cellEl.find(".checkbox").each(function () {
          that.bindCellEventHandler(cellEl, this, colIndex);
        });
        cellEl.find(".radio").each(function () {
          that.bindCellEventHandler(cellEl, this, colIndex);
        });*/

        cellEl.attr('bindRowEventHandlerFinish', 'Y');
      };

      for (var i = 0; i < this.dataModel.columns.length; i++) {
        var _ret = _loop2();

        if (_ret === "continue") continue;
      }
    }
  }, {
    key: "cptDataOnChange",
    value: function cptDataOnChange(cptId, colIndex) {
      var cptEl = $("#" + cptId);
      var rowIndex = cptEl.closest(".tfp-dataset-row").index();
      var cellData = cptEl.find("input").val(); //try {

      eval(this.dataModel.onCellDataChange); //} catch (err) {
      //  console.error(err);
      //}
    }
    /**
     * 绑定单元格输入项事件
     * @param  {[type]} ipt [description]
     * @return {[type]}     [description]
     */

  }, {
    key: "bindCellEventHandler",
    value: function bindCellEventHandler(cellEl, ipt, colIndex) {
      var that = this;
      var col = this.dataModel.columns[colIndex]; //如果是开关，则不在此处理，而是在开关单独的点击事件函数里处理
      //如果是只读，不绑定事件

      if (!col || col.type.toLowerCase() == "switch") return;
      if (!col || col.type.toLowerCase() == "checkbox") return;
      if (!col || col.type.toLowerCase() == "radio") return; // let cellData = $(ipt).val();
      //单击事件

      if (this.dataModel.onCellClick) {
        cellEl.click(function () {
          var rowIndex = $(this).closest(".tfp-dataset-row").index();
          var cellData = $(ipt).val();
          that.selectCell(rowIndex, colIndex); //try {

          eval(that.dataModel.onCellClick); //} catch (err) {
          //  console.log(err);
          //}
        });
      } //双击事件


      if (this.dataModel.onCellDblClick) {
        cellEl.dblclick(function () {
          var rowIndex = $(this).closest(".tfp-dataset-row").index();
          var cellData = $(ipt).val(); //try {

          eval(that.dataModel.onCellDblClick); //} catch (err) {
          //  console.log(err);
          //}
        });
      } //获得焦点事件


      $(ipt).focus(function () {
        var rowIndex = $(this).closest(".tfp-dataset-row").index();
        that.selectCell(rowIndex, colIndex);

        if (that.dataModel.onCellFocus) {
          var cellData = $(this).val(); //try {

          eval(that.dataModel.onCellFocus); //} catch (err) {
          //  console.log(err);
          //}
        }
      });
      if (col.readonly) return; //如果是下拉列表，要单独处理数据变化和失去焦点事件

      if (col.type.toLowerCase() == "select" || col.type.toLowerCase() == "datadic") {
        if (this.dataModel.onCellDataChange || this.calcCols && this.calcCols[col.id]) {
          $(ipt).change(function () {
            var rowIndex = $(this).closest(".tfp-dataset-row").index();
            var cellData = $(this).val(); //try {

            eval(that.dataModel.onCellDataChange); //} catch (err) {
            //  console.error(err);
            //}

            that.formulaCell(this, col, rowIndex);
          });
        }

        if (this.dataModel.onCellBlur) {
          $(ipt).blur(function () {
            var rowIndex = $(this).closest(".tfp-dataset-row").index();
            var cellData = $(this).val(); //try {

            eval(that.dataModel.onCellBlur); //} catch (err) {
            //  console.error(err);
            //}
          });
        }
      } //最后再处理单行输入框的失去焦点事件
      //因为单行输入框DOM元素没有数据变化事件


      if (col.type.toLowerCase() == "text" || col.type.toLowerCase() == "password" || col.type.toLowerCase() == "textarea") {
        if (that.dataModel.onCellDataChange) {
          $(ipt).change(function () {
            var rowIndex = $(this).closest(".tfp-dataset-row").index();
            var cellData = $(this).val(); //try {

            eval(that.dataModel.onCellDataChange); //} catch (err) {
            //  console.error(err);
            //}
          });
        }

        $(ipt).blur(function () {
          var rowIndex = $(this).closest(".tfp-dataset-row").index();
          var cellData = $(this).val();

          if (that.dataModel.onCellBlur) {
            //try {
            eval(that.dataModel.onCellBlur); //} catch (err) {
            //  console.log(err);
            //}
          }

          that.formulaCell(this, col, rowIndex);
        });
        $(ipt).keypress(function (e) {
          var rowIndex = $(this).closest(".tfp-dataset-row").index();
          var cellData = $(this).val(); //if (e.which == 13) {
          //  that.focusNextInput(this);
          //}
          //if (that.dataModel.onCellKeyPress) {
          //try {
          //  eval(that.dataModel.onCellKeyPress);
          //} catch (err) {
          //  console.error(err);
          //}
          //}
        });
      }

      if (col.type.toLowerCase() == "text" || col.type.toLowerCase() == "textarea") {
        $(ipt).blur(function () {
          var verify = col.verify;
          var el = this;
          var jqObj = $(this);

          if (ipt.value && verify && (0, _typeof2["default"])(verify) == 'object' && verify.verify && verify.verifyMsg) {
            var reg = new RegExp(verify.verify);

            if (!reg.test(this.value.toString())) {
              var _parent = $(el.offsetParent);

              if (!el.dataset.inputerror) jqObj.attr('data-bordercolor', jqObj.css('border-color'));
              if (_parent.css('position') == 'static' || !_parent.css('position')) _parent.css('position', 'relative');
              var tooltipId = 'tfp-tooltip-' + col.id;
              if ($('#' + tooltipId).length > 0) $('#' + tooltipId).remove();

              var _tooltip = $('<div>', {
                'id': tooltipId
              }).css({
                'position': 'absolute',
                'display': 'none',
                'margin': '0px',
                'padding': '8px 11px',
                'border': '1px solid #f56c6c',
                'border-radius': '4px',
                'font-size': '12px',
                'line-height': '12px',
                'color': '#606266',
                'background': '#fff',
                'white-space': 'nowrap'
              }).html(verify.verifyMsg);

              _tooltip.append($('<div>').css({
                'position': 'absolute',
                'top': '23px',
                'right': '20px',
                'width': '12px',
                'height': '12px',
                'background': '#fff',
                'border': '1px solid #f56c6c',
                'border-top': '0px',
                'border-left': '0px',
                'transform': 'rotate(45deg)',
                'border-radius': '0px 0px 4px 0px'
              }));

              $('body').append(_tooltip.css('top', '-10000px').show());
              var _tooltipOffsetWidth = _tooltip[0].offsetWidth;

              _tooltip.css({
                'top': el.offsetTop - 40 + 'px',
                'left': el.offsetLeft + el.offsetWidth - _tooltipOffsetWidth + 'px'
              }).hide();

              _parent.append(_tooltip.fadeIn(300, 'linear'));

              jqObj.css('border-color', '#f56c6c').attr('data-inputerror', 'true');
              var t = setTimeout(function () {
                _tooltip.fadeOut(300, 'linear', function () {
                  $(this).remove();
                });
              }, 2000);
            }
          }
        });
        $(ipt).keypress(function (e) {
          if (this.dataset.inputerror) {
            var verify = col.verify;
            var reg = new RegExp(verify.verify);

            if (reg.test(this.value + e.key)) {
              $(this).css('border-color', this.dataset.bordercolor).removeAttr('data-inputerror').removeAttr('data-bordercolor');
            }
          }
        });
        $(ipt).change(function () {
          if (this.dataset.inputerror) {
            var verify = col.verify;
            var reg = new RegExp(verify.verify);

            if (!this.value || reg.test(this.value)) {
              $(this).css('border-color', this.dataset.bordercolor).removeAttr('data-inputerror').removeAttr('data-bordercolor');
            }
          }
        });
      }
    }
    /**
     * 让下一个输入项获得焦点
     */

  }, {
    key: "focusNextInput",
    value: function focusNextInput(curCpt) {
      var cellDiv = $(curCpt).parent();
      var isFind = false;
      cellDiv.nextAll().each(function () {
        if (!$(this).is(':visible')) return;

        if ($(this).find("input").length > 0) {
          var ipt = $(this).find("input").eq(0);

          if (!(ipt.attr("readonly") || ipt.attr("disabled"))) {
            isFind = true;
            $(this).find("input").focus();
            return false;
          }
        } else if ($(this).find("select").length > 0) {
          var _ipt = $(this).find("select").eq(0);

          if (!(_ipt.attr("readonly") || _ipt.attr("disabled"))) {
            isFind = true;
            $(this).find("select").focus();
            return false;
          }
        }
      });

      if (!isFind) {
        var nextRow = cellDiv.parent().next();

        if (nextRow.length > 0) {
          nextRow.children("div").each(function () {
            if (!$(this).is(':visible')) return;

            if ($(this).find("input").length > 0) {
              var ipt = $(this).find("input").eq(0);

              if (!(ipt.attr("readonly") || ipt.attr("disabled"))) {
                $(this).find("input").focus();
                return false;
              }
            } else if ($(this).find("select").length > 0) {
              var _ipt2 = $(this).find("select").eq(0);

              if (!(_ipt2.attr("readonly") || _ipt2.attr("disabled"))) {
                $(this).find("select").focus();
                return false;
              }
            }
          });
        }
      }
    }
  }, {
    key: "formulaCell",
    value: function formulaCell(ipt, col, rowIndex) {
      if (this.calcCols && this.calcCols[col.id]) {
        //获得当前行的数据
        var curRowDiv = $(ipt).parent().parent();
        var rowDataTmp = this.getRow(curRowDiv.index(), {
          autoFormat: true
        }).row;
        var arr = this.calcCols[col.id];

        for (var j = 0; j < arr.length; j++) {
          for (var k = 0; k < this.dataModel.columns.length; k++) {
            var colR = this.dataModel.columns[k];

            if (arr[j] == colR.id && colR.formula) {
              this.exeFormula(colR, rowDataTmp, curRowDiv, k);
              break;
            }
          }
        }
      }

      this._tfp.iptValueOnChange(this, col, rowIndex);
    }
  }, {
    key: "resetRowNum",
    value: function resetRowNum() {
      if (!this.dataModel.showRowNum) return;

      this._jqObj.find(".tfp-dataset-row").each(function (index, el) {
        $(el).find(".row-num").html(index + 1);
      });
    }
  }, {
    key: "insertRowBeforeCurRow",
    value: function insertRowBeforeCurRow() {
      if (this.curRowIndex < 0) return;
      this.addRow({}, this.curRowIndex, "before");
      this.curRowIndex++;
      this.resetRowNum();
    }
  }, {
    key: "insertRowAfterCurRow",
    value: function insertRowAfterCurRow() {
      if (this.curRowIndex < 0) return;
      this.addRow({}, this.curRowIndex, "after");
      this.resetRowNum();
    }
    /**
     * 添加行
     * @param {[type]} data [description]
     */

  }, {
    key: "addRow",
    value: function addRow(data, index, position) {
      var _this4 = this;

      var dataList = this._jqObj.find(".tfp-dataset-list");

      var rowIndex = dataList.find(".tfp-dataset-row").length;

      if (index >= 0) {
        rowIndex = index;
      }

      var rowData = data;
      if (!rowData) rowData = {};

      if (this.dataModel.onBeforeAddRow) {
        try {
          eval(this.dataModel.onBeforeAddRow);
        } catch (err) {
          console.log(err);
        }
      }

      if (index >= 0) this.rows.splice(index, 0, rowData);else this.rows.push(rowData);
      var rowWidth = this.getRowWidth();
      var indent = this.getHtmlIndent();
      var rowHtml = this.getRowHtml(rowIndex, rowData, indent + "\t\t", rowWidth);

      if (index >= 0) {
        if (position == "before") {
          dataList.find(".tfp-dataset-row").eq(index).before(rowHtml);
        } else {
          dataList.find(".tfp-dataset-row").eq(index).after(rowHtml);
          rowIndex++;
        }
      } else {
        dataList.append(rowHtml);
        var listEl = dataList.get(0);
        listEl.scrollTop = listEl.scrollHeight - listEl.clientHeight;
      }

      var that = this;

      if (this.newCpts && this.newCpts.length > 0) {
        var _loop3 = function _loop3() {
          var cdm = _this4.newCpts[i];

          _this4._tfp.use([cdm.type], function () {
            that._tfp.parseCpt(cdm, that);

            var cpt = that._tfp.components[cdm.id];
            var col = that.dataModel.columns[cdm.colIndex];

            if (col.options) {
              //如果设置了数据加载服务，则绑定数据
              if (col.loadDataListService && col.dataListBindingMember) {
                cpt.bindData(col.options);
              } else {
                cpt.options = col.options;
              }
            }

            cpt.initRuntime();
          });
        };

        for (var i = 0; i < this.newCpts.length; i++) {
          _loop3();
        }
      }

      this.newCpts = [];
      var newRow = dataList.find(".tfp-dataset-row").eq(rowIndex); // if (newRow.find("input").length > 0) {
      //   newRow.find("input").eq(0).focus();
      // } else if (newRow.find("select").length > 0) {
      //   newRow.find("select").eq(0).focus();
      // }
      //如果不是批量加载编码规则

      if (!this.isBatchLoadingEncodingRule) {
        var _loop4 = function _loop4(_i) {
          var col = _this4.dataModel.columns[_i];

          if (col.type == "encodingrule") {
            //需要设置规则代码
            if (!col.encodingRuleCode) {
              console.log("请为第" + _i + "列设置规则代码！");
              return {
                v: void 0
              };
            }

            _this4._tfp.use("Service", function () {
              var service = that._tfp["new"]("Service");

              service.path = "sys/service/encoding_rule/getCurCode.tbs";
              service.request({
                rule_code: col.encodingRuleCode,
                update_mode: 'R'
              }, function (req, res) {
                var ipt = newRow.children(".tfp-dataset-cell").eq(_i).find("input");
                ipt.val(res.data.code);
                ipt.get(0).readOnly = true;
              });
            });
          }
        };

        for (var _i = 0; _i < this.dataModel.columns.length; _i++) {
          var _ret2 = _loop4(_i);

          if ((0, _typeof2["default"])(_ret2) === "object") return _ret2.v;
        }
      } //执行自动计算表达式


      if (this.formulaIpts || this.calcCols) {
        for (var _i2 = 0; _i2 < this.dataModel.columns.length; _i2++) {
          var col = this.dataModel.columns[_i2];
          var colIndex = _i2;
          if (this.dataModel.showCheckbox) colIndex++;
          if (this.dataModel.showRowNum) colIndex++;
          var cellDiv = newRow.children("div").eq(colIndex);

          if (cellDiv.children("input").length > 0) {
            this.formulaCell(cellDiv.children("input").get(0), col, rowIndex);
          } else if (cellDiv.children("select").length > 0) {
            this.formulaCell(cellDiv.children("select").get(0), col, rowIndex);
          }
        }
      }

      if (this.dataModel.onAfterAddRow) {
        try {
          eval(this.dataModel.onAfterAddRow);
        } catch (err) {
          console.log(err);
        }
      }

      this.bindRowEventHandler(newRow, rowIndex);
      /*
      //挂载单元格事件
      for(var i=0;i<this.dataModel.columns.length;i++) {
        let col = this.dataModel.columns[i];
        let colIndex = i;
        if (this.dataModel.showRowNum) colIndex++;
        if(this.dataModel.showCheckbox) colIndex++;
        let cellEl = lastRow.children().eq(colIndex);
        cellEl.find("input").each(function() {
          that.bindCellEventHandler(this, colIndex);
        });
        cellEl.find("select").each(function() {
          that.bindCellEventHandler(this, colIndex);
        });
        cellEl.find(".switch").each(function() {
          that.bindCellEventHandler(this, colIndex);
        });
      }*/
    }
    /**
     * 添加多行
     * @param {[type]} data [description]
     */

  }, {
    key: "addRows",
    value: function addRows(rows) {
      var _this5 = this;

      if (!rows || !Array.isArray(rows)) return;
      if (rows.length > 1 && this.encodingRuleCols.length > 0) this.isBatchLoadingEncodingRule = true;

      for (var i = 0; i < rows.length; i++) {
        this.addRow(rows[i]);
      } //如果需要批量加载编码规则


      if (this.isBatchLoadingEncodingRule) {
        var that = this;

        var _loop5 = function _loop5(j) {
          var colIndex = _this5.encodingRuleCols[j];
          var col = _this5.columns[colIndex]; //需要设置规则代码

          if (!col.encodingRuleCode) {
            console.log("请为第" + j + "列设置规则代码！");
            return "break";
          }

          _this5._tfp.use("Service", function () {
            var service = that._tfp["new"]("Service");

            service.path = "sys/service/encoding_rule/getCodeList.tbs";
            service.request({
              rule_code: col.encodingRuleCode,
              update_mode: 'R',
              count: rows.length
            }, function (req, res) {
              var codeList = res.data;

              for (var _i3 = 0; _i3 < rows.length; _i3++) {
                var rowIndex = that.rows.length - rows.length + _i3;
                that.setCellData(rowIndex, colIndex, codeList[_i3]);
              }

              that.isBatchLoadingEncodingRule = false;
            });
          });
        };

        for (var j = 0; j < this.encodingRuleCols.length; j++) {
          var _ret3 = _loop5(j);

          if (_ret3 === "break") break;
        }
      }
    }
    /**
    * 上移指定行
    * @param  {[type]} imgOrIndex [description]
    * @return {[type]}     [description]
    */

  }, {
    key: "moveUpRow",
    value: function moveUpRow(imgOrIndex) {
      var curRow;

      if (typeof imgOrIndex == "number") {
        curRow = this.getRowEl(imgOrIndex);
      } else {
        curRow = $(imgOrIndex).parent().parent();
      }

      var prevRow = curRow.prev();

      if (prevRow.length > 0) {
        prevRow.before(curRow);
        if (typeof imgOrIndex == "number" && imgOrIndex == this.curRowIndex) this.curRowIndex -= 1;

        this._jqObj.find(".tfp-dataset-row").each(function (index, el) {
          $(el).find(".row-num").html(index + 1);
        });

        if (this.dataModel.onAfterMoveRow) {
          try {
            var rowIndex = curRow.index();
            eval(this.dataModel.onAfterMoveRow);
          } catch (err) {
            console.log(err);
          }
        }
      }
    }
    /**
     * 将当前行上移一行
     */

  }, {
    key: "moveCurRowUp",
    value: function moveCurRowUp() {
      this.moveUpRow(this.curRowIndex);
    }
    /**
    * 将指定行移到第一行
    * @param  {[type]} imgOrIndex [description]
    * @return {[type]}     [description]
    */

  }, {
    key: "moveToFirst",
    value: function moveToFirst(imgOrIndex) {
      var curRow;

      if (typeof imgOrIndex == "number") {
        if (imgOrIndex == 0) return;
        curRow = this.getRowEl(imgOrIndex);
      } else {
        curRow = $(imgOrIndex).parent().parent();
      }

      var firstRow = this.getRowEl(0);

      if (firstRow.length > 0) {
        firstRow.before(curRow);
        if (typeof imgOrIndex == "number" && imgOrIndex == this.curRowIndex) this.curRowIndex = 0;

        this._jqObj.find(".tfp-dataset-row").each(function (index, el) {
          $(el).find(".row-num").html(index + 1);
        });

        this._jqObj.find(".tfp-dataset-list").get(0).scrollTop = 0;

        if (this.dataModel.onAfterMoveRow) {
          try {
            var rowIndex = curRow.index();
            eval(this.dataModel.onAfterMoveRow);
          } catch (err) {
            console.log(err);
          }
        }
      }
    }
    /**
     * 将当前行移动到第一行
     */

  }, {
    key: "moveCurRowToFirst",
    value: function moveCurRowToFirst() {
      this.moveToFirst(this.curRowIndex);
    }
    /**
    * 下移行
    * @param  {[type]} imgOrIndex [description]
    * @return {[type]}     [description]
    */

  }, {
    key: "moveDownRow",
    value: function moveDownRow(imgOrIndex) {
      var curRow;

      if (typeof imgOrIndex == "number") {
        curRow = this.getRowEl(imgOrIndex);
      } else {
        curRow = $(imgOrIndex).parent().parent();
      }

      var nextRow = curRow.next();

      if (nextRow.length > 0) {
        nextRow.after(curRow);
        if (typeof imgOrIndex == "number" && imgOrIndex == this.curRowIndex) this.curRowIndex += 1;

        this._jqObj.find(".tfp-dataset-row").each(function (index, el) {
          $(el).find(".row-num").html(index + 1);
        });

        if (this.dataModel.onAfterMoveRow) {
          try {
            var rowIndex = curRow.index();
            eval(this.dataModel.onAfterMoveRow);
          } catch (err) {
            console.log(err);
          }
        }
      }
    }
    /**
     * 将当前行下移一行
     */

  }, {
    key: "moveCurRowDown",
    value: function moveCurRowDown() {
      this.moveDownRow(this.curRowIndex);
    }
    /**
    * 将指定行移到最后一行
    * @param  {[type]} imgOrIndex [description]
    * @return {[type]}     [description]
    */

  }, {
    key: "moveToLast",
    value: function moveToLast(imgOrIndex) {
      var curRow;

      if (typeof imgOrIndex == "number") {
        if (imgOrIndex == this._jqObj.find(".tfp-dataset-row").length - 1) return;
        curRow = this.getRowEl(imgOrIndex);
      } else {
        curRow = $(imgOrIndex).parent().parent();
      }

      var lastRow = this.getRowEl(this._jqObj.find(".tfp-dataset-row").length - 1);

      if (lastRow.length > 0) {
        lastRow.after(curRow);
        if (typeof imgOrIndex == "number" && imgOrIndex == this.curRowIndex) this.curRowIndex = this._jqObj.find(".tfp-dataset-row").length - 1;

        this._jqObj.find(".tfp-dataset-row").each(function (index, el) {
          $(el).find(".row-num").html(index + 1);
        });

        var dataList = this._jqObj.find(".tfp-dataset-list").get(0);

        dataList.scrollTop = dataList.scrollHeight - dataList.clientHeight;

        if (this.dataModel.onAfterMoveRow) {
          try {
            var rowIndex = curRow.index();
            eval(this.dataModel.onAfterMoveRow);
          } catch (err) {
            console.log(err);
          }
        }
      }
    }
    /**
     * 将当前行移动到最后一行
     */

  }, {
    key: "moveCurRowToLast",
    value: function moveCurRowToLast() {
      this.moveToLast(this.curRowIndex);
    }
    /**
     * 通过点击插入图片插入行
     * @param  {[type]} img [description]
     * @return {[type]}     [description]
     */

  }, {
    key: "insertRow",
    value: function insertRow(img) {
      this.addRow({}, $(img).parent().parent().index());

      this._jqObj.find(".tfp-dataset-row").each(function (index, el) {
        $(el).find(".row-num").html(index + 1);
      });
    }
    /**
     * 通过点击删除图片删除行
     * @param  {[type]} img [description]
     * @return {[type]}     [description]
     */

  }, {
    key: "deleteRow",
    value: function deleteRow(img) {
      this.removeRow($(img).parent().parent().index());
    }
    /**
     * 删除行
     * @param  {[type]} rowIndex [description]
     * @return {[type]}          [description]
     */

  }, {
    key: "removeRow",
    value: function removeRow(rowIndex) {
      var _this6 = this;

      if (this.dataModel.showDelRowConfirm) {
        tfp.showConfirm("确定删除？", function (ret) {
          if (ret) _this6.exeRemoveRow(rowIndex);
        });
      } else {
        this.exeRemoveRow(rowIndex);
      }
    }
    /**
     * 重新计算设置了计算表达式的列
     */

  }, {
    key: "reCalcComputedCol",
    value: function reCalcComputedCol() {
      var _this7 = this;

      if (this.rows.length == 0) {
        if (this.formulaIpts && this.formulaIpts.length > 0) {
          this.formulaIpts.forEach(function (iptId) {
            var ipt = _this7._tfp.get(iptId);

            if (ipt) ipt.value = 0;
          });
        }
      } else {
        this.rows.forEach(function (row, index) {
          _this7.columns.forEach(function (col) {
            _this7._tfp.iptValueOnChange(_this7, col, index);
          });
        });
      }
    }
    /**
     * 删除行
     * @param  {[type]} rowIndex [description]
     * @return {[type]}          [description]
     */

  }, {
    key: "exeRemoveRow",
    value: function exeRemoveRow(rowIndex) {
      var rowData = this.rows[rowIndex];

      if (this.dataModel.onBeforeRemoveRow) {
        try {
          var ret = eval(this.dataModel.onBeforeRemoveRow);
          if (!ret) return;
        } catch (err) {
          console.log(err);
          return;
        }
      } //删除该行的子组件


      for (var i = 0; i < this.dataModel.columns.length; i++) {
        var col = this.dataModel.columns[i];

        if (["date", "time", "datetime", "user", "dep", "popuplist"].contains(col.type.toLowerCase())) {
          var cellEl = this.getCellEl(rowIndex, i);
          var cptId = cellEl.attr("id");

          if (cptId) {
            this.dataModel.components.remove(cptId);
            var cptIndex = -1;

            for (var j = 0; j < this.dataModel.components.length; j++) {
              if (this.dataModel.components[j].id == cptId) cptIndex = j;
            }

            if (cptIndex >= 0) this.dataModel.components.splice(cptIndex, 1);
            delete this._tfp.components[cptId];
          }
        }
      }

      this._jqObj.find(".tfp-dataset-row").eq(rowIndex).remove();

      this._jqObj.find(".tfp-dataset-row").each(function (index, el) {
        $(el).find(".row-num").html(index + 1);
      });
      /*if (this.dataModel.onRemoveRow) {
        try {
          eval(this.dataModel.onRemoveRow);
        } catch (err) {
          console.log(err);
        }
      }*/


      this.reCalcComputedCol();

      if (this.dataModel.onAfterRemoveRow) {
        try {
          eval(this.dataModel.onAfterRemoveRow);
        } catch (err) {
          console.log(err);
        }
      }

      if (rowIndex == this.curRowIndex) this.curRowIndex = -1;
    }
    /**
     * 删除所有行
     */

  }, {
    key: "removeAll",
    value: function removeAll() {
      var _this8 = this;

      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.empty();

      if (this.formulaIpts && this.formulaIpts.length > 0) {
        this.formulaIpts.forEach(function (iptId) {
          var ipt = _this8._tfp.get(iptId);

          if (ipt) ipt.value = 0;
        });
      }

      this.curRowIndex = -1;
      this.hideRemoveRowMenu();
    }
  }, {
    key: "removeCurRow",
    value: function removeCurRow() {
      if (this.curRowIndex < 0) return;
      this.removeRow(this.curRowIndex);
      this.hideRemoveRowMenu();
    }
  }, {
    key: "removeCheckedRows",
    value: function removeCheckedRows() {
      if (!this.showCheckbox) return;
      this.hideRemoveRowMenu();
      var rows = this.getCheckedRowsEl();
      if (rows.length == 0) return;

      if (this.dataModel.onBeforeRemoveRow) {
        try {
          var ret = eval(this.dataModel.onBeforeRemoveRow);
          if (!ret) return;
        } catch (err) {
          console.log(err);
          return;
        }
      }

      rows.forEach(function (row) {
        row.remove();
      });
      this.resetRowNum();

      if (this.dataModel.onAfterRemoveRow) {
        try {
          eval(this.dataModel.onAfterRemoveRow);
        } catch (err) {
          console.log(err);
        }
      }
    }
    /**
     * 清空指定单元格的数据
     * @param {*} rowIndex 
     * @param {*} colIndex 
     */

  }, {
    key: "clearCellData",
    value: function clearCellData(rowIndex, colIndex) {
      this.setCellData(rowIndex, colIndex, "");
    }
    /**
     * 清空指定行的数据
     * @param {*} rowIndex 
     */

  }, {
    key: "clearRowData",
    value: function clearRowData(rowIndex) {
      var row = this.getRowEl(rowIndex);
      if (row.length == 0) return;

      for (var i = 0; i < this.dataModel.columns.length; i++) {
        this.setCellData(rowIndex, i, "");
      }
    }
    /**
     * 清空指定列的数据
     * @param {*} colIndex 
     */

  }, {
    key: "clearColData",
    value: function clearColData(colIndex) {
      var rows = this.getRows();

      for (var i = 0; i < rows.length; i++) {
        this.setCellData(i, colIndex, "");
      }
    }
    /**
     * 清空指定区域内的数据
     */

  }, {
    key: "clearRangeData",
    value: function clearRangeData(startRowIndex, startColIndex, endRowIndex, endColIndex) {
      var rows = this.getRows();

      for (var i = startRowIndex; i <= endRowIndex; i++) {
        for (var j = startColIndex; j <= endColIndex; j++) {
          this.setCellData(i, j, "");
        }
      }
    }
    /**
     * 清空全部数据
     */

  }, {
    key: "clearAllData",
    value: function clearAllData() {
      var rows = this.getRows();

      for (var i = 0; i < rows.length; i++) {
        for (var j = 0; j < this.dataModel.columns.length; j++) {
          this.setCellData(i, j, "");
        }
      }

      this.hideClearDataMenu();
    }
    /**
     * 清除当前行数据
     * @returns 
     */

  }, {
    key: "clearCurRowData",
    value: function clearCurRowData() {
      if (this.curRowIndex < 0) return;
      this.clearRowData(this.curRowIndex);
      this.hideClearDataMenu();
    }
    /**
     * 清除选中行数据
     */

  }, {
    key: "clearCheckedRowsData",
    value: function clearCheckedRowsData() {
      var _this9 = this;

      if (!this.showCheckbox) return;
      this.hideClearDataMenu();
      var rows = this.getCheckedRows();
      console.log(rows);
      if (rows.length == 0) return;
      rows.forEach(function (row) {
        _this9.clearRowData(row._rowIndex);
      });
    }
    /**
     * 禁用指定单元格
     * @param {*} rowIndex 
     */

  }, {
    key: "disableCell",
    value: function disableCell(rowIndex, colIndex) {
      var col = this.dataModel.columns[colIndex];
      if (!col) return;
      var cell = this.getCellEl(rowIndex, colIndex);
      if (!cell) return;
      var colType = col.type.toLowerCase();

      if (["date", "time", "datetime", "user", "dep", "role", "popuplist"].includes(colType)) {
        var cptId = cell.attr("id");

        var _cpt = tfp.get(cptId);

        if (_cpt) _cpt.disabled = true;
      }

      cell.attr("cpt-disable", "true");
      cell.css("background-color", "#EEEEEE");

      if (cell.children("input").length > 0) {
        cell.children("input").get(0).disabled = true;
        cell.find("input").css("background-color", "#EEEEEE");
      }

      if (cell.children("select").length > 0) {
        cell.children("select").get(0).disabled = true;
        cell.find("select").css("background-color", "#EEEEEE");
      }

      if (cell.children("textarea").length > 0) {
        cell.children("textarea").get(0).disabled = true;
        cell.find("textarea").css("background-color", "#EEEEEE");
      }
    }
    /**
     * 禁用指定行
     * @param {*} rowIndex 
     */

  }, {
    key: "disableRow",
    value: function disableRow(rowIndex) {
      var row = this.getRowEl(rowIndex);
      if (row.length == 0) return;

      for (var i = 0; i < this.dataModel.columns.length; i++) {
        this.disableCell(rowIndex, i);
      }
    }
    /**
     * 禁用指定列
     * @param {*} colIndex 
     */

  }, {
    key: "disableCol",
    value: function disableCol(colIndex) {
      var rows = this.getRows();

      for (var i = 0; i < rows.length; i++) {
        this.disableCell(i, colIndex);
      }
    }
    /**
     * 禁用指定区域
     */

  }, {
    key: "disableRange",
    value: function disableRange(startRowIndex, startColIndex, endRowIndex, endColIndex) {
      var rows = this.getRows();

      for (var i = startRowIndex; i <= endRowIndex; i++) {
        for (var j = startColIndex; j <= endColIndex; j++) {
          this.disableCell(i, j);
        }
      }
    }
    /**
     * 禁用全部
     */

  }, {
    key: "disableAll",
    value: function disableAll() {
      var rows = this.getRows();

      for (var i = 0; i < rows.length; i++) {
        for (var j = 0; j < this.dataModel.columns.length; j++) {
          this.disableCell(i, j);
        }
      }
    }
    /**
     * 启用指定单元格
     * @param {*} rowIndex 
     */

  }, {
    key: "enableCell",
    value: function enableCell(rowIndex, colIndex) {
      var col = this.dataModel.columns[colIndex];
      var cell = this.getCellEl(rowIndex, colIndex);
      var colType = col.type.toLowerCase();

      if (["date", "time", "datetime", "user", "dep", "role", "popuplist"].includes(colType)) {
        var cptId = cell.attr("id");

        var _cpt2 = tfp.get(cptId);

        if (!_cpt2) _cpt2.disabled = false;
      }

      cell.attr("cpt-disable", "");
      cell.css("background-color", "");

      if (cell.children("input").length > 0) {
        cell.children("input").get(0).disabled = false;
        cell.find("input").css("background-color", "");
      }

      if (cell.children("select").length > 0) {
        cell.children("select").get(0).disabled = false;
        cell.find("select").css("background-color", "");
      }

      if (cell.children("textarea").length > 0) {
        cell.children("textarea").get(0).disabled = false;
        cell.find("textarea").css("background-color", "");
      }
    }
    /**
     * 启用指定行
     * @param {*} rowIndex 
     */

  }, {
    key: "enableRow",
    value: function enableRow(rowIndex) {
      var row = this.getRowEl(rowIndex);
      if (row.length == 0) return;

      for (var i = 0; i < this.dataModel.columns.length; i++) {
        this.enableCell(rowIndex, i);
      }
    }
    /**
     * 启用指定列
     * @param {*} colIndex 
     */

  }, {
    key: "enableCol",
    value: function enableCol(colIndex) {
      var rows = this.getRows();

      for (var i = 0; i < rows.length; i++) {
        this.enableCell(i, colIndex);
      }
    }
    /**
     * 启用指定区域
     */

  }, {
    key: "enableRange",
    value: function enableRange(startRowIndex, startColIndex, endRowIndex, endColIndex) {
      var rows = this.getRows();

      for (var i = startRowIndex; i <= endRowIndex; i++) {
        for (var j = startColIndex; j <= endColIndex; j++) {
          this.enableCell(i, j);
        }
      }
    }
    /**
     * 启用全部
     */

  }, {
    key: "enableAll",
    value: function enableAll() {
      var rows = this.getRows();

      for (var i = 0; i < rows.length; i++) {
        for (var j = 0; j < this.dataModel.columns.length; j++) {
          this.enableCell(i, j);
        }
      }
    }
    /**
     * 点击全选框后
     * @param  {[type]} cbk [description]
     * @return {[type]}     [description]
     */

  }, {
    key: "checkAllOnClick",
    value: function checkAllOnClick(cbk) {
      if (cbk.checked) {
        this.checkAll();
      } else {
        this.unCheckAll();
      }
    }
    /**
     * 全部选中
     * @return {[type]} [description]
     */

  }, {
    key: "checkAll",
    value: function checkAll() {
      if (!this.dataModel.showCheckbox) return;

      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.find(".tfp-dataset-checkbox").each(function () {
        $(this).get(0).checked = true;
      });

      if (this.dataModel.onAfterCheckedAll) {
        try {
          eval(this.dataModel.onAfterCheckedAll);
        } catch (err) {
          console.log(err);
        }
      }
    }
    /**
     * 取消全选
     * @return {[type]} [description]
     */

  }, {
    key: "unCheckAll",
    value: function unCheckAll() {
      if (!this.dataModel.showCheckbox) return;

      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.find(".tfp-dataset-checkbox").each(function () {
        $(this).get(0).checked = false;
      });

      if (this.dataModel.onAfterUnCheckedAll) {
        try {
          eval(this.dataModel.onAfterUnCheckedAll);
        } catch (err) {
          console.log(err);
        }
      }
    }
    /**
     * 选中指定键值的行
     * @param  {[type]} keys [description]
     * @return {[type]}      [description]
     */

  }, {
    key: "checkRowsByKey",
    value: function checkRowsByKey(keys) {
      if (!this.dataModel.showCheckbox || !this.dataModel.keyCol || !keys) return;
      if (typeof keys == "string") keys = keys.split(",");
      var keyColIndex = 0;

      for (var i = 0; i < this.dataModel.columns.length; i++) {
        var col = this.dataModel.columns[i];

        if (col.id == this.dataModel.keyCol) {
          keyColIndex = i + 1;
          break;
        }
      }

      if (keyColIndex == 0) return;
      var that = this;

      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.find(".tfp-dataset-row").each(function (rowIndex) {
        var keyColDiv = $(this).children("div").eq(keyColIndex);
        var key = keyColDiv.find("input").val();

        if (keys.contains(key)) {
          $(this).find(".tfp-dataset-checkbox").get(0).checked = true;

          if (that.dataModel.onAfterCheckedRow) {
            try {
              eval(that.dataModel.onAfterCheckedRow);
            } catch (err) {
              console.log(err);
            }
          }
        }
      });
    }
    /**
     * 该方法已废弃
     * @param {} keys 
     */

  }, {
    key: "checkRows",
    value: function checkRows(keys) {
      this.checkRowsByKey(keys);
    }
    /**
     * 选中指定索引的行
     * @param  {[type]} keys [description]
     * @return {[type]}      [description]
     */

  }, {
    key: "checkRowsByIndex",
    value: function checkRowsByIndex(indexs) {
      if (!this.dataModel.showCheckbox) return;
      var arr = [];

      if (typeof indexs == "string") {
        arr = indexs.split(",");
      } else if (tfp.isInt(indexs)) {
        arr = ['' + indexs];
      } else if (Array.isArray(indexs)) {
        for (var i = 0; i < indexs.length; i++) {
          arr.push('' + indexs[i]);
        }
      }

      if (arr.length == 0) return;
      var that = this;

      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.find(".tfp-dataset-row").each(function (rowIndex) {
        if (arr.contains('' + rowIndex)) {
          $(this).find(".tfp-dataset-checkbox").get(0).checked = true;

          if (that.dataModel.onAfterCheckedRow) {
            try {
              eval(that.dataModel.onAfterCheckedRow);
            } catch (err) {
              console.log(err);
            }
          }
        }
      });
    }
    /**
     * 选中指定索引的行
     * @param {*} rowIndex 
     */

  }, {
    key: "checkRow",
    value: function checkRow(rowIndex) {
      this.checkRowsByIndex([rowIndex]);
    }
    /**
     * 取消选中指定索引的行
     * @param  {[type]} keys [description]
     * @return {[type]}      [description]
     */

  }, {
    key: "unCheckRowsByIndex",
    value: function unCheckRowsByIndex(indexs) {
      if (!this.dataModel.showCheckbox) return;
      var arr = [];

      if (typeof indexs == "string") {
        arr = indexs.split(",");
      } else if (tfp.isInt(indexs)) {
        arr = ['' + indexs];
      } else if (Array.isArray(indexs)) {
        for (var i = 0; i < indexs.length; i++) {
          arr.push('' + indexs[i]);
        }
      }

      if (arr.length == 0) return;
      var that = this;

      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.find(".tfp-dataset-row").each(function (rowIndex) {
        if (arr.contains('' + rowIndex)) {
          $(this).find(".tfp-dataset-checkbox").get(0).checked = false;

          if (that.dataModel.onAfterCheckedRow) {
            try {
              eval(that.dataModel.onAfterCheckedRow);
            } catch (err) {
              console.log(err);
            }
          }
        }
      });
    }
    /**
     * 取消选中指定索引的行
     * @param {*} rowIndex 
     */

  }, {
    key: "unCheckRow",
    value: function unCheckRow(rowIndex) {
      this.unCheckRowsByIndex([rowIndex]);
    }
    /**
     * 获得选中行的数据
     * @param  {Function} cb [description]
     * @return {[type]}      [description]
     */

  }, {
    key: "getCheckedRowsData",
    value: function getCheckedRowsData(cb) {
      if (cb) {
        this.getRowsData({
          onlyGetChecked: true,
          checkRequired: true
        }, cb);
        return;
      }

      return this.getRowsData({
        onlyGetChecked: true,
        checkRequired: true
      });
    }
    /**
     * 获得选中的行
     * @param  {Function} cb [description]
     * @return {[type]}      [description]
     */

  }, {
    key: "getCheckedRows",
    value: function getCheckedRows(cb) {
      if (cb) {
        this.getRows({
          onlyGetChecked: true,
          checkRequired: true
        }, cb);
        return;
      }

      return this.getRows({
        onlyGetChecked: true,
        checkRequired: true
      });
    }
    /**
     * 获得指定单元格的数据
     * @param  {[type]} rowIndex  [description]
     * @param  {[type]} _colIndex [description]
     * @return {[type]}           [description]
     */

  }, {
    key: "getCellData",
    value: function getCellData(rowIndex, _colIndex) {
      var dataList = this._jqObj.find(".tfp-dataset-list");

      var rowDiv = dataList.find(".tfp-dataset-row").eq(rowIndex);
      var colIndex = _colIndex;
      if (this.dataModel.showCheckbox) colIndex++;
      if (this.dataModel.showRowNum) colIndex++;
      var val = null;
      var colDiv = rowDiv.children("div").eq(colIndex);
      var col = this.dataModel.columns[_colIndex];
      var colType = col.type.toLowerCase();

      if ((colType == "select" || colType == "datadic") && !col.readonly) {
        val = colDiv.find("select").val();
      } else if (colType == "switch") {
        val = Array.isArray(col.options) ? col.options[0] : false;
        if (colDiv.find(".switch").attr("value") == "true") val = Array.isArray(col.options) ? col.options[1] : true;
      } else if (colType == "popuplist") {
        var _cpt3 = this._tfp.components[colDiv.attr("id")];

        val = _cpt3.value;
      } else if (colType == "checkbox") {
        val = colDiv.find("input").attr("value");
      } else if (colType == "radio") {
        val = colDiv.find("input").attr("value");
      } else if (colType == "textarea") {
        val = colDiv.find("textarea").val();
      } else {
        val = colDiv.find("input").val();
      }

      if (val == "") {
        if (colType == "text" && (col.dataType == "int" || col.dataType == "float" || col.dataType == "money")) {
          if (col.dataType == "int") {
            val = 0;
          } else {
            val = 0.00;
          }
        }
      } else {
        if (colType == "text" && (col.dataType == "int" || col.dataType == "float" || col.dataType == "money")) {
          if (col.dataType == "int") {
            val = parseInt(val);
          } else {
            val = parseFloat(val);
          }
        }
      }

      return val;
    }
    /**
     * 设置指定单元格的值
     * @param {[type]} rowIndex  [description]
     * @param {[type]} _colIndex [description]
     * @param {[type]} val       [description]
     */

  }, {
    key: "setCellData",
    value: function setCellData(rowIndex, _colIndex, val) {
      if (val + "" == "null") val = "";

      var dataList = this._jqObj.find(".tfp-dataset-list");

      var rowDiv = dataList.find(".tfp-dataset-row").eq(rowIndex);
      var colIndex = _colIndex;
      if (this.dataModel.showCheckbox) colIndex++;
      if (this.dataModel.showRowNum) colIndex++;
      var colDiv = rowDiv.children("div").eq(colIndex);
      var col = this.dataModel.columns[_colIndex];
      var colType = col.type.toLowerCase();

      if (colType == "switch") {
        var val1 = "false";
        var val2 = "true";

        if (col.options) {
          if (typeof col.options == "string" && col.options.indexOf(",") > 0) {
            var arr = col.options.split(",");
            val1 = arr[0] + "";
            val2 = arr[1] + "";
          } else if (Array.isArray(col.options) && col.options.length > 1) {
            val1 = col.options[0] + "";
            val2 = col.options[1] + "";
          }
        }

        if (val + "" == val2) {
          colDiv.find("div").css("float", "right");
          colDiv.find("div").css("background-color", "#0099ff");
          colDiv.attr("value", val2);
        } else {
          colDiv.find("div").css("float", "left");

          if (this._tfp.curPage.bgColorMode == "dark") {
            colDiv.find("div").css("background-color", "#666666");
          } else {
            colDiv.find("div").css("background-color", "#999999");
          }

          colDiv.attr("value", val1);
        }
      } else if (colType == "checkbox") {
        colDiv.find(".checkboxitem").each(function () {
          if (val && (val + "").split(",").contains($(this).attr("data-option"))) $(this).find("div").css("display", "inline-block");else $(this).find("div").css("display", "none");
        });
        colDiv.attr("value", val);
      } else if (colType == "radio") {
        colDiv.find(".checkboxitem").each(function () {
          if (val == $(this).attr("data-option")) $(this).find("div").css("display", "inline-block");else $(this).find("div").css("display", "none");
        });
        colDiv.attr("value", val);
      } else if ((colType == "select" || colType == "datadic") && !col.readonly) {
        colDiv.find("select").val(val);
      } else if (colType == "textarea") {
        colDiv.find("textarea").val(val);
      } else {
        colDiv.find("input").val(val);
      }

      this.formulaCell(this, col, rowIndex);
    }
    /**
     * 设置行数据
     * @param {[type]} rowIndex [description]
     * @param {[type]} rowData  [description]
     */

  }, {
    key: "setRowData",
    value: function setRowData(rowIndex, rowData) {
      if (!rowData || !((0, _typeof2["default"])(rowData) == "object")) return;

      for (var i = 0; i < this.dataModel.columns.length; i++) {
        var col = this.dataModel.columns[i];
        var colIndex = i;

        for (var p in rowData) {
          if (p.toLowerCase() == col.id.toLowerCase()) {
            this.setCellData(rowIndex, colIndex, rowData[p]);
            break;
          }
        }
      }
    }
    /**
     * 设置列数据
     * @param {[type]} colIndex [description]
     * @param {[type]} data  [description]
     */

  }, {
    key: "setColData",
    value: function setColData(colIndex, data) {
      var _this10 = this;

      data.forEach(function (d, rowIndex) {
        _this10.setCellData(rowIndex, colIndex, d);
      });
    }
    /**
     * 获得指定行的jquery对象
     * @param  {[type]} rowIndex [description]
     * @return {[type]}          [description]
     */

  }, {
    key: "getRowEl",
    value: function getRowEl(rowIndex) {
      var dataList = this._jqObj.find(".tfp-dataset-list");

      return dataList.find(".tfp-dataset-row").eq(rowIndex);
    }
    /**
     * 获得指定单元格的jquery对象
     * @param  {[type]} rowIndex  [description]
     * @param  {[type]} _colIndex [description]
     * @return {[type]}           [description]
     */

  }, {
    key: "getCellEl",
    value: function getCellEl(rowIndex, _colIndex) {
      var dataList = this._jqObj.find(".tfp-dataset-list");

      var rowDiv = dataList.find(".tfp-dataset-row").eq(rowIndex);
      var colIndex = _colIndex;
      if (this.dataModel.showCheckbox) colIndex++;
      if (this.dataModel.showRowNum) colIndex++;
      return rowDiv.children("div").eq(colIndex);
    }
    /**
     * 获得指定行的数据
     * @param  {[type]} index   [description]
     * @param  {[type]} options [description]
     * @return {[type]}         [description]
     */

  }, {
    key: "getRowData",
    value: function getRowData(index, options) {
      var checkRequired = false;
      var onlyGetChecked = false;
      var autoFormat = false;

      if (options) {
        if (options.checkRequired) checkRequired = true;
        if (options.onlyGetChecked) onlyGetChecked = true;
        if (options.autoFormat) autoFormat = true;
      }

      var dataList = this._jqObj.find(".tfp-dataset-list");

      var rowDiv = dataList.find(".tfp-dataset-row").eq(index);
      var row = {
        _rowIndex: index,
        _rowNum: index + 1
      };
      var checked = false;

      if (this.dataModel.showCheckbox && rowDiv.find(".tfp-dataset-checkbox").get(0).checked) {
        checked = true;
        row.checked = true;
      }

      if (onlyGetChecked && !checked) return {
        row: null,
        isCheckOk: true
      };

      for (var i = 0; i < this.dataModel.columns.length; i++) {
        var col = this.dataModel.columns[i];
        var colIndex = i;
        if (this.dataModel.showCheckbox) colIndex++;
        if (this.dataModel.showRowNum) colIndex++;
        var val = null;
        var colDiv = rowDiv.children("div").eq(colIndex);
        var colType = col.type.toLowerCase();

        if ((colType == "select" || colType == "datadic") && !col.readonly) {
          val = colDiv.find("select").val();
        } else if (colType == "popuplist") {
          var _cpt4 = this._tfp.components[colDiv.attr("id")];

          if (_cpt4) {
            val = _cpt4.value;
          } else {
            val = colDiv.find("input").val();
          }
        } else if (colType == "dep" || colType == "user") {
          var _cpt5 = this._tfp.components[colDiv.attr("id")];

          if (_cpt5 && _cpt5.value) {
            if (col.orgDataType == "code") {
              val = _cpt5.value.code;
            } else if (col.orgDataType == "name") {
              val = _cpt5.value.name;
            } else if (col.orgDataType == "object") {
              val = _cpt5.value;
            } else {
              val = _cpt5.value.id;
            }
          }
        } else if (colType == "switch") {
          var val1 = Array.isArray(col.options) ? col.options[0] : "false";
          var val2 = Array.isArray(col.options) ? col.options[1] : "true";
          val = val1;
          if (colDiv.find(".switch").attr("value") == val2) val = val2;
          if (val == "true") val = true;
          if (val == "false") val = false;
        } else if (colType == "checkbox") {
          val = colDiv.find(".checkbox").attr("value");
        } else if (colType == "radio") {
          val = colDiv.find(".radio").attr("value");
        } else if (colType == "textarea") {
          val = colDiv.find("textarea").val();
        } else {
          val = colDiv.find("input").val();
        }

        if (tfp.isNull(val)) {
          if (col.required && checkRequired) {
            var colName = col.id;
            if (col.name) colName = col.name;

            this._tfp.showMsg(colName + "不能为空！");

            if (!col.readonly) {
              if (colType == "text" || colType == "select" || colType == "password" || colType == "number" || colType == "date" || colType == "time" || colType == "datetime") {
                colDiv.find(colType).focus();
              } else if (colType == "datadic") {
                colDiv.find("select").focus();
              }
            }

            return {
              row: null,
              isCheckOk: false
            };
          } else {
            if (colType == "text" && autoFormat && (col.dataType == "int" || col.dataType == "float" || col.dataType == "money")) {
              if (col.dataType == "int") {
                val = 0;
              } else {
                val = 0.00;
              }
            }
          }
        } else {
          if (colType == "text" && autoFormat && (col.dataType == "int" || col.dataType == "float" || col.dataType == "money")) {
            if (col.dataType == "int") {
              val = parseInt(val);
            } else {
              val = parseFloat(val);
            }
          }

          if (checkRequired && !isNull(val) && col.verify && (0, _typeof2["default"])(col.verify) == 'object' && col.verify.verify && col.verify.verifyMsg) {
            var reg = new RegExp(col.verify.verify);

            if (!reg.test(val.toString())) {
              this._tfp.showMsg(col.verify.verifyMsg);

              if (cpt.focus) cpt.focus();
              return {
                row: null,
                isCheckOk: false
              };
            }
          }

          row[col.id] = val;
        }
      }

      return {
        row: row,
        isCheckOk: true
      };
    }
    /**
     * 已废弃
     * @param {*} index 
     * @param {*} options 
     * @returns 
     */

  }, {
    key: "getRow",
    value: function getRow(index, options) {
      return this.getRowData(index, options);
    }
    /**
     * 获得所有行的数据
     * @param  {[type]}   options [description]
     * @param  {Function} cb      [description]
     * @return {[type]}           [description]
     */

  }, {
    key: "getRowsData",
    value: function getRowsData(options, cb) {
      var checkRequired = false;
      var onlyGetChecked = false;

      if (options) {
        if (options.checkRequired) checkRequired = true;
        if (options.onlyGetChecked) onlyGetChecked = true;
      }

      if (onlyGetChecked && !this.dataModel.showCheckbox) return [];
      var that = this;
      var rows = [];
      var isCheckOk = true;

      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.find(".tfp-dataset-row").each(function (index) {
        var ret = that.getRow(index, options);

        if (!ret.isCheckOk) {
          isCheckOk = false;
          return false;
        }

        if (ret.row) rows.push(ret.row);
      });
      if (!isCheckOk) return;

      if (cb) {
        cb(rows);
      } else {
        return rows;
      }
    }
    /**
     * 获得所有行的jQuery对象
     * @returns 
     */

  }, {
    key: "getRowsEl",
    value: function getRowsEl() {
      var dataList = this._jqObj.children(".tfp-dataset-list");

      return dataList.children(".tfp-dataset-row");
    }
    /**
     * 获得选中行的jQuery对象
     * @returns 
     */

  }, {
    key: "getCheckedRowsEl",
    value: function getCheckedRowsEl() {
      if (!this.dataModel.showCheckbox) return [];
      var arr = [];

      var dataList = this._jqObj.children(".tfp-dataset-list");

      dataList.children(".tfp-dataset-row").each(function () {
        var rowDiv = $(this);

        if (rowDiv.find(".tfp-dataset-checkbox").get(0).checked) {
          arr.push(rowDiv);
        }
      });
      return arr;
    }
    /**
     * 已废弃
     * @param {*} options 
     * @param {*} cb 
     * @returns 
     */

  }, {
    key: "getRows",
    value: function getRows(options, cb) {
      if (cb) {
        this.getRowsData(options, cb);
      } else {
        return this.getRowsData(options, cb);
      }
    }
    /**
     * 求指定列的合计值
     * @param  {[type]} colName [description]
     * @return {[type]}         [description]
     */

  }, {
    key: "sum",
    value: function sum(colId) {
      var ret = 0;
      var colIndex = 0;
      var dataType = "text";

      for (var i = 0; i < this.columns.length; i++) {
        var col = this.columns[i];

        if (col.id == colId) {
          colIndex = i;
          if (this.dataModel.showRowNum) colIndex++;
          if (this.dataModel.showCheckbox) colIndex++;
          if (col.dataType) dataType = col.dataType;
          break;
        }
      }

      var that = this;

      var dataList = this._jqObj.find(".tfp-dataset-list");

      dataList.find(".tfp-dataset-row").each(function (index) {
        var cellVal = $(this).children().eq(colIndex).find("input").val().trim().replaceAll(",", "");

        if (cellVal != "") {
          if (dataType == "int") {
            if (isInt(cellVal)) ret += parseInt(cellVal);
          } else if (!isNaN(cellVal)) {
            ret += parseFloat(cellVal);
          }
        }
      });

      if (dataType == "money") {
        ret = this._tfp.formatMoney(ret);
      }

      return ret;
    }
    /**
     * 绑定数据
     * @param  {[type]} data [description]
     * @return {[type]}      [description]
     */

  }, {
    key: "bindData",
    value: function bindData(data) {
      this.rows = data;
    }
  }, {
    key: "onLoadData",
    value: function onLoadData(req, res) {
      this.exeEventHandler("onAfterLoadData");
      var data = [];

      if (this.dataModel.dataBindingMember) {
        data = res[this.dataModel.dataBindingMember];
      } else if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
        data = res[this.dataModel.dataQuerySetting.dataMember];
      }

      if (!data) return;

      if (data.pageSize && data.rows) {
        this.bindData(data.rows);
      } else {
        this.bindData(data);
      }
    }
  }, {
    key: "loadColData",
    value: function loadColData(col, cb) {
      var that = this;

      if (col.type == "datadic") {
        col.dataListValueFormat = "code";
        col.dataListTextFormat = "name"; //需要设置类别编码

        if (!col.dataDicCode) {
          this._tfp.showMsg("请设置类别编码！");

          return;
        }

        this._tfp.use("Service", function () {
          var service = that._tfp["new"]("Service");

          service.path = "sys/service/data_dic/getList.tbs";
          service.request({
            typeCode: col.dataDicCode
          }, function (req, res) {
            that.onLoadColData(col, res, cb);
          });
        });

        return;
      } //如果设置了加载数据的后台服务组件，则通过该组件加载数据


      var loadDataService = col.loadDataListService; //兼容老版本组件

      if (col.dataQuerySetting && col.dataQuerySetting.serviceCpt) {
        loadDataService = col.dataQuerySetting.serviceCpt;
      }

      if (loadDataService) {
        var serviceCpt = this._tfp.get(loadDataService);

        if (!serviceCpt) {
          this._tfp.showMsg("ID为[" + loadDataService + "]的后台服务组件不存在！");

          return;
        }

        serviceCpt.status = 0;
        serviceCpt.request(null, function (req, res) {
          that.onLoadColData(col, res, cb);
        });
        return;
      } //如果设置了加载数据的后台服务路径，则动态创建服务组件请求该地址进行数据加载


      if (col.dataQuerySetting && col.dataQuerySetting.servicePath) {
        var options = {
          servicePath: col.dataQuerySetting.servicePath,
          autoReload: false,
          autoShowError: true,
          showLoading: true,
          encryptRequestArgs: col.dataQuerySetting.encryptRequestArgs,
          encryptResponseArgs: col.dataQuerySetting.encryptResponseArgs
        }; //如果设置了查询的请求参数，则绑定到服务对象上

        if (col.dataQuerySetting.requestArgs && col.dataQuerySetting.requestArgs.length > 0) {
          options.argSettings = col.dataQuerySetting.requestArgs;
        } //发起动态请求


        this._tfp.request(options, function (req, res, service) {
          that.onLoadColData(col, res, cb);
        });
      }
    }
    /**
     * 加载列的数据
     * @param {*} col 
     */

  }, {
    key: "setColOptions",
    value: function setColOptions(col, cb) {
      if (!["radio", "checkbox", "select", "datadic", "popuplist"].includes(col.type.toLowerCase())) {
        if (cb) cb();
        return;
      } //如果是弹出列表，且采用数据表格显示，则不在此加载数据，而是在显示数据表格时动态加载


      if (col.type.toLowerCase() == "popuplist" && col.showTable) {
        if (cb) cb();
        return;
      }

      if (col.jsonDataSet) {
        col.loadDataListService = col.jsonDataSet.loadDataListService;
        col.dataListBindingMember = col.jsonDataSet.dataListBindingMember;
        col.valueField = col.jsonDataSet.valueField;
        col.textField = col.jsonDataSet.textField;
        col.parentIdField = col.jsonDataSet.parentIdField;
        col.options = col.jsonDataSet.options; // col.defaultValue = col.jsonDataSet.defaultValue;
      } //如果设置了数据加载服务，且还未加载过数据，则从后台加载数据


      if ((col.loadDataListService && col.dataListBindingMember || col.dataQuerySetting || col.type == "datadic") && !col.isLoadData) {
        this.loadColData(col, cb);
        return;
      }

      if (col.options) {
        //否则，如果该列设置了固定的可选项
        var options = [];

        try {
          col.options = JSON.parse(col.options);
        } catch (error) {}

        if (Array.isArray(col.options)) {
          for (var j = 0; j < col.options.length; j++) {
            var option = col.options[j];

            if (typeof option == "string") {
              options.push({
                value: option,
                text: option
              });
            } else if (Object.prototype.toString.call(option) === '[object Object]') {
              if (!option.text && option.text != 0) option.text = option.value;
              options.push(option);
            }
          }
        } else if (typeof col.options == "string") {
          var arr = (col.options + '').split(",");

          for (var j = 0; j < arr.length; j++) {
            options.push({
              value: arr[j],
              text: arr[j]
            });
          }
        }

        col.options = options;
        if (cb) cb();
      } else {
        col.options = [];
        if (cb) cb();
      }
    }
  }, {
    key: "onLoadColData",
    value: function onLoadColData(col, res, cb) {
      var dataMember = "data";

      if (col.dataListBindingMember) {
        dataMember = col.dataListBindingMember;
      } else if (col.dataQuerySetting && col.dataQuerySetting.dataMember) {
        dataMember = col.dataQuerySetting.dataMember;
      }

      var data = res[dataMember];
      if (!data) return;

      if (data.pageSize && data.rows) {
        data = data.rows;
      }

      if (col.dataListValueFormat) {
        var optionsTmp = [];

        for (var i = 0; i < data.length; i++) {
          var rowTmp = data[i];
          var optionTmp = {};

          try {
            if (col.dataListValueFormat.indexOf("{") < 0 && col.dataListValueFormat.indexOf("}") < 0) {
              optionTmp.value = this._tfp.replaceDataField(rowTmp, "{" + col.dataListValueFormat + "}");
            } else {
              optionTmp.value = this._tfp.replaceDataField(rowTmp, col.dataListValueFormat);
            }
          } catch (e) {
            console.log(e);
          }

          if (isNull(optionTmp.value)) continue;

          if (col.dataListTextFormat) {
            try {
              if (col.dataListTextFormat.indexOf("{") < 0 && col.dataListTextFormat.indexOf("}") < 0) {
                optionTmp.text = this._tfp.replaceDataField(rowTmp, "{" + col.dataListTextFormat + "}");
              } else {
                optionTmp.text = this._tfp.replaceDataField(rowTmp, col.dataListTextFormat);
              }
            } catch (e) {
              console.log(e);
            }
          }

          optionsTmp.push(optionTmp);
        }

        col.options = optionsTmp;
      } else {
        col.options = data;
      }

      col.isLoadData = true;
      if (cb) cb();
    }
  }, {
    key: "setColOptionsLoop",
    value: function setColOptionsLoop(cb) {
      var that = this;

      if (that.tmp_index >= this.dataModel.columns.length) {
        cb();
      } else {
        //加载下拉列表列和弹出列表列的可选项
        this.setColOptions(this.dataModel.columns[that.tmp_index], function () {
          that.tmp_index++;
          that.setColOptionsLoop(cb);
        });
      }
    }
  }, {
    key: "submit",
    value: function submit(options) {
      if (!this.dataModel.submitService && !this.dataModel.dataSubmitSetting) {
        this._tfp.showMsg("请为[" + this.id + "]设置数据提交有关参数！");

        return;
      }

      this.exeEventHandler("onBeforeSubmit");
      var that = this;
      this.getRowsData(options, function (rows) {
        var args = {};
        args[that.id] = rows;

        if (that.dataModel.dataSubmitSetting && that.dataModel.dataSubmitSetting.servicePath) {
          var optionsReq = {
            servicePath: that.dataModel.dataSubmitSetting.servicePath,
            autoShowError: true,
            showLoading: true,
            args: args
          };

          if (that.dataModel.dataSubmitSetting.requestArgs && that.dataModel.dataSubmitSetting.requestArgs.length > 0) {
            optionsReq.argSettings = that.dataModel.dataSubmitSetting.requestArgs;
          }

          if (that.dataModel.dataSubmitSetting.encryptRequestArgs) optionsReq.encryptRequestArgs = that.dataModel.dataSubmitSetting.encryptRequestArgs;
          if (that.dataModel.dataSubmitSetting.encryptResponseArgs) optionsReq.encryptResponseArgs = that.dataModel.dataSubmitSetting.encryptResponseArgs;

          that._tfp.request(optionsReq, function (req, res) {
            if (that.dataModel.showSubmitSuccessHint) that._tfp.showMsg("提交成功！");
            that.exeEventHandler("onAfterSubmit", res);
          });

          return;
        }

        var serviceId = this.dataModel.submitService;

        if (this.dataModel.dataSubmitSetting && this.dataModel.dataSubmitSetting.serviceCpt) {
          serviceId = this.dataModel.dataSubmitSetting.serviceCpt;
        }

        var serviceCpt = that._tfp.get(serviceId);

        if (!serviceCpt) {
          that._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");

          return;
        }

        serviceCpt.request(args, function (req, res) {
          if (that.dataModel.showSubmitSuccessHint) that._tfp.showMsg("提交成功！");
          that.exeEventHandler("onAfterSubmit", res);
        });
      });
    }
  }, {
    key: "initDesigning",
    value: function initDesigning() {
      this.bindScrollEvent();
    }
    /**
     * 初始化运行时
     * @return {[type]} [description]
     */

  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this; //绑定添加按钮的点击事件

      this._jqObj.find(".tfp-dataset-button-add").click(function () {
        that.addRow();
      }); //绑定打开对话框添加按钮的点击事件


      this._jqObj.find(".tfp-dataset-button-add-from-dialog").click(function () {
        if (isNull(that.dataModel.addFromDialogPath)) {
          that._tfp.showMsg("请设置弹窗页面路径！");

          return;
        }

        var width = "640px";
        var height = "480px";
        if (that.dataModel.addFromDialogWidth) width = that.dataModel.addFromDialogWidth + "";
        if (width.indexOf("px") < 0) width += "px";
        if (that.dataModel.addFromDialogHeight) height = that.dataModel.addFromDialogHeight + "";
        if (height.indexOf("px") < 0) height += "px";

        that._tfp.openDialog(that.dataModel.addFromDialogButtonText, that.dataModel.addFromDialogPath, width, height, null, function (ret) {
          if (ret) {
            if (Array.isArray(ret)) {
              that.addRows(ret);
            } else {
              that.addRow(ret);
            }
          }
        });
      });

      document.addEventListener("click", function () {
        var srcEl = event.srcElement;
        var cell = $(srcEl);
        if (!cell.hasClass("tfp-dataset-cell")) cell = $(srcEl).closest(".tfp-dataset-cell"); //如果点击了单元格以外的地方，则取消选中单元格

        if ((cell.length == 0 || cell.closest(".tfp-dataset").attr("id") != that.id) && that.curCellRowIndex >= 0 && that.curCellColIndex >= 0) {
          var curCell = that.getCellEl(that.curCellRowIndex, that.curCellColIndex);
          if (curCell.length > 0) curCell.removeClass("tfp-dataset-cell-selected");
          that.curCellRowIndex = -1;
          that.curCellColIndex = -1;
        }
      });
      document.addEventListener("keydown", function (e) {
        if (that.curCellRowIndex >= 0 && that.curCellColIndex >= 0) {
          var cellEl = that.getCellEl(that.curCellRowIndex, that.curCellColIndex);
          var col = that.dataModel.columns[that.curCellColIndex];
          var rowIndex = that.curCellRowIndex;
          var colIndex = that.curCellColIndex;
          var cellData = that.getCellData(rowIndex, colIndex);

          if (that.dataModel.onCellKeyPress) {
            //try {
            var ret = eval(that.dataModel.onCellKeyPress);
            if (ret == false) return; //} catch (err) {
            //  console.error(err);
            //}
          } //如果是多行输入框，则不做任何处理


          if (col.type.toLowerCase() == "textarea") return;

          if (e.keyCode == 38) {
            //上
            //如果当前单元格为弹出列表，且列表已弹出，则不能上下切换单元格
            if (col.type.toLowerCase() == "popuplist") {
              if ($("#" + cellEl.attr("id") + "_PopupListDiv").is(":visible")) return;
            }

            event.preventDefault();
            if (that.curCellRowIndex > 0) that.selectCell(that.curCellRowIndex - 1, that.curCellColIndex);
          } else if (e.keyCode == 40) {
            //下
            //如果当前单元格为弹出列表，且列表已弹出，则不能上下切换单元格
            if (col.type.toLowerCase() == "popuplist") {
              if ($("#" + cellEl.attr("id") + "_PopupListDiv").is(":visible")) return;
            }

            event.preventDefault();
            if (that.curCellRowIndex < that.rows.length - 1) that.selectCell(that.curCellRowIndex + 1, that.curCellColIndex);
          } else if (e.keyCode == 37) {
            //左
            //判断输入框中光标位置，如果是在最前面，则可以切换单元格
            if (cellEl.find("input").length > 0 && !cellEl.find("input").prop("readonly")) {
              var cursorPosition = cellEl.find("input").prop('selectionStart');
              var txtLen = cellEl.find("input").val().length;
              if (txtLen > 0 && cursorPosition != 0) return;
            }

            if (that.curCellColIndex > 0) {
              $(".tfp-popuplist-table").hide();
              $(".tfp-popuplist-datalist").hide();
              that.selectCell(that.curCellRowIndex, that.curCellColIndex - 1);
            }
          } else if (e.keyCode == 39) {
            //右
            //判断输入框中光标位置，如果是在最后面，则可以切换单元格
            if (cellEl.find("input").length > 0 && !cellEl.find("input").prop("readonly")) {
              var _cursorPosition = cellEl.find("input").prop('selectionStart');

              var _txtLen = cellEl.find("input").val().length;
              if (_txtLen > 0 && _cursorPosition != _txtLen) return;
            }

            if (that.curCellColIndex < that.dataModel.columns.length - 1) {
              $(".tfp-popuplist-table").hide();
              $(".tfp-popuplist-datalist").hide();
              that.selectCell(that.curCellRowIndex, that.curCellColIndex + 1);
            } else if (that.curCellColIndex == that.dataModel.columns.length - 1 && that.curCellRowIndex < that.rows.length - 1) {
              $(".tfp-popuplist-table").hide();
              $(".tfp-popuplist-datalist").hide();
              that.selectCell(that.curCellRowIndex + 1, 0);
            }
          } else if (e.keyCode == 13) {
            //回车
            e.stopPropagation(); //如果当前单元格为弹出列表，且列表未弹出，则弹出

            if (col.type.toLowerCase() == "popuplist") {
              if (!$("#" + cellEl.attr("id") + "_PopupListDiv").is(":visible")) {
                cellEl.find("input").blur();

                var _cpt6 = tfp.get(cellEl.attr("id"));

                if (_cpt6) _cpt6.showOptions();
                e.stopImmediatePropagation();
              }

              return;
            }

            if (that.enterKeyMode == "down") {
              if (that.curCellRowIndex < that.rows.length - 1) {
                that.selectCell(that.curCellRowIndex + 1, that.curCellColIndex);
              } else if (that.curCellRowIndex == that.rows.length - 1 && that.enterKeyAddRow) {
                that.addRow({});
                that.selectCell(that.curCellRowIndex + 1, that.curCellColIndex);
              }
            } else {
              if (that.curCellColIndex < that.dataModel.columns.length - 1) {
                that.selectCell(that.curCellRowIndex, that.curCellColIndex + 1);
              } else if (that.curCellColIndex == that.dataModel.columns.length - 1 && that.curCellRowIndex == that.rows.length - 1 && that.enterKeyAddRow) {
                that.addRow({});
                that.selectCell(that.curCellRowIndex + 1, 0);
              }
            }
          } else if (e.keyCode == 9) {//TAB
            //if(that.curCellColIndex<(that.dataModel.columns.length-1)) that.selectCell(that.curCellRowIndex, that.curCellColIndex+1);
          } //e.stopPropagation();

        }
      }); //要在这里判断一下，否则有些情况会造成重复绑定事件

      if (!this.isBindEventHandler) {
        this.bindEventHandler();
      }

      if (this.dataModel.columns) {
        this.tmp_index = 0;
        this.setColOptionsLoop(function () {
          that.initRuntimeGoon();
        });
      } else {
        that.initRuntimeGoon();
      }
    }
  }, {
    key: "initRuntimeGoon",
    value: function initRuntimeGoon() {
      this.encodingRuleCols = []; //编码规则列所在索引

      this.isBatchLoadingEncodingRule = false; //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载

      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      } //设置计算列关联的列，以便当关联列的数据发生变化时，自动执行计算列的值


      if (this.dataModel.columns) {
        //存在关联计算的列
        this.calcCols = {};

        for (var i = 0; i < this.dataModel.columns.length; i++) {
          var col = this.dataModel.columns[i]; //设置编码规则列的索引，以便添加多行时批量加载编码规则

          if (col.type.toLowerCase() == "encodingrule") {
            //需要设置规则代码
            if (!col.encodingRuleCode) {
              console.log("请为第" + i + "列设置规则代码！");
              return;
            }

            this.encodingRuleCols.push(i);
          } //如果是计算列


          if (col.formula) {
            var arr = col.formula.match(/\{[\w]+\}/g);

            if (arr.length > 0) {
              for (var j = 0; j < arr.length; j++) {
                for (var k = 0; k < this.dataModel.columns.length; k++) {
                  var colR = this.dataModel.columns[k]; //如果当前列与计算列有关联，则标示为计算关联列

                  if ("{" + colR.id + "}" == arr[j]) {
                    if (!this.calcCols[colR.id]) {
                      this.calcCols[colR.id] = [];
                    }

                    if (!this.calcCols[colR.id].contains(col.id)) this.calcCols[colR.id].push(col.id);
                  }
                }
              }
            }
          }
        }
      }
    }
  }]);
  return DataSet;
}(_controller.VisibleComponent);

exports["default"] = DataSet;