"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "DataDic",
  "comment": "数据字典",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [{
    "name": "inputSetting",
    "comment": "输入项设置",
    "type": "group",
    "items": [{
      "name": "typeCode",
      "comment": "字典类别编码",
      "type": "Dialog",
      "inputType": "text",
      "title": "数据字典列表",
      "path": "taskbuilder-proj-manager/dataDicList.tfp",
      "width": "320px",
      "height": "480px"
    }, {
      "name": "valueType",
      "comment": "值类型",
      "type": "Select",
      "options": [{
        "value": "code",
        "text": "字典编码"
      }, {
        "value": "name",
        "text": "字典名称"
      }, {
        "value": "obj",
        "text": "字典对象"
      }],
      "default": "code",
      "notnull": true
    }, {
      "name": "value",
      "comment": "组件值",
      "type": "String"
    }, {
      "name": "comment",
      "comment": "组件备注",
      "type": "String"
    }, {
      "name": "placeHolders",
      "comment": "输入提示",
      "type": "String",
      "isHtmlAttr": true
    }, {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    }, {
      "name": "multiCheck",
      "comment": "允许多选",
      "type": "Switch"
    }, {
      "name": "required",
      "comment": "必填",
      "type": "Switch"
    }, {
      "name": "readonly",
      "comment": "只读",
      "type": "Switch",
      "isHtmlAttr": true
    }, {
      "name": "disabled",
      "comment": "禁用",
      "type": "Switch",
      "isHtmlAttr": true
    }, {
      "name": "encrypted",
      "comment": "加密发送",
      "type": "Switch"
    }]
  }],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "120px",
    "height": "30px",
    "line-height": "30px",
    "padding-left": "2px",
    "padding-right": "2px"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击时"
  }, {
    "name": "onFocus",
    "comment": "获得焦点时",
    "isNotHtmlEvent": true
  }, {
    "name": "onBlur",
    "comment": "失去焦点时",
    "isNotHtmlEvent": true
  }, {
    "name": "onChange",
    "comment": "值发生变化时",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;