"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "DataCard",
  "comment": "数据卡片",
  "cssFiles": "style.css",
  "attrs": [{
    "name": "dataQuerySetting",
    "comment": "数据查询设置",
    "type": "Dialog",
    "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
    "width": "800px",
    "height": "640px"
  }, {
    "name": "allowPaging",
    "comment": "允许翻页",
    "type": "Switch",
    "notPrint": true,
    "default": false
  }, {
    "name": "pageSize",
    "comment": "每页显示数量",
    "type": "Select",
    "notPrint": true,
    "options": [{
      "value": "20",
      "text": "20"
    }, {
      "value": "30",
      "text": "30"
    }, {
      "value": "50",
      "text": "50"
    }, {
      "value": "100",
      "text": "100"
    }]
  }],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "120px",
    "height": "120px",
    "border": "1px solid #cccccc",
    "position": "relative"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onBeforeLoadData",
    "comment": "加载数据前",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "args",
      "type": "Object",
      "comment": "请求数据"
    }]
  }, {
    "name": "onAfterLoadData",
    "comment": "加载数据后",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "req",
      "type": "Object",
      "comment": "请求数据"
    }, {
      "name": "res",
      "type": "Object",
      "comment": "响应数据"
    }]
  }, {
    "name": "onBeforeBindData",
    "comment": "绑定数据前",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "data",
      "type": "Object",
      "comment": "绑定的数据"
    }]
  }, {
    "name": "onAfterBindData",
    "comment": "绑定数据后",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "data",
      "type": "Object",
      "comment": "绑定的数据"
    }]
  }, {
    "name": "onClick",
    "comment": "鼠标点击卡片时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "cardIndex",
      "type": "Int",
      "comment": "卡片索引"
    }, {
      "name": "cardData",
      "type": "Object",
      "comment": "卡片数据"
    }]
  }, {
    "name": "onDblClick",
    "comment": "鼠标双击卡片时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "cardIndex",
      "type": "Int",
      "comment": "卡片索引"
    }, {
      "name": "cardData",
      "type": "Object",
      "comment": "卡片数据"
    }]
  }, {
    "name": "onMouseOver",
    "comment": "鼠标经过卡片时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "cardIndex",
      "type": "Int",
      "comment": "卡片索引"
    }, {
      "name": "cardData",
      "type": "Object",
      "comment": "卡片数据"
    }]
  }, {
    "name": "onMouseOut",
    "comment": "鼠标移出卡片时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "cardIndex",
      "type": "Int",
      "comment": "卡片索引"
    }, {
      "name": "cardData",
      "type": "Object",
      "comment": "卡片数据"
    }]
  }, {
    "name": "onBeforeAddCard",
    "comment": "添加卡片前",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "cardIndex",
      "type": "Int",
      "comment": "卡片索引"
    }, {
      "name": "cardData",
      "type": "Object",
      "comment": "卡片数据"
    }]
  }, {
    "name": "onAfterAddCard",
    "comment": "添加卡片后",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "cardIndex",
      "type": "Int",
      "comment": "卡片索引"
    }, {
      "name": "cardData",
      "type": "Object",
      "comment": "卡片数据"
    }]
  }, {
    "name": "onBeforeUpdateCard",
    "comment": "修改卡片前",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "cardIndex",
      "type": "Int",
      "comment": "卡片索引"
    }, {
      "name": "cardData",
      "type": "Object",
      "comment": "卡片数据"
    }]
  }, {
    "name": "onAfterUpdateCard",
    "comment": "修改卡片后",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "cardIndex",
      "type": "Int",
      "comment": "卡片索引"
    }, {
      "name": "cardData",
      "type": "Object",
      "comment": "卡片数据"
    }]
  }, {
    "name": "onBeforeRemoveCard",
    "comment": "移除卡片前",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "cardIndex",
      "type": "Int",
      "comment": "卡片索引"
    }]
  }, {
    "name": "onAfterRemoveCard",
    "comment": "移除卡片后",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "cardIndex",
      "type": "Int",
      "comment": "卡片索引"
    }]
  }],
  "methods": [{
    "name": "addCard",
    "comment": "添加卡片",
    "args": [{
      "name": "cardData",
      "comment": "卡片数据",
      "type": "Object",
      "required": true
    }]
  }, {
    "name": "updateCard",
    "comment": "修改卡片数据",
    "args": [{
      "name": "cardIndex",
      "comment": "卡片索引",
      "type": "Int",
      "required": true
    }, {
      "name": "cardData",
      "comment": "卡片数据",
      "type": "Object",
      "required": true
    }]
  }, {
    "name": "removeCard",
    "comment": "删除卡片",
    "args": [{
      "name": "cardIndex",
      "comment": "卡片索引",
      "type": "Int",
      "required": true
    }]
  }, {
    "name": "getCptInCard",
    "comment": "获得卡片内的组件",
    "args": [{
      "name": "cardIndex",
      "comment": "卡片索引",
      "type": "Int",
      "required": true
    }, {
      "name": "cptDesignId",
      "comment": "组件设计时编号",
      "type": "String",
      "required": true
    }, {
      "name": "retVarName",
      "comment": "返回给",
      "type": "varList",
      "width": "100px",
      "default": "cpt",
      "required": true,
      "isOnlyStr": true
    }]
  }, {
    "name": "bindData",
    "comment": "绑定数据",
    "args": [{
      "name": "data",
      "comment": "数据",
      "type": "Object",
      "required": true
    }]
  }, {
    "name": "loadData",
    "comment": "加载数据",
    "args": [{
      "name": "toPage",
      "comment": "页号",
      "type": "Int"
    }]
  }, {
    "name": "gotoPage",
    "comment": "加载指定页的数据",
    "args": [{
      "name": "toPage",
      "comment": "页号",
      "type": "Int",
      "required": true
    }]
  }]
};
exports["default"] = _default;