"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 数据卡片组件
 * @param {[type]} dataModel [description]
 */
var DataCard = /*#__PURE__*/function (_ContainerComponent) {
  (0, _inherits2["default"])(DataCard, _ContainerComponent);

  var _super = _createSuper(DataCard);

  function DataCard(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, DataCard);
    _this = _super.call(this, __tfp, "DataCard", dataModel, parent);
    _this.dataList = [];
    _this.cards = [];
    _this.curPage = 1;
    _this.pageCount = 0;
    _this.rowsCount = 0;
    return _this;
  } //属性


  (0, _createClass2["default"])(DataCard, [{
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    }
  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    }
  }, {
    key: "allowPaging",
    get: function get() {
      return this.dataModel.allowPaging ? this.dataModel.allowPaging : false;
    },
    set: function set(value) {
      this.dataModel.allowPaging = value ? true : false;

      if (this._tfp.isDesigning && this._jqObj) {
        if (this.dataModel.allowPaging) {
          if (this._jqObj.parent().find(".tfp-datacard-footer").length > 0) return;
          this.setFooter();
        } else {
          this._jqObj.parent().find(".tfp-datacard-footer").remove();
        }
      }
    }
  }, {
    key: "pageSize",
    get: function get() {
      return this.dataModel.pageSize ? this.dataModel.pageSize : 20;
    },
    set: function set(value) {
      this.dataModel.pageSize = value ? value : 20;
    }
  }, {
    key: "containerEl",
    get: function get() {
      return this._jqObj.get(0);
    }
  }, {
    key: "setCptDataFormat",
    value: function setCptDataFormat(cdm) {
      if (!cdm) return;

      if (cdm.dataBindingFormat) {
        cdm.value = cdm.dataBindingFormat;
      }

      if (cdm.components && cdm.components.length > 0) {
        for (var i = 0; i < cdm.components.length; i++) {
          this.setCptDataFormat(cdm.components[i]);
        }
      }
    }
    /**
     * 动态创建子组件
     * @param  {[type]} cdm [description]
     * @return {[type]}     [description]
     */

  }, {
    key: "createChildCpt",
    value: function createChildCpt(parent, cdm, cardIndex, data) {
      var newId = this.id + "_" + cdm.id + "_" + cardIndex;
      $("#" + cdm.id).attr("id", newId);
      cdm.id = newId;
      var cptClass = this._tfp.controllers[cdm.type];

      if (!cptClass) {
        console.log("未找到名为[" + cdm.type + "]的组件控制器！");
        return;
      }

      var cpt = new cptClass(this._tfp, cdm, parent);
      window[cpt.id] = cpt;
      cpt._jqObj = $("#" + cpt.id);
      if (cpt._jqObj.length > 0) cpt.el = cpt._jqObj[0];

      this._tfp.bindCptData(cpt, data);

      this._tfp.initCptRuntime(cpt);

      if (!cdm.components || cdm.components.length == 0) return;

      for (var i = 0; i < cdm.components.length; i++) {
        this.createChildCpt(cpt, cdm.components[i], cardIndex, data);
      }

      return cpt;
    }
    /**
     * 添加卡片
     * @param {*} cardData 
     * @param {*} cardIndex 
     * @returns 
     */

  }, {
    key: "addCard",
    value: function addCard(cardData, cardIndex) {
      if (!cardIndex && cardIndex != 0) {
        this.dataList.push(cardData);
        cardIndex = this.dataList.length;
      }

      if (this.dataModel.onBeforeAddCard) {
        try {
          var ret = eval(this.dataModel.onBeforeAddCard);
          if (ret) cardData = ret;
        } catch (err) {
          console.log(err);
        }
      }

      var dataCardHtml = this.templateHtml + "";
      dataCardHtml = dataCardHtml.replace(" id=\"" + this.id + "\"", "");

      try {
        dataCardHtml = this._tfp.replaceDataField(cardData, dataCardHtml);
        dataCardHtml = this._tfp.exeExpress(dataCardHtml);
      } catch (e) {
        console.log(e);
        return;
      }

      this.parentEl.append(dataCardHtml);
      var newCard = {
        index: cardIndex,
        components: []
      };
      var cdmNew = JSON.parse(JSON.stringify(this.templateCdm));

      for (var j = 0; j < cdmNew.components.length; j++) {
        var cdmChild = cdmNew.components[j];
        var cptChild = this.createChildCpt(this, cdmChild, cardIndex, cardData);
        newCard.components.push(cptChild);
      }

      var newCardEl = this.parentEl.find(".tfp-datacard").last();
      newCardEl.show();
      newCard._jqObj = newCardEl;
      this.cards.push(newCard);
      var that = this;

      if (this.templateCdm.onDblClick) {
        newCardEl.dblclick(function () {
          var cardIndex = $(this).index();
          var cardData = that.dataList[cardIndex];

          try {
            eval(that.templateCdm.onDblClick);
          } catch (err) {
            console.log(err);
          }
        });
      } else if (this.templateCdm.onClick) {
        newCardEl.click(function () {
          var cardIndex = $(this).index();
          var cardData = that.dataList[cardIndex];

          try {
            eval(that.templateCdm.onClick);
          } catch (err) {
            console.log(err);
          }
        });
      }

      if (this.templateCdm.onMouseOver) {
        newCardEl.mouseover(function () {
          var cardIndex = $(this).index();
          var cardData = that.dataList[cardIndex];

          try {
            eval(that.templateCdm.onMouseOver);
          } catch (err) {
            console.log(err);
          }
        });
      }

      if (this.templateCdm.onMouseOut) {
        newCardEl.mouseout(function () {
          var cardIndex = $(this).index();
          var cardData = that.dataList[cardIndex];

          try {
            eval(that.templateCdm.onMouseOut);
          } catch (err) {
            console.log(err);
          }
        });
      }

      if (this.templateCdm.onAfterAddCard) {
        try {
          eval(this.templateCdm.onAfterAddCard);
        } catch (err) {
          console.log(err);
        }
      }
    }
  }, {
    key: "updateCardCptData",
    value: function updateCardCptData(cpt, cardData) {
      this._tfp.bindCptData(cpt, cardData);

      if (cpt.components && cpt.components.length > 0) {
        for (var i = 0; i < cpt.components.length; i++) {
          this.updateCardCptData(cpt.components[i], cardData);
        }
      }
    }
    /**
     * 修改卡片
     * @param {*} cardIndex 
     * @param {*} cardData 
     * @returns 
     */

  }, {
    key: "updateCard",
    value: function updateCard(cardIndex, cardData) {
      if (this.templateCdm.onBeforeUpdateCard) {
        try {
          eval(this.templateCdm.onBeforeUpdateCard);
        } catch (err) {
          console.log(err);
        }
      }

      if (cardIndex >= this.dataList.length) return;
      this.dataList[cardIndex] = cardData;
      var card = this.cards[cardIndex];

      for (var i = 0; i < card.components.length; i++) {
        this.updateCardCptData(card.components[i], cardData);
      }

      if (this.templateCdm.onAfterUpdateCard) {
        try {
          eval(this.templateCdm.onAfterUpdateCard);
        } catch (err) {
          console.log(err);
        }
      }
    }
    /**
     * 移除卡片
     * @param {*} cardIndex 
     * @returns 
     */

  }, {
    key: "removeCard",
    value: function removeCard(cardIndex) {
      if (this.templateCdm.onBeforeRemoveCard) {
        try {
          eval(this.templateCdm.onBeforeRemoveCard);
        } catch (err) {
          console.log(err);
        }
      }

      if (cardIndex >= this.dataList.length) return;
      this.dataList.splice(cardIndex, 1);
      this.cards.splice(cardIndex, 1);
      this.parentEl.find(".tfp-datacard").eq(cardIndex).remove();

      if (this.templateCdm.onAfterRemoveCard) {
        try {
          eval(this.templateCdm.onAfterRemoveCard);
        } catch (err) {
          console.log(err);
        }
      }
    }
    /**
     * 获得卡片内指定id的组件
     * @param {*} cardIndex 
     * @param {*} cptDesignId 
     * @returns 
     */

  }, {
    key: "getCptInCard",
    value: function getCptInCard(cardIndex, cptDesignId) {
      var cptNewId = this.id + "_" + cptDesignId + "_" + cardIndex;
      return this._tfp.get(cptNewId);
    }
    /**
     * 绑定数据
     * @param {*} data 
     * @returns 
     */

  }, {
    key: "bindData",
    value: function bindData(data) {
      if (!data || !Array.isArray(data)) return;
      this.dataList = data;
      this.parentEl.find('.tfp-datacard').remove();

      if (this.dataModel.onBeforeBindData) {
        try {
          eval(this.dataModel.onBeforeBindData);
        } catch (err) {
          console.log(err);
        }
      }

      for (var i = 0; i < data.length; i++) {
        var cardData = data[i];
        cardData._index = i;
        this.addCard(cardData, i);
      }

      this.parentEl.get(0).scrollTop = 0;

      if (this.dataModel.onAfterBindData) {
        try {
          eval(this.dataModel.onAfterBindData);
        } catch (err) {
          console.log(err);
        }
      }
    }
  }, {
    key: "setPageButton",
    value: function setPageButton() {
      if (!this.dataModel.allowPaging) return;
      var footerDiv = this.parentEl.parent().children(".tfp-datacard-footer");
      var arr = [];
      var index = parseInt(this.curPage);

      while (index > 0 && arr.length < 3) {
        arr.unshift(index);
        index--;
      }

      index = parseInt(this.curPage) + 1;

      while (arr.length < 5 && index <= this.pageCount) {
        arr.push(index);
        index++;
      }

      for (var i = 0; i < arr.length; i++) {
        var btn = footerDiv.find(".tfp-datacard-footer-page").eq(i);
        btn.html(arr[i]);
        btn.attr("title", "跳转到第" + arr[i] + "页");

        if (arr[i] == parseInt(this.curPage)) {
          btn.css("background-color", "#4E6EF2");
          btn.css("color", "#FFFFFF");
        } else {
          btn.css("background-color", "");
          btn.css("color", "");
        }

        btn.show();
      }

      for (var _i = arr.length; _i < 5; _i++) {
        var _btn = footerDiv.find(".tfp-datacard-footer-page").eq(_i);

        _btn.html("");

        _btn.attr("title", "");

        _btn.hide();
      }
    }
    /**
     * 跳转到指定页面
     * @param {*} toPage 
     */

  }, {
    key: "gotoPage",
    value: function gotoPage(toPage) {
      this.loadData(toPage);
    }
    /**
     * 加载数据
     * @param {*} toPage 
     * @returns 
     */

  }, {
    key: "loadData",
    value: function loadData(toPage) {
      var args = {};

      if (this.allowPaging) {
        args = {
          pageSize: this.pageSize,
          toPage: toPage ? toPage : 1
        };
      }

      (0, _get2["default"])((0, _getPrototypeOf2["default"])(DataCard.prototype), "loadData", this).call(this, args);
    }
  }, {
    key: "onLoadData",
    value: function onLoadData(req, res) {
      var data = [];

      if (this.dataModel.dataBindingMember) {
        data = res[this.dataModel.dataBindingMember];
      } else if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
        data = res[this.dataModel.dataQuerySetting.dataMember];
      }

      if (!data) return;

      if (data.rows) {
        this.curPage = data.toPage;
        this.rowsCount = data.rowsCount;
        this.pageCount = data.pageCount;
        this.pageSize = data.pageSize;
        this.setPageButton();
        this.bindData(data.rows);
      } else {
        if (!Array.isArray(data)) data = [data];
        this.curPage = 1;
        this.rowsCount = data.length;
        this.pageCount = 1;
        this.pageSize = data.length;
        this.bindData(data);
      }
    }
  }, {
    key: "setFooter",
    value: function setFooter() {
      this._jqObj.parent().append("<div class=\"tfp-datacard-footer\">\r\n" + "<div class=\"tfp-datacard-footer-first\" title=\"首页\">&lt;&lt;</div>" + "<div class=\"tfp-datacard-footer-prev\" class=\"tfp-datacard-footer-first\" title=\"上一页\">&lt;</div>" + "<div class=\"tfp-datacard-footer-page\" title=\"\"></div>" + "<div class=\"tfp-datacard-footer-page\" title=\"\"></div>" + "<div class=\"tfp-datacard-footer-page\" title=\"\"></div>" + "<div class=\"tfp-datacard-footer-page\" title=\"\"></div>" + "<div class=\"tfp-datacard-footer-page\" title=\"\"></div>" + "<div class=\"tfp-datacard-footer-next\" title=\"下一页\">&gt;</div>" + "<div class=\"tfp-datacard-footer-last\" title=\"最后一页\">&gt;&gt;</div></div>");
    }
  }, {
    key: "initDesigning",
    value: function initDesigning() {
      if (this.dataModel.allowPaging) this.setFooter();
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;
      this.parentEl = this._jqObj.parent();

      if (this.dataModel.allowPaging) {
        this._jqObj.parent().append("<div class=\"tfp-datacard-container\"></div>");

        this.parentEl = this._jqObj.parent().children(".tfp-datacard-container");

        var position = this._jqObj.parent().css("position");

        if (!position) this._jqObj.parent().css("position", "relative");
        this.setFooter();

        var divFooter = this._jqObj.parent().children(".tfp-datacard-footer");

        divFooter.find(".tfp-datacard-footer-first").click(function () {
          that.gotoPage(1);
        });
        divFooter.find(".tfp-datacard-footer-prev").click(function () {
          var prevPage = that.curPage - 1;
          if (prevPage < 1) prevPage = 1;
          that.gotoPage(prevPage);
        });
        divFooter.find(".tfp-datacard-footer-next").click(function () {
          var nextPage = that.curPage + 1;
          if (nextPage > that.pageCount) nextPage = that.pageCount;
          that.gotoPage(nextPage);
        });
        divFooter.find(".tfp-datacard-footer-last").click(function () {
          that.gotoPage(that.pageCount);
        });
        divFooter.find(".tfp-datacard-footer-page").click(function () {
          var toPage = parseInt($(this).html());
          if (toPage == that.curPage) return;
          divFooter.find(".tfp-datacard-footer-page").css("background-color", "");
          divFooter.find(".tfp-datacard-footer-page").css("color", "");
          $(this).css("background-color", "#4E6EF2");
          $(this).css("color", "#FFFFFF");
          that.gotoPage(toPage);
        });
      }

      if (this._jqObj.length > 0) this.templateHtml = this._jqObj.get(0).outerHTML;
      this.templateCdm = JSON.parse(JSON.stringify(this.dataModel));
      this.dataModel.components = [];

      this._jqObj.remove();

      this.parentEl.children(".tfp-datacard").remove(); //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载

      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      } else if (this.dataModel.dataList) {
        this.bindData(this.dataModel.dataList);
      }
    }
  }]);
  return DataCard;
}(_controller.ContainerComponent);

exports["default"] = DataCard;