"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisibleComponent = exports.InvisibleComponent = exports.FormInput = exports.ContainerComponent = exports.Component = void 0;

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var _parent = Symbol("parent");
/**
 * TaskUI组件基类
 */


var Component = /*#__PURE__*/function () {
  function Component(__tfp, typeName, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Component);

    if (!__tfp) {
      throw new Error("请提供tfp对象！");
      return;
    }

    if (!typeName) {
      console.log(dataModel);
      throw new Error("请提供组件类型！");
      return;
    }

    this._tfp = __tfp;
    this.level = 0; //组件相对页面组件的层次

    this.index = 0; //组件在父组件中的索引，主要用来排序
    //目前如果某个兄弟组件删除了，不会重置所有剩余的兄弟组件的索引
    //如果没有提供数据模型，则进行模型初始化

    if (!dataModel) {
      var metadata = this._tfp.type(typeName);

      if (!metadata) {
        throw new Error("请提供正确的组件类型！");
        return;
      }

      this.dataModel = {
        type: typeName
      };
      this.dataModel.id = this.dataModel.type.substr(0, 1).toLowerCase() + this.dataModel.type.substr(1) + this._tfp.getNewCptIndex(this.dataModel.type); //如果是用户自定义组件里的新创建的子组件，则在组件编号前面加上用户自定义组件的编号，以免跟其他页面里的组件id重复

      if (this.dataModel.type != "Page" && this._tfp.curPage.pageType == "component") this.dataModel.id = this._tfp.curPage.id + "_" + this.dataModel.id;
      var attrs = this.attrTypes; //设置组件默认属性

      for (var _i = 0; _i < attrs.length; _i++) {
        var attr = attrs[_i];

        if (attr["default"] || attr["default"] == 0 || attr["default"] == false) {
          if (attr.type.toLowerCase() == "string") {
            this.dataModel[attr.name] = attr["default"].replace("{id}", this.id);
          } else {
            this.dataModel[attr.name] = attr["default"];
          }
        }
      } //设置可视组件数据模型的默认样式


      if (metadata.defaultStyles) {
        this.dataModel.styles = {};

        for (var style in metadata.defaultStyles) {
          this.dataModel.styles[style] = metadata.defaultStyles[style];
        }
      }
    } else {
      //否则用传入的数据模型
      this.dataModel = dataModel;
      if (!this.dataModel.type) this.dataModel.type = typeName;
    } //设置组件数据模型的默认ID


    if (!this.dataModel.id) {
      this.dataModel.id = this.dataModel.type.substr(0, 1).toLowerCase() + this.dataModel.type.substr(1) + this._tfp.getNewCptIndex(this.dataModel.type);
    }

    this._tfp.components[this.dataModel.id] = this;
    if (this._tfp.isRuntime) window[this.dataModel.id] = this; //设置组件的父组件

    if (parent) {
      this[_parent] = parent;
      this.level = parent.level + 1;

      if (!this._tfp.isLoadingPage) {
        if (!parent.dataModel.components) parent.dataModel.components = [];
        var cptExists = false;

        for (var i = 0; i < parent.dataModel.components.length; i++) {
          var cdmTmp = parent.dataModel.components[i];

          if (cdmTmp.id == this.dataModel.id) {
            cptExists = true;
            continue;
          }

          if (cdmTmp.index >= this.index) this.index = cdmTmp.index + 1;
        }

        if (!cptExists) parent.dataModel.components.push(this.dataModel);
      }
    } else {//TODO 如果创建组件时没有提供父组件，则表示是临时组件，后续可以设置父组件
    }
  } //组件ID，每个组件的ID是唯一的，不能重复


  (0, _createClass2["default"])(Component, [{
    key: "id",
    get: function get() {
      return this.dataModel.id;
    },
    set: function set(value) {
      if (!value) return;
      var oldId = this.dataModel.id;
      if (oldId == value) return;

      for (var cptId in this._tfp.components) {
        if (cptId == value) {
          throw new Error("ID为的" + value + "组件已存在！");
          return;
        }
      }

      this.dataModel.id = value;
      delete this._tfp.components[oldId];
      this._tfp.components[this.dataModel.id] = this;

      if (this._tfp.isRuntime) {
        delete window[oldId];
        window[this.dataModel.id] = this;
      }

      if ($("#" + oldId).length > 0) {
        $("#" + oldId).attr("id", this.dataModel.id);
      }
    } //组件类型，组件一旦创建，不允许再修改类型

  }, {
    key: "type",
    get: function get() {
      return this.dataModel.type;
    },
    set: function set(value) {} //组件类型元数据，组件一旦创建，不允许再修改

  }, {
    key: "metadata",
    get: function get() {
      return this._tfp.type(this.dataModel.type);
    },
    set: function set(value) {} //父组件

  }, {
    key: "parent",
    get: function get() {
      return this[_parent];
    },
    set: function set(value) {
      //如果没有设置父组件
      if (!this[_parent]) {
        this[_parent] = value;
        if (!this[_parent].dataModel.components) this[_parent].dataModel.components = [];

        this[_parent].dataModel.components.push(this.dataModel);
      } else {
        if (this[_parent].id != value.id) {
          //如果已经设置了父组件，但新设置的父组件和原来的父组件不一样
          this[_parent].dataModel.components.remove(this.dataModel);

          this[_parent] = value;
          if (!this[_parent].dataModel.components) this[_parent].dataModel.components = [];

          this[_parent].dataModel.components.push(this.dataModel);
        } else {
          //如果父组件没有变化，则不需要执行后续操作
          return;
        }
      } //设置当前组件的层级和索引


      this.level = this[_parent].level + 1;

      for (var i = 0; i < this[_parent].dataModel.components.length; i++) {
        var cdmTmp = this[_parent].dataModel.components[i];
        if (cdmTmp.index >= this.index) this.index = cdmTmp.index + 1;
      }
    }
  }, {
    key: "attrTypes",
    get: function get() {
      var attrs = [];

      var metadata = this._tfp.type(this.type);

      if (metadata.attrs) {
        for (var i = 0; i < metadata.attrs.length; i++) {
          var attr = metadata.attrs[i];

          if (attr.type == "group" || attr.items) {
            for (var j = 0; j < attr.items.length; j++) {
              attrs.push(attr.items[j]);
            }
          } else {
            attrs.push(attr);
          }
        }
      }

      return attrs;
    },
    set: function set(value) {}
  }, {
    key: "setParentOnly",
    value: function setParentOnly(value) {
      this[_parent] = value;
      this.level = this[_parent].level + 1;
    }
  }, {
    key: "attr",
    value: function attr(attrName, attrValue) {
      if (arguments.length == 0) return; //获取属性值

      if (arguments.length == 1) {
        return this[attrName];
      }

      this[attrName] = attrValue;
    }
    /**
     * 获得属性定义信息
     * @param  {[type]} attrName [description]
     * @return {[type]}          [description]
     */

  }, {
    key: "getAttrTypeInfo",
    value: function getAttrTypeInfo(attrName) {
      if (!this.metadata) {
        throw new Error("没有找到组件类型定义信息，请先引用类型信息！");
        return;
      }

      if (!this.metadata.attrs) {
        //throw new Error("没有找到组件的属性定义信息！");
        return null;
      }

      for (var i = 0; i < this.metadata.attrs.length; i++) {
        var attrInfo = this.metadata.attrs[i];

        if (attrInfo.type == "group" || attrInfo.items) {
          for (var j = 0; j < attrInfo.items.length; j++) {
            if (attrInfo.items[j].name == attrName) {
              return attrInfo.items[j];
            }
          }
        } else {
          if (this.metadata.attrs[i].name == attrName) {
            return this.metadata.attrs[i];
          }
        }
      }

      return null;
    }
    /**
     * 检查属性选项是否是组件类型定义中设置的选项
     * @param  {[type]} attrName [description]
     * @param  {[type]} attrVal  [description]
     * @return {[type]}          [description]
     */

  }, {
    key: "checkAttrOption",
    value: function checkAttrOption(attrName, attrVal) {
      var attr = this.getAttrTypeInfo(attrName);
      if (!attr) return false;
      var options = attr.options;
      if (!options) return false;

      for (var i = 0; i < options.length; i++) {
        if (options[i].value == attrVal) return true;
      }

      return false;
    }
    /**
     * 执行事件处理函数
     * @param  {[type]} eventName [description]
     * @return {[type]}           [description]
     */

  }, {
    key: "exeEventHandler",
    value: function exeEventHandler(eventName) {
      //设计时不执行任何事件处理函数
      if (this._tfp.isDesigning) return;
      var ret;

      if (this[eventName] && typeof this[eventName] == "function") {
        ret = this[eventName](arguments);
      } else if (this.dataModel[eventName]) {
        var funcStr = this.dataModel[eventName];

        if (funcStr.indexOf("(") > 0) {
          var funcName = funcStr.substr(0, funcStr.indexOf("("));

          if (typeof window[funcName] == "function") {
            var args = [];

            if (arguments.length > 1) {
              for (var i = 1; i < arguments.length; i++) {
                args.push(arguments[i]);
              }
            }

            var func = window[funcName];
            ret = func.apply(window, args);
          } else {
            ret = eval(funcStr);
          }
        } else {
          ret = eval(funcStr);
        }
      }

      if (ret) return ret;
    }
  }]);
  return Component;
}();

exports.Component = Component;

var InvisibleComponent = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(InvisibleComponent, _Component);

  var _super = _createSuper(InvisibleComponent);

  function InvisibleComponent(__tfp, typeName, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, InvisibleComponent);
    return _super.call(this, __tfp, typeName, dataModel, parent);
  }

  (0, _createClass2["default"])(InvisibleComponent, [{
    key: "isInvisible",
    get: function get() {
      return true;
    },
    set: function set(value) {}
  }, {
    key: "render",
    value: function render() {
      //如果是不可视组件，只有在设计时需要渲染
      if (this._tfp.isDesigning) {
        if (window.parent.uiDesigner) window.parent.uiDesigner.addInvisibleComponent(this);

        this._tfp.initCptDesignSetting(this);
      }
    }
  }]);
  return InvisibleComponent;
}(Component);

exports.InvisibleComponent = InvisibleComponent;

var VisibleComponent = /*#__PURE__*/function (_Component2) {
  (0, _inherits2["default"])(VisibleComponent, _Component2);

  var _super2 = _createSuper(VisibleComponent);

  function VisibleComponent(__tfp, typeName, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, VisibleComponent);
    _this = _super2.call(this, __tfp, typeName, dataModel, parent);
    _this._jqObj = null;
    _this.el = null;
    _this.isRendered = false;
    return _this;
  }

  (0, _createClass2["default"])(VisibleComponent, [{
    key: "isInvisible",
    get: function get() {
      return false;
    },
    set: function set(value) {}
  }, {
    key: "isContainer",
    get: function get() {
      return false;
    },
    set: function set(value) {}
  }, {
    key: "isShow",
    get: function get() {
      return this._jqObj.is(":visible");
    },
    set: function set(value) {}
  }, {
    key: "styles",
    get: function get() {
      return this.dataModel.styles;
    },
    set: function set(value) {}
  }, {
    key: "style",
    get: function get() {
      return this.dataModel.style;
    },
    set: function set(value) {
      if (!value) value = "";
      this.dataModel.style = value;

      if (this._jqObj) {
        var style = value.trim();
        if (style != "" && !style.endsWith(";")) style += ";";

        if (this.dataModel.styles) {
          for (var styleTmp in this.dataModel.styles) {
            style += styleTmp + ": " + this.dataModel.styles[styleTmp] + ";";
          }
        } //要保留设计时的外边框


        var outline = this._jqObj.css("outline");

        this._jqObj.attr("style", style);

        this._jqObj.css("outline", outline);
      }
    } // 更改样式对象

  }, {
    key: "styleObj",
    get: function get() {
      //console.log(this.dataModel)
      return this.dataModel.styleObj;
    },
    set: function set(value) {
      this.dataModel.styleObj = value;
    } // 显示隐藏对象

  }, {
    key: "hideObj",
    get: function get() {
      return this.dataModel.hideObj;
    },
    set: function set(value) {
      this.dataModel.hideObj = value;
    }
  }, {
    key: "class",
    get: function get() {
      return this.dataModel["class"];
    },
    set: function set(value) {
      if (!value) value = "";
      this.dataModel["class"] = value;

      if (this._jqObj) {
        this._jqObj.attr("class", value);
      }
    }
  }, {
    key: "indent",
    get: function get() {
      var _indent = "";

      for (var i = 0; i < this.level; i++) {
        _indent += "\t";
      }

      return _indent;
    },
    set: function set(value) {}
  }, {
    key: "controlId",
    get: function get() {
      return this.dataModel.id;
    },
    set: function set(value) {
      this.id = value;

      if (this.type.toLowerCase() == "dataset") {
        this.dataBindingMember = "data_" + this.id;
      } else {
        this.dataBindingFormat = "{" + this.id + "}";
      }
    }
  }, {
    key: "controlName",
    get: function get() {
      return this.dataModel.titleName;
    },
    set: function set(value) {
      this.dataModel.titleName = value;
      this._tfp.get(this.parent.parent.components[0].components[0].id)["value"] = value + "：";
    }
  }, {
    key: "controlWidth",
    get: function get() {
      return this.parent.parent.parent["colWidth"];
    },
    set: function set(value) {
      this._tfp.get(this.parent.parent.parent.id)["colWidth"] = value;
    }
  }, {
    key: "controlDirection",
    get: function get() {
      return this.parent.parent["direction"];
    },
    set: function set(value) {
      this._tfp.get(this.parent.parent.id)["direction"] = value;
    }
  }, {
    key: "css",
    value: function css(styleName, styleValue) {
      if (arguments.length == 0) return; //获取样式值

      if (arguments.length == 1) {
        if (!this.dataModel.styles) return null;
        return this.dataModel.styles[styleName];
      }

      if (this._jqObj) this._jqObj.css(styleName, styleValue);
      if (!this.dataModel.styles) this.dataModel.styles = {};

      if (styleValue == "" || styleValue == null) {
        delete this.dataModel.styles[styleName];
      } else {
        this.dataModel.styles[styleName] = styleValue; //如果定义了样式修改监听事件处理器，则执行

        if (this.styleOnChange) this.styleOnChange(styleName, styleValue);
      }
    }
  }, {
    key: "val",
    value: function val(value) {
      if (arguments.length == 0) return this.value;
      this.value = value;
    }
  }, {
    key: "show",
    value: function show() {
      if (this._jqObj) this._jqObj.show();
    }
  }, {
    key: "hide",
    value: function hide() {
      if (this._jqObj) this._jqObj.hide();
    }
  }, {
    key: "toggle",
    value: function toggle(speed, easing, cb) {
      if (this._jqObj) this._jqObj.toggle(speed, easing, cb);
    }
  }, {
    key: "animate",
    value: function animate(styles, speed, easing, cb) {
      if (this._jqObj) this._jqObj.animate(styles, speed, easing, cb);
    }
  }, {
    key: "clearQueue",
    value: function clearQueue(queueName) {
      if (this._jqObj) this._jqObj.clearQueue(queueName);
    }
  }, {
    key: "delay",
    value: function delay(speed, queueName) {
      if (this._jqObj) this._jqObj.delay(speed, queueName);
    }
  }, {
    key: "dequeue",
    value: function dequeue(queueName) {
      if (this._jqObj) this._jqObj.dequeue(queueName);
    }
  }, {
    key: "fadeIn",
    value: function fadeIn(speed, easing, cb) {
      if (this._jqObj) this._jqObj.fadeIn(speed, easing, cb);
    }
  }, {
    key: "fadeOut",
    value: function fadeOut(speed, easing, cb) {
      if (this._jqObj) this._jqObj.fadeOut(speed, easing, cb);
    }
  }, {
    key: "fadeTo",
    value: function fadeTo(speed, opacity, easing, cb) {
      if (this._jqObj) this._jqObj.fadeTo(speed, opacity, easing, cb);
    }
  }, {
    key: "fadeToggle",
    value: function fadeToggle(speed, easing, cb) {
      if (this._jqObj) this._jqObj.fadeToggle(speed, easing, cb);
    }
  }, {
    key: "finish",
    value: function finish(queueName) {
      if (this._jqObj) this._jqObj.finish(queueName);
    }
  }, {
    key: "queue",
    value: function queue(queueName) {
      if (this._jqObj) this._jqObj.queue(queueName);
    }
  }, {
    key: "slideDown",
    value: function slideDown(speed, easing, cb) {
      if (this._jqObj) this._jqObj.slideDown(speed, easing, cb);
    }
  }, {
    key: "slideToggle",
    value: function slideToggle(speed, easing, cb) {
      if (this._jqObj) this._jqObj.slideToggle(speed, easing, cb);
    }
  }, {
    key: "slideUp",
    value: function slideUp(speed, easing, cb) {
      if (this._jqObj) this._jqObj.slideUp(speed, easing, cb);
    }
  }, {
    key: "stop",
    value: function stop(stopAll, goToEnd) {
      if (this._jqObj) this._jqObj.stop(stopAll, goToEnd);
    }
  }, {
    key: "bind",
    value: function bind(eventName, cb) {
      if (this._jqObj) this._jqObj.bind(eventName, cb);
    }
  }, {
    key: "unbind",
    value: function unbind(eventName, cb) {
      if (this._jqObj) this._jqObj.unbind(eventName, cb);
    }
  }, {
    key: "click",
    value: function click(cb) {
      if (!this._jqObj) return;

      if (cb) {
        this._jqObj.click(cb);
      } else {
        this._jqObj.click();
      }
    }
  }, {
    key: "dblclick",
    value: function dblclick(cb) {
      if (!this._jqObj) return;

      if (cb) {
        this._jqObj.dblclick(cb);
      } else {
        this._jqObj.dblclick();
      }
    }
  }, {
    key: "blur",
    value: function blur(cb) {
      if (!this._jqObj) return;

      if (cb) {
        this._jqObj.blur(cb);
      } else {
        this._jqObj.blur();
      }
    }
  }, {
    key: "focus",
    value: function focus(cb) {
      if (!this._jqObj) return;

      if (cb) {
        this._jqObj.focus(cb);
      } else {
        this._jqObj.focus();
      }
    }
  }, {
    key: "focusin",
    value: function focusin(cb) {
      if (!this._jqObj) return;

      if (cb) {
        this._jqObj.focusin(cb);
      } else {
        this._jqObj.focusin();
      }
    }
  }, {
    key: "focusout",
    value: function focusout(cb) {
      if (!this._jqObj) return;

      if (cb) {
        this._jqObj.focusout(cb);
      } else {
        this._jqObj.focusout();
      }
    }
  }, {
    key: "hover",
    value: function hover(inFunction, outFunction) {
      if (this._jqObj) this._jqObj.hover(inFunction, outFunction);
    }
  }, {
    key: "keydown",
    value: function keydown(cb) {
      if (!this._jqObj) return;

      if (cb) {
        this._jqObj.keydown(cb);
      } else {
        this._jqObj.keydown();
      }
    }
  }, {
    key: "keypress",
    value: function keypress(cb) {
      if (!this._jqObj) return;

      if (cb) {
        this._jqObj.keypress(cb);
      } else {
        this._jqObj.keypress();
      }
    }
  }, {
    key: "keyup",
    value: function keyup(cb) {
      if (!this._jqObj) return;

      if (cb) {
        this._jqObj.keyup(cb);
      } else {
        this._jqObj.keyup();
      }
    }
  }, {
    key: "mousedown",
    value: function mousedown(cb) {
      if (this._jqObj) this._jqObj.mousedown(cb);
    }
  }, {
    key: "mouseenter",
    value: function mouseenter(cb) {
      if (this._jqObj) this._jqObj.mouseenter(cb);
    }
  }, {
    key: "mouseleave",
    value: function mouseleave(cb) {
      if (this._jqObj) this._jqObj.mouseleave(cb);
    }
  }, {
    key: "mousemove",
    value: function mousemove(cb) {
      if (this._jqObj) this._jqObj.mousemove(cb);
    }
  }, {
    key: "mouseout",
    value: function mouseout(cb) {
      if (this._jqObj) this._jqObj.mouseout(cb);
    }
  }, {
    key: "mouseover",
    value: function mouseover(cb) {
      if (this._jqObj) this._jqObj.mouseover(cb);
    }
  }, {
    key: "mouseup",
    value: function mouseup(cb) {
      if (this._jqObj) this._jqObj.mouseup(cb);
    }
  }, {
    key: "resize",
    value: function resize(cb) {
      if (this._jqObj) this._jqObj.resize(cb);
    }
  }, {
    key: "scroll",
    value: function scroll(cb) {
      if (!this._jqObj) return;

      if (cb) {
        this._jqObj.scroll(cb);
      } else {
        this._jqObj.scroll();
      }
    }
  }, {
    key: "select",
    value: function select() {
      if (this._jqObj) this._jqObj.select();
    }
  }, {
    key: "trigger",
    value: function trigger(eventName) {
      if (this._jqObj) this._jqObj.trigger(eventName);
    }
  }, {
    key: "triggerHandler",
    value: function triggerHandler(eventName) {
      if (this._jqObj) this._jqObj.triggerHandler(eventName);
    }
  }, {
    key: "width",
    value: function width() {
      if (this._jqObj) this._jqObj.width();
    }
  }, {
    key: "height",
    value: function height() {
      if (this._jqObj) this._jqObj.height();
    }
  }, {
    key: "html",
    value: function html(_html) {
      if (this._jqObj) {
        if (arguments.length == 0) {
          return this._jqObj.html();
        } else {
          this._jqObj.html(_html);
        }
      }
    }
  }, {
    key: "text",
    value: function text(txt) {
      if (this._jqObj) {
        if (arguments.length == 0) {
          return this._jqObj.text();
        } else {
          this._jqObj.text(txt);
        }
      }
    }
  }, {
    key: "innerHeight",
    value: function innerHeight() {
      if (this._jqObj) this._jqObj.innerHeight();
    }
  }, {
    key: "innerWidth",
    value: function innerWidth() {
      if (this._jqObj) this._jqObj.innerWidth();
    }
  }, {
    key: "offset",
    value: function offset() {
      if (this._jqObj) this._jqObj.offset();
    }
  }, {
    key: "outerHeight",
    value: function outerHeight() {
      if (this._jqObj) this._jqObj.outerHeight();
    }
  }, {
    key: "outerWidth",
    value: function outerWidth() {
      if (this._jqObj) this._jqObj.outerWidth();
    }
  }, {
    key: "position",
    value: function position() {
      if (this._jqObj) this._jqObj.position();
    }
  }, {
    key: "scrollLeft",
    value: function scrollLeft() {
      if (this._jqObj) this._jqObj.scrollLeft();
    }
  }, {
    key: "scrollTop",
    value: function scrollTop() {
      if (this._jqObj) this._jqObj.scrollTop();
    }
  }, {
    key: "getHtmlIndent",
    value: function getHtmlIndent() {
      if (this.indent) return this.indent;
      var indent = "";

      for (var i = 0; i < this.level; i++) {
        indent += "\t";
      }

      return indent;
    }
  }, {
    key: "render",
    value: function render(target, direction) {
      if ((!this.parent || !this.parent.containerEl && !this.parent.getContainerEl) && this.type != "Page") return;
      var Render = this._tfp.renders[this.type];
      var render = new Render(this._tfp, this.dataModel, this.level);

      if (this.type == "Page") {
        if (this.dataModel.pageType == "print-report") {
          this._jqObj = $(".print-page-bg-panel");
        } else if (this.dataModel.pageElId && this._tfp.isRuntime) {
          this._jqObj = $("#" + this.dataModel.pageElId);
        } else {
          this._jqObj = $("body");
        }

        this._jqObj.append(render.getHtml());

        this._tfp.curPage = this;
      } else {
        var containerEl = null; //getContainerEl方法是为了支持父组件不止一个容器元素的情况，例如布局组件，需要通过子组件id提供不同的容器元素

        if (this.parent.getContainerEl) {
          containerEl = this.parent.getContainerEl(this.id, this.dataModel);
        } else {
          containerEl = this.parent.containerEl;
        }

        if (!containerEl) return;

        if (!target) {
          if (direction == "before" || direction == "prepend" || direction == "left" || direction == "top") {
            $(containerEl).prepend(render.getHtml());
            this.parent.dataModel.components.pop();
            this.parent.dataModel.components.unshift(this.dataModel);
          } else if (direction == "after" || direction == "append" || direction == "right" || direction == "bottom") {
            $(containerEl).append(render.getHtml());
          } else {
            $(containerEl).append(render.getHtml());
          }
        } else {
          this.parent.dataModel.components.pop();
          var targetCptIndex = 0;

          for (var _i2 = 0; _i2 < this.parent.dataModel.components.length; _i2++) {
            var cdmChild = this.parent.dataModel.components[_i2];

            if (cdmChild.id == target.id) {
              targetCptIndex = _i2;
              break;
            }
          }

          if (direction == "before" || direction == "prepend" || direction == "left" || direction == "top") {
            $("#" + target.id).before(render.getHtml()); // this.parent.dataModel.components.splice(targetCptIndex, 0, this.dataModel);
          } else if (direction == "after" || direction == "append" || direction == "right" || direction == "bottom") {
            $("#" + target.id).after(render.getHtml());
            this.parent.dataModel.components.splice(targetCptIndex + 1, 0, this.dataModel);
          } else {
            $(containerEl).append(render.getHtml());
            this.parent.dataModel.components.push(this.dataModel);
          }
        }

        this._jqObj = $("#" + this.id);
      }

      if (this._jqObj.length > 0) this.el = this._jqObj.get(0);

      if (!this.isRendered && this._tfp.isDesigning) {
        this._tfp.initCptDesignSetting(this);
      }

      if (typeof window != "undefined" && !this._tfp.isDesigning) {
        window[this.id] = this;
      }

      if (this.dataModel.components) {
        for (var i = 0; i < this.dataModel.components.length; i++) {
          var _cdmChild = this.dataModel.components[i];

          var cptChild = this._tfp.render(_cdmChild, this);
        }
      }

      if (this._tfp.isDesigning) {
        if (this["initDesigning"]) this.initDesigning();
      } else if (this._tfp.isRuntime) {
        //如果页面已经渲染完，然后动态创建新的组件，则需要初始化组件运行时
        if (this._tfp.curPage && this._tfp.curPage.isRendered && this["initRuntime"]) this.initRuntime();
      }

      this.isRendered = true;
    }
  }, {
    key: "renderByTarget",
    value: function renderByTarget(target, targetParent, direction) {
      this.setParentOnly(targetParent);
      var index = 0;

      if (!target) {
        if (direction == "before" || direction == "prepend" || direction == "left" || direction == "top") {
          index = 0;
        } else if (direction == "after" || direction == "append" || direction == "rignt" || direction == "bottom") {
          index = targetParent.dataModel.components.length - 1;

          if (index < 0) {
            index = 0;
            direction = "prepend";
          } else {
            target = targetParent.dataModel.components[index];
            index = index + 1;
          }
        }
      } else {
        for (var j = 0; j < targetParent.dataModel.components.length; j++) {
          if (targetParent.dataModel.components[j].id == target.id) {
            if (direction == "before" || direction == "prepend" || direction == "left" || direction == "top") {
              index = j;
            } else if (direction == "after" || direction == "append" || direction == "rignt" || direction == "bottom") {
              index = j + 1;
            } else {
              index = j + 1;
            }

            break;
          }
        }
      }

      targetParent.dataModel.components.splice(index, 0, this.dataModel);
      this.render(target, direction);
    }
  }, {
    key: "remove",
    value: function remove() {
      this._tfp.remove(this, true);
    }
  }, {
    key: "clear",
    value: function clear() {
      if (this.dataModel.components) {
        for (var i = 0; i < this.dataModel.components.length; i++) {
          var childCdm = this.dataModel.components[i];

          var child = this._tfp.get(childCdm.id);

          child.clear();
          if (child._jqObj) child._jqObj.remove();
          delete this._tfp.components[child.id];
        } //this.dataModel.components = [];

      }
    }
  }, {
    key: "print",
    value: function print() {
      this._tfp.print(this.el);
    }
  }, {
    key: "setAttr",
    value: function setAttr(attr, value) {
      if (attr.cellType == "col") {
        this.parent.parent.parent[attr.name] = value;
      } else if (attr.cellType == "label") {
        this.parent.parent.components[0].components[0][attr.name] = value;
      } else {
        this[attr.name] = value;
      }
    }
  }, {
    key: "getAttr",
    value: function getAttr(attr) {
      if (attr.cellType == "col") {
        return this.parent.parent.parent[attr.name];
      } else if (attr.cellType == "label") {
        return this.parent.parent.components[0].components[0][attr.name];
      } else {
        return this[attr.name];
      }
    }
    /**
     * 为可视组件定义的统一的数据加载方法
     * @returns 
     */

  }, {
    key: "loadData",
    value: function loadData(args) {
      //如果没有设置数据查询有关的参数，则不执行数据加载操作
      if (!this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      && !this.dataModel.loadDataService && !this.dataModel.dataQuerySetting) {
        //this._tfp.showMsg("请为[" + this.id + "]设置数据查询有关参数！");
        return;
      } //获得数据绑定成员对象名


      var dataBindingMember = this.dataModel.dataBindingMember; //某些老版本的组件使用的该属性，需要兼容

      if (this.dataModel.dataListBindingMember) {
        dataBindingMember = this.dataModel.dataListBindingMember;
      } else if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
        dataBindingMember = this.dataModel.dataQuerySetting.dataMember;
      }

      if (!dataBindingMember) {
        this._tfp.showMsg("请为[" + this.id + "]设置数据绑定成员！");

        return;
      } //如果设置了检查数据加载必须参数的方法，则执行该方法进行检查


      if (this.checkLoadDataArg) {
        var ret = this.checkLoadDataArg();
        if (!ret) return;
      }

      this.exeEventHandler("onBeforeLoadData");
      var that = this; //如果设置了加载数据的后台服务组件，则通过该组件加载数据

      var loadDataService = this.dataModel.loadDataService; //兼容老版本组件

      if (this.dataModel.loadDataListService) {
        loadDataService = this.dataModel.loadDataListService;
      } else if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.serviceCpt) {
        loadDataService = this.dataModel.dataQuerySetting.serviceCpt;
      }

      if (loadDataService) {
        var serviceCpt = this._tfp.get(loadDataService);

        if (!serviceCpt) {
          this._tfp.showMsg("ID为[" + loadDataService + "]的后台服务组件不存在！");

          return;
        } //与后台服务组件建立绑定


        if (!serviceCpt.bindCpts) serviceCpt.bindCpts = [];
        if (!serviceCpt.bindCpts.contains(this.id)) serviceCpt.bindCpts.push(this.id);
        serviceCpt.status = 0;
        serviceCpt.request(args, function (req, res) {
          that.isLoadedData = true;
          that.exeEventHandler("onAfterLoadData", req, res); //如果定义了数据加载后需要执行的方法，则执行该方法

          if (that.onLoadData) {
            that.onLoadData(req, res);
          } else {
            //否则直接执行数据绑定的方法
            var data = res[dataBindingMember];
            that.bindData(data);
          }
        });
        return;
      } //如果设置了加载数据的后台服务路径，则动态创建服务组件请求该地址进行数据加载


      if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.servicePath) {
        var options = {
          cptId: this.id,
          servicePath: this.dataModel.dataQuerySetting.servicePath,
          autoReload: false,
          autoShowError: true,
          showLoading: true,
          encryptRequestArgs: this.dataModel.dataQuerySetting.encryptRequestArgs,
          encryptResponseArgs: this.dataModel.dataQuerySetting.encryptResponseArgs,
          args: args
        };

        if (this.dataModel.dataQuerySetting.disableAutoLoad) {
          options.disableAutoLoad = true; //第一次加载后就要把这个开关改过来，不然后面再手动加载也无法加载

          this.dataModel.dataQuerySetting.disableAutoLoad = false;
        } //如果设置了查询的请求参数，则绑定到服务对象上


        if (this.dataModel.dataQuerySetting.requestArgs && this.dataModel.dataQuerySetting.requestArgs.length > 0) {
          options.argSettings = this.dataModel.dataQuerySetting.requestArgs;
        } //发起动态请求


        this._tfp.request(options, function (req, res, service) {
          that.isLoadedData = true;
          that.exeEventHandler("onAfterLoadData", req, res); //如果定义了数据加载后需要执行的方法，则执行该方法

          if (that.onLoadData) {
            that.onLoadData(req, res);
          } else {
            //否则直接执行数据绑定的方法
            var data = res[dataBindingMember];
            that.bindData(data);
          }
        });

        return;
      }
    }
  }]);
  return VisibleComponent;
}(Component); //容器组件


exports.VisibleComponent = VisibleComponent;

var ContainerComponent = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(ContainerComponent, _VisibleComponent);

  var _super3 = _createSuper(ContainerComponent);

  function ContainerComponent(__tfp, typeName, dataModel, parent) {
    var _this2;

    (0, _classCallCheck2["default"])(this, ContainerComponent);
    _this2 = _super3.call(this, __tfp, typeName, dataModel, parent);
    if (!_this2.dataModel.components) _this2.dataModel.components = [];
    return _this2;
  }

  (0, _createClass2["default"])(ContainerComponent, [{
    key: "isContainer",
    get: function get() {
      return true;
    },
    set: function set(value) {}
  }, {
    key: "containerEl",
    get: function get() {
      return this.el;
    },
    set: function set(value) {
      this.el = value;
    }
  }, {
    key: "components",
    get: function get() {
      return this.dataModel.components;
    },
    set: function set(value) {}
    /**
     * 添加子组件
     * @param {[type]} cptChild [description]
     */

  }, {
    key: "addChild",
    value: function addChild(cptChild) {
      cptChild.parent = this;
    }
    /**
     * 移除子组件
     * @param  {[type]} cptId [description]
     * @return {[type]}       [description]
     */

  }, {
    key: "removeChild",
    value: function removeChild(cptId) {
      for (var i = 0; i < this.dataModel.components.length; i++) {
        var childCdm = this.dataModel.components[i];

        if (childCdm.id == cptId) {
          var child = this._tfp.components[childCdm.id];
          child.clear();
          if (child._jqObj) child._jqObj.remove();

          if (this._tfp.isRuntime) {
            delete this._tfp.components[child.id];
            delete window[child.id];
          }

          child = null;
          childCdm = null;
          return;
        }
      }
    }
    /**
     * 清空子组件
     * @return {[type]} [description]
     */

  }, {
    key: "clearChildren",
    value: function clearChildren() {
      for (var i = 0; i < this.dataModel.components.length; i++) {
        var childCdm = this.dataModel.components[i];
        var child = this._tfp.components[childCdm.id];
        child.clear();
        if (child._jqObj) child._jqObj.remove();
        delete this._tfp.components[child.id];
        if (this._tfp.isRuntime) delete window[child.id];
        child = null;
        childCdm = null;
      }

      this.dataModel.components = [];
    }
  }]);
  return ContainerComponent;
}(VisibleComponent); //表单输入项组件


exports.ContainerComponent = ContainerComponent;

var FormInput = /*#__PURE__*/function (_VisibleComponent2) {
  (0, _inherits2["default"])(FormInput, _VisibleComponent2);

  var _super4 = _createSuper(FormInput);

  function FormInput(__tfp, typeName, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, FormInput);
    return _super4.call(this, __tfp, typeName, dataModel, parent);
  }

  (0, _createClass2["default"])(FormInput, [{
    key: "isFormInput",
    get: function get() {
      return true;
    } //组件备注

  }, {
    key: "comment",
    get: function get() {
      return this.dataModel.comment;
    },
    set: function set(value) {
      this.dataModel.comment = value;
    } //数据绑定格式

  }, {
    key: "dataBindingFormat",
    get: function get() {
      return this.dataModel.dataBindingFormat;
    },
    set: function set(value) {
      this.dataModel.dataBindingFormat = value;
    } //是否必填

  }, {
    key: "required",
    get: function get() {
      return this.dataModel.required ? true : false;
    },
    set: function set(value) {
      this.dataModel.required = value ? true : false;
    } //是否只读

  }, {
    key: "readonly",
    get: function get() {
      return this.dataModel.readonly ? true : false;
    },
    set: function set(value) {
      this.dataModel.readonly = value ? true : false;
      if (!this.dataModel.readonly) delete this.dataModel.readonly;

      if (this._jqObj && this._jqObj.length > 0 && !this._tfp.isDesigning) {
        var el = this._jqObj.get(0);

        if (el.tagName == "INPUT" || el.tagName == "TEXTAREA") {
          el.readOnly = this.dataModel.readonly;
        } else if (el.tagName == "SELECT") {
          el.disabled = this.dataModel.disabled;
        } else if (el.tagName == "DIV") {
          var that = this;

          this._jqObj.find("input").each(function () {
            $(this).get(0).readOnly = that.dataModel.readonly;
          });
        }
      }
    } //是否加密发送

  }, {
    key: "encrypted",
    get: function get() {
      return this.dataModel.encrypted ? true : false;
    },
    set: function set(value) {
      this.dataModel.encrypted = value ? true : false;
    } //是否禁用

  }, {
    key: "disabled",
    get: function get() {
      return this.dataModel.disabled ? true : false;
    },
    set: function set(value) {
      this.dataModel.disabled = value ? true : false;

      if (this._jqObj && this._jqObj.length > 0 && !this._tfp.isDesigning) {
        var el = this._jqObj.get(0);

        if (el.tagName == "INPUT" || el.tagName == "SELECT" || el.tagName == "TEXTAREA") {
          el.disabled = this.dataModel.disabled;
        } else if (el.tagName == "DIV") {
          var that = this;

          this._jqObj.find("input").each(function () {
            $(this).get(0).disabled = that.dataModel.disabled;
          });
        }
      }

      if (!this.dataModel.disabled) delete this.dataModel.disabled;
    } //自动计算表达式

  }, {
    key: "formula",
    get: function get() {
      return this.dataModel.formula;
    },
    set: function set(value) {
      if (isNull(value)) {
        delete this.dataModel["formula"];
        return;
      }

      this.dataModel.formula = value;
    }
    /**
     * 当值发生变化时
     * @return {[type]} [description]
     */

  }, {
    key: "valueOnChange",
    value: function valueOnChange() {
      this._tfp.iptValueOnChange(this);
    }
    /**
     * 执行计算表达式
     * @return {[type]} [description]
     */

  }, {
    key: "exeFormula",
    value: function exeFormula() {
      if (!this.dataModel.formula) return;
      var val = this.dataModel.formula;
      var ipts = this.dataModel.formula.match(/\$\{[\w]+\}/g);

      for (var i = 0; i < ipts.length; i++) {
        var iptId = ipts[i].substr(2, ipts[i].length - 3);
        var ipt = this._tfp.components[iptId];
        if (!ipt) continue;
        var iptVal = ipt.value;

        if (ipt.type == "Text" && isNull(iptVal)) {
          //如果是单行输入框，且数据类型不是文本，则值为空时，将值设置为0，以便计算
          //不判断类型了，用户经常不设置类型
          //if(ipt.dataType=="int" || ipt.dataType=="float" || ipt.dataType=="money") {
          iptVal = "0"; //}
        } else if (ipt.type == "DataSet") {
          iptVal = ipt.id;
        }

        val = val.replace(new RegExp("\\$\\{" + iptId + "\\}"), iptVal);
      }

      try {
        this.value = eval(val);
      } catch (err) {
        console.error("执行计算表达式出错：" + err.message);
      }
    }
    /**
     * 设置输入项的选项
     * @param {[type]} value [description]
     */

  }, {
    key: "setOptions",
    value: function setOptions(value) {
      if (!value) return;
      var options = [];

      if (typeof value == "string") {
        var arr = value.split(",");

        for (var i = 0; i < arr.length; i++) {
          var str = arr[i];

          if (str.trim() != "") {
            options.push({
              value: str,
              text: str
            });
          }
        }
      } else if (Array.isArray(value)) {
        for (var i = 0; i < value.length; i++) {
          var val = value[i];

          if (Object.prototype.toString.call(val) === '[object Object]') {
            options.push(val);
          } else {
            options.push({
              value: val,
              text: val
            });
          }
        }
      }

      this.dataModel.options = options;
    }
    /**
     * 触发input类型组件的值改变事件
     * @param {*} cb 
     */

  }, {
    key: "change",
    value: function change(cb) {
      if (this._jqObj) this._jqObj.change(cb);
    }
  }]);
  return FormInput;
}(VisibleComponent);

exports.FormInput = FormInput;