"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 折叠面板组件
 * @param {[type]} dataModel [description]
 */
var Collapse = /*#__PURE__*/function (_ContainerComponent) {
  (0, _inherits2["default"])(Collapse, _ContainerComponent);

  var _super = _createSuper(Collapse);

  function Collapse(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, Collapse);
    _this = _super.call(this, __tfp, "Collapse", dataModel, parent);

    if (!_this.dataModel.components || _this.dataModel.components.length == 0) {
      _this.dataModel.components = [{
        id: _this.id + "_item1",
        title: "collapse1",
        type: "CollapseItem",
        isAttached: true,
        styles: {
          height: "150px"
        }
      }, {
        id: _this.id + "_item2",
        title: "collapse2",
        type: "CollapseItem",
        isAttached: true,
        styles: {
          height: "150px"
        }
      }];
    }

    return _this;
  } // 选项


  (0, _createClass2["default"])(Collapse, [{
    key: "options",
    get: function get() {
      var options = [];

      for (var i = 0; i < this.dataModel.components.length; i++) {
        var collapseItemlDM = this.dataModel.components[i];
        options.push({
          id: collapseItemlDM.id,
          type: "CollapseItem",
          title: collapseItemlDM.title
        });
      }

      return options;
    },
    set: function set(value) {
      var items = [];
      if (value) items = value;
      var collapseItemls = [];

      for (var i = 0; i < items.length; i++) {
        var item = items[i];
        var cdm = null;

        if (item.id) {
          var collapseIteml = this._tfp.components[item.id];
          cdm = collapseIteml.dataModel;
          cdm.title = item.title;
          delete this._tfp.components[collapseIteml.id];
        } else {
          cdm = {
            type: "CollapseItem",
            isAttached: true,
            title: item.title,
            styles: {
              height: "150px"
            }
          };
        }

        collapseItemls.push(cdm);
      }

      this.dataModel.components = collapseItemls;

      this._jqObj.remove();

      this.render();
    } //手风琴模式

  }, {
    key: "organMode",
    get: function get() {
      return this.dataModel.organMode;
    },
    set: function set(value) {
      this.dataModel.organMode = value ? true : false;
    }
  }, {
    key: "containerEl",
    get: function get() {
      return this._jqObj.get(0);
    }
  }, {
    key: "hasAttachedChilds",
    get: function get() {
      return true;
    }
    /**
     * 展开元素
     * @param {} index 
     */

  }, {
    key: "unfoldItem",
    value: function unfoldItem(index) {
      var item = this._jqObj.children(".tfp-collapseitem").eq(index);

      var title = item.children(".tfp-collapseitem-title");
      var n = title.data('n');
      if (n % 2 == 1) return;
      item.removeClass("tfp-collapseitem-hide");
      title.children("#tfp-collapseitem-arrow").attr('class', 'tfp-collapseitem-arrow-down');
      title.data({
        n: n + 1
      });

      if (this.dataModel.organMode) {
        item.siblings(".tfp-collapseitem").addClass("tfp-collapseitem-hide");
        item.siblings(".tfp-collapseitem").children(".tfp-collapseitem-title").children("#tfp-collapseitem-arrow").attr('class', 'tfp-collapseitem-arrow-right');
        item.siblings(".tfp-collapseitem").children(".tfp-collapseitem-title").data({
          n: 0
        });
      }
    }
    /**
     * 展开所有元素
     */

  }, {
    key: "unfoldAll",
    value: function unfoldAll() {
      if (this.dataModel.organMode) return;

      for (var i = 0; i < this._jqObj.children(".tfp-collapseitem").length; i++) {
        this.unfoldItem(i);
      }
    }
    /**
     * 折叠元素
     * @param {} index 
     */

  }, {
    key: "foldItem",
    value: function foldItem(index) {
      var item = this._jqObj.children(".tfp-collapseitem").eq(index);

      var title = item.children(".tfp-collapseitem-title");
      var n = title.data('n');
      if (n % 2 == 0) return;
      item.addClass("tfp-collapseitem-hide");
      title.children("#tfp-collapseitem-arrow").attr('class', 'tfp-collapseitem-arrow-right');
      title.data({
        n: n + 1
      });
      if (this.dataModel.organMode) item.siblings(".tfp-collapseitem").children(".tfp-collapseitem-title").data({
        n: 0
      });
    }
    /**
     * 折叠所有元素
     */

  }, {
    key: "foldAll",
    value: function foldAll() {
      if (this.dataModel.organMode) return;

      for (var i = 0; i < this._jqObj.children(".tfp-collapseitem").length; i++) {
        this.foldItem(i);
      }
    }
  }, {
    key: "collapseOnChange",
    value: function collapseOnChange() {
      var that = this;

      this._jqObj.find(".tfp-collapseitem").addClass("tfp-collapseitem-hide");

      this._jqObj.find('.tfp-collapseitem-title').data({
        n: 0
      });

      this._jqObj.find('.tfp-collapseitem-title').click(function () {
        var n = $(this).data('n');

        if (n % 2 == 1) {
          $(this).parent().addClass("tfp-collapseitem-hide");
          $(this).children("#tfp-collapseitem-arrow").attr('class', 'tfp-collapseitem-arrow-right');
        } else {
          $(this).parent().removeClass("tfp-collapseitem-hide");
          $(this).children("#tfp-collapseitem-arrow").attr('class', 'tfp-collapseitem-arrow-down');

          if (that.dataModel.organMode) {
            $(this).parent().siblings(".tfp-collapseitem").addClass("tfp-collapseitem-hide");
            $(this).parent().siblings(".tfp-collapseitem").children(".tfp-collapseitem-title").children("#tfp-collapseitem-arrow").attr('class', 'tfp-collapseitem-arrow-right');
          }
        }

        $(this).data({
          n: n + 1
        });
        if (that.dataModel.organMode) $(this).parent().siblings(".tfp-collapseitem").children(".tfp-collapseitem-title").data({
          n: 0
        });
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      this.collapseOnChange();
    }
  }]);
  return Collapse;
}(_controller.ContainerComponent);

exports["default"] = Collapse;