"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/*
class CKEditorUploadAdapter {
  constructor(loader, cptModel) {
    // CKEditor 5's FileLoader instance.
    this.loader = loader;
    this.cptModel = cptModel;

    // URL where to send files.
    this.url = '/Upload?appCode=CKEditor';

    this.loader.file.then((file) => {
      if (file.type.indexOf("image/") == 0) {
        if (cptModel.compressImage) this.url += "&compressImage=true";
        if (cptModel.imageMaxSize) this.url += "&maxSize=" + cptModel.imageMaxSize;
      }
    });
  }

  // Starts the upload process.
  upload() {
    return new Promise((resolve, reject) => {
      this._initRequest();
      this._initListeners(resolve, reject);
      this._sendRequest();
    });
  }

  // Aborts the upload process.
  abort() {
    if (this.xhr) {
      this.xhr.abort();
    }
  }

  // Example implementation using XMLHttpRequest.
  _initRequest() {
    const xhr = this.xhr = new XMLHttpRequest();

    let uploadUrl = this.url;
    try {
      if (top.taskMsgAuthObj) uploadUrl = tfp.setUrlAuthData(uploadUrl);
    } catch (err) {
      try {
        if (window.parent.taskMsgAuthObj) uploadUrl = tfp.setUrlAuthData(uploadUrl);
      } catch (err2) {
        //
      }
    }
    this.url = uploadUrl;

    xhr.open('POST', this.url, true);
    xhr.responseType = 'json';
  }

  // Initializes XMLHttpRequest listeners.
  _initListeners(resolve, reject) {
    const xhr = this.xhr;
    const loader = this.loader;
    const genericErrorText = '文件上传失败：' + ` ${loader.file.name}。`;

    xhr.addEventListener('error', () => reject(genericErrorText));
    xhr.addEventListener('abort', () => reject());
    xhr.addEventListener('load', () => {
      const response = xhr.response;

      if (!response || response.error) {
        return reject(response && response.error ? response.error.message : genericErrorText);
      }

      // If the upload is successful, resolve the upload promise with an object containing
      // at least the "default" URL, pointing to the image on the server.
      resolve({
        default: response.url
      });
    });

    if (xhr.upload) {
      xhr.upload.addEventListener('progress', evt => {
        if (evt.lengthComputable) {
          loader.uploadTotal = evt.total;
          loader.uploaded = evt.loaded;
        }
      });
    }
  }

  // Prepares the data and sends the request.
  _sendRequest() {
    const data = new FormData();
    this.loader.file.then((file) => {
      data.append('file', file);
      this.xhr.send(data);
    });
  }
}*/

/**
 * 富文本组件
 * @param {[type]} dataModel [description]
 */
var CKEditor = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(CKEditor, _FormInput);

  var _super = _createSuper(CKEditor);

  function CKEditor(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, CKEditor);
    return _super.call(this, __tfp, "CKEditor", dataModel, parent);
  } //属性


  (0, _createClass2["default"])(CKEditor, [{
    key: "value",
    get: function get() {
      if (!this._tfp.isDesigning && this.editor) this.dataModel.value = this.editor.getData();
      if (!this.dataModel.value) return "";
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj && !this._tfp.isDesigning && this.editor) {
        this.editor.setData(value);
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "dataBindingFormat",
    get: function get() {
      return this.dataModel.dataBindingFormat;
    },
    set: function set(value) {
      this.dataModel.dataBindingFormat = value;
    }
  }, {
    key: "showMode",
    get: function get() {
      return this.dataModel.showMode ? this.dataModel.showMode : "default";
    },
    set: function set(value) {
      this.dataModel.showMode = value == "compact" ? "compact" : "default";

      if (this._jqObj && this._tfp.isDesigning) {
        this._jqObj.empty();

        this._jqObj.html(this.getDesigningHtml());
      }
    } //是否只读

  }, {
    key: "readonly",
    get: function get() {
      return this.dataModel.readonly ? true : false;
    },
    set: function set(value) {
      this.dataModel.readonly = value ? true : false;
      if (!this.dataModel.readonly) delete this.dataModel.readonly;

      if (this._jqObj && this._tfp.isDesigning) {
        this._jqObj.empty();

        this._jqObj.html(this.getDesigningHtml());
      }
    } //是否压缩图片

  }, {
    key: "compressImage",
    get: function get() {
      return this.dataModel.compressImage ? true : false;
    },
    set: function set(value) {
      this.dataModel.compressImage = value ? true : false;
    }
  }, {
    key: "imageMaxSize",
    get: function get() {
      return this.dataModel.imageMaxSize;
    },
    set: function set(value) {
      this.dataModel.imageMaxSize = value;
    }
    /*getUploadAdapterPlugin(editor) {
      editor.plugins.get('FileRepository').createUploadAdapter = (loader) => {
        let cptId = editor.sourceElement.id;
        cptId = cptId.substring(0, cptId.lastIndexOf("_editor"));
        let cptModel = tfp.components[cptId].dataModel;
        return new CKEditorUploadAdapter(loader, cptModel);
      };
    }*/

  }, {
    key: "getDesigningHtml",
    value: function getDesigningHtml() {
      var showMode = this.showMode;

      if (this._tfp.curPage.bgColorMode == 'dark') {
        showMode == "compact" ? showMode = "compact-dark" : showMode = "default-dark";
      }

      if (this.dataModel.readonly) return "";
      var bgImg = this._tfp.rootPath + "/src/components/" + this.dataModel.type.toLowerCase() + "/images/" + showMode + ".png";
      var toolbarHeight = 76;
      if (this.dataModel.showMode == "compact") toolbarHeight = 38;
      var html = "<div style=\"width:100%;height:" + toolbarHeight + "px;background-repeat:no-repeat;background-image:url(" + bgImg + ");position:absolute;z-index:1;top:0;border-bottom:1px solid #cccccc;\"></div>";
      html += "<div style=\"position:absolute;z-index:1;width:100%;top:" + toolbarHeight + "px;bottom:0;\"></div>";
      return html;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this; //如果是只读或者禁用

      if (this.dataModel.readonly || that.dataModel.disabled) {
        CKEditorCreater.createReadonly(this._jqObj.children("div").get(0), function (editor) {
          that.editor = editor;
          if (that.dataModel.value) editor.setData(that.dataModel.value);
          editor.enableReadOnlyMode('feature-id');

          that._jqObj.find(".ck.ck-editor__editable_inline").css("border", "0");
        });
        /*CKSource.Editor.create(this._jqObj.children("div").get(0), {
          removePlugins: [ 'Title', 'Toolbar'],
          toolbar: {
            items: []
          }
        }).then(editor => {
          that.editor = editor;
              if (that.dataModel.value) editor.setData(that.dataModel.value);
          editor.enableReadOnlyMode('feature-id');
          that._jqObj.find(".ck.ck-editor__editable_inline").css("border", "0");
        }).catch(error => {
          console.log(error);
        });*/

        return;
      }

      var toolbar = [];

      if (this.dataModel.showMode == "compact" || this.dataModel.showMode == "compact-dark") {
        CKEditorCreater.createCompact(this._jqObj.children("div").get(0), function (editor) {
          that.onCreateEditor(editor);
        });
        /*toolbar = ['undo', 'redo', '|', 'alignment',
        '|', 'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor',
        '|', 'bold', 'italic', 'underline', 'strikethrough',
        '|', 'bulletedList', 'numberedList', 'outdent', 'indent']; */
      } else {
        CKEditorCreater.create(this._jqObj.children("div").get(0), function (editor) {
          that.onCreateEditor(editor);
        });
        /*toolbar = ['undo', 'redo', '|', 'heading', '|', 'alignment',
        'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor', '|', 
        'bold', 'italic', 'underline', 'strikethrough', '|','findAndReplace', 'selectAll','removeFormat',   '-',  
        'outdent', 'indent','bulletedList', 'numberedList', 
        '|', 'subscript', 'superscript', 'code', 
        '|', 'specialCharacters', 'horizontalLine', '|', 
        'link', 'imageInsert', 'insertTable', 'highlight', 'blockQuote', 
        'mediaEmbed', 'codeBlock', 'htmlEmbed', 'sourceEditing'];*/
      } //工具栏可配置项

      /*['alignment:left', 'alignment:right', 'alignment:center', 'alignment:justify', 'alignment', 'undo', 'redo', 
      'blockQuote', 'bold', 'code', 'codeBlock', 'selectAll', 'findAndReplace', 'fontBackgroundColor', 'fontColor', 
      'fontFamily', 'fontSize', 'heading', 'highlight:yellowMarker', 'highlight:greenMarker', 'highlight:pinkMarker', 
      'highlight:blueMarker', 'highlight:redPen', 'highlight:greenPen', 'removeHighlight', 'highlight', 'horizontalLine', 
      'htmlEmbed', 'imageTextAlternative', 'toggleImageCaption', 'uploadImage', 'imageUpload', 'insertImage', 'imageInsert', 
      'resizeImage:original', 'resizeImage:25', 'resizeImage:50', 'resizeImage:75', 'resizeImage', 'imageResize', 
      'imageStyle:inline', 'imageStyle:alignLeft', 'imageStyle:alignRight', 'imageStyle:alignCenter', 
      'imageStyle:alignBlockLeft', 'imageStyle:alignBlockRight', 'imageStyle:block', 'imageStyle:side', 
      'imageStyle:wrapText', 'imageStyle:breakText', 'indent', 'outdent', 'italic', 'link', 'linkImage', 
      'numberedList', 'bulletedList', 'mediaEmbed', 'pageBreak', 'removeFormat', 'sourceEditing', 'specialCharacters', 
      'restrictedEditingException', 'strikethrough', 'style', 'subscript', 'superscript', 'insertTable', 'tableColumn', 
      'tableRow', 'mergeTableCells', 'toggleTableCaption', 'tableCellProperties', 'tableProperties', 'textPartLanguage', 
      'todoList', 'underline']*/

      /*CKSource.Editor.create(this._jqObj.children("div").get(0), {
        removePlugins: [ 'Title' ],
        toolbar: {
          items: toolbar,
          shouldNotGroupWhenFull: true
        },
        extraPlugins: [this.getUploadAdapterPlugin]
      }).then(editor => {
        
      }).catch(error => {
        console.log(error);
      });*/

    }
  }, {
    key: "onCreateEditor",
    value: function onCreateEditor(editor) {
      this.editor = editor;
      var that = this;
      if (that.dataModel.value) editor.setData(that.dataModel.value);
      if (that.dataModel.readonly || that.dataModel.disabled) editor.enableReadOnlyMode('feature-id');

      that._jqObj.find(".ck-sticky-panel").show();

      editor.editing.view.change(function (writer) {
        var contentHeight = that._jqObj.height();

        if (that.dataModel.showMode == "default") {
          contentHeight -= 79;
        } else if (that.dataModel.showMode == "compact") {
          contentHeight -= 39;
        }

        writer.setStyle('height', contentHeight + 'px', editor.editing.view.document.getRoot());
      });
      editor.model.document.on('change:data', function () {
        that.valueOnChange();
        that.exeEventHandler("onChange", editor.getData());
      });
      editor.editing.view.document.on('change:isFocused', function (evt, name, value) {
        if (value) {
          eval(that.dataModel.onFocus);
        } else {
          eval(that.dataModel.onBlur);
        }
      });
    }
  }, {
    key: "initDesigning",
    value: function initDesigning() {
      this._jqObj.css("border", "1px solid #cccccc");
    }
  }]);
  return CKEditor;
}(_controller.FormInput);

exports["default"] = CKEditor;