"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 多选框组件
 * @param {[type]} dataModel [description]
 */
var CheckBox = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(CheckBox, _FormInput);

  var _super = _createSuper(CheckBox);

  function CheckBox(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, CheckBox);
    return _super.call(this, __tfp, "CheckBox", dataModel, parent);
  }

  (0, _createClass2["default"])(CheckBox, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this.dataModel.readonly) {
        this._jqObj.empty();

        this._jqObj.append(this.addReadonlyOption());
      } else {
        this.checkOptionByValue();
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "text",
    get: function get() {
      var _this = this;

      if (!this.dataModel.value) return "";
      var vals = (this.dataModel.value + "").split(',');
      var txts = [];

      var _loop = function _loop(i) {
        var val = vals[i];
        if (val == null || val == undefined || val == "") return "continue";

        var option = _this.dataModel.options.find(function (v) {
          return v.value == val;
        });

        if (!option) return "continue";
        txts.push(option.text);
      };

      for (var i = 0; i < vals.length; i++) {
        var _ret = _loop(i);

        if (_ret === "continue") continue;
      }

      if (txts.length == 0) return "";
      return txts.join(",");
    },
    set: function set(txt) {}
  }, {
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(value) {
      if (!value) return;
      this.setOptions(value);

      if (this._jqObj) {
        this._jqObj.empty();

        if (this.dataModel.readonly) {
          this._jqObj.append(this.addReadonlyOption());
        } else {
          if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') this._jqObj.append("\t<div class=\"tfp-checkbox-button\">\r\n");

          for (var i = 0; i < value.length; i++) {
            if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') {
              this.addButtonOption(value[i], i);
            } else {
              this.addOption(value[i], true);
            }
          }
        }
      }
    }
  }, {
    key: "valueField",
    get: function get() {
      return this.dataModel.valueField;
    },
    set: function set(value) {
      this.dataModel.valueField = value;
    }
  }, {
    key: "textField",
    get: function get() {
      return this.dataModel.textField;
    },
    set: function set(value) {
      this.dataModel.textField = value;
    }
  }, {
    key: "showStyle",
    get: function get() {
      return this.dataModel.showStyle;
    },
    set: function set(value) {
      this.dataModel.showStyle = value;

      if (this._jqObj) {
        this._jqObj.empty();

        if (this.dataModel.readonly) {
          this._jqObj.append(this.addReadonlyOption());
        } else {
          if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') this._jqObj.append("\t<div class=\"tfp-checkbox-button\">\r\n");

          for (var i = 0; i < this.dataModel.options.length; i++) {
            if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') {
              this.addButtonOption(this.dataModel.options[i], i);
            } else {
              this.addOption(this.dataModel.options[i], true);
            }
          }
        }
      }
    }
  }, {
    key: "jsonDataSet",
    get: function get() {
      return this.dataModel.jsonDataSet;
    },
    set: function set(value) {
      this.dataModel.jsonDataSet = value;
    }
  }, {
    key: "typeCode",
    get: function get() {
      return this.dataModel.typeCode;
    },
    set: function set(value) {
      this.dataModel.typeCode = value;
    }
  }, {
    key: "portrait",
    get: function get() {
      return this.dataModel.portrait;
    },
    set: function set(value) {
      this.dataModel.portrait = value ? true : false;

      if (this._jqObj) {
        if (value) {
          var that = this;

          this._jqObj.find("label").each(function (index) {
            if (index < that._jqObj.find("label").length - 1) {
              $("<br/>").insertAfter($(this));
            }
          });
        } else {
          this._jqObj.find("br").remove();
        }
      }
    }
  }, {
    key: "checkOptionByValue",
    value: function checkOptionByValue() {
      //不能返回，因为如果值为空，要清除已选择的选项
      //if(!this.dataModel.value) return;
      if (this._jqObj) {
        var arrVal = (this.dataModel.value + "").split(",");

        if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') {
          this._jqObj.find(".tfp-checkbox-button .tfp-checkbox-button-item").each(function () {
            $(this).removeClass('tfp-checkbox-button-false');
            $(this).removeClass('tfp-checkbox-button-true');

            if (arrVal.contains($(this).attr("data-option"))) {
              $(this).addClass('tfp-checkbox-button-true');
            } else {
              $(this).addClass('tfp-checkbox-button-false');
            }
          });
        } else {
          this._jqObj.find(".tfp-checkbox-box").each(function () {
            if (arrVal.contains($(this).attr("data-option"))) {
              $(this).children().css("display", "block");
            } else {
              $(this).children().css("display", "none");
            }
          });
        }
      }
    }
  }, {
    key: "getOption",
    value: function getOption(index) {
      return this.dataModel.options[index];
    }
  }, {
    key: "getOptionByValue",
    value: function getOptionByValue(val) {
      return this.dataModel.options.find(function (v) {
        return v.value == val;
      });
    }
  }, {
    key: "getSelectedOptions",
    value: function getSelectedOptions() {
      var _this2 = this;

      if (!this.dataModel.value) return [];
      var vals = (this.dataModel.value + "").split(',');
      var options = [];

      var _loop2 = function _loop2(i) {
        var val = vals[i];
        if (val == null || val == undefined || val == "") return "continue";

        var option = _this2.dataModel.options.find(function (v) {
          return v.value == val;
        });

        if (!option) return "continue";
        options.push(option);
      };

      for (var i = 0; i < vals.length; i++) {
        var _ret2 = _loop2(i);

        if (_ret2 === "continue") continue;
      }

      return options;
    }
  }, {
    key: "getOptionHtml",
    value: function getOptionHtml(indent, option) {
      var optionHtml = "";
      var optionDisplay = "none";
      if (this.value && (this.value + "").split(",").contains(option.value)) optionDisplay = "block";
      var disabledStyle = "";
      if (this.dataModel.disabled) disabledStyle = " style=\"background-color:#eeeeee;\"";
      optionHtml += indent + "\t<div class=\"tfp-checkbox-box\" " + disabledStyle + " data-option=\"" + option.value + "\">";

      if (this.dataModel.showStyle == 'checkMode') {
        optionHtml += "<span class=\"tfp-checkbox-button-true\" style=\"font-size:10px;height:100%;display:" + optionDisplay + ";\">✔</span>";
      } else {
        optionHtml += "<div style=\"display:" + optionDisplay + ";\"></div>";
      }

      optionHtml += "</div> ";

      if (option.text) {
        optionHtml += "<label class=\"tfp-checkbox-label\">" + option.text + "</label>\r\n";
      } else {
        optionHtml += "<label class=\"tfp-checkbox-label\">" + option.value + "</label>\r\n";
      }

      return optionHtml;
    }
  }, {
    key: "addReadonlyOption",
    value: function addReadonlyOption() {
      var labelHtml = "";
      var text = [];

      for (var i = 0; i < this.dataModel.options.length; i++) {
        var option = this.dataModel.options[i];

        if (this.value && (this.value + "").split(",").contains(option.value + '')) {
          if (option.text) {
            text.push(option.text);
          } else {
            text.push(option.value);
          }
        }
      }

      labelHtml += "<label class=\"tfp-checkbox-label\" style=\"margin-left:0px;\">" + text.join(',') + "</label>\r\n";
      return labelHtml;
    }
  }, {
    key: "addOption",
    value: function addOption(option, isInit) {
      var indent = this.getHtmlIndent();
      var str = "";
      if (this.portrait && this._jqObj.children().length > 0) str += indent + "\t<br>\r\n";
      str += this.getOptionHtml(indent, option);

      if (str != "") {
        if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') {
          this._jqObj.find(".tfp-checkbox-button").append(str);

          this.bindButtonOptionEvent(this._jqObj.find(".tfp-checkbox-button").children(':last-child'));
        } else {
          this._jqObj.append(str);

          this.bindOptionEvent(this._jqObj.find(".tfp-checkbox-box").last().get(0));
          this.bindOptionEvent(this._jqObj.find(".tfp-checkbox-label").last().get(0));
        }

        if (!isInit) {
          this.dataModel.options.push(option);
        }
      }
    }
  }, {
    key: "bindOptionEvent",
    value: function bindOptionEvent(el) {
      var that = this;
      $(el).click(function () {
        if (that.dataModel.disabled || that.dataModel.readonly) return;
        var elHtml = $(this);
        if ($(this).hasClass("tfp-checkbox-label")) elHtml = $(this).prev();

        if (elHtml.children().css("display") == "block") {
          elHtml.children().css("display", "none");
        } else {
          elHtml.children().css("display", "block");
        }

        var val = "";

        that._jqObj.find(".tfp-checkbox-box").each(function () {
          if ($(this).children().css("display") == "block") {
            if (val != "") val += ",";
            val += $(this).attr("data-option");
          }
        });

        that.dataModel.value = val;
        that.valueOnChange();
        that.exeEventHandler("onChange", val);

        that._tfp.runRules(that);
      });
    }
  }, {
    key: "addButtonOption",
    value: function addButtonOption(option, i) {
      var indent = this.getHtmlIndent();
      var str = "";
      str += this.getButtonOptionHtml(indent, option, i);

      if (str != "") {
        this._jqObj.find(".tfp-checkbox-button").append(str);

        this.bindButtonOptionEvent(this._jqObj.find(".tfp-checkbox-button").children(':last-child'));
      }
    }
  }, {
    key: "getButtonOptionHtml",
    value: function getButtonOptionHtml(indent, option, index) {
      var optionHtml = "";
      var optionDisplay = "tfp-checkbox-button-false";
      if (this.value && (this.value + "").split(",").contains(option.value)) optionDisplay = "tfp-checkbox-button-true";
      optionHtml += "<div class=\"tfp-checkbox-button-item " + optionDisplay + "\" data-option=\"" + option.value + "\" style=\"";
      if (this.dataModel.showStyle == "disperseMode") optionHtml += "margin-right: 10px;border-radius: 15px;border:0px;";
      if (this.dataModel.showStyle == "buttonMode" && index == 0) optionHtml += "border-radius: 4px 0 0 4px;";
      if (this.dataModel.showStyle == "buttonMode" && index == this.dataModel.options.length - 1) optionHtml += "border-radius: 0 4px 4px 0;";
      optionHtml += "\">";

      if (option.text) {
        optionHtml += option.text;
      } else {
        optionHtml += option.value;
      }

      optionHtml += "</div>\r\n";
      return optionHtml;
    }
  }, {
    key: "bindButtonOptionEvent",
    value: function bindButtonOptionEvent(el) {
      var that = this;
      $(el).click(function () {
        if (that.dataModel.disabled || that.dataModel.readonly) return;

        if ($(this).hasClass("tfp-checkbox-button-true")) {
          $(this).removeClass("tfp-checkbox-button-true");
          $(this).addClass("tfp-checkbox-button-false");
        } else {
          $(this).removeClass("tfp-checkbox-button-false");
          $(this).addClass("tfp-checkbox-button-true");
        }

        var val = "";

        that._jqObj.find(".tfp-checkbox-button-item").each(function () {
          if ($(this).hasClass("tfp-checkbox-button-true")) {
            if (val != "") val += ",";
            val += $(this).attr("data-option");
          }
        });

        that.dataModel.value = val;
        that.valueOnChange();
        that.exeEventHandler("onChange", val);

        that._tfp.runRules(that);
      });
    }
  }, {
    key: "bindOptionsEvent",
    value: function bindOptionsEvent() {
      var that = this;

      if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') {
        this._jqObj.find(".tfp-checkbox-button-item").each(function () {
          that.bindButtonOptionEvent(this);
        });
      } else {
        this._jqObj.find(".tfp-checkbox-box,.tfp-checkbox-label").each(function () {
          that.bindOptionEvent(this);
        });
      }
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (data.rows && data.rowsCount) {
        data = data.rows;
      }

      if (!Array.isArray(data)) return;
      var options = [];

      for (var i = 0; i < data.length; i++) {
        var row = data[i];
        var option = {
          value: row[this.dataModel.valueField]
        };

        if (this.dataModel.textField) {
          option.text = row[this.dataModel.textField];
        } else {
          option.text = option.value;
        }

        options.push(option);
      }

      this.options = options; //根据组件值选中对应的选项

      this.checkOptionByValue();

      if (this.dataModel.onBindData) {
        try {
          eval(this.dataModel.onBindData);
        } catch (err) {
          console.log(err);
        }
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this; //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载

      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      } else if (this.dataModel.typeCode) {
        this.dataModel.valueField = "code";
        this.dataModel.textField = "name";

        this._tfp.use("Service", function () {
          var service = that._tfp["new"]("Service");

          service.path = "sys/service/data_dic/getList.tbs";
          service.request({
            typeCode: that.dataModel.typeCode
          }, function (req, res) {
            that.bindData(res.data);
          });
        });
      } else if (this.options && this.options.length > 0) {
        this.bindOptionsEvent();
      }
    }
  }]);
  return CheckBox;
}(_controller.FormInput);

exports["default"] = CheckBox;