"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("./controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 图表组件
 * @param {[type]} dataModel [description]
 */
var Chart = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(Chart, _VisibleComponent);

  var _super = _createSuper(Chart);

  function Chart(__tfp, inputType, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Chart);
    return _super.call(this, __tfp, inputType, dataModel, parent);
  }

  (0, _createClass2["default"])(Chart, [{
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    }
  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    }
  }, {
    key: "showLegend",
    get: function get() {
      return this.dataModel.showLegend;
    },
    set: function set(value) {
      this.dataModel.showLegend = value ? true : false;
      if (this._tfp.isDesigning) this.reloadDemoData();
    }
  }, {
    key: "showLabel",
    get: function get() {
      return this.dataModel.showLabel;
    },
    set: function set(value) {
      this.dataModel.showLabel = value ? true : false;
      if (this._tfp.isDesigning) this.reloadDemoData();
    }
  }, {
    key: "showLabelLine",
    get: function get() {
      return this.dataModel.showLabelLine;
    },
    set: function set(value) {
      this.dataModel.showLabelLine = value ? true : false;
      if (this._tfp.isDesigning) this.reloadDemoData();
    }
  }, {
    key: "showLoading",
    get: function get() {
      return this.dataModel.showLoading;
    },
    set: function set(value) {
      this.dataModel.showLoading = value ? true : false;
    }
  }, {
    key: "animation",
    get: function get() {
      return this.dataModel.animation;
    },
    set: function set(value) {
      this.dataModel.animation = value ? true : false;
    }
  }, {
    key: "css",
    value: function css(styleName, styleValue) {
      if (arguments.length == 0) return; //获取样式值

      if (arguments.length == 1) {
        if (!this.dataModel.styles) return null;
        return this.dataModel.styles[styleName];
      }

      (0, _get2["default"])((0, _getPrototypeOf2["default"])(Chart.prototype), "css", this).call(this, styleName, styleValue);

      if ((styleName == "height" || styleName == "width") && styleValue) {
        if (this._tfp.isDesigning) {
          this.reloadDemoData();
        } else {
          this.loadData();
        }
      }
    }
  }, {
    key: "getDemoData",
    value: function getDemoData() {
      var data = {
        seriesData: []
      };

      if (this.type != "ChartPie" && this.type != "ChartAnnular") {
        var dataSet = this.dataModel.series;

        if (!dataSet || dataSet.length == 0) {
          if (this.type == "ChartLine") {
            data.series = [{
              name: "演示数据",
              type: "line"
            }];
          } else if (this.type == "ChartBar") {
            data.series = [{
              name: "演示数据",
              type: "bar"
            }];
          } else if (this.type == "ChartBarY") {
            data.series = [{
              name: "演示数据",
              type: "bar"
            }];
          } else if (this.type == "ChartLineBar") {
            data.series = [{
              name: "演示数据1",
              type: "line"
            }, {
              name: "演示数据2",
              type: "bar"
            }];
          }

          dataSet = data.series;
        }

        data.categoryData = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];

        for (var i = 0; i < dataSet.length; i++) {
          var itemData = [];

          for (var j = 0; j < 7; j++) {
            itemData.push(Math.ceil(Math.random() * 1000));
          }

          data.seriesData.push(itemData);
        }
      } else {
        data.seriesData = [{
          value: 1048,
          name: '统计项目1'
        }, {
          value: 735,
          name: '统计项目2'
        }, {
          value: 580,
          name: '统计项目3'
        }, {
          value: 484,
          name: '统计项目4'
        }, {
          value: 300,
          name: '统计项目5'
        }];
      }

      return data;
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (!this.chart) this.chart = echarts.init(document.getElementById(this.id));
      var option = {
        series: []
      }; //if(this.dataModel.darkMode) option.darkMode = true;

      if (this.type != "ChartPie" && this.type != "ChartAnnular") {
        if (this.dataModel.showLegend) {
          option.legend = {
            data: []
          };
        } else {
          delete option["legend"];
        }

        option.grid = {
          left: "80px",
          right: "20px"
        };

        if (this.type == "ChartBarY") {
          option.yAxis = {
            type: 'category'
          };

          if (this._tfp.isDesigning) {
            option.yAxis.data = data.categoryData;
          } else {
            option.yAxis.data = [];
          }

          option.xAxis = {
            type: 'value'
          };
        } else {
          option.xAxis = {
            type: 'category'
          };

          if (this._tfp.isDesigning) {
            option.xAxis.data = data.data;
          } else {
            option.xAxis.data = [];
          }

          option.yAxis = {
            type: 'value'
          };
        }

        var dataSet = this.dataModel.series;
        if (!dataSet || dataSet.length == 0) dataSet = data.series;

        for (var i = 0; i < dataSet.length; i++) {
          var s = dataSet[i];
          if (this.dataModel.showLegend) option.legend.data.push(s.name);
          var item = {
            name: s.name
          };

          if (this.type == "ChartLine") {
            item.type = "line";
          } else if (this.type == "ChartBar" || this.type == "ChartBarY") {
            item.type = "bar";
          } else {
            item.type = s.type;
          }

          if (this.dataModel.stack) {
            item.stack = "total";
          } else {
            delete item["stack"];
          }

          if (this.dataModel.smooth) {
            item.smooth = true;
          } else {
            item.smooth = false;
          }

          if (this.dataModel.showArea) {
            item.areaStyle = {};
          } else {
            delete item["areaStyle"];
          }

          item.label = {
            show: true
          };
          if (!this.dataModel.showLabel) item.label.show = false;
          item.labelLine = {
            show: true
          };
          if (!this.dataModel.showLabelLine) item.labelLine.show = false;

          if (this._tfp.isDesigning) {
            item.data = data.seriesData[i];
          } else {
            item.data = [];
          }

          option.series.push(item);
        }

        if (!this._tfp.isDesigning && this.dataModel.categoryField) {
          for (var i = 0; i < data.length; i++) {
            var rowData = data[i];

            if (this.type == "ChartBarY") {
              option.yAxis.data.push(rowData[this.dataModel.categoryField]);
            } else {
              option.xAxis.data.push(rowData[this.dataModel.categoryField]);
            }

            for (var j = 0; j < dataSet.length; j++) {
              var s = dataSet[j];
              var item = option.series[j];
              item.data.push(rowData[s.dataField]);
            }
          }
        }
      } else {
        var s = {
          type: "pie",
          data: []
        };

        if (this.type == "ChartPie") {
          if (this.dataModel.radius) {
            s.radius = this.dataModel.radius;
          } else {
            s.radius = "50%";
          }
        } else {
          var outerRadius = this.dataModel.outerRadius;
          if (!outerRadius) outerRadius = "40%";
          var innerRadius = this.dataModel.innerRadius;
          if (!innerRadius) innerRadius = "70%";
          s.radius = [outerRadius, innerRadius];
        }

        if (this._tfp.isDesigning) {
          s.data = data.seriesData;
        } else if (data && data.length > 0 && this.dataModel.nameField && this.dataModel.valueField) {
          for (var i = 0; i < data.length; i++) {
            var _rowData = data[i];
            var itemData = {
              name: _rowData[this.dataModel.nameField],
              value: _rowData[this.dataModel.valueField]
            };
            if (!itemData.name || !itemData.value && itemData.value != 0) continue;
            s.data.push(itemData);
          }
        }

        option.series.push(s);
      }

      if (this.dataModel.showLoading) this.chart.showLoading();
      if (this.dataModel.onBeforeBindData) this.exeEventFunc(this.dataModel.onBeforeBindData, option, data);
      this.chart.setOption(option);
      if (this.dataModel.onAfterBindData) this.exeEventFunc(this.dataModel.onAfterBindData, option, data);
      if (this.dataModel.showLoading) this.chart.hideLoading();
    }
  }, {
    key: "exeEventFunc",
    value: function exeEventFunc(funcStr, option, data) {
      if (!funcStr || this._tfp.isDesigning) return;

      if (funcStr.indexOf(".") < 0 && funcStr.indexOf(" ") < 0 && funcStr.indexOf("=") < 0 && funcStr.indexOf("(") < 0 && funcStr.indexOf(")") < 0) {
        eval(funcStr + "(option, data)");
      } else {
        eval(funcStr);
      }
    }
  }, {
    key: "onLoadData",
    value: function onLoadData(req, res) {
      this.exeEventHandler("onAfterLoadData");

      if (this.dataModel.dataBindingMember) {
        //兼容老版本
        this.bindData(res[this.dataModel.dataBindingMember]);
      } else if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
        this.bindData(res[this.dataModel.dataQuerySetting.dataMember]);
      } else {
        this.bindData(res);
      }
    }
  }, {
    key: "reloadDemoData",
    value: function reloadDemoData() {
      this.chart = null;

      this._jqObj.remove();

      this.render();
    }
  }, {
    key: "render",
    value: function render() {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(Chart.prototype), "render", this).call(this);

      if (this._tfp.isDesigning) {
        var data = this.getDemoData();
        this.bindData(data);
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      }
    }
  }]);
  return Chart;
}(_controller.VisibleComponent);

exports["default"] = Chart;