"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controllerPhone = _interopRequireDefault(require("../cascader/controller.phone.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 地区级联选择
 * @param {[type]} dataModel [description]
 */
var CascaderRegion = /*#__PURE__*/function (_Cascader) {
  (0, _inherits2["default"])(CascaderRegion, _Cascader);

  var _super = _createSuper(CascaderRegion);

  function CascaderRegion(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, CascaderRegion);
    var dm = dataModel;
    if (!dm) dm = {};
    dm.valueField = "code";
    dm.textField = "name";
    dm.idField = "code";
    dm.parentIdField = "parent_code";
    if (!dm.regionType) dm.regionType = 1;
    if (!dm.rootParentId) dm.rootParentId = 0;
    return _super.call(this, __tfp, dm, parent, "CascaderRegion");
  }

  (0, _createClass2["default"])(CascaderRegion, [{
    key: "regionType",
    get: function get() {
      return this.dataModel.regionType;
    },
    set: function set(value) {
      this.dataModel.regionType = value;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(CascaderRegion.prototype), "initRuntime", this).call(this);
      var lsItemName = "_tfp_region_data_" + this.dataModel.regionType + "_" + this.dataModel.rootParentId;
      var data = localStorage.getItem(lsItemName);

      if (data) {
        this.bindData(JSON.parse(data));
        return;
      } //需要设置顶级地区代码


      if (this.dataModel.regionType > 2 && this.dataModel.rootParentId == 0) {
        console.log("请设置顶级地区代码！");
        return;
      }

      var that = this;

      this._tfp.use("Service", function () {
        var service = that._tfp["new"]("Service");

        service.path = "sys/service/data_dic/getRegionList.tbs";
        var args = {
          rootParentCode: 0,
          level: 3
        };
        if (that.dataModel.rootParentId) args.rootParentCode = that.dataModel.rootParentId;

        if (that.dataModel.regionType == 1) {
          args.level = 2;
        } else if (that.dataModel.regionType >= 4) {
          args.level = 4;
        }

        service.request(args, function (req, res) {
          localStorage.setItem(lsItemName, JSON.stringify(res.data));
          that.bindData(res.data);
        });
      });
    }
  }]);
  return CascaderRegion;
}(_controllerPhone["default"]);

exports["default"] = CascaderRegion;