"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 地区选择组件
 * @param {[type]} dataModel [description]
 */
var Cascader = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Cascader, _FormInput);

  var _super = _createSuper(Cascader);

  function Cascader(__tfp, dataModel, parent, inputType) {
    var _this;

    (0, _classCallCheck2["default"])(this, Cascader);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "Cascader", dataModel, parent);
    }

    _this.nodes = {};
    _this.rootNodes = [];
    return (0, _possibleConstructorReturn2["default"])(_this);
  }

  (0, _createClass2["default"])(Cascader, [{
    key: "value",
    get: function get() {
      return this.dataModel.value ? this.dataModel.value : "";
    },
    set: function set(value) {
      if (!isNull(value)) {
        if (isObj(value)) {
          this.dataModel.value = value.value;
        } else {
          this.dataModel.value = value;
        }
      } else {
        this.dataModel.value = "";

        this._jqObj.children("input").val('');
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", this.dataModel.value);
      }

      if (!isNull(value) && this._jqObj) {
        if (isObj(value)) {
          this._jqObj.children("input").attr('data-value', value.value);

          if (value.level) this._jqObj.children("input").attr('data-level', value.level);
          if (value.id) this._jqObj.children("input").attr('nodeid', value.id);
          if (value.text) this._jqObj.children("input").val(value.text);
        } else {
          var val = value + "";
          var txt = "";

          if (this.nodes) {
            if (val.indexOf("/") > 0) {
              var arr = val.split("/");

              for (var i = 0; i < arr.length; i++) {
                var node = this.nodes[arr[i]];

                if (node) {
                  if (txt != "") txt += "/";
                  txt += node.name;
                }
              }
            } else {
              var _node = this.nodes[val];

              if (_node) {
                txt = _node.name;

                while (_node.parentId != 0) {
                  var _node2 = this.nodes[_node2.parentId];
                  if (!_node2) break;
                  txt = _node2.name + "/" + txt;
                }
              }
            }
          }

          this._jqObj.children("input").val(txt);
        }
      }
    }
  }, {
    key: "text",
    get: function get() {
      var ret = "";
      if (this._jqObj) ret = this._jqObj.children("input").val();
      return ret;
    },
    set: function set(value) {}
  }, {
    key: "placeHolder",
    get: function get() {
      return this.dataModel.placeHolder;
    },
    set: function set(value) {
      this.dataModel.placeHolder = value;
      if (this._jqObj) this._jqObj.children("input").attr("placeholder", value);
    }
  }, {
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    }
  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    }
  }, {
    key: "valueField",
    get: function get() {
      return this.dataModel.valueField;
    },
    set: function set(value) {
      this.dataModel.valueField = value;
    }
  }, {
    key: "textField",
    get: function get() {
      return this.dataModel.textField;
    },
    set: function set(value) {
      this.dataModel.textField = value;
    }
  }, {
    key: "idField",
    get: function get() {
      return this.dataModel.idField;
    },
    set: function set(value) {
      this.dataModel.idField = value;
    }
  }, {
    key: "parentIdField",
    get: function get() {
      return this.dataModel.parentIdField;
    },
    set: function set(value) {
      this.dataModel.parentIdField = value;
    }
  }, {
    key: "rootParentId",
    get: function get() {
      return this.dataModel.rootParentId;
    },
    set: function set(value) {
      this.dataModel.rootParentId = value;
    }
    /**
     * 检查数据加载参数是否设置正确
     * @returns 
     */

  }, {
    key: "checkLoadDataArg",
    value: function checkLoadDataArg() {
      if (!this.dataModel.valueField) {
        alert("请为[" + this.id + "]设置选项值字段格式！");
        return false;
      }

      if (!this.dataModel.idField) {
        alert("请为[" + this.id + "]设置节点主键字段格式！");
        return false;
      }

      return true;
    }
  }, {
    key: "loadData",
    value: function loadData() {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(Cascader.prototype), "loadData", this).call(this);
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (isNull(data) || !Array.isArray(data)) return;
      this.nodes = {};
      this.rootNodes = [];
      var nodeIdArr = [];

      for (var i = 0; i < data.length; i++) {
        var nodeData = data[i];
        var node = {};
        node.id = nodeData[this.dataModel.idField];
        node.value = nodeData[this.dataModel.valueField];
        node.name = nodeData[this.dataModel.textField];
        if (!this.dataModel.textField) node.name = nodeData[this.dataModel.valueField];
        node.parentId = nodeData[this.dataModel.parentIdField];
        node.data = nodeData;
        node.childNodes = [];
        this.nodes[node.id] = node;
        nodeIdArr.push(node.id);
      } //生成节点之间的关系


      for (var i = 0; i < nodeIdArr.length; i++) {
        var nodeId = nodeIdArr[i];
        var node = this.nodes[nodeId];

        if (node.parentId == this.dataModel.rootParentId) {
          this.rootNodes.push(nodeId);
        } else {
          var parentNode = this.nodes[node.parentId];

          if (parentNode) {
            parentNode.childNodes.push(nodeId);
          }
        }
      }

      this.value = this.dataModel.value + '';
    }
  }, {
    key: "setOptionsList",
    value: function setOptionsList(optionsList, value) {
      var that = this;
      var optionObj = {
        options: [],
        value: value
      };

      for (var i = 0; i < this.rootNodes.length; i++) {
        var node = this.nodes[this.rootNodes[i]];
        optionObj.options.push({
          value: node.value,
          text: node.name
        });
      }

      optionObj.onChange = function () {
        that.optionsOnChange(0);
      };

      optionsList.push(optionObj);
      this.setOptionsChildren(optionsList, value);
    }
  }, {
    key: "setOptionsChildren",
    value: function setOptionsChildren(optionsList, value) {
      var that = this;
      var node = this.nodes[value];
      if (node.childNodes.length == 0) return;
      var optionObj = {
        options: [],
        value: this.nodes[node.childNodes[0]].value
      };

      for (var i = 0; i < node.childNodes.length; i++) {
        var nodeChild = this.nodes[node.childNodes[i]];
        optionObj.options.push({
          value: nodeChild.value,
          text: nodeChild.name
        });
      }

      optionObj.onChange = function () {
        that.optionsOnChange(1);
      };

      optionsList.push(optionObj);
      this.setOptionsChildren(optionsList, this.nodes[node.childNodes[0]].value);
    }
  }, {
    key: "optionsOnChange",
    value: function optionsOnChange(index) {
      var dataVal = window.popupList.getColumnVal(index);
      var node = this.nodes[dataVal];
      var dayCol = $(".tfp-popuplist-content-column").get(index + 1);
      $(dayCol).find(".tfp-popuplist-content-item").remove();
      $(dayCol).find(".tfp-popuplist-content-items").append("<div class=\"tfp-popuplist-content-item\" data-value=\"\"></div><div class=\"tfp-popuplist-content-item\" data-value=\"\"></div><div class=\"tfp-popuplist-content-item\" data-value=\"\"></div>");

      if (node.childNodes.length == 0) {
        $(dayCol).find(".tfp-popuplist-content-items").append("</div><div class=\"tfp-popuplist-content-item\" data-value=\"\"></div>");
        return;
      }

      ;

      for (var i = 0; i < node.childNodes.length; i++) {
        var nodeChild = this.nodes[node.childNodes[i]];
        $(dayCol).find(".tfp-popuplist-content-items").append("<div class=\"tfp-popuplist-content-item\" data-value=\"" + nodeChild.value + "\">" + nodeChild.name + "</div>");
      }

      $(dayCol).find(".tfp-popuplist-content-items").append("<div class=\"tfp-popuplist-content-item\" data-value=\"\"></div><div class=\"tfp-popuplist-content-item\" data-value=\"\"></div><div class=\"tfp-popuplist-content-item\" data-value=\"\"></div>");
      this.optionsOnChange(index + 1);
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.css("padding", "0px");

      this._jqObj.find("input").css("width", "100%"); //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载


      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      }

      this._jqObj.click(function () {
        if (that.dataModel.readonly || that.dataModel.disabled) return;
        var optionsList = [];
        that.setOptionsList(optionsList, that.rootNodes[0]);
        window.popupList.show(optionsList, function (arr) {
          if (arr.length > 0) {
            var val = "";
            arr.forEach(function (item) {
              if (val != '' && item != '') val += '/';
              if (item != '') val += item;
            });
            that.value = val;
          } else {
            that.value = '';
          }
        });
      });
    }
  }]);
  return Cascader;
}(_controller.FormInput);

exports["default"] = Cascader;