"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 级联选择器组件
 * @param {[type]} dataModel [description]
 */
var Cascader = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Cascader, _FormInput);

  var _super = _createSuper(Cascader);

  function Cascader(__tfp, dataModel, parent, inputType) {
    var _this;

    (0, _classCallCheck2["default"])(this, Cascader);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "Cascader", dataModel, parent);
    }

    _this.nodes = {};
    _this.rootNodes = [];
    _this.isLoad = false;
    return (0, _possibleConstructorReturn2["default"])(_this);
  }

  (0, _createClass2["default"])(Cascader, [{
    key: "value",
    get: function get() {
      return this.dataModel.value ? this.dataModel.value : "";
    },
    set: function set(value) {
      if (!isNull(value)) {
        if (isObj(value)) {
          this.dataModel.value = value.value;
        } else {
          this.dataModel.value = value;
        }
      } else {
        this.dataModel.value = "";
      }

      if (!isNull(value) && this._jqObj) {
        if (isObj(value)) {
          this._jqObj.children("input").attr('data-value', value.value);

          if (value.level) this._jqObj.children("input").attr('data-level', value.level);
          if (value.id) this._jqObj.children("input").attr('nodeid', value.id);
          if (value.text) this._jqObj.children("input").val(value.text);
        } else {
          var val = value + "";
          var txt = "";

          if (this.nodes) {
            if (val.indexOf("/") > 0) {
              var arr = val.split("/");

              for (var i = 0; i < arr.length; i++) {
                var node = this.nodes[arr[i]];

                if (node) {
                  if (txt != "") txt += "/";
                  txt += node.name;
                }
              }
            } else {
              var _node = this.nodes[val];

              if (_node) {
                txt = _node.name;

                while (_node.parentId != 0) {
                  var _node2 = this.nodes[_node2.parentId];
                  if (!_node2) break;
                  txt = _node2.name + "/" + txt;
                }
              }
            }
          }

          this._jqObj.children("input").val(txt);
        }
      }
    }
  }, {
    key: "text",
    get: function get() {
      var ret = "";
      if (this._jqObj) ret = this._jqObj.children("input").val();
      return ret;
    },
    set: function set(value) {
      if (this._jqObj) this._jqObj.children("input").val(value);
    }
  }, {
    key: "placeHolder",
    get: function get() {
      return this.dataModel.placeHolder;
    },
    set: function set(value) {
      this.dataModel.placeHolder = value;
      if (this._jqObj) this._jqObj.children("input").attr("placeholder", value);
    }
  }, {
    key: "popupWidth",
    get: function get() {
      return this.dataModel.popupWidth;
    },
    set: function set(value) {
      this.dataModel.popupWidth = value;
    }
  }, {
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    }
  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    }
  }, {
    key: "valueField",
    get: function get() {
      return this.dataModel.valueField;
    },
    set: function set(value) {
      this.dataModel.valueField = value;
    }
  }, {
    key: "textField",
    get: function get() {
      return this.dataModel.textField;
    },
    set: function set(value) {
      this.dataModel.textField = value;
    }
  }, {
    key: "idField",
    get: function get() {
      return this.dataModel.idField;
    },
    set: function set(value) {
      this.dataModel.idField = value;
    }
  }, {
    key: "parentIdField",
    get: function get() {
      return this.dataModel.parentIdField;
    },
    set: function set(value) {
      this.dataModel.parentIdField = value;
    }
  }, {
    key: "rootParentId",
    get: function get() {
      return this.dataModel.rootParentId;
    },
    set: function set(value) {
      this.dataModel.rootParentId = value;
    }
  }, {
    key: "typeCode",
    get: function get() {
      return this.dataModel.typeCode;
    },
    set: function set(value) {
      this.dataModel.typeCode = value;
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (isNull(data) || !Array.isArray(data)) return;
      this.nodes = {};
      this.rootNodes = [];
      var nodeIdArr = [];

      for (var i = 0; i < data.length; i++) {
        var nodeData = data[i];
        var node = {};
        node.id = nodeData[this.dataModel.idField];
        node.value = nodeData[this.dataModel.valueField];
        node.name = nodeData[this.dataModel.textField];
        if (!this.dataModel.textField) node.name = nodeData[this.dataModel.valueField];
        node.parentId = nodeData[this.dataModel.parentIdField];
        node.data = nodeData;
        node.childNodes = [];
        this.nodes[node.id] = node;
        nodeIdArr.push(node.id);
      } //生成节点之间的关系


      for (var i = 0; i < nodeIdArr.length; i++) {
        var nodeId = nodeIdArr[i];
        var node = this.nodes[nodeId];

        if (node.parentId == this.dataModel.rootParentId) {
          this.rootNodes.push(nodeId);
        } else {
          var parentNode = this.nodes[node.parentId];

          if (parentNode) {
            parentNode.childNodes.push(nodeId);
          }
        }
      }

      if (this.dataModel.value) this.value = this.dataModel.value;

      this._jqObj.children("img").attr('src', '' + this._tfp.rootPath + '/src/components/select/images/arrow-down-' + this._tfp.curPage.contentColorMode + '.png');

      this._jqObj.children("img").css('margin-top', '10px');

      this.isLoad = true;
    }
    /**
     * 检查数据加载参数是否设置正确
     * @returns 
     */

  }, {
    key: "checkLoadDataArg",
    value: function checkLoadDataArg() {
      if (!this.dataModel.valueField) {
        alert("请为[" + this.id + "]设置选项值字段格式！");
        return false;
      }

      if (!this.dataModel.idField) {
        alert("请为[" + this.id + "]设置节点主键字段格式！");
        return false;
      }

      return true;
    }
  }, {
    key: "loadData",
    value: function loadData() {
      this._jqObj.children("img").attr('src', '' + this._tfp.rootPath + '/src/components/cascader/images/loading.gif');

      this._jqObj.children("img").css('margin-top', '-25px');

      (0, _get2["default"])((0, _getPrototypeOf2["default"])(Cascader.prototype), "loadData", this).call(this);
    }
  }, {
    key: "showMenuItems",
    value: function showMenuItems(nodeId, level) {
      var that = this;
      var node = this.nodes[nodeId];
      if (node.childNodes.length == 0) return;
      var menusEl = $(".tfp-cascader-menus");
      var html = "<div id=\"cascader-items-" + nodeId + "\" class=\"tfp-cascader-items\" style=\"flex-basis: " + that.dataModel.popupWidth + "px;\">";

      for (var i = 0; i < node.childNodes.length; i++) {
        var nodeChild = this.nodes[node.childNodes[i]];

        if (nodeChild.childNodes.length > 0) {
          html += "<div nodeid=\"" + nodeChild.id + "\" data-value=\"" + nodeChild.value + "\" data-level=\"" + (level + 1) + "\">" + nodeChild.name + "<span class='tfp-ci-arrow'></span></div>";
        } else {
          html += "<div nodeid=\"" + nodeChild.id + "\" data-value=\"" + nodeChild.value + "\" data-level=\"" + (level + 1) + "\">" + nodeChild.name + "</div>";
        }
      }

      html += "</div>";
      menusEl.css("width", (level + 1) * that.dataModel.popupWidth + "px");
      menusEl.append(html);
      $("#cascader-items-" + nodeId).find("div").click(function (e) {
        //实现菜单单击相关功能
        $(this).addClass('active').siblings().removeClass('active');
        var nodeChildItem = that.nodes[node.childNodes[$(this).index()]];

        if (nodeChildItem.childNodes.length == 0) {
          var childText = '';
          var childValue = '';
          var childLevel = '';

          for (var i = 0; i < $('.tfp-cascader-items').length; i++) {
            if (childText == '') {
              childText += $('.tfp-cascader-items .active').eq(i).text();
              childValue += $('.tfp-cascader-items .active').eq(i).attr('data-value');
              childLevel += $('.tfp-cascader-items .active').eq(i).attr('data-level');
            } else {
              childText += '/';
              childText += $('.tfp-cascader-items .active').eq(i).text();
              childValue += '/';
              childValue += $('.tfp-cascader-items .active').eq(i).attr('data-value');
              childLevel += '|';
              childLevel += $('.tfp-cascader-items .active').eq(i).attr('data-level');
            }

            if ($('.tfp-cascader-items .active').eq(i).children().length == 0) break;
          }

          that._jqObj.children("input").attr('data-value', childValue);

          that._jqObj.children("input").attr('data-level', childLevel);

          that._jqObj.children("input").attr('nodeid', nodeChildItem.id);

          that._jqObj.children("input").val(childText);

          that.setValue(childValue);
          that.closePicker();
        }

        $(this).parent().nextAll().remove();
        var nodeId = $(this).attr("nodeid");
        var level = parseInt($(this).attr("data-level"));
        that.showMenuItems(nodeId, level);
        e.stopPropagation();
      });
    }
  }, {
    key: "showPicker",
    value: function showPicker() {
      var offset = this._jqObj.offset();

      var width = this.dataModel.popupWidth;
      var top = offset.top + 31;
      var left = offset.left;
      var docWidth = document.documentElement.clientWidth;
      var docHeight = document.documentElement.clientHeight; //根据页面大小自动调整显示位置

      if (left + width > docWidth) {
        left = offset.left + this._jqObj.outerWidth() - width;
        if (left < 0) left = 0;
      }

      if (top + 245 > docHeight) {
        top = offset.top - 245;
        if (top < 0) top = 0;
      }

      var html = "<div class=\"tfp-cascader-menus\" style=\"top: " + top + "px; left:" + left + "px; width: " + width + "px;\">"; //默认显示第一层菜单

      html += "<div class=\"tfp-cascader-items\" style=\"flex-basis: " + width + "px;\">";

      for (var i = 0; i < this.rootNodes.length; i++) {
        var node = this.nodes[this.rootNodes[i]];

        if (node.childNodes.length > 0) {
          html += "<div nodeid=\"" + node.id + "\" data-value=\"" + node.value + "\" data-level=\"1\">" + node.name + "<span class='tfp-ci-arrow'></span></div>";
        } else {
          html += "<div nodeid=\"" + node.id + "\" data-value=\"" + node.value + "\" data-level=\"1\">" + node.name + "</div>";
        }
      }

      html += "</div>";
      html += "</div>";
      $("body").append(html);
      $("body").bind("click", this.closePicker);
      var that = this;
      $(".tfp-cascader-menus").find(".tfp-cascader-items").find("div").click(function (e) {
        //实现菜单单击相关功能
        $(this).addClass('active').siblings().removeClass('active');
        var nodeItem = that.nodes[that.rootNodes[$(this).index()]];

        if (nodeItem.childNodes.length == 0) {
          var nodeText = '';
          var nodeValue = '';
          var nodeLevel = '';

          for (var i = 0; i < $('.tfp-cascader-items').length; i++) {
            if (nodeText == '') {
              nodeText += $('.tfp-cascader-items .active').eq(i).text();
              nodeValue += $('.tfp-cascader-items .active').eq(i).attr('data-value');
              nodeLevel += $('.tfp-cascader-items .active').eq(i).attr('data-level');
            } else {
              nodeText += '/';
              nodeText += $('.tfp-cascader-items .active').eq(i).text();
              nodeValue += '/';
              nodeValue += $('.tfp-cascader-items .active').eq(i).attr('data-value');
              nodeLevel += '|';
              nodeLevel += $('.tfp-cascader-items .active').eq(i).attr('data-level');
            }

            if ($('.tfp-cascader-items .active').eq(i).children().length == 0) break;
          }

          that._jqObj.children("input").attr('data-value', nodeValue);

          that._jqObj.children("input").attr('nodeid', nodeItem.id);

          that._jqObj.children("input").attr('data-level', nodeLevel);

          that._jqObj.children("input").val(nodeText);

          that.setValue(nodeValue);
          that.closePicker();
        }

        $(this).parent().nextAll().remove();
        var nodeId = $(this).attr("nodeid");
        var level = parseInt($(this).attr("data-level"));
        that.showMenuItems(nodeId, level);
        e.stopPropagation();
      });
    }
  }, {
    key: "closePicker",
    value: function closePicker() {
      $(".tfp-cascader-menus").remove();
    }
  }, {
    key: "setValue",
    value: function setValue(value) {
      this.dataModel.value = value;
      this.valueOnChange();
      this.exeEventHandler("onChange", value);

      this._jqObj.find("input").focus();
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      if (this.readonly) {
        this._jqObj.css("padding-left", "0px");

        this._jqObj.find("img").css("display", "none");

        this._jqObj.find("input").css("padding-left", "0px");
      } //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载


      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      } else if (this.dataModel.typeCode) {
        this._tfp.use("Service", function () {
          var service = that._tfp["new"]("Service");

          service.path = "sys/service/data_dic/getDataDicList.tbs";
          service.request(null, function (req, res) {
            that.bindData(res.data);
          });
        });
      }

      this._jqObj.click(function (e) {
        if (that.dataModel.readonly || that.dataModel.disabled) return;
        if ($(".tfp-cascader-menus").length > 0) return;
        if (that.isLoad == false) return;
        that.showPicker();
        e.stopPropagation();
      });

      that._jqObj.hover(function () {
        if (that._tfp.curPage.bgColorMode == "light" && !(that.disabled || that.readonly)) {
          that._jqObj.css("background-color", "#F6F6F6");

          that._jqObj.find("input").css("background-color", "#F6F6F6");
        }

        if (that.isLoad == false) return;

        if (that._jqObj.children("input").val() != '') {
          that._jqObj.children("img").attr('src', '' + that._tfp.rootPath + '/src/components/select/images/close-' + that._tfp.curPage.contentColorMode + '.png');
        }

        that._jqObj.find('img').on('click', function (e) {
          if (that._jqObj.children("input").val() != '') {
            e.stopPropagation();

            that._jqObj.children("input").removeAttr('data-value');

            that._jqObj.children("input").removeAttr('nodeid');

            that._jqObj.children("input").removeAttr('data-level');

            that._jqObj.children("input").val('');

            that.setValue(that._jqObj.children("input").val());
          }
        });
      }, function () {
        if (that._tfp.curPage.bgColorMode == "light" && !(that.disabled || that.readonly) && !that._jqObj.find("input").is(":focus")) {
          that._jqObj.css("background-color", "");

          that._jqObj.find("input").css("background-color", "");
        }

        if (that.isLoad == false) return;

        if ($(".tfp-cascader-menus").length == 0) {
          that._jqObj.children("img").attr('src', '' + that._tfp.rootPath + '/src/components/select/images/arrow-down-' + that._tfp.curPage.contentColorMode + '.png');
        } else {
          that._jqObj.children("img").attr('src', '' + that._tfp.rootPath + '/src/components/select/images/arrow-down-' + that._tfp.curPage.contentColorMode + '.png');
        }
      });

      this._jqObj.find("input").focus(function () {
        if (that.disabled || that.readonly) return;
        if (that._tfp.curPage.bgColorMode == "light") that._jqObj.css("outline", "1px solid var(--sys-theme-color)");

        try {
          if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
        } catch (err) {
          console.log(err.message);
        }
      });

      this._jqObj.find("input").blur(function () {
        if (that.disabled || that.readonly) return;
        if (that._tfp.curPage.bgColorMode == "light") that._jqObj.css("outline", "0");

        that._jqObj.css("background-color", "");

        that._jqObj.find("input").css("background-color", "");

        try {
          if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
        } catch (err) {
          console.log(err.message);
        }
      });
    }
  }]);
  return Cascader;
}(_controller.FormInput);

exports["default"] = Cascader;