"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _render = _interopRequireDefault(require("../render.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var ButtonRender = /*#__PURE__*/function (_TFPComponentRender) {
  (0, _inherits2["default"])(ButtonRender, _TFPComponentRender);

  var _super = _createSuper(ButtonRender);

  function ButtonRender(__tfp, _dataModel, _level) {
    (0, _classCallCheck2["default"])(this, ButtonRender);
    return _super.call(this, __tfp, _dataModel, _level);
  }

  (0, _createClass2["default"])(ButtonRender, [{
    key: "getSpecialClass",
    value: function getSpecialClass() {
      var classHtml = " tfp-button-" + (this.dataModel.buttonType ? this.dataModel.buttonType : "default");
      if (this.dataModel.plain) classHtml += "-plain";
      classHtml += " tfp-button-" + (this.dataModel.theme ? this.dataModel.theme : "rect");
      classHtml += " tfp-button-" + (this.dataModel.portrait ? "column" : "row");
      return classHtml;
    }
  }, {
    key: "getAttrHtml",
    value: function getAttrHtml(retainStyleAttr) {
      var attrHtml = (0, _get2["default"])((0, _getPrototypeOf2["default"])(ButtonRender.prototype), "getAttrHtml", this).call(this, retainStyleAttr);
      if (this._tfp.isDesigning && attrHtml.indexOf("readonly") < 0) attrHtml += " readonly";
      return attrHtml;
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml) {
      var bodyHtml = "\r\n";
      var indent = this.getHtmlIndent();
      var fontWeight = "";
      if (this.dataModel.labelWeight) fontWeight = "font-weight:bold;";

      if (this.dataModel.showImage) {
        var imgUrl = this.dataModel.imageUrl;

        if (!imgUrl) {
          imgUrl = this._tfp.rootPath + "/src/components/button/images/default-photo.png";
        } else if (this._tfp.isDesigning) {
          if (imgUrl.indexOf("tfp-button-icon") < 0) imgUrl = this._tfp.getUrlRealPath(imgUrl);
        }

        var imgWidth = 20;
        if (this.dataModel.imageWidth) imgWidth = parseInt(this.dataModel.imageWidth);
        var imgHeight = 20;
        if (this.dataModel.imageHeight) imgHeight = parseInt(this.dataModel.imageHeight);
        var labelColor = '';
        if (this.dataModel.labelColor) labelColor = "color:" + this.dataModel.labelColor + ";";
        var imgHtml = '';

        if (imgUrl.indexOf("tfp-button-icon") < 0) {
          imgHtml = indent + "\t<img src=\"" + imgUrl + "\" width=\"" + imgWidth + "\" height=\"" + imgHeight + "\" style=\"margin-top:3px; margin-bottom:3px;\" />\r\n";
        } else {
          var fontSize = imgWidth ? imgWidth : imgHeight;
          imgHtml = indent + "\t<span class=\"" + imgUrl + "\" style=\"font-size:" + fontSize + "px;margin-top:3px; margin-bottom:3px;" + labelColor + "\"></span>\r\n";
        }

        if (this.dataModel.hiddenText) {
          bodyHtml += indent + "\t" + imgHtml + "\r\n";
          bodyHtml += indent + "\t<label style=\"display:none;line-height:" + this._tfp.formatPx(this.cpt.labelHeight) + ";font-size:14px;\">" + this.dataModel.value + "</label>\r\n";
        } else {
          if (this.dataModel.portrait) {
            bodyHtml += indent + "\t" + imgHtml + "\r\n";
            bodyHtml += indent + "\t<label style=\"line-height:" + this._tfp.formatPx(this.cpt.labelHeight) + ";font-size:" + this._tfp.formatPx(this.cpt.labelSize) + ";" + labelColor + "" + fontWeight + "\">" + this.dataModel.value + "</label>\r\n";
          } else {
            bodyHtml += indent + "\t" + imgHtml + "\r\n";
            bodyHtml += indent + "\t<label style=\"margin-left:7px;line-height:" + this._tfp.formatPx(this.cpt.labelHeight) + ";font-size:" + this._tfp.formatPx(this.cpt.labelSize) + ";" + labelColor + "" + fontWeight + "\">" + this.dataModel.value + "</label>\r\n";
          }
        }
      } else {
        if (this.dataModel.value) {
          bodyHtml += indent + "\t<label style=\"line-height:" + this._tfp.formatPx(this.cpt.labelHeight) + ";font-size:" + this._tfp.formatPx(this.cpt.labelSize) + ";";
          if (this.dataModel.labelColor) bodyHtml += "color:" + this.dataModel.labelColor + ";";
          if (fontWeight) bodyHtml += "" + fontWeight + "";
          bodyHtml += "\">" + this.dataModel.value + "</label>\r\n";
        }
      }

      return bodyHtml + indent;
    }
  }, {
    key: "getHtml",
    value: function getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
      return (0, _get2["default"])((0, _getPrototypeOf2["default"])(ButtonRender.prototype), "getHtml", this).call(this, "div", false, parentIndent, retainStyleAttr);
    }
  }]);
  return ButtonRender;
}(_render["default"]);

exports["default"] = ButtonRender;