"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Button",
  "comment": "按钮",
  "tagName": "button",
  "attrs": [{
    "name": "buttonInfo",
    "comment": "按钮信息",
    "type": "group",
    "items": [{
      "name": "value",
      "comment": "按钮文本",
      "type": "String",
      "default": "{id}"
    }, {
      "name": "buttonType",
      "comment": "按钮类型",
      "type": "Select",
      "isHtmlAttr": true,
      "attrName": "type",
      "options": [{
        "value": "primary",
        "text": "	主要按钮"
      }, {
        "value": "default",
        "text": "默认按钮"
      }, {
        "value": "warn",
        "text": "危险按钮"
      }]
    }, {
      "name": "sizeType",
      "comment": "尺寸按钮",
      "type": "Select",
      "isHtmlAttr": true,
      "attrName": "size",
      "options": [{
        "value": "default",
        "text": "	默认尺寸"
      }, {
        "value": "mini",
        "text": "	小尺寸"
      }]
    }, {
      "name": "plain",
      "comment": "是否镂空背景透明",
      "type": "Switch",
      "isHtmlAttr": true
    }, {
      "name": "buttonDisabled",
      "comment": "是否禁用按钮",
      "type": "Switch",
      "attrName": "disabled"
    }, {
      "name": "loading",
      "comment": "是否带 loading 图标",
      "type": "Switch",
      "isHtmlAttr": true
    }, {
      "name": "formType",
      "comment": "触发form submit/reset",
      "type": "Select",
      "attrName": "form-type",
      "options": [{
        "value": "submit",
        "text": "提交表单"
      }, {
        "value": "reset",
        "text": "重置表单"
      }]
    }, {
      "name": "opentype",
      "comment": "微信开放能力",
      "type": "Select",
      "attrName": "open-type",
      "options": [{
        "value": "share",
        "text": "转发"
      }, {
        "value": "getPhoneNumber",
        "text": "获取用户手机号"
      }, {
        "value": "getUserInfo",
        "text": "	获取用户信息"
      }, {
        "value": "openSetting",
        "text": "打开授权设置页"
      }, {
        "value": "launchApp",
        "text": "打开APP"
      }, {
        "value": "chooseAvatar",
        "text": "获取用户头像"
      }]
    }, {
      "name": "appParameter",
      "comment": "打开APP传递的参数",
      "isHtmlAttr": true,
      "type": "String",
      "attrName": "app-parameter"
    }]
  }],
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "defaultStyles": {},
  "events": [{
    "name": "bindtap",
    "args": [{
      'name': 'e'
    }],
    "eventArgs": "",
    "comment": "点击时"
  }, {
    "name": "bindgetuserinfo",
    "args": [{
      'name': 'e'
    }],
    "eventArgs": "",
    "comment": "用户信息的回调"
  }, {
    "name": "bindgetphonenumber",
    "args": [{
      'name': 'e'
    }],
    "eventArgs": "",
    "comment": "获取手机号的回调"
  }, {
    "name": "bindopensetting",
    "args": [{
      'name': 'e'
    }],
    "eventArgs": "",
    "comment": "打开授权的回调"
  }, {
    "name": "bindlaunchapp",
    "args": [{
      'name': 'e'
    }],
    "eventArgs": "",
    "comment": "打开APP成功的回调"
  }, {
    "name": "bindchooseavatar",
    "args": [{
      'name': 'e'
    }],
    "eventArgs": "",
    "comment": "获取用户头像的回调"
  }]
};
exports["default"] = _default;