"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 按钮组件
 * @param {[type]} dataModel [description]
 */
var Button = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(Button, _VisibleComponent);

  var _super = _createSuper(Button);

  function Button(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Button);
    return _super.call(this, __tfp, "Button", dataModel, parent);
  } //属性


  (0, _createClass2["default"])(Button, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.find("label").text(value);

        this.exeEventHandler("onChange");
      }
    }
  }, {
    key: "buttonType",
    get: function get() {
      return this.dataModel.buttonType;
    },
    set: function set(value) {
      this.dataModel.buttonType = value;

      if (this._jqObj) {
        this._jqObj.removeClass("wx-button-primary");

        this._jqObj.removeClass("wx-button-default");

        this._jqObj.removeClass(" wx-button-warn");

        this._jqObj.addClass("wx-button-" + value);
      }
    }
  }, {
    key: "sizeType",
    get: function get() {
      return this.dataModel.sizeType;
    },
    set: function set(value) {
      this.dataModel.sizeType = value;

      if (this._jqObj) {
        if (value) {
          this._jqObj.attr("size", "mini");
        } else {
          this._jqObj.removeAttr("size");
        }
      }
    }
  }, {
    key: "plain",
    get: function get() {
      return this.dataModel.plain;
    },
    set: function set(value) {
      this.dataModel.plain = value ? true : false;

      if (this._jqObj) {
        this._jqObj.attr("plain", true);

        if (!value) {
          this._jqObj.removeAttr("plain");
        }
      }
    }
  }, {
    key: "buttonDisabled",
    get: function get() {
      return this.dataModel.buttonDisabled;
    },
    set: function set(value) {
      this.dataModel.buttonDisabled = value; // this.dataModel.buttonDisabled = value ? true : false;

      if (this._jqObj) {
        this._jqObj.attr("disabled", true);

        if (!value) {
          this._jqObj.removeAttr("disabled");
        }
      }
    }
  }, {
    key: "loading",
    get: function get() {
      return this.dataModel.loading;
    },
    set: function set(value) {
      this.dataModel.loading = value;

      if (this._jqObj) {
        if (value) {
          var imgUrl = this._tfp.rootPath + "/src/components/button/images/lodding.png";
          var str = "<div class=\"lodding\"> <img class=\"loddingImg\" src=\"".concat(imgUrl, "\"   /> </div>");

          this._jqObj.prepend(str);
        } else {
          this._jqObj.find(".lodding").remove();

          this._jqObj.removeAttr("lodding");
        }
      }
    }
  }, {
    key: "formType",
    get: function get() {
      return this.dataModel.formType;
    },
    set: function set(value) {
      this.dataModel.formType = value;
    }
  }, {
    key: "opentype",
    get: function get() {
      return this.dataModel.opentype;
    },
    set: function set(value) {
      this.dataModel.opentype = value;
    }
  }]);
  return Button;
}(_controller.VisibleComponent);

exports["default"] = Button;