"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 按钮组件
 * @param {[type]} dataModel [description]
 */
var Button = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(Button, _VisibleComponent);

  var _super = _createSuper(Button);

  function Button(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Button);
    return _super.call(this, __tfp, "Button", dataModel, parent);
  }

  (0, _createClass2["default"])(Button, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.find("label").text(value);

        this.exeEventHandler("onChange");
      }
    }
  }, {
    key: "buttonType",
    get: function get() {
      return this.dataModel.buttonType;
    },
    set: function set(value) {
      var buttonType = "default";
      if (value) buttonType = value;

      if (!this.checkAttrOption("buttonType", buttonType)) {
        this._tfp.showMsg("按钮组件不支持类型：" + buttonType + "！");

        return;
      }

      this.dataModel.buttonType = buttonType;

      if (this._jqObj) {
        this._jqObj.removeClass("tfp-button-default tfp-button-primary tfp-button-info" + " tfp-button-warning tfp-button-success tfp-button-danger");

        this._jqObj.removeClass("tfp-button-default-plain tfp-button-primary-plain tfp-button-info-plain" + " tfp-button-warning-plain tfp-button-success-plain tfp-button-danger-plain");

        if (this.plain) {
          this._jqObj.addClass("tfp-button-" + buttonType + "-plain");
        } else {
          this._jqObj.addClass("tfp-button-" + buttonType);
        }
      }
    }
  }, {
    key: "theme",
    get: function get() {
      return this.dataModel.theme;
    },
    set: function set(value) {
      var theme = "rect";
      if (value) theme = value;

      if (!this.checkAttrOption("theme", theme)) {
        this._tfp.showMsg("按钮组件不支持风格：" + theme + "！");

        return;
      }

      this.dataModel.theme = theme;

      if (this._jqObj) {
        this._jqObj.removeClass("tfp-button-round tfp-button-rect tfp-button-circle");

        this._jqObj.addClass("tfp-button-" + theme);
      }
    }
  }, {
    key: "plain",
    get: function get() {
      return this.dataModel.plain;
    },
    set: function set(value) {
      this.dataModel.plain = value ? true : false;

      if (this._jqObj) {
        this._jqObj.removeClass("tfp-button-default tfp-button-primary tfp-button-info" + " tfp-button-warning tfp-button-success tfp-button-danger");

        this._jqObj.removeClass("tfp-button-default-plain tfp-button-primary-plain tfp-button-info-plain" + " tfp-button-warning-plain tfp-button-success-plain tfp-button-danger-plain");

        var buttonType = this.buttonType;
        if (!buttonType) buttonType = "default";

        if (this.dataModel.plain) {
          this._jqObj.addClass("tfp-button-" + buttonType + "-plain");
        } else {
          this._jqObj.addClass("tfp-button-" + buttonType);
        }
      }
    }
  }, {
    key: "showImage",
    get: function get() {
      return this.dataModel.showImage;
    },
    set: function set(value) {
      this.dataModel.showImage = value ? true : false;

      if (this._jqObj) {
        if (value) {
          if (this._jqObj.find("img").length > 0) {
            this._jqObj.find("img").show();

            return;
          }

          if (this._jqObj.find("span").length > 0) {
            this._jqObj.find("span").show();

            return;
          }

          if (this._tfp.isDesigning) {
            uiDesigner.showAttrSettingRow("imageUrl");
            uiDesigner.showAttrSettingRow("imageWidth");
            uiDesigner.showAttrSettingRow("imageHeight");
            uiDesigner.showAttrSettingRow("portrait");
            uiDesigner.showAttrSettingRow("hiddenText");
          }

          var imgUrl = this.dataModel.imageUrl;

          if (!imgUrl) {
            imgUrl = this._tfp.rootPath + "/src/components/button/images/default-photo.png";
          } else if (this._tfp.isDesigning) {
            imgUrl = this._tfp.getUrlRealPath(imgUrl);
          }

          var imgWidth = 16;
          if (this.dataModel.imageWidth) imgWidth = this.dataModel.imageWidth;
          if ((imgWidth + "").indexOf("px") < 0) imgWidth += "px";
          var imgHeight = 16;
          if (this.dataModel.imageHeight) imgHeight = this.dataModel.imageHeight;
          if ((imgHeight + "").indexOf("px") < 0) imgHeight += "px";
          uiDesigner.setCurCptAttrSettingVal("imageWidth", "16");
          uiDesigner.setCurCptAttrSettingVal("imageHeight", "16");
          var imgHtml = "<img src=\"" + imgUrl + "\" style=\"width:" + imgWidth + ";height:" + imgHeight + ";\" />";

          this._jqObj.find("label").before(imgHtml);

          if (!this.dataModel.portrait) this._jqObj.find("label").css("margin-left", "7px"); //this._jqObj.find("label").css("line-height", this._jqObj.height() + "px");
        } else {
          if (this._jqObj.find("img")) this._jqObj.find("img").remove();
          if (this._jqObj.find("span")) this._jqObj.find("span").remove();
          this.dataModel.portrait = false;
          this.dataModel.hiddenText = false;
          this.dataModel.imageUrl = "";
          this.dataModel.imageWidth = 16;
          this.dataModel.imageHeight = 16;

          this._jqObj.find("label").css("margin-left", "0px");

          this._jqObj.find("label").css("line-height", "30px");

          this._jqObj.find("label").show();

          if (this._tfp.isDesigning) {
            uiDesigner.hideAttrSettingRow("imageUrl");
            uiDesigner.hideAttrSettingRow("imageWidth");
            uiDesigner.hideAttrSettingRow("imageHeight");
            uiDesigner.setCurCptAttrSettingVal("imageWidth", "16");
            uiDesigner.setCurCptAttrSettingVal("imageHeight", "16"); //window.parent.$("[attr-name=imageWidth]").find("input").val("24");
            //window.parent.$("[attr-name=imageHeight]").find("input").val("24");

            uiDesigner.setCurCptAttrSettingVal("portrait", false);
            uiDesigner.hideAttrSettingRow("portrait");
            uiDesigner.setCurCptAttrSettingVal("hiddenText", false);
            uiDesigner.hideAttrSettingRow("hiddenText");
          }
        }
      }
    }
  }, {
    key: "imageUrl",
    get: function get() {
      return this.dataModel.imageUrl;
    },
    set: function set(value) {
      this.dataModel.imageUrl = value;

      if (this._jqObj) {
        var imgWidth = 20;
        if (this.dataModel.imageWidth) imgWidth = parseInt(this.dataModel.imageWidth);
        var imgHeight = 20;
        if (this.dataModel.imageHeight) imgHeight = parseInt(this.dataModel.imageHeight);
        var imgMargin = 3;
        if (this.dataModel.portrait && !this.dataModel.hiddenText) imgMargin = 10;
        var labelColor = '';
        if (this.dataModel.labelColor) labelColor = "color:" + this.dataModel.labelColor + ";";

        if (this._tfp.isDesigning && value) {
          if (this._jqObj.find("img")) this._jqObj.find("img").remove();
          if (this._jqObj.find("span")) this._jqObj.find("span").remove();

          if (value.indexOf("tfp-button-icon") >= 0) {
            var fontSize = imgWidth ? imgWidth : imgHeight;

            this._jqObj.find("label").before('<span class="' + value + '" style=\"font-size:' + fontSize + 'px;margin-top:' + imgMargin + 'px; margin-bottom:3px;' + labelColor + '\"></span>');
          } else {
            this._jqObj.find("label").before('<img src="' + this._tfp.getUrlRealPath(value) + '" width=\"' + imgWidth + '\" height=\"' + imgHeight + '\" style=\"margin-top:' + imgMargin + 'px; margin-bottom:3px;\">');
          }
        } else {
          if (this._jqObj.find("img")) this._jqObj.find("img").remove();
          if (this._jqObj.find("span")) this._jqObj.find("span").remove();
          var imgUrl = this._tfp.rootPath + "/src/components/button/images/default-photo.png";

          this._jqObj.find("label").before('<img src="' + imgUrl + '" width=\"' + imgWidth + '\" height=\"' + imgHeight + '\" style=\"margin-top:' + imgMargin + 'px; margin-bottom:3px;\">');
        }
      }
    }
  }, {
    key: "imageWidth",
    get: function get() {
      return this.dataModel.imageWidth;
    },
    set: function set(value) {
      this.dataModel.imageWidth = value;

      if (this._jqObj) {
        if (this.dataModel.imageUrl && this.dataModel.imageUrl.indexOf("tfp-button-icon") >= 0) {
          this._jqObj.find("span").css("font-size", value + 'px');
        } else {
          this._jqObj.find("img").attr("width", value);
        }
      }
    }
  }, {
    key: "imageHeight",
    get: function get() {
      return this.dataModel.imageHeight;
    },
    set: function set(value) {
      this.dataModel.imageHeight = value;

      if (this._jqObj) {
        if (this.dataModel.imageUrl && this.dataModel.imageUrl.indexOf("tfp-button-icon") >= 0) {
          this._jqObj.find("span").css("font-size", value + 'px');
        } else {
          this._jqObj.find("img").attr("height", value);
        } //if (!this.portrait) this._jqObj.find("label").css("line-height",
        //  (this._jqObj.find("img").height() + 6) + "px");

      }
    }
  }, {
    key: "hiddenText",
    get: function get() {
      return this.dataModel.hiddenText;
    },
    set: function set(value) {
      this.dataModel.hiddenText = value ? true : false;

      if (this._jqObj) {
        if (this._jqObj.find("label").length == 0) return;

        if (value) {
          this.portrait = false;
          uiDesigner.setCurCptAttrSettingVal("portrait", false);
          uiDesigner.hideAttrSettingRow("portrait");

          this._jqObj.find("img").css("margin-top", "3px");

          this._jqObj.find("label").hide();
        } else {
          this._jqObj.find("label").show(); //this._jqObj.find("div").css("float", "left");
          //this._jqObj.find("img").css("margin-top", "3px");


          if (!this.dataModel.portrait) this._jqObj.find("label").css("margin-left", "7px"); //this._jqObj.find("label").css("line-height", (this._jqObj.find("img").height() + 6) + "px");

          uiDesigner.showAttrSettingRow("portrait");
        }
      }
    }
  }, {
    key: "portrait",
    get: function get() {
      return this.dataModel.portrait;
    },
    set: function set(value) {
      this.dataModel.portrait = value ? true : false;

      if (this._jqObj) {
        if (value) {
          this._jqObj.css({
            "flex-direction": "column"
          });
          /*this._jqObj.find("div").css("float", "none");
          this._jqObj.find("div").css("width", "100%");
          this._jqObj.find("img").css("margin-top", "10px");
          this._jqObj.find("label").css("margin-left", "0px");
          this._jqObj.find("label").css("line-height", "30px");*/

        } else {
          this._jqObj.css("flex-direction", "row");
          /*this._jqObj.find("div").css("float", "left");
          this._jqObj.find("div").css("width", "");
          this._jqObj.find("img").css("margin-top", "3px");
          this._jqObj.find("label").css("margin-left", "7px");
          this._jqObj.find("label").css("line-height", (this._jqObj.find("img").height() + 6) + "px");*/

        }
      }
    }
  }, {
    key: "title",
    get: function get() {
      return this.dataModel.title;
    },
    set: function set(value) {
      this.dataModel.title = value;

      if (this._jqObj) {
        this._jqObj.attr("title", value);
      }
    }
  }, {
    key: "labelSize",
    get: function get() {
      if (this.dataModel.labelSize) return this._tfp.getPixel(this.dataModel.labelSize);
      return 14;
    },
    set: function set(value) {
      this.dataModel.labelSize = value;

      if (this._jqObj) {
        var size = value;
        if ((size + "").indexOf("px") < 0) size += "px";

        this._jqObj.find("label").css("font-size", size);
      }
    }
  }, {
    key: "labelHeight",
    get: function get() {
      if (this.dataModel.labelHeight) return this._tfp.getPixel(this.dataModel.labelHeight);
      return 30;
    },
    set: function set(value) {
      this.dataModel.labelHeight = value;

      if (this._jqObj) {
        var height = value;
        if ((height + "").indexOf("px") < 0) height += "px";

        this._jqObj.find("label").css("line-height", height);
      }
    }
  }, {
    key: "labelColor",
    get: function get() {
      return this.dataModel.labelColor;
    },
    set: function set(value) {
      this.dataModel.labelColor = value;

      if (this._jqObj) {
        var color = value;

        this._jqObj.find("label").css("color", color);

        if (this.dataModel.imageUrl && this.dataModel.imageUrl.indexOf("tfp-button-icon") >= 0) {
          this._jqObj.find("span").css("color", color);
        }
      }
    }
  }, {
    key: "labelWeight",
    get: function get() {
      return this.dataModel.labelWeight;
    },
    set: function set(value) {
      this.dataModel.labelWeight = value ? true : false;

      if (this._jqObj) {
        if (value) {
          this._jqObj.find("label").css("font-weight", "bold");
        } else {
          this._jqObj.find("label").css("font-weight", "");
        }
      }
    } //是否禁用

  }, {
    key: "disabled",
    get: function get() {
      return this.dataModel.disabled ? true : false;
    },
    set: function set(value) {
      this.dataModel.disabled = value ? true : false;
      if (!this.dataModel.disabled) delete this.dataModel.disabled;

      if (this._jqObj) {
        if (value) {
          this._jqObj.css("background-color", "#CCCCCC");
        } else {
          this._jqObj.css("background-color", "");
        }
      }
    }
  }, {
    key: "css",
    value: function css(styleName, styleValue) {
      if (arguments.length == 0) return; //获取样式值

      if (arguments.length == 1) {
        if (!this.dataModel.styles) return null;
        return this.dataModel.styles[styleName];
      }

      (0, _get2["default"])((0, _getPrototypeOf2["default"])(Button.prototype), "css", this).call(this, styleName, styleValue);

      if (styleName == "height" && styleValue) {
        if (this._jqObj && !this.showImage) {
          //this._jqObj.css("line-height", styleValue);
          this._jqObj.find("label").css("line-height", styleValue);
        }
      }
    }
  }, {
    key: "show",
    value: function show() {
      if (this._jqObj) this._jqObj.css("display", "inline-flex");
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.click(function () {
        if (that.dataModel.readonly || that.dataModel.disabled || !that.dataModel.onClick) return;

        try {
          if (that.dataModel.onClick.indexOf("(") < 0) {
            eval(that.dataModel.onClick + "()");
          } else {
            eval(that.dataModel.onClick);
          }
        } catch (err) {
          console.log(err.message);
        }
      });
    }
  }]);
  return Button;
}(_controller.VisibleComponent);

exports["default"] = Button;