"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Breadcrumb",
  "comment": "面包屑",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [{
    "name": "inputSetting",
    "comment": "基础设置",
    "type": "group",
    "items": [{
      "name": "options",
      "comment": "数据集",
      "type": "Dataset",
      "columns": [{
        "id": "text",
        "name": "文本",
        "type": "String",
        "required": true,
        "width": "180px"
      }, {
        "id": "href",
        "name": "链接",
        "type": "String",
        "width": "340px"
      }]
    }, {
      "name": "separator",
      "comment": "分隔符",
      "type": "String",
      "default": ">"
    }]
  }, {
    "name": "dataSourceSetting",
    "comment": "数据源设置",
    "type": "group",
    "items": [{
      "name": "dataQuerySetting",
      "comment": "数据查询设置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
      "width": "800px",
      "height": "640px"
    }, {
      "name": "dataListTextFormat",
      "comment": "选项文本数据格式",
      "type": "String",
      "showModelFieldList": true
    }, {
      "name": "dataListHrefFormat",
      "comment": "选项链接数据格式",
      "type": "String",
      "showModelFieldList": true
    }]
  }],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {},
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击时",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;