"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 面包屑组件
 * @param {[type]} dataModel [description]
 */
var Breadcrumb = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Breadcrumb, _FormInput);

  var _super = _createSuper(Breadcrumb);

  function Breadcrumb(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, Breadcrumb);
    _this = _super.call(this, __tfp, "Breadcrumb", dataModel, parent);

    if (!_this.dataModel.options) {
      _this.dataModel.options = [{
        text: "breadcrumb1",
        href: "/app/sys/console/home.tfp"
      }, {
        text: "breadcrumb2",
        href: ""
      }, {
        text: "breadcrumb3",
        href: ""
      }];
    }

    return _this;
  }

  (0, _createClass2["default"])(Breadcrumb, [{
    key: "loadDataListService",
    get: function get() {
      return this.dataModel.loadDataListService;
    },
    set: function set(value) {
      this.dataModel.loadDataListService = value;
    }
  }, {
    key: "dataListBindingMember",
    get: function get() {
      return this.dataModel.dataListBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataListBindingMember = value;
    }
  }, {
    key: "dataListTextFormat",
    get: function get() {
      return this.dataModel.dataListTextFormat;
    },
    set: function set(value) {
      this.dataModel.dataListTextFormat = value;
    }
  }, {
    key: "dataListHrefFormat",
    get: function get() {
      return this.dataModel.dataListHrefFormat;
    },
    set: function set(value) {
      this.dataModel.dataListHrefFormat = value;
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (isNull(data) || !Array.isArray(data)) return;
      var options = [];

      for (var i = 0; i < data.length; i++) {
        var row = data[i];
        var option = {};

        try {
          var textFormat = this.dataModel.dataListTextFormat;
          if (textFormat.indexOf("{") < 0 && textFormat.indexOf("#[") < 0) textFormat = "{" + textFormat + "}";
          option.text = this._tfp.replaceDataField(row, textFormat);
          if (option.text) option.text = this._tfp.exeExpress(option.text);
        } catch (e) {
          console.log(e);
          return;
        }

        if (isNull(option.text)) continue;

        if (this.dataModel.dataListHrefFormat) {
          try {
            var hrefFormat = this.dataModel.dataListHrefFormat;
            if (hrefFormat.indexOf("{") < 0 && hrefFormat.indexOf("#[") < 0) hrefFormat = "{" + hrefFormat + "}";
            option.href = this._tfp.replaceDataField(row, hrefFormat);
            if (option.href) option.href = this._tfp.exeExpress(option.href);
          } catch (e) {
            console.log(e);
            return;
          }
        }

        if (isNull(option.href)) continue;
        options.push(option);
      }

      this.options = options;
    }
  }, {
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(options) {
      if (this._jqObj && options && Array.isArray(options)) {
        this.dataModel.options = options;

        if (this._jqObj) {
          this.reRender();
        }
      }
    }
  }, {
    key: "separator",
    get: function get() {
      return this.dataModel.separator;
    },
    set: function set(value) {
      this.dataModel.separator = ">";
      if (value && value.length == 1) this.dataModel.separator = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "reRender",
    value: function reRender() {
      this._jqObj.empty();

      this._jqObj.append(this.getBodyHtml());
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml) {
      var bodyHtml = "\r\n";
      var indent = this.getHtmlIndent();
      var color = "#303133";
      if (this._tfp.curPage.bgColorMode == 'dark') color = "#fff";

      for (var i = 0; i < this.dataModel.options.length; i++) {
        var option = this.dataModel.options[i];
        bodyHtml += indent + "<div><a";

        if (option.href && !this._tfp.isDesigning) {
          if (this.dataModel.onClick) bodyHtml += " href=\"javascript:void(0)\" onclick=\"".concat(this.dataModel.onClick, "\"");else bodyHtml += " href=\"javascript:void(0)\" onclick=\"tfp.openPage('" + option.text + "', '" + option.href + "')\"";
        }

        if (option.href) bodyHtml += " class=\"href_col\" style=\"font-weight:700;color:" + color + ";cursor:pointer;\"";
        bodyHtml += ">" + option.text + "</a><span>" + this.dataModel.separator + "</span></div>";
      }

      return bodyHtml + indent;
    }
    /**
     * 检查数据加载参数是否设置正确
     * @returns 
     */

  }, {
    key: "checkLoadDataArg",
    value: function checkLoadDataArg() {
      if (!this.dataModel.dataListTextFormat) {
        alert("请为[" + this.id + "]设置选项文本数据格式！");
        return false;
      }

      return true;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      }
    }
  }]);
  return Breadcrumb;
}(_controller.FormInput);

exports["default"] = Breadcrumb;