"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "BarCode",
  "comment": "条形码",
  "jsFiles": "barcode.min.js",
  "attrs": [{
    "name": "text",
    "comment": "文本内容",
    "type": "String",
    "default": "taskbuilder"
  }, {
    "name": "width",
    "comment": "条形码宽度",
    "type": "Int",
    "default": 190
  }, {
    "name": "height",
    "comment": "条形码高度",
    "type": "Int",
    "default": 90
  }, {
    "name": "displayValue",
    "comment": "是否显示文字",
    "type": "Switch",
    "default": false
  }, {
    "name": "textAlign",
    "comment": "水平对齐方式",
    "type": "Select",
    "default": "left",
    "options": [{
      "value": "left",
      "text": "左对齐"
    }, {
      "value": "center",
      "text": "居中"
    }, {
      "value": "right",
      "text": "右对齐"
    }]
  }, {
    "name": "textPosition",
    "comment": "垂直对齐方式",
    "type": "Select",
    "default": "top",
    "options": [{
      "value": "top",
      "text": "上对齐"
    }, {
      "value": "bottom",
      "text": "下对齐"
    }]
  }, {
    "name": "fontSize",
    "comment": "文字大小",
    "type": "Int",
    "default": 15
  }, {
    "name": "background",
    "comment": "背景颜色",
    "type": "String",
    "default": "white"
  }, {
    "name": "lineColor",
    "comment": "文字条码颜色",
    "type": "String",
    "default": "#272822"
  }, {
    "name": "margin",
    "comment": "条码边距",
    "type": "Int",
    "default": 0
  }],
  "styles": ["position", "margin", "border", "other"],
  "defaultStyles": {//默认拖拽出来的大小样式
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击时",
    "isNotHtmlEvent": true
  }, {
    "name": "onMouseOver",
    "comment": "鼠标经过时",
    "isNotHtmlEvent": true
  }, {
    "name": "onMouseOut",
    "comment": "鼠标移出时",
    "isNotHtmlEvent": true
  }],
  "methods": []
};
exports["default"] = _default;