"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

// 可视组件  
// 不可视组件

/**
 * 二维码组件
 * @param {[type]} dataModel [description]
 */
var BarCode = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(BarCode, _VisibleComponent);

  var _super = _createSuper(BarCode);

  // 全局组件tfp     数据模型   上级组件 最上层的是窗口 
  function BarCode(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, BarCode);
    return _super.call(this, __tfp, "BarCode", dataModel, parent);
  }

  (0, _createClass2["default"])(BarCode, [{
    key: "text",
    get: function get() {
      return this.dataModel.text;
    },
    set: function set(value) {
      this.dataModel.text = value;
      if (value) this.renderQr(value);
    }
  }, {
    key: "width",
    get: function get() {
      return this.dataModel.width;
    },
    set: function set(value) {
      this.dataModel.width = value;

      if (this._jqObj) {
        this._jqObj.css("width", value + "px");

        if (this._tfp.isDesigning) this._jqObj.css("background-size", this.dataModel.width + "px " + this.dataModel.height + "px");
      }
    }
  }, {
    key: "height",
    get: function get() {
      return this.dataModel.height;
    },
    set: function set(value) {
      this.dataModel.height = value;

      if (this._jqObj) {
        this._jqObj.css("height", value + "px");

        if (this._tfp.isDesigning) this._jqObj.css("background-size", this.dataModel.width + "px " + this.dataModel.height + "px");
      }
    }
  }, {
    key: "displayValue",
    get: function get() {
      return this.dataModel.displayValue;
    },
    set: function set(value) {
      this.dataModel.displayValue = value;
    }
  }, {
    key: "textAlign",
    get: function get() {
      return this.dataModel.textAlign;
    },
    set: function set(value) {
      this.dataModel.textAlign = value;
    }
  }, {
    key: "textPosition",
    get: function get() {
      return this.dataModel.textPosition;
    },
    set: function set(value) {
      this.dataModel.textPosition = value;
    }
  }, {
    key: "fontSize",
    get: function get() {
      return this.dataModel.fontSize;
    },
    set: function set(value) {
      this.dataModel.fontSize = value;
    }
  }, {
    key: "background",
    get: function get() {
      return this.dataModel.background;
    },
    set: function set(value) {
      this.dataModel.background = value;
    }
  }, {
    key: "lineColor",
    get: function get() {
      return this.dataModel.lineColor;
    },
    set: function set(value) {
      this.dataModel.lineColor = value;
    }
  }, {
    key: "margin",
    get: function get() {
      return this.dataModel.margin;
    },
    set: function set(value) {
      this.dataModel.margin = value;
    }
  }, {
    key: "renderQr",
    value: function renderQr(txt) {
      //运行时不生产图片，因为图片无法拖拽调整位置
      if (this._tfp.isDesigning) return;

      this._jqObj.empty();

      JsBarcode("#" + this.id, txt, {
        format: "CODE39",
        //选择要使用的条形码类型
        width: 3,
        //设置条之间的宽度
        height: this.dataModel.height,
        //高度
        displayValue: this.dataModel.displayValue,
        //是否在条形码下方显示文字
        text: txt,
        //覆盖显示的文本
        // fontOptions: "bold italic",//使文字加粗体或变斜体
        font: "fantasy",
        //设置文本的字体
        textAlign: this.dataModel.textAlign,
        //设置文本的水平对齐方式
        textPosition: this.dataModel.textPosition,
        //设置文本的垂直位置
        textMargin: 5,
        //设置条形码和文本之间的间距
        fontSize: this.dataModel.fontSize,
        //设置文本的大小
        background: this.dataModel.background,
        //设置条形码的背景
        lineColor: this.dataModel.lineColor,
        //设置条和文本的颜色。
        margin: this.dataModel.margin
      });
    }
  }, {
    key: "initDesigning",
    value: function initDesigning() {
      if (this._jqObj) {
        if (this._jqObj.parent().get(0).tagName == "TD") {
          this._jqObj.css("vertical-align", "middle");

          if (!(this.dataModel.styles && this.dataModel.styles.display)) this._jqObj.css("display", "inline-block");
        }
      }
    } // 初始化 运行时   页面渲染完成执行

  }, {
    key: "initRuntime",
    value: function initRuntime() {
      this.initDesigning();
      var that = this;
      var txt = this.dataModel.text;

      if (!txt) {
        txt = "taskbuilder";
      }

      if (that.dataModel.margin) {
        that.dataModel.margin = parseInt(that.dataModel.margin);
      } //如果不是动态绑定的后台数据，则初始化时即可渲染，否则需要等绑定数据后再渲染


      if (txt.indexOf("{") < 0) this.renderQr(txt);

      this._jqObj.click(function () {
        if (that.dataModel.onClick) {
          eval(that.dataModel.onClick);
        }
      });
    }
  }, {
    key: "styleOnChange",
    value: function styleOnChange(styleName, styleValue) {
      if (this._tfp.isDesigning && (styleName == "width" || styleName == "height")) {
        if (styleName == "width") {
          this.width = this._tfp.getPx(styleValue);
        } else if (styleName == "height") {
          this.height = this._tfp.getPx(styleValue);
        }
      }
    }
  }]);
  return BarCode;
}(_controller.VisibleComponent);

exports["default"] = BarCode;