"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Audio",
  "comment": "音频组件",
  "attrs": [{
    "name": "src",
    "comment": "音频文件路径",
    "type": "String"
  }, {
    "name": "width",
    "comment": "宽度",
    "type": "Int",
    "default": 400
  }, {
    "name": "controls",
    "comment": "是否显示组件",
    "type": "Switch",
    "default": true
  }, {
    "name": "loop",
    "comment": "循环播放",
    "type": "Switch",
    "default": false
  }, {
    "name": "muted",
    "comment": "静音播放",
    "type": "Switch",
    "default": false
  }, {
    "name": "autoplay",
    "comment": "自动播放",
    "type": "Switch",
    "default": false
  }],
  "styles": ["position", "margin", "border", "other"],
  "defaultStyles": {//默认拖拽出来的大小样式
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击时",
    "isNotHtmlEvent": true
  }, {
    "name": "onMouseOver",
    "comment": "鼠标经过时",
    "isNotHtmlEvent": true
  }, {
    "name": "onMouseOut",
    "comment": "鼠标移出时",
    "isNotHtmlEvent": true
  }],
  "methods": [{
    "name": "play",
    "comment": "播放"
  }, {
    "name": "pause",
    "comment": "暂停"
  }]
};
exports["default"] = _default;