"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = [{
  "id": "Container",
  "name": "容器组件",
  "components": [{
    "name": "Layout",
    "comment": "布局",
    "dependencies": ["Panel"]
  }, {
    "name": "Panel",
    "comment": "面板",
    "matchAllClient": true
  }, {
    "name": "FlexPanel",
    "comment": "弹性面板",
    "matchAllClient": true
  }, {
    "name": "FlexBox",
    "comment": "弹性栅格",
    "matchAllClient": true,
    "dependencies": ["Panel", "FlexPanel"]
  }, {
    "name": "GridCell",
    "comment": "数据表格单元格",
    "dependent": true
  }, {
    "name": "Table",
    "comment": "普通表格",
    "matchAllClient": true
  }, {
    "name": "Grid",
    "comment": "数据表格Old",
    "dependencies": ["GridCell"],
    "dependent": true
  }, {
    "name": "GridView",
    "comment": "数据表格",
    "dependencies": ["GridCell"]
  }, {
    "name": "DataSet",
    "comment": "可编辑表格"
  }, {
    "name": "Form",
    "comment": "表单",
    "matchAllClient": true
  }, {
    "name": "TabPage",
    "comment": "选项页",
    "matchAllClient": true,
    "dependent": true
  }, {
    "name": "Tab",
    "comment": "选项卡",
    "matchAllClient": true,
    "dependencies": ["TabPage"]
  }, {
    "name": "DataCard",
    "comment": "数据卡片",
    "matchAllClient": true
  }, {
    "name": "Tree",
    "comment": "树形组件"
  }, {
    "name": "CollapseItem",
    "comment": "折叠面板项目",
    "dependent": true
  }, {
    "name": "Collapse",
    "comment": "折叠面板",
    "dependencies": ["CollapseItem"]
  }, {
    "name": "Iframe",
    "comment": "嵌入页面",
    "matchAllClient": true
  }, {
    "name": "Gridbox",
    "comment": "宫格",
    "dependencies": ["Panel", "Row"]
  }, {
    "name": "Row",
    "comment": "宫格行",
    "dependencies": ["Col"]
  }, {
    "name": "Col",
    "comment": "宫格列"
  }, {
    "name": "Cellbox",
    "comment": "单元",
    "dependencies": ["Cellitem"]
  }, {
    "name": "Cellitem",
    "comment": "单元明细"
  }, {
    "name": "UserComponent",
    "comment": "自定义组件",
    "matchAllClient": true
  }]
}, {
  "id": "ReadOnlyInput",
  "name": "只读组件",
  "components": [{
    "name": "Button",
    "comment": "按钮",
    "matchAllClient": true
  }, {
    "name": "Link",
    "comment": "链接",
    "matchAllClient": true
  }, {
    "name": "Label",
    "comment": "文本标签",
    "matchAllClient": true
  }, {
    "name": "Pre",
    "comment": "文本段落",
    "matchAllClient": true
  }, {
    "name": "Heading",
    "comment": "标题",
    "matchAllClient": true
  }, {
    "name": "Line",
    "comment": "分割线",
    "matchAllClient": true
  }, {
    "name": "List",
    "comment": "只读列表",
    "matchAllClient": true
  }, {
    "name": "Dropdown",
    "comment": "弹出菜单"
  }, {
    "name": "Image",
    "comment": "图片",
    "matchAllClient": true
  }, {
    "name": "ImageList",
    "comment": "图片组"
  }, {
    "name": "FileList",
    "comment": "文件组"
  }, {
    "name": "Calendar",
    "comment": "日历"
  }, {
    "name": "Progress",
    "comment": "进度条",
    "matchAllClient": true
  }, {
    "name": "Steps",
    "comment": "步骤条"
  }, {
    "name": "TimeLine",
    "comment": "时间线",
    "matchAllClient": true
  }, {
    "name": "Marquee",
    "comment": "跑马灯"
  }, {
    "name": "Breadcrumb",
    "comment": "面包屑"
  }]
}, {
  "id": "Input",
  "name": "基础输入项",
  "components": [{
    "name": "Text",
    "comment": "单行输入框",
    "matchAllClient": true
  }, {
    "name": "TextArea",
    "comment": "多行输入框",
    "matchAllClient": true
  }, {
    "name": "Radio",
    "comment": "单选框",
    "matchAllClient": true
  }, {
    "name": "CheckBox",
    "comment": "复选框",
    "matchAllClient": true
  }, {
    "name": "Select",
    "comment": "下拉列表"
  }, {
    "name": "PopupList",
    "comment": "弹出列表"
  }, {
    "name": "PopupSelection",
    "comment": "弹窗选择"
  }, {
    "name": "Cascader",
    "comment": "级联选择"
  }, {
    "name": "Switch",
    "comment": "开关",
    "matchAllClient": true
  }, {
    "name": "InputNumber",
    "comment": "计数器",
    "matchAllClient": true
  }, {
    "name": "Slider",
    "comment": "滑块",
    "matchAllClient": true
  }, {
    "name": "Date",
    "comment": "日期"
  }, {
    "name": "Time",
    "comment": "时间"
  }, {
    "name": "DateTime",
    "comment": "日期时间"
  }, {
    "name": "DateRange",
    "comment": "日期范围"
  }, {
    "name": "Transfer",
    "comment": "穿梭框"
  }, {
    "name": "CKEditor",
    "comment": "富文本"
  }, {
    "name": "PhotoUpload",
    "comment": "图片上传"
  }, {
    "name": "FileUpload",
    "comment": "文件上传",
    "matchAllClient": true
  }, {
    "name": "Password",
    "comment": "密码",
    "matchAllClient": true
  }, {
    "name": "Hidden",
    "comment": "隐藏域",
    "matchAllClient": true
  }]
}, {
  "id": "InputEx",
  "name": "扩展输入项",
  "components": [{
    "name": "Dep",
    "comment": "部门"
  }, {
    "name": "User",
    "comment": "用户"
  }, {
    "name": "Role",
    "comment": "角色"
  }, {
    "name": "OrgPicker",
    "comment": "组织",
    "matchAllClient": true
  }, {
    "name": "DataDic",
    "comment": "数据字典"
  }, {
    "name": "EncodingRule",
    "comment": "编码规则",
    "matchAllClient": true
  }, {
    "name": "CascaderRegion",
    "comment": "地区选择"
  }, {
    "name": "IconPicker",
    "comment": "图标选择"
  }, {
    "name": "PathPicker",
    "comment": "路径选择"
  }, {
    "name": "ColorPicker",
    "comment": "颜色选择"
  }, {
    "name": "QrCode",
    "comment": "二维码",
    "matchAllClient": true
  }, {
    "name": "BarCode",
    "comment": "条形码",
    "matchAllClient": true
  }, {
    "name": "Schedule",
    "comment": "日程"
  }, {
    "name": "GanttChart",
    "comment": "甘特图"
  }, {
    "name": "Swiper",
    "comment": "轮播图",
    "matchAllClient": true
  }, {
    "name": "Rate",
    "comment": "评分",
    "matchAllClient": true
  }, {
    "name": "Sign",
    "comment": "签章",
    "matchAllClient": true
  }, {
    "name": "Icon",
    "comment": "小图标"
  }, {
    "name": "CounterSign",
    "comment": "会签",
    "dependent": true
  }, {
    "name": "RichText",
    "comment": "富文本old",
    "dependent": true
  }]
}, {
  "id": "Invisible",
  "name": "不可视组件",
  "components": [{
    "name": "Service",
    "comment": "服务请求",
    "matchAllClient": true,
    "isInvisible": true
  }, {
    "name": "Timer",
    "comment": "定时器",
    "matchAllClient": true,
    "isInvisible": true
  }]
}, {
  "id": "ImportExport",
  "name": "导入导出",
  "components": [{
    "name": "ExcelImport",
    "comment": "Excel导入"
  }, {
    "name": "ExcelExport",
    "comment": "Excel导出"
  }]
}, {
  "id": "Chart",
  "name": "统计图表",
  "components": [{
    "name": "ChartLine",
    "comment": "折线图",
    "matchAllClient": true
  }, {
    "name": "ChartBar",
    "comment": "柱状图",
    "matchAllClient": true
  }, {
    "name": "ChartBarY",
    "comment": "条形图",
    "matchAllClient": true
  }, {
    "name": "ChartLineBar",
    "comment": "线柱结合图",
    "matchAllClient": true
  }, {
    "name": "ChartPie",
    "comment": "饼状图",
    "matchAllClient": true
  }, {
    "name": "ChartAnnular",
    "comment": "环形图",
    "matchAllClient": true
  }]
}, {
  "id": "Media",
  "name": "媒体组件",
  "components": [{
    "name": "Audio",
    "comment": "音频",
    "matchAllClient": true
  }, {
    "name": "Video",
    "comment": "视频",
    "matchAllClient": true
  }]
}];
exports["default"] = _default;