"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _TFPStatements = _interopRequireDefault(require("./TFPStatements.js"));

var TFPGUIFuncCompiler = /*#__PURE__*/function () {
  function TFPGUIFuncCompiler() {
    (0, _classCallCheck2["default"])(this, TFPGUIFuncCompiler);
    this.smCategoryDic = {};
    this.smTypesDic = {};
  }

  (0, _createClass2["default"])(TFPGUIFuncCompiler, [{
    key: "init",
    value: function init() {
      for (var i = 0; i < _TFPStatements["default"].length; i++) {
        var category = _TFPStatements["default"][i];
        this.smCategoryDic[category.name] = category;

        for (var j = 0; j < category.statements.length; j++) {
          var sm = category.statements[j];
          this.smTypesDic[category.name + "_" + sm.name] = sm;
        }
      }
    }
  }, {
    key: "getSMTypeInfo",
    value: function getSMTypeInfo(categoryName, smName) {
      return this.smTypesDic[categoryName + "_" + smName];
    }
  }, {
    key: "getVars",
    value: function getVars(funcObj, jsGlobalVars) {
      //存储以定义的变量信息，以便后续语句判断变量是否已声明
      var vars = {}; //全局变量

      if (jsGlobalVars && jsGlobalVars.length > 0) {
        for (var i = 0; i < jsGlobalVars.length; i++) {
          vars[jsGlobalVars[i].name] = "global";
        }
      } //函数参数


      if (funcObj.args && funcObj.args.length > 0) {
        for (var _i = 0; _i < funcObj.args.length; _i++) {
          vars[funcObj.args[_i].name] = "arg";
        }
      }

      return vars;
    }
  }, {
    key: "compile",
    value: function compile(funcObj, jsGlobalVars) {
      if (!funcObj || !funcObj.statements || funcObj.statements.length == 0) return "";
      var vars = this.getVars(funcObj, jsGlobalVars);
      var js = "";

      for (var i = 0; i < funcObj.statements.length; i++) {
        js += this.getStatementJs(vars, funcObj.statements[i], "\t");
      }

      return js;
    }
  }, {
    key: "formatStrVar",
    value: function formatStrVar(str) {
      var ret = str;
      var patt = new RegExp("\\{([\\w|.|%|\\u4E00-\\u9FA5]*)\\}", "g");
      var result = patt.exec(ret);

      while (result != null) {
        var varName = result[0];
        varName = varName.substring(1, varName.length - 1);
        ret = ret.replace("{" + varName + "}", "'+" + varName + "+'");
        patt = new RegExp("\\{([\\w|.|%|\\u4E00-\\u9FA5]*)\\}", "g");
        result = patt.exec(ret);
      }

      return ret;
    }
  }, {
    key: "getSMInputInfo",
    value: function getSMInputInfo(smtype, inputName) {
      if (!smtype.inputs || smtype.inputs.length == 0) return null;

      for (var i = 0; i < smtype.inputs.length; i++) {
        var ipt = smtype.inputs[i];
        if (ipt.name == inputName) return ipt;
      }

      return null;
    }
  }, {
    key: "formatExpress",
    value: function formatExpress(smType, sm, prefix) {
      if (!smType.format) return "";
      var val = smType.format;
      var patt = new RegExp("\\{([\\w|.|%|\\u4E00-\\u9FA5]*)\\}", "g");
      var result = patt.exec(val);

      while (result != null) {
        var argName = result[0];
        argName = argName.substring(1, argName.length - 1);
        var argVal = "";

        if (argName == "_prefix") {
          argVal = prefix;
        } else if (sm[argName] || sm[argName] == 0) {
          argVal = sm[argName];

          if (typeof argVal == "string" && argVal.indexOf("{") >= 0 && argVal.indexOf("}") > 0) {
            argVal = this.formatStrVar(argVal);
          }
        } else {
          var ipt = this.getSMInputInfo(smType, argName); //如果设置了用户输入的值为空时

          if (ipt && ipt.nullVal) {
            argVal = ipt.nullVal;
          }
        }

        val = val.replace("{" + argName + "}", argVal);
        patt = new RegExp("\\{([\\w|.|%|\\u4E00-\\u9FA5]*)\\}", "g");
        result = patt.exec(val);
      }

      return val;
    }
  }, {
    key: "getStatementJs",
    value: function getStatementJs(vars, sm, prefix, isArg) {
      if (sm.disabled) return "";
      var smType = this.getSMTypeInfo(sm.category, sm.type);
      if (!smType) return ""; //检查必填项，如果必填项为空，则不生成该语句

      if (smType.inputs && smType.inputs.length > 0) {
        for (var i = 0; i < smType.inputs.length; i++) {
          var ipt = smType.inputs[i];
          var iptVal = sm[ipt.name];

          if (ipt.required && !iptVal && iptVal != 0) {
            return "";
          }
        }
      }

      var js = "";

      if (sm.category == "logic" || sm.category == "common") {
        return this.getCommonStatementJs(vars, smType, sm, prefix, isArg);
      } else {
        if (sm.category == "component") {
          js += this.getCptStatementJs(vars, smType, sm, prefix, isArg);
        } else {
          if (!isArg || sm.statements) js += prefix;
          js += this.addReturnVar(vars, sm);
          js += this.formatExpress(smType, sm, prefix);
          if (!isArg || sm.statements) js += ";\r\n";
        }
      }

      var mergeArgs = {};
      var haveMergeCbFunc = false; //判断有没有需要合并的参数

      if (smType.inputs && smType.inputs.length > 0) {
        for (var _i2 = 0; _i2 < smType.inputs.length; _i2++) {
          var _ipt = smType.inputs[_i2];

          if (_ipt.mergeTo) {
            if (!mergeArgs[_ipt.mergeTo]) mergeArgs[_ipt.mergeTo] = {};
            var mergeArg = mergeArgs[_ipt.mergeTo];

            if (_ipt.type == "cbFunc") {
              mergeArg[_ipt.name] = this.formatExpress(_ipt, sm, prefix);
              haveMergeCbFunc = true;
            } else {
              mergeArg[_ipt.name] = sm[_ipt.name];
            }
          }
        }
      }

      for (var p in mergeArgs) {
        var _mergeArg = mergeArgs[p];
        var jsMerge = "";

        for (var pp in _mergeArg) {
          var v = _mergeArg[pp];
          if (v == null || v == undefined) continue;
          if (jsMerge != "") jsMerge += ",\r\n";
          jsMerge += prefix + "\t\"" + pp + "\": " + (v + "").replaceAll("'", '"');
        }

        var _ii = js.indexOf("[[" + p + "]]");

        if (_ii > 0) {
          js = js.substring(0, _ii) + "{\r\n" + jsMerge + "\r\n" + prefix + "}" + js.substring(_ii + p.length + 4);
        }
      }

      var jss = ""; //判断有没有子语句

      if (sm.statements && sm.statements.length > 0) {
        for (var _i3 = 0; _i3 < sm.statements.length; _i3++) {
          jss += this.getStatementJs(vars, sm.statements[_i3], prefix + "\t" + (haveMergeCbFunc ? "\t" : ""), isArg);
        }
      }

      var ii = js.indexOf("[[statements]]");

      if (ii > 0) {
        js = js.substring(0, ii) + "\r\n" + jss + (haveMergeCbFunc ? "\t" : "") + prefix + js.substring(ii + 14);
      }

      return js;
    }
  }, {
    key: "getCommonStatementJs",
    value: function getCommonStatementJs(vars, smType, sm, prefix, isArg) {
      var js = "";

      switch (sm.type.toLowerCase()) {
        case "if":
          var condition = sm.condition;
          js = prefix + "if(" + condition + ") {\r\n";

          if (sm.statements) {
            for (var i = 0; i < sm.statements.length; i++) {
              js += this.getStatementJs(vars, sm.statements[i], prefix + "\t", isArg);
            }
          }

          js += prefix + "}";

          if (sm.elseIfStatements) {
            for (var _i4 = 0; _i4 < sm.elseIfStatements.length; _i4++) {
              var smElseIf = sm.elseIfStatements[_i4];
              js += " else if(" + smElseIf.condition + ") {\r\n";

              if (smElseIf.statements) {
                for (var j = 0; j < smElseIf.statements.length; j++) {
                  js += this.getStatementJs(vars, smElseIf.statements[j], prefix + "\t");
                }
              }

              js += prefix + "}";
            }
          }

          if (sm.elseStatements) {
            js += " else {\r\n";

            for (var _i5 = 0; _i5 < sm.elseStatements.length; _i5++) {
              js += this.getStatementJs(vars, sm.elseStatements[_i5], prefix + "\t");
            }

            js += prefix + "}";
          }

          js += "\r\n";
          break;

        case "for":
          js = prefix + "for(let " + sm.indexVar + "=" + sm.indexStart + "; " + sm.indexVar + "<" + sm.cycleNumber + "; " + sm.indexVar + "++) {\r\n";

          if (sm.statements) {
            for (var _i6 = 0; _i6 < sm.statements.length; _i6++) {
              js += this.getStatementJs(vars, sm.statements[_i6], prefix + "\t");
            }
          }

          js += prefix + "}\r\n";
          break;

        case "iteratearray":
          var attValJs = sm.arrVar;
          js = prefix + "for(let " + sm.indexVar + " = " + sm.startIndex + "; " + sm.indexVar + "<" + attValJs + ".length; " + sm.indexVar + "++) {\r\n";

          if (sm.statements) {
            for (var _i7 = 0; _i7 < sm.statements.length; _i7++) {
              js += this.getStatementJs(vars, sm.statements[_i7], prefix + "\t");
            }
          }

          js += prefix + "}\r\n";
          break;

        case "iterateobject":
          var objVarJs = sm.objVar;
          js = prefix + "for(let " + sm.propVar + " in " + objVarJs + ") {\r\n";

          if (sm.statements) {
            for (var _i8 = 0; _i8 < sm.statements.length; _i8++) {
              js += this.getStatementJs(vars, sm.statements[_i8], prefix + "\t");
            }
          }

          js += prefix + "}\r\n";
          break;

        case "return":
          js = prefix + "return";
          js += sm.retVal || sm.retVal == 0 ? " " + sm.retVal : "";
          js += ";\r\n";
          break;

        case "callfunc":
          js = this.getCallFuncJs(vars, sm, prefix, isArg);
          break;

        case "comment":
          if (!sm.message) return "";
          js += prefix + "//" + sm.message + "\r\n";
          break;

        case "declare":
          vars[sm.varName] = "local";
          js += prefix + "let " + sm.varName;
          if (sm.defaultVal) js += " = " + sm.defaultVal;
          js += ";\r\n";
          break;

        case "assign":
          js += prefix + sm.varName + " " + sm.operator + " " + sm.value + ";\r\n";
          break;

        case "custom":
          if (!sm.content) return "";
          if (!isArg) js = prefix;
          js += sm.content;
          if (!isArg) js += ";\r\n";
          break;

        default:
          js += prefix + this.formatExpress(smType, sm, prefix) + ";\r\n";
          break;
      }

      return js;
    }
  }, {
    key: "getCallFuncJs",
    value: function getCallFuncJs(vars, sm, prefix, isArg) {
      var js = "";
      if (!sm.funcName) return "";
      if (!isArg || sm.statements) js = prefix; //如果有返回值变量

      if (sm.args && sm.args.length > 0) {
        for (var i = 0; i < sm.args.length; i++) {
          var arg = sm.args[i];

          if (arg.name == "retVarName" && arg.value) {
            js += "let " + arg.value + " = ";
            break;
          }
        }
      }

      if (sm.cptId) js += sm.cptId + ".";
      js += sm.funcName + "(";

      if (sm.args && sm.args.length > 0) {
        for (var _i9 = 0; _i9 < sm.args.length; _i9++) {
          var _arg = sm.args[_i9];
          if (_arg.name == "retVarName") continue;
          if (_i9 > 0) js += ", ";

          var argType = _arg.type.toLowerCase();

          if ((!_arg.value || _arg.value == "") && _arg.value + "" != "0" && argType != "function") {
            //如果必须的参数为空，则不编译
            if (_arg.required) return "";
            js += "null";
            continue;
          }

          js += _arg.value;
          /*if(argType=="int" || argType=="float" || argType=="number" || argType=="bool" 
            || argType=="array" || argType=="object" || argType=="undefined") {
              js += arg.value;
          } else if(argType=="px") {
              let val = arg.value+"";
              if(val.indexOf("px")<0 && val.indexOf("%")<0) val += "px";
              js += val;
          } else if(argType=="date") {
              let val = arg.value+"";
              if(arg.value.indexOf("Date(")<0) {
                  js += "'"+arg.value+"'";
              } else {
                  js += arg.value;
              }
          } else if(argType=="function") {
              if(arg.enabled) {
                  js += "function(";
                  if(arg.args) {
                      for(let j=0;j<arg.args.length;j++) {
                          let funcArg = arg.args[j];
                          if(j>0) js += ", ";
                          js += funcArg.value;
                      }
                  }
                  js += ") {\r\n";
                  if(sm.statements) {
                      for (let i = 0; i < sm.statements.length; i++) {
                          js += this.getStatementJs(vars, sm.statements[i], prefix + "\t");
                      }
                  }
                  js += prefix + "}";
              }
          } else {
              js += "'"+arg.value+"'";
          }*/
        }
      }

      if (sm.haveCbFunc) {
        if (sm.args && sm.args.length > 0) js += " ,";
        js += " function(";

        if (sm.cbArgs && sm.cbArgs.length > 0) {
          for (var _i10 = 0; _i10 < sm.cbArgs.length; _i10++) {
            js += (_i10 > 0 ? ", " : "") + sm.cbArgs[_i10].name;
          }
        }

        js += ") {\r\n";

        if (sm.statements) {
          for (var _i11 = 0; _i11 < sm.statements.length; _i11++) {
            js += this.getStatementJs(vars, sm.statements[_i11], prefix + "\t");
          }
        }

        js += prefix + "}";
      }

      js += ");\r\n";
      return js;
    }
  }, {
    key: "addReturnVar",
    value: function addReturnVar(vars, sm) {
      var js = ""; //如果有返回值变量

      if (sm.retVarName) {
        //如果语句格式字符串里没有retVarName参数
        if (!sm.format || sm.format.indexOf("{retVarName}") < 0) {
          //如果该变量没有定义，则加上变量定义关键字，并添加到以定义变量列表中
          if (!vars[sm.retVarName]) {
            js += "let ";
            vars[sm.retVarName] = "local";
          }
        }

        js += sm.retVarName + " = ";
      }

      return js;
    }
  }, {
    key: "getCptStatementJs",
    value: function getCptStatementJs(vars, smType, sm, prefix, isArg) {
      if (!sm.cptId && !(sm.type == "tfp.use" || sm.type == "tfp.new" || sm.type == "tfp.render")) return "";
      var js = "";

      switch (sm.type) {
        case "batchSetCptAttr":
          if (!sm.attrs) return "";

          for (var attrName in sm.attrs) {
            js += prefix + sm.cptId + ".attr('" + attrName + "', " + sm.attrs[attrName] + ");\r\n";
          }

          break;

        case "batchSetCptCss":
          if (!sm.styles) return "";

          for (var styleName in sm.styles) {
            js += prefix + sm.cptId + ".css('" + styleName + "', '" + sm.styles[styleName] + "');\r\n";
          }

          break;

        case "callCptFunc":
          js = this.getCallFuncJs(vars, sm, prefix, isArg);
          break;

        default:
          if (!isArg || sm.statements) js += prefix;
          js += this.addReturnVar(vars, sm);
          js += this.formatExpress(smType, sm, prefix);
          if (!isArg || sm.statements) js += ";\r\n";
          break;
      }

      return js;
    }
  }]);
  return TFPGUIFuncCompiler;
}();

exports["default"] = TFPGUIFuncCompiler;

if (typeof window != "undefined") {
  window.guiFuncCompiler = new TFPGUIFuncCompiler();
  window.guiFuncCompiler.init();
}