/**
 * 企业微信客户端浏览器扩展对象
 * @type {TaskMsgClient}
 */

// 获取登录类型
var loginType = localStorage.getItem('loginType') ? localStorage.getItem('loginType') : "mobile"

function TaskMsgClient() {
  this.TMiOSClientIsInit = false; //iOS客户端是否已初始化
  this.isDisableGoBack = false; //是否禁止退回
  this.AndroidClientCallBackFuncIndex = 1000; //安卓客户端回调函数索引
  this.clientOSType = ""; //客户端类型
  this.mobileType = 'workwx';

  /**
   * 初始化客户端对象
   * @return {[type]} [description]
   */
  this.init = function () {
    // alert(navigator.userAgent)
    //获得客户端类型
    if (navigator.userAgent.indexOf("iPhone") > 0) {
      if (navigator.userAgent.indexOf("Safari") > 0) {
        this.clientOSType = "web";
      } else {
        this.clientOSType = "iOS";
      }
    } else if (
      navigator.userAgent.indexOf("Windows") > 0 ||
      navigator.userAgent.indexOf("Mac OS") > 0) {
      this.clientOSType = "PC";
    } else {
      this.clientOSType = "Android";
    }
  };

  //以下变量为私有变量，不能暴露在外面
  this._sessionId;
  this._loginname;
  this._orgCode;
  this._orgKey;
  this._userId;
  this._datatype;
  this._pwd;
  this.haveLoad = false;

  /**
   * 获取authData
   */
  this.loadAuthData = function () {
    this._sessionId = localStorage.getItem("s");
    if (localStorage.getItem("loginType") == 'mobile') {
      this._loginname = localStorage.getItem("mobile");
    } else {
      this._loginname = localStorage.getItem("l");
    }
    this._pwd = localStorage.getItem("p");
    var authData = localStorage.getItem("d");
    var authTs = localStorage.getItem("t");
    if (authData) {
      var ivData = [this._loginname, this._pwd, 'web', parseInt(authTs)];
      var iv = CryptoJS.MD5(JSON.stringify(ivData)).toString().substr(0, 16);
      ivData.push(iv);
      var key = CryptoJS.MD5(JSON.stringify(ivData)).toString();

      var data = CryptoJS.AES.decrypt(authData,
        CryptoJS.enc.Utf8.parse(key), {
        iv: CryptoJS.enc.Utf8.parse(iv),
        mode: CryptoJS.mode.CBC
      }).toString(CryptoJS.enc.Utf8);
      var arr = JSON.parse(data);
      this._orgCode = arr[0];
      this._userId = arr[1];
      this._orgKey = arr[2];
      if (arr.length >= 4) _datatype = arr[3];

      arr = null;
      data = null;
      ivData = null;
      this.haveLoad = true;
    }
  };

  this.setAuthData = function (service) {
    if (!this._orgCode || !this._orgKey) {
      return;
    }
    if (!service.args) service.args = {};
    service.args.sessionId = this._sessionId;
    service.args._auth_ts = (new Date()).getTime();
    service.args._auth_org = this._orgCode;
    var signData = [this._orgCode, this._orgKey, service.args._auth_ts];
    var iv = CryptoJS.MD5(JSON.stringify(signData)).toString().substr(0, 16);
    signData.push(iv);
    var key = CryptoJS.MD5(JSON.stringify(signData)).toString();
    var loginData = "";
    if (_datatype && _datatype == 'accountcode') {
      loginData = ['accountcode', _userId, 'web'];
    }
    else if (this._userId && this._userId != "") {
      loginData = ['userid', this._userId, 'web'];
    } else {
      loginData = ['loginname', this._loginname, 'web'];
    }
    signData.push(this._pwd);
    //暂时不对请求参数进行签名，因为服务器端怎么校验还没想清楚
    //for(p in msg) {
    //signData.push(msg[p]);
    //}
    loginData.push(CryptoJS.MD5(JSON.stringify(signData)).toString());
    signData = null;
    if (service.encArgs) loginData.push(JSON.stringify(service.encArgs));
    service.args._auth_data = CryptoJS.AES.encrypt(JSON.stringify(loginData),
      CryptoJS.enc.Utf8.parse(key), {
      iv: CryptoJS.enc.Utf8.parse(iv),
      mode: CryptoJS.mode.CBC
    }).toString();
    return service;
  };

  this.encryptRequestData = function (p, args) {
    if (p.encryptRequestArgs) {
      var eniv = "";
      var enkey = "";
      if (p._auth_ts) {
        var ensign = [p._orgCode || _orgCode, p._orgKey || _orgKey, p._auth_ts];
        eniv = CryptoJS.MD5(JSON.stringify(ensign)).toString().substr(0, 16);
        ensign.push(eniv);
        enkey = CryptoJS.MD5(JSON.stringify(ensign)).toString();
      }
      else {
        eniv = CryptoJS.MD5('1234567890abcdef1234567890abcdef').toString().substr(0, 16);
        enkey = CryptoJS.MD5('tasgine-meanssoft').toString();
      }

      var enargs = p.encryptRequestArgs.split(',');
      for (let i = 0; i < enargs.length; i++) {
        var arg = args[enargs[i]];
        if (arg !== null && typeof arg !== 'undefined') {
          if (typeof arg === 'object') {
            args[enargs[i]] = CryptoJS.AES.encrypt(JSON.stringify(arg),
              CryptoJS.enc.Utf8.parse(enkey), {
              iv: CryptoJS.enc.Utf8.parse(eniv),
              mode: CryptoJS.mode.CBC
            }).toString();
          }
          else {
            args[enargs[i]] = CryptoJS.AES.encrypt(arg.toString(),
              CryptoJS.enc.Utf8.parse(enkey), {
              iv: CryptoJS.enc.Utf8.parse(eniv),
              mode: CryptoJS.mode.CBC
            }).toString();
          }
        }
      }
    }
  };

  this.decryptResponseData = function (p, args) {
    if (p.encryptResponseArgs) {
      var eniv = "";
      var enkey = "";
      if (p._auth_ts) {
        var ensign = [p._orgCode || _orgCode, p._orgKey || _orgKey, p._auth_ts];
        eniv = CryptoJS.MD5(JSON.stringify(ensign)).toString().substr(0, 16);
        ensign.push(eniv);
        enkey = CryptoJS.MD5(JSON.stringify(ensign)).toString();
      }
      else {
        eniv = CryptoJS.MD5('1234567890abcdef1234567890abcdef').toString().substr(0, 16);
        enkey = CryptoJS.MD5('tasgine-meanssoft').toString();
      }

      var enargs = p.encryptResponseArgs.split(',');
      for (let i = 0; i < enargs.length; i++) {
        var arg = args[enargs[i]];
        if (arg) {
          args[enargs[i]] = CryptoJS.AES.decrypt(arg,
            CryptoJS.enc.Utf8.parse(enkey), {
            iv: CryptoJS.enc.Utf8.parse(eniv),
            mode: CryptoJS.mode.CBC
          }).toString(CryptoJS.enc.Utf8);
          try {
            args[enargs[i]] = JSON.parse(args[enargs[i]]);
          } catch (e) { }
        }
      }
    }
  };

  var authLogin = false; //自动登录
  var code = getUrlArg("code");
  var tsDiff = 0;
  var dUserId = '' //企业微信用户id
  var mobile = '';

  // 登录页初始化加载
  this.checkLogin = function (loadobj, cb) {
    // localStorage.clear()
    var that = this;
    localStorage.setItem('loginType', loginType);
    dUserId = localStorage.getItem('u');
    var loginInfo = localStorage.getItem('l');
    var pwd = localStorage.getItem('p');
    if (dUserId && pwd && loginInfo) {
      authLogin = true;
      return cb(true)

    } else {
      authLogin = false;
    }
    that.getloginData(cb);
  }

  this.getloginData = function (cb) {
    var args = {};
    var that = this;
    args.notAuth = true;
    var service = new TaskMsgService();
    service.path = "sys/service/getSysData";
    service.request(args, function (req, res) {
      localStorage.setItem('orgcode', res.orgcode);
      if (res.ts) tsDiff = new Date().getTime() - res.ts;
      var getAny = { wx: "corpid,agentid,directLogin,realmName,home,home_,login" };
      that.getwxInfo(getAny, function (cb) {
        that.getCode(cb);
      });
    });
  }

  // 放入企业微信设置内容
  this.getwxInfo = function (getAny, cb) {
    var args = {};
    var that = this;
    args.filepath = window.location.pathname.split('app/')[1].split('/')[0];
    args.getAny = getAny;
    var service = new TaskMsgService();
    service.path = "dev/service/proj/getPro";
    service.request(args, function (req, res) {
      if (res.data) {
        if (getAny.wx) {
          getAny.wx = getAny.wx.split(',');
          for (var x = 0; x < getAny.wx.length; x++) {
            that[getAny.wx[x]] = res.data.wx[getAny.wx[x]];
            localStorage.setItem(getAny.wx[x], res.data.wx[getAny.wx[x]]);
          }
        }
        cb();
      } else {
        alert('请设置企业微信配置！');
        cb(false)
        return
      }
    });
  }

  this.getCode = function (cb) {
    if (!code || code == '') {
      alert('获取授权码失败，请检查应用配置！');
      return cb(false);
    }
    var that = this;
    if (authLogin) {
      that.tologin({}, cb);
    } else {
      that.getUserinfo(cb);
    }
  }

  //获取企业微信用户信息
  this.getUserinfo = function (cb) {
    var that = this;
    let args = {};
    args.notAuth = true;
    args.filepath = window.location.pathname.split('app/')[1].split('/')[0];
    args.code = code;
    var service = new TaskMsgService();
    service.path = "sys/service/workweixin/getOauth2Weixin";
    service.request(args,
      function (req, res) {
        dUserId = res.userid;
        mobile = res.userinfo.mobile;
        localStorage.setItem("mobile", mobile);
        localStorage.setItem('u', dUserId);
        // alert(that.login)
        tfp.gotoPage(that.login);
        cb(false)
        // location = that.login;
      });

  }

  // 登录
  this.tologin = function (loginobj, cb) {
    var that = this;
    var args = {};
    if (!authLogin) {
      if (loginType == 'mobile') {
        args.mobile = $("#mobile").val();
        if (!args.mobile) {
          alert('请输入手机号！');
          $("#mobile").focus();
          return cb(false);
        }
      } else {
        args.loginname = $("#loginname").val();
        if (!args.loginname) {
          alert('请输入个人账号！');
          $("#loginname").focus();
          return cb(false);
        }
      }
      var pwd = $("#password").val();
      if (!pwd) {
        alert('请输入登录密码！');
        $("#password").focus();
        return cb(false);
      }
    } else {
      // 已登陆过
      // location = that.home;
      return cb(true)
    }
    args.clientType = 'web';
    args.ts = new Date().getTime() - tsDiff;
    pwd = CryptoJS.MD5(pwd).toString();
    var ivData;
    if (loginType == 'mobile') {
      ivData = [args.mobile, pwd, args.clientType, args.ts];
    } else {
      ivData = [args.loginname, pwd, args.clientType, args.ts];
    }
    var iv = CryptoJS.MD5(JSON.stringify(ivData)).toString().substr(0, 16);
    ivData.push(iv);
    var key = CryptoJS.MD5(JSON.stringify(ivData)).toString();
    args.data = CryptoJS.AES.encrypt(JSON.stringify(ivData), CryptoJS.enc.Utf8.parse(key), {
      iv: CryptoJS.enc.Utf8.parse(iv),
      mode: CryptoJS.mode.CBC
    }).toString();
    args.dts = new Date().getTime();
    args.keycode = code;
    args.otherdata = that.handlerOtherCode(dUserId, args.keycode, args.dts);
    args.otherlogin = authLogin;
    args.loginType = loginType;
    args.notAuth = true;
    ivData = null;
    var service = new TaskMsgService();
    service.path = "sys/service/login";
    service.request(args, function (req, res) {
      if (res.code == 0) {
        localStorage.setItem("s", res.sessionId);
        localStorage.setItem("l", req.loginname);
        localStorage.setItem("mobile", req.mobile);
        localStorage.setItem("p", pwd);
        localStorage.setItem("d", res.data);
        localStorage.setItem("t", res.ts);
        localStorage.setItem("sex", res.userSex);
        localStorage.setItem("orgname", res.orgName);
        localStorage.setItem('f', tsDiff);
        localStorage.setItem("loginType", loginType)
        authLogin = false;
        // location = localStorage.getItem("home");
        tfp.gotoPage(localStorage.getItem("home"));
        return cb(true);
      } else {
        cb(false)
      }
    });
  }

  //加密
  this.handlerOtherCode = function (othercode, keycode, dts) {
    var keytmp = [keycode, "mini", dts];
    var iv = CryptoJS.MD5(JSON.stringify(keytmp)).toString().substr(0, 16);
    keytmp.push(iv);
    var key = CryptoJS.MD5(JSON.stringify(keytmp)).toString();
    var text = [othercode, "mini", dts];
    var otherdata = CryptoJS.AES.encrypt(JSON.stringify(text), CryptoJS.enc.Utf8.parse(key), {
      iv: CryptoJS.enc.Utf8.parse(iv),
      mode: CryptoJS.mode.CBC,
    }).toString();
    return otherdata;
  };

  // 企业微信组件授权
  this.empower = function (cb) {
    var that = this;
    let args = {};
    args.timestamp = new Date().getTime();
    args.url = location.href.split('#')[0];
    args.noTmClient = true;
    args.filepath = window.location.pathname.split('/')[2];
    var service = new TaskMsgService();
    service.path = "sys/service/workweixin/getConfigWeixin";
    service.request(args, function (req, res) {
      if (res.code == 0) {
        // alert("获取鉴权信息成功：" + JSON.stringify(res));
        that.afterEmpower(res, cb);
      } else {
        alert(res.message);
        cb(false)
      }
    });
  }

  this.afterEmpower = function (info, cb) {
    var that = this;
    that.corpid = info.corpid;
    that.realmName = info.realmName;
    wx.config({
      beta: true,// 必须这么写，否则wx.invoke调用形式的jsapi会有问题
      debug: false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
      appId: info.corpid,//必填，企业ID
      timestamp: info.time_stamp, // 必填，生成签名的时间戳
      nonceStr: info.nonceStr, // 必填，自定义固定字符串。
      signature: info.sign, // 必填，签名
      jsApiList: [
        'chooseImage', //选择图片
        'uploadImage',
        'getLocalImgData', //获取本地图片base64码
        'previewImage', //预览图片
        'getLocation', //获取地理位置
        'openLocation', //地图显示位置信息
        'scanQRCode', //扫一扫
        'selectEnterpriseContact', //选人
        'onMenuShareAppMessage', //转发
        'onMenuShareWechat', //微信
        'onMenuShareTimeline', //朋友圈
        'getConnectedWifi', //wifi信息
        'getNetworkType', //网络状态
        'chooseMessageFile',//从会话选择文件
      ]
    });
    wx.error(function (res) {
      // config信息验证失败会执行error函数，如签名过期导致验证失败，具体错误信息可以打开config的debug模式查看，也可以在返回的res参数中查看，对于SPA可以在这里更新签名。
      alert('wx error: ' + JSON.stringify(res));
      return cb(false);
    });
    cb()
  }


  /**
   * 显示图片选择窗口
   * @param  {[type]}  cb [回调函数]
   * @param  {Boolean} maxCount [最大可选照片数]
   * @param  {Boolean} sourceType   [相册选取或者拍照,默认 ['camera','album'] ]
   */
  this.showImagePicker = function (args, cb) {
    if (!args.sourceType) args.sourceType = ['camera', 'album'];
    if (!args.maxCount) args.maxCount = 1;
    wx.ready(function () {
      wx.chooseImage({
        count: args.maxCount, // 默认9
        sizeType: ['original', 'compressed'], // 可以指定是原图还是压缩图，默认二者都有
        sourceType: args.sourceType, // 可以指定来源是相册还是相机，默认二者都有
        defaultCameraMode: "normal", //表示进入拍照界面的默认模式，目前有normal与batch两种选择，normal表示普通单拍模式，batch表示连拍模式，不传该参数则为normal模式。从3.0.26版本开始支持front和batch_front两种值，其中front表示默认为前置摄像头单拍模式，batch_front表示默认为前置摄像头连拍模式。（注：用户进入拍照界面仍然可自由切换两种模式）
        isSaveToAlbum: 1, //整型值，0表示拍照时不保存到系统相册，1表示自动保存，默认值是1
        success: function (res) {
          var localIds = res.localIds; // 返回选定照片的本地ID列表，
          cb(localIds)
          // andriod中localId可以作为img标签的src属性显示图片；
          // iOS应当使用 getLocalImgData 获取图片base64数据，从而用于img标签的显示（在img标签内使用 wx.chooseImage 的 localid 显示可能会不成功）
        }
      });
    });
  };



  /**
   * 显示图片
   * @param  {[type]} imagePath [description]
   * @param  {[type]} imageCode [description]
   * @return {[type]}           [description]
   */
  this.showImage = function (args, cb) {
    var that = this;
    var beforesrc = '/Download?showImage=true&fileCode=';
    if (!args.imageCode) return cb(false);
    if (args.imageCode.indexOf('http') == -1 || args.imageCode.indexOf('Download') == -1) {
      args.imageCode = that.realmName + beforesrc + args.imageCode;
    }
    var list = [];
    var index = 0;
    for (var x = args.imageList.length - 1; x >= 0; x--) {
      if (args.imageList[x].indexOf('http') == -1) {
        args.imageList[x] = that.realmName + beforesrc + args.imageList[x];
      }
      list[index] = args.imageList[x];
      index++;
    }
    wx.ready(function () {
      wx.previewImage({
        current: args.imageCode, // 第一张显示的图片链接
        urls: list// 需要预加载的图片http链接列表，预加载后，可以滑动浏览这些图片
      });
      cb(true)
    })
  };

  /**
   * 扫码
   * @param {*} args 
   * @param {*} cb 
   */
  this.showCodeScanner = function (cb) {
    wx.ready(function () {
      wx.scanQRCode({
        desc: 'scanQRCode desc',
        needResult: 1, // 默认为0，扫描结果由企业微信处理，1则直接返回扫描结果，
        scanType: ["qrCode", "barCode"], // 可以指定扫二维码还是条形码（一维码），默认二者都有
        success: function (res) {
          // 回调, 当needResult为1时返回处理结果
          // alert(JSON.stringify(res));
          cb(JSON.stringify(res))
        },
        error: function (res) {
          if (res.errMsg.indexOf('function_not_exist') > 0) {
            alert('版本过低请升级')
          }
          cb(false)
        }
      });
    });
  }

  /**
   * 分享
   * @param {*} args 
   * @param {*} cb 
   */
  this.share = function (args, cb) {
    wx.ready(function () {   //需在用户可能点击分享按钮前就先调用
      wx.onMenuShareAppMessage({
        title: args.title ? args.title : '', // 分享标题
        desc: args.content ? args.content : '', // 分享描述
        link: args.url ? args.url : '', // 分享链接，该链接域名或路径必须与当前页面对应的公众号JS安全域名一致
        imgUrl: args.imageUrl ? args.imageUrl : '', // 分享图标
        success: function () {
          // alert('分享成功！');
          cb(true)
        }, cancel: function () {
          // 用户取消分享后执行的回调函数
          cb(false)
        }
      })
    });
  }

  /**
   * 获取当前地理位置信息（单次定位）
   * @param {*} args 
   * @param {*} cb 
   */
  this.getLocation = function (cb) {
    wx.ready(function () {
      wx.getLocation({
        type: 'wgs84', // 默认为wgs84的gps坐标，如果要返回直接给openLocation用的火星坐标，可传入'gcj02'
        success: function (res) {
          /*
          {
              'latitude': res.latitude, // 纬度，浮点数，范围为90 ~ -90
              'longitude': res.longitude, // 经度，浮点数，范围为180 ~ -180。
              'speed': res.speed, // 速度，以米/每秒计
              'accuracy': res.accuracy // 位置精度
          }
          */
          // alert(JSON.stringify(res));
          cb(res)
        },
        fail: function (err) {
          cb(false)
        }
      });
    });
  }

  /**
   * 展示位置
   * @param {*} args
   * @param {*} cb 
   */
  this.showLocation = function (args, cb) {
    wx.ready(function () {
      wx.openLocation({
        latitude: args.latitude, // 纬度，浮点数，范围为90 ~ -90
        longitude: args.longitude, // 经度，浮点数，范围为180 ~ -180。
        name: args.name ? args.name : '', // 位置名
        address: args.address ? args.address : '', // 地址详情说明
        scale: args.scale ? args.scale : 16, // 地图缩放级别,整形值,范围从1~28。默认为16
      });
      cb(true)
    });
  }

  /**
 * 获取已连接中的 Wi-Fi 信息
 * @param {*} cb 
 */
  this.getInterface = function (cb) {
    wx.ready(function () {
      wx.getConnectedWifi({
        success: function (res) {
          /*
          //wifi
          {
              "SSID":"", //Wi-Fi 的SSID
              "BSSID":"", //Wi-Fi 的BSSID
              "secure":"", //Wi-Fi 是否安全
              "signalStrength":"" //Wi-Fi 信号强度
          }
          */
          // alert(JSON.stringify(res));
          cb(res)
        },
        fail: function (err) {
          cb(false)
        }
      })
    });
  }

  /**
   * 获取网络类型
   * @param {*} cb 
   */
  this.getNetState = function (cb) {
    wx.ready(function () {
      wx.getNetworkType({
        success: function (res) {
          var networkType = res.networkType; // 返回网络类型2g，3g，4g，wifi
          // alert(networkType);
          cb(networkType)
        },
        fail: function (err) {
          cb(false)
        }
      });
    });
  }

  /**
   * 上传图片
   * @param {*} args 
   * @param {*} cb 
   */
  this.uploadFile = function (args, cb) {
    var that = this;
    wx.ready(function () {
      wx.chooseImage({
        count: args.maxCount, // 默认9
        sizeType: ['original', 'compressed'], // 可以指定是原图还是压缩图，默认二者都有
        sourceType: ['album', 'camera'], // 可以指定来源是相册还是相机，默认二者都有
        success: function (res) {
          var localIds = res.localIds; // 返回选定照片的本地ID列表，localId可以作为img标签的src属性显示图片
          wx.uploadImage({
            localId: localIds[0], // 需要上传的图片的本地ID，由chooseImage接口获得
            isShowProgressTips: true, // 默认为1，显示进度提示
            success: function (res) {
              alert('上传成功')
              var serverId = res.serverId; // 返回图片的服务器端ID
              let obj = {};
              obj.filepath = window.location.pathname.split('/')[2];
              obj.serverId = serverId;
              var service = new TaskMsgService();
              service.path = "sys/service/workweixin/uploadfile";
              service.request(obj, function (req, res) {
                if (res.code == 0) {
                  // alert(JSON.stringify(res))
                } else {
                  alert(res.message);
                  cb(false)
                }
              });
            }
          });
        }
      });
    })
  }

  // 支付生成订单
  this.confirmOrder = function (obj, cb) {
    var args = {};
    var service = new TaskMsgService();
    args.total_fee = obj.total_fee;//支付总额
    args.out_trade_no = obj.out_trade_no;//商户订单号
    args.filepath = window.location.pathname.split('/')[2];
    args.serverUrl = location.href.split('#')[0].split('/app/')[0]; //获取路径
    service.path = "sys/service/wxPayPhone/payOrder";
    service.request(args, function (req, res) {
      if (res.code == 0) {
        window.location = res.h5_url;
        cb(res);
      } else {
        this.showError("支付错误!");
        cb(false);
      }
    });
  }
}

if ((navigator.userAgent + "").indexOf("Electron") < 0) {
  window.tmClient = new TaskMsgClient();
  window.tmClient.init();
  window.tmClient.loadAuthData();
}