/**
 * 任信客户端浏览器扩展对象
 * @type {TaskMsgClient}
 */

function TaskMsgClient() {
  this.TMiOSClientIsInit = false; //iOS客户端是否已初始化
  this.isDisableGoBack = false; //是否禁止退回
  this.tmClientCallBackFuncIndex = 0; // 回调函数索引
  this.AndroidClientCallBackFuncIndex = 1000; //安卓客户端回调函数索引
  this.clientOSType = ""; //客户端类型
  this.mobileType = 'renxun';
  this.iOSClientInitScript = []; //iOS客户端初始化脚本
  this.waitProcessServices = []; //等待处理的服务请求
  this.waitProcessIndex = 0;
  this.isElectron = window.navigator.userAgent.toString().indexOf('Electron') > 0; // 判断是否为electron客户端

  /**
   * 初始化客户端对象
   */
  this.init = function () {
    //获得客户端类型
    if (navigator.userAgent.indexOf("iPhone") > 0) {
      if (navigator.userAgent.indexOf("Safari") > 0) {
        this.clientOSType = "web";
      } else {
        this.clientOSType = "iOS";
      }
    } else if (
      navigator.userAgent.indexOf("Windows") > 0 ||
      navigator.userAgent.indexOf("Mac OS") > 0
    ) {
      this.clientOSType = "PC";
    } else {
      this.clientOSType = "Android";
    }
  };

  /**
   * 执行iOS客户端初始化脚本
   */
  this.exeiOSClientInitScript = function () {
    this.TMiOSClientIsInit = true;
    for (var i = 0; i < this.iOSClientInitScript.length; i++) {
      eval(this.iOSClientInitScript[i]);
    }
    this.iOSClientInitScript = [];
    this.processWaitServices();
  };

  /**
   * 处理等待的服务请求
   */
  this.processWaitServices = function () {
    if (this.waitProcessIndex >= this.waitProcessServices.length) {
      this.waitProcessServices = [];
      this.waitProcessIndex = 0;
    } else {
      var that = this;
      var waitProcess = this.waitProcessServices[this.waitProcessIndex]
      var service = waitProcess.service;
      var callback = waitProcess.callback;
      var args = waitProcess.args;
      if (!args.notAuth) {
        this.getAuthData(function (authData) {
          args._auth_ts = authData._auth_ts;
          args._auth_data = authData._auth_data;
          service.request(args)
            .then((res) => {
              if (callback) {
                callback(res);
              }
              that.waitProcessIndex++;
              that.processWaitServices();
            })
            .catch(function (err) {
              if (callback) {
                callback(err);
              }
            });
        });
      }
    }
  };

  /**
   * 获取身份信息
   * @param {Function} cb 回调函数
   */
  this.getAuthData = function (cb) {
    if (this.clientOSType == "iOS") {
      if (cb) {
        if (typeof cb == "function") {
          // window.onTMClientGetAuthData = function (authData) {
          // 	if (cb) cb(JSON.parse(authData));
          // 	window.onTMClientGetAuthData = null;
          // }
          // if (this.TMiOSClientIsInit) {
          // 	window.webkit.messageHandlers.GetAuthData.postMessage({ "callback": "onTMClientGetAuthData" });
          // } else {
          // 	this.iOSClientInitScript.push("window.webkit.messageHandlers.GetAuthData.postMessage({'callback':'onTMClientGetAuthData'})");
          // }
          const callbackName = this.convertCallBack(window, function (authData) {
            if (cb) cb(JSON.parse(authData));
          });
          window.webkit.messageHandlers.GetAuthData.postMessage({ "callback": callbackName });
        } else {
          // if (this.TMiOSClientIsInit) {
          // 	window.webkit.messageHandlers.GetAuthData.postMessage({ "callback": cb });
          // } else {
          // 	this.iOSClientInitScript.push("window.webkit.messageHandlers.GetAuthData.postMessage({'callback':'" + cb + "'})");
          // }
          window.webkit.messageHandlers.GetAuthData.postMessage({ "callback": cb });
        }
      }
    } else if (this.clientOSType == "Android") {
      if (cb) {
        if (typeof cb == "function") {
          let authData = window.TMAndroidClient.getAuthData();
          return cb(JSON.parse(authData));
        } else {
          let authData = window.TMAndroidClient.getAuthData();
          return eval(cb + "(JSON.parse(authData))");
        }
      }
    }
  };

  /**
   * 打开网页回调函数，配合invokeOpenerCallbackFunc扩展使用
   * @callback openWebPageCallback
   * @param {Any} arg 数据
   */
  /**
   * 打开网页
   * @param {Object} args 参数
   * @param {String} args.url 地址
   * @param {String} args.title 页面标题
   * @param {String} [args.leftNavButtonTitle] 左侧按钮文本
   * @param {Boolean} [args.isRemotePath] 是否加载本地url
   * @param {String | openWebPageCallback} [args.callback] 执行当前页面回调，
   * @param {Boolean} [args.hideNavBar] 是否隐藏标题栏
   * @param {Boolean} [args.noAuth] 是否拼接身份验证参数
   * @example
   * tmClient.openWebPage({ url: '127.0.0.1', title: '首页' });
   */
  this.openWebPage = function (args) {
    if (!args) {
      alert('请提供打开网页参数');
      return;
    }
    if (!args.url) {
      alert('请提供网页路径');
      return;
    }
    if (!args.hideNavBar) args.hideNavBar = false;
    if (args.callback) args.callback = this.convertCallBack(window, args.callback);
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.OpenWebPage.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      if (args.callback) {
        args.requestCode = this.AndroidClientCallBackFuncIndex;
        this.AndroidClientCallBackFuncIndex++;
      }
      if (args.url.indexOf('?') == -1) {
        args.url = args.url + '?hideNavBar=' + args.hideNavBar;
      } else {
        args.url = args.url + '&hideNavBar=' + args.hideNavBar;
      }
      window.TMAndroidClient.openWebPage(JSON.stringify(args));
    } else if (this.clientOSType == "web" || this.clientOSType == "PC") {
      if (this.isElectron) {
        top.openWindow(args);
        return;
      }
      window.open(args.url);
    }
  };

  /**
   * 调用Opener的回调函数
   * @param  {any} arg 数据
   * @example
   * tmClient.invokeOpenerCallbackFunc(res);
   */
  this.invokeOpenerCallbackFunc = function (arg) {
    if (this.clientOSType == "iOS") {
      if (typeof (arg) == "object") {
        window.webkit.messageHandlers.InvokeOpenerCallbackFunc.postMessage(JSON.stringify(arg));
      } else {
        window.webkit.messageHandlers.InvokeOpenerCallbackFunc.postMessage(arg);
      }
    } else if (this.clientOSType == "Android") {
      if (typeof (arg) == "object") {
        window.TMAndroidClient.invokeOpenerCallbackFunc(JSON.stringify(arg));
      } else {
        window.TMAndroidClient.invokeOpenerCallbackFunc(arg);
      }
    } else if (this.clientOSType == "web" || this.clientOSType == "PC") {
      if (this.isElectron) {
        const tmClientCallBackName = window.tmClientCallBackNames.pop();
        if (tmClientCallBackName) window.invokeCallback(tmClientCallBackName, arg);
        return;
      }
    }
  };

  /**
   * 执行Opener中的脚本
   * @param  {[type]} js    [js脚本]
   * @return {[type]}       [description]
   */
  this.evalOpenerScript = function (js) {
    if (this.clientOSType == "iOS") {
      if (this.TMiOSClientIsInit) {
        window.webkit.messageHandlers.EvalOpenerScript.postMessage(js);
      } else {
        this.iOSClientInitScript.push("window.webkit.messageHandlers.EvalOpenerScript.postMessage('" + js + "')");
      }
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.evalOpenerScript(js);
    }
  };

  /**
   * 关闭当前窗口
   * @example
   * tmClient.close();
   */
  this.close = function () {
    if (this.clientOSType == "iOS") {
      if (this.TMiOSClientIsInit) {
        window.webkit.messageHandlers.Close.postMessage(null);
      } else {
        this.iOSClientInitScript.push("window.webkit.messageHandlers.Close.postMessage(null);");
      }
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.close();
    } else if (this.clientOSType == "web" || this.clientOSType == "PC") {
      if (this.isElectron) {
        top.closeWindow();
        return;
      }
      window.close();
    }
  };

  /**
   * 设置更多菜单
   * @param {Object[]} menuInfo 菜单列表
   * @param {String} menuInfo[].text 按钮
   * @param {String} menuInfo[].jsStatement 运行脚本
   * @example
   * tmClient.setMoreMenu([{'text':'按钮', 'jsStatement':'test()'}]);
   */
  this.setMoreMenu = function (menuInfo) {
    if (!menuInfo) {
      alert("请提供菜单信息");
      return;
    }
    if (this.clientOSType == "iOS") {
      if (this.TMiOSClientIsInit) {
        window.webkit.messageHandlers.SetMoreMenu.postMessage(JSON.stringify(menuInfo));
      } else {
        this.iOSClientInitScript.push(
          "window.webkit.messageHandlers.SetMoreMenu.postMessage('" + JSON.stringify(menuInfo).replace(/'/g, "\\'") + "')"
        );
      }
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.setMoreMenu(JSON.stringify(menuInfo));
    } else if (this.clientOSType == "web" || this.clientOSType == "PC") {
      if (top.setMoreMenu) top.setMoreMenu(menuInfo);
    }
  };

  /**
   * 设置窗口标题
   * @param {String} title 标题
   * @example
   * tmClient.setTitle('标题');
   */
  this.setTitle = function (title) {
    if (!title) {
      alert("请提供标题");
      return;
    }
    if (this.clientOSType == "iOS") {
      var args = {};
      args.title = title;
      if (this.TMiOSClientIsInit) {
        window.webkit.messageHandlers.SetTitle.postMessage(JSON.stringify(args));
      } else {
        this.iOSClientInitScript.push("window.webkit.messageHandlers.SetTitle.postMessage('" + JSON.stringify(args) + "')");
      }
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.setTitle(title);
    } else if (this.clientOSType == "web" || this.clientOSType == "PC") {
      if (top.setTitle) top.setTitle(title);
    }
  };

  /**
   * 上传附件回调函数
   * @callback uploadAttachCallback
   * @param {Number} id 文件编号
   * @param {String} code 文件编码
   */
  /**
   * 上传附件
   * @param {Object} args 参数对象
   * @param {String} args.filePath 文件路径
   * @param {String} args.appCode appCode
   * @param {String} args.appDataId appDataId
   * @param {Boolean} [args.isShowProgress] 是否显示进度条
   * @param {String} [args.retainExt] 是否更改扩展名
   * @param {String | uploadAttachCallback} [args.callback] 文件路径
   * @param {String | uploadAttachCallback} cb 回调函数
   * @example
   * tmClient.uploadAttach({
   * 	filePath: '/abc/demo.txt',
   * 	appCode: 'demo', 
   * 	appDataId: 1, 
   * 	isShowProgress: true, 
   * 	callback: function(id, code) { console.log(id, code); }
   * });
   */
  this.uploadAttach = function (args, cb) {
    if (!args) {
      alert("请提供文件信息");
      return;
    }

    if (!args.filePath) {
      alert("请提供文件路径");
      return;
    }

    if (!args.appCode) {
      alert("请提供应用代码");
      return;
    }
    args.serverProtocol = location.protocol;
    args.serverAddress = location.hostname;
    args.serverPort = location.port;
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientUploadAttach";
        window.onTMClientUploadAttach = function (id, code) {
          if (cb) cb(id, code);
          window.onTMClientUploadAttach = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.UploadAttach.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.uploadAttach(JSON.stringify(args));
    }
  };

  /**
   * 上传附件到指定url
   * @param  {[type]}  url            [url路径]
   * @param  {[type]}  filePath       [文件路径]
   * @param  {[type]}  isShowProgress [是否显示进度条]
   * @param  {[type]}  cb             [description]
   * @return {[type]}                 [description]
   */
  this.uploadToUrl = function (args, cb) {
    if (!args) {
      alert("请提供文件信息");
      return;
    }
    if (!args.url) {
      alert("请提供文件上传路径");
      return;
    }
    if (!args.filePath) {
      alert("请提供文件保存路径");
      return;
    }
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientUploadToUrl";
        window.onTMClientUploadToUrl = function (ret) {
          if (cb) cb(ret);
          window.onTMClientUploadToUrl = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      if (this.TMiOSClientIsInit) {
        window.webkit.messageHandlers.UploadToUrl.postMessage(JSON.stringify(args));
      } else {
        this.iOSClientInitScript.push("window.webkit.messageHandlers.UploadToUrl.postMessage('" + JSON.stringify(args) + "')");
      }
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.uploadToUrl(JSON.stringify(args));
    }
  };

  /**
   * 上传多个附件
   * @param  {[type]}  cb   [回调函数]
   * @param  {[type]}  files          [文件数组]
   * @param  {Boolean} isShowProgress [是否显示进度条]
   * @return {[type]}                 [description]
   */
  this.uploadAttachs = function (args, cb) {
    if (!args || !args.files || args.files.length == 0) {
      alert("请提供文件信息");
      return;
    }
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientUploadAttachs";
        window.onTMClientUploadAttachs = function (ret) {
          if (cb) cb(ret);
          window.onTMClientUploadAttachs = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.UploadAttachs.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.uploadAttachs(JSON.stringify(args));
    }
  };

  /**
   * 下载附件
   * @param  {[type]}  cb     [回调函数]
   * @param  {[type]}  fileCode         [文件fileCode]
   * @param  {[type]}  fileName         [文件fileName]
   * @param  {[type]}  appCode          [文件appCode]
   * @param  {[type]}  appDataId        [文件appDataId]
   * @param  {Boolean} isShowProgress   [是否显示进度条]
   * @param  {[type]}  progressCallback [下载进度回调]
   * @return {[type]}                   [description]
   */
  this.downAttach = function (args, cb, progressCallback) {
    if (!args) {
      alert("请提供文件信息");
      return;
    }
    if (!args.fileName) {
      alert("请提供文件保存路径");
      return;
    }
    args.serverProtocol = location.protocol;
    args.serverAddress = location.hostname;
    args.serverPort = location.port;
    if (progressCallback) args.progressCallback = progressCallback;
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientDownAttach";
        window.onTMClientDownAttach = function (ret) {
          if (cb) cb(ret);
          window.onTMClientDownAttach = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.DownAttach.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.downAttach(JSON.stringify(args));
    }
  };

  /**
   * 从指定url下载附件
   * @param  {[type]}  url              [下载url]
   * @param  {[type]}  fileCode         [fileCode]
   * @param  {[type]}  fileName         [fileName]
   * @param  {[type]}  appCode          [appCode]
   * @param  {[type]}  appDataId        [appDataId]
   * @param  {Boolean} isShowProgress   [是否显示进度条]
   * @param  {[type]}  cb     [回调函数]
   */
  this.downFromUrl = function (args, cb) {
    if (!args) {
      alert("请提供下载参数");
      return;
    }
    if (!args.url) {
      alert("请提供文件下载路径");
      return;
    }
    if (!args.fileName) {
      alert("请提供文件保存路径");
      return;
    }
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientDownFromUrl";
        window.onTMClientDownFromUrl = function (ret) {
          if (cb) cb(ret);
          window.onTMClientDownFromUrl = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.DownFromUrl.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.downFromUrl(JSON.stringify(args));
    }
  };

  /**
   * 播放音频
   * @param  {[type]} filePath [description]
   * @param  {[type]} fileCode [description]
   * @return {[type]}          [description]
   */
  this.playAudio = function (args) {
    if (!args || (!args.filePath && !args.fileCode)) {
      alert("请提供文件路径或代码");
      return;
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.PlayAudio.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.playAudio(JSON.stringify(args));
    }
  };

  /**
   * 播放视频
   * @param  {[type]} url     [description]
   * @return {[type]}          [description]
   */
  this.playVideo = function (url) {
    if (!url) {
      alert("请提供视频路径");
      return;
    }
    var args = {};
    args.url = url;
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.PlayVideo.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.playVideo(JSON.stringify(args));
    }
  };

  /**
   * 打开文件
   * @param  {[type]} filePath [description]
   * @return {[type]}          [description]
   */
  this.openFile = function (filePath) {
    if (!filePath) {
      alert("请提供文件路径");
      return;
    }
    var args = {};
    args.filePath = filePath;
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.OpenFile.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.openFile(JSON.stringify(args));
    }
  };

  /**
   * 显示图片
   * @param  {[type]} imagePath [description]
   * @param  {[type]} imageCode [description]
   * @return {[type]}           [description]
   */
  this.showImage = function (args) {
    if (!args || (!args.imagePath && !args.imageCode)) {
      alert("请提供图片路径或代码");
      return;
    }
    // args.serverProtocol = location.protocol;
    // args.serverAddress = location.hostname;
    // args.serverPort = location.port;
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.ShowImage.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showImage(JSON.stringify(args));
    }
  };

  /**
   * 显示PDF
   * @param  {[type]} pdfCode [description]
   * @return {[type]}           [description]
   */
  this.showPdf = function (pdfCode) {
    if (pdfCode) {
      alert("请提供PDF代码");
      return;
    }
    var args = {};
    args.pdfCode = pdfCode;
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.ShowPdf.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showPdf(JSON.stringify(args));
    }
  };

  /**
   * 显示附件列表
   * @param  {[type]} appCode   [description]
   * @param  {[type]} appDataId [description]
   */
  this.showAttachList = function (args) {
    if (!args) {
      alert("请提供附件信息");
      return;
    }
    if (!args.appCode) {
      alert("请提供应用代码");
      return;
    }
    if (!args.appDataId) args.appDataId = 0;
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.ShowAttachList.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showAttachList(JSON.stringify(args));
    }
  };

  /**
   * 显示用户信息
   * @param  {[type]} userId [description]
   * @return {[type]}        [description]
   */
  this.showUserInfo = function (userId) {
    if (!userId) {
      alert("请提供用户编号");
      return;
    }
    var args = {};
    args.userId = userId;

    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.ShowUserInfo.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showUserInfo(JSON.stringify(args));
    }
  };

  /**
   * 在地图上显示位置
   * @param  {[type]}   longitude [经度]
   * @param  {[type]}   latitude  [纬度]
   * @param  {[type]}   tolerance [范围]
   * @param  {Function} cb        [回调函数]
   */
  this.showLocation = function (args, cb) {
    if (!args) args = {};
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientShowLocation";
        window.onTMClientShowLocation = function (ret) {
          if (cb) cb(ret);
          window.onTMClientShowLocation = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.ShowLocation.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showLocation(JSON.stringify(args));
    }
  };

  /**
   * 获得当前位置
   * @param  {[type]} cb [description]
   * @param  {[type]} errorFunc    [description]
   * @param  {[type]} getDetail    [description]
   * @return {[type]}              [description]
   */
  this.getLocation = function (getDetail, cb) {
    var args = {};
    args.getDetail = true;
    if (!getDetail) args.getDetail = false;
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientGetLocation";
        window.onTMClientGetLocation = function (ret) {
          cb(ret);
          window.onTMClientGetLocation = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      if (this.TMiOSClientIsInit) {
        window.webkit.messageHandlers.GetLocation.postMessage(JSON.stringify(args));
      } else {
        this.iOSClientInitScript.push("window.webkit.messageHandlers.GetLocation.postMessage('" + JSON.stringify(args) + "')");
      }
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.getLocation(JSON.stringify(args));
    }
  };

  /**
   * 显示文件选择窗口回调函数
   * @callback showFilePickerCallback
   * @param {Object[]} fileList 图片数组
   * @param {String} fileList[].name 文件名称
   * @param {String} fileList[].path 文件路径
   * @param {Number} fileList[].size 文件大小
   */
  /**
   * 显示文件选择窗口
   * @param {Object | Boolean} [args] 参数对象 | 是否多选（适配老版）
   * @param {Boolean} [args.isMutiSelect] 是否多选
   * @param {Number} [args.maxCount] 最大值
   * @param {String} [args.exFunc] 函数名(ios)
   * @param {Any} [args.params] 函数参数(ios)
   * @param {String | showFilePickerCallback} [args.callback] 文件路径
   * @param {String | showFilePickerCallback} [cb] 回调函数
   * @example
   * tmClient.showFilePicker({
   * 	isMutiSelect: true,
   * 	maxCount: 9, 
   * 	callback: function(imageList) { console.log(imageList); }
   * });
   */
  this.showFilePicker = function (args, cb) {
    if (typeof args != 'object') args = { isMutiSelect: args };
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientShowFilePicker";
        window.onTMClientShowFilePicker = function (ret) {
          if (cb) cb(ret);
          window.onTMClientShowFilePicker = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (args.callback) args.callback = this.convertCallBack(widnow, args.callback);
    if (this.clientOSType == "iOS") {
      if (this.TMiOSClientIsInit) {
        window.webkit.messageHandlers.ShowFilePicker.postMessage(JSON.stringify(args));
      } else {
        this.iOSClientInitScript.push("window.webkit.messageHandlers.ShowFilePicker.postMessage('" + JSON.stringify(args) + "')");
      }
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showFilePicker(JSON.stringify(args));
    }
  };

  /**
   * 显示图片选择窗口回调函数
   * @callback showImagePickerCallback
   * @param {Object[]} imageList 图片数组
   * @param {String} imageList[].name 文件名称
   * @param {String} imageList[].path 文件路径
   * @param {Number} imageList[].size 文件大小
   */
  /**
   * 显示图片选择窗口
   * @param {Object} [args] 参数对象
   * @param {Boolean} [args.isMutiSelect] 是否多选
   * @param {Boolean} [args.isCompress] 是否压缩
   * @param {Number} [args.maxCount] 最大值
   * @param {String} [args.exFunc] 函数名(ios)
   * @param {Any} [args.params] 函数参数(ios)
   * @param {String | showImagePickerCallback} [args.callback] 文件路径
   * @param {String | showImagePickerCallback} [cb] 回调函数
   * @example
   * tmClient.showImagePicker({
   * 	isMutiSelect: true,
   * 	isCompress: false, 
   * 	maxCount: 9, 
   * 	callback: function(imageList) { console.log(imageList); }
   * });
   */
  this.showImagePicker = function (args, cb) {
    if (!args) args = {};
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientShowImagePicker";
        window.onTMClientShowImagePicker = function (ret) {
          if (cb) cb(ret);
          window.onTMClientShowImagePicker = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (args.callback) args.callback = this.convertCallBack(window, args.callback);
    if (this.clientOSType == "iOS") {
      if (this.TMiOSClientIsInit) {
        window.webkit.messageHandlers.ShowImagePickerOrTakePhoto.postMessage(JSON.stringify(args));
      } else {
        this.iOSClientInitScript.push("window.webkit.messageHandlers.ShowImagePickerOrTakePhoto.postMessage('" + JSON.stringify(
          args) + "')");
      }
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showImagePicker(JSON.stringify(args));
    }
  };

  /**
   * 拍照
   * @param  {[type]}  cb [回调函数]
   * @param  {Boolean} isCompress   [是否压缩]
   * @param  {Boolean} watermark    [是否加水印]
   * @return {[type]}               [description]
   */
  this.takePhoto = function (args, cb) {
    if (!args) args = {};
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientTakePhoto";
        window.onTMClientTakePhoto = function (ret) {
          if (cb) cb(ret);
          window.onTMClientTakePhoto = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.TakePhoto.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.takePhoto(JSON.stringify(args));
    }
  };

  /**
   * 显示录音窗口
   * @param  {[type]}   cb   [回调函数]
   * @return {[type]}        [description]
   */
  this.showAudioRecorder = function (cb) {
    var args = {};
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientShowAudioRecorder";
        window.onTMClientShowAudioRecorder = function (ret) {
          if (cb) cb(ret);
          window.onTMClientShowAudioRecorder = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.ShowAudioRecorder.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showAudioRecorder(JSON.stringify(args));
    }
  };

  /**
   * 显示时间选择窗口
   * @param  {[type]} cb             [回调函数]
   * @param  {[type]} dateType       [类型：datetime, date, time]
   * @param  {[type]} defaultValue   [默认时间]
   */
  this.showDateTimePicker = function (args, cb) {
    if (!args) args = {};
    if (!args.dateType) args.dateType = "datetime";
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientShowDateTimePicker";
        window.onTMClientShowDateTimePicker = function (ret) {
          if (cb) cb(ret);
          window.onTMClientShowDateTimePicker = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.ShowDateTimePicker.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showDateTimePicker(JSON.stringify(args));
    }
  };

  /**
   * 显示用户选择窗口
   * @param  {[type]}  cb            [回调函数]
   * @param  {Boolean} isMutiSelect  [是否多选]
   * @param  {[type]}  canSelectSelf [是否允许选择自己]
   */
  this.showUserPicker = function (args, cb) {
    if (!args) args = {};
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientShowUserPicker";
        window.onTMClientShowUserPicker = function (ret) {
          if (cb) cb(ret);
          window.onTMClientShowUserPicker = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.ShowUserPicker.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      args.requestCode = this.AndroidClientCallBackFuncIndex;
      this.AndroidClientCallBackFuncIndex++;
      window.TMAndroidClient.showUserPicker(JSON.stringify(args));
    }
  };

  /**
   * 显示部门选择窗口
   * @param  {[type]}  cb           [回调函数]
   * @param  {Boolean} isMutiSelect [是否多选]
   */
  this.showDepPicker = function (args, cb) {
    if (!args) args = {};
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientShowDepPicker";
        window.onTMClientShowDepPicker = function (ret) {
          if (cb) cb(ret);
          window.onTMClientShowDepPicker = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.ShowDepPicker.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showDepPicker(JSON.stringify(args));
    }
  };

  /**
   * 显示角色选择窗口
   * @param  {[type]}  cb           [回调函数]
   * @param  {Boolean} isMutiSelect [是否多选]
   */
  this.showRolePicker = function (args, cb) {
    if (!args) args = {};
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientShowRolePicker";
        window.onTMClientShowRolePicker = function (ret) {
          if (cb) cb(ret);
          window.onTMClientShowRolePicker = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.ShowRolePicker.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showRolePicker(JSON.stringify(args));
    }
  };

  /**
   * 显示岗位选择窗口
   * @param  {[type]}  cb           [回调函数]
   * @param  {Boolean} isMutiSelect [是否多选]
   */
  this.showPostPicker = function (args, cb) {
    if (!args) args = {};
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientShowPostPicker";
        window.onTMClientShowPostPicker = function (ret) {
          if (cb) cb(ret);
          window.onTMClientShowPostPicker = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.ShowPostPicker.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showPostPicker(JSON.stringify(args));
    }
  };

  /**
   * 显示扫一扫窗口
   * @param  {[type]} cb           [回调函数]
   * @param  {[type]} isMulti      [是否支持多次扫描]
   * @param  {[type]} isRepetition [是否去重]
   * @param  {[type]} canAlbum     [是否允许从相册选择]
   */
  this.showCodeScanner = function (args, cb) {
    if (!args) args = {};
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientShowCodeScanner";
        window.onTMClientShowCodeScanner = function (ret) {
          if (cb) cb(ret);
          window.onTMClientShowCodeScanner = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      if (this.TMiOSClientIsInit) {
        window.webkit.messageHandlers.ShowCodeScanner.postMessage(JSON.stringify(args));
      } else {
        this.iOSClientInitScript.push("window.webkit.messageHandlers.ShowCodeScanner.postMessage('" + JSON.stringify(args) + "')");
      }
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showBarcodeScanner(JSON.stringify(args));
    }
  };

  /**
   * 显示扫一扫条形码窗口
   * @param  {[type]} cb           [回调函数]
   * @param  {[type]} isMulti      [是否支持多次扫描]
   * @param  {[type]} isRepetition [是否去重]
   * @param  {[type]} canAlbum     [是否允许从相册选择]
   */
  this.showBarCodeScanner = function (args, cb) {
    if (!args) args = {};
    args.codeType = 1;
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientShowBarCodeScanner";
        window.onTMClientShowBarCodeScanner = function (ret) {
          if (cb) cb(ret);
          window.onTMClientShowBarCodeScanner = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      if (this.TMiOSClientIsInit) {
        window.webkit.messageHandlers.ShowBarCodeScanner.postMessage(JSON.stringify(args));
      } else {
        this.iOSClientInitScript.push("window.webkit.messageHandlers.ShowBarCodeScanner.postMessage('" + JSON.stringify(args) + "')");
      }
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showBarcodeScanner(JSON.stringify(args));
    }
  };

  /**
   * 设置在Android手机上按后退键时执行的回调函数
   * @param {[type]}  cb   [回调函数]
   */
  this.setBackKeyOnClickCallback = function (cb) {
    var callback = "onTMClientSetBackKey";
    if (cb) {
      if (typeof cb == "function") {
        window.onTMClientSetBackKey = function (ret) {
          if (cb) cb(ret);
          window.onTMClientSetBackKey = null;
        }
      } else {
        callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      //不支持，因为iPhone没有物理的后退键
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.setBackKeyOnClickCallback(callback);
    }
  };

  /**
   * 显示键盘
   */
  this.showKeyboard = function () {
    if (this.clientOSType == "iOS") {
      //
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.showKeyboard();
    }
  };

  /**
   * 隐藏键盘
   */
  this.hideKeyboard = function () {
    if (this.clientOSType == 'iOS') {
      window.webkit.messageHandlers.HideKeyboard.postMessage(null);
    } else if (this.clientOSType == 'Android') {
      window.TMAndroidClient.hideKeyboard();
    }
  };

  /**
   * 获得运营商名称
   * @param  {[type]} cb    [回调函数]
   */
  this.getOperatorName = function (cb) {
    var args = {};
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientGetOperatorName";
        window.onTMClientGetOperatorName = function (ret) {
          if (cb) cb(ret);
          window.onTMClientGetOperatorName = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.GetOperatorName.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      return window.TMAndroidClient.getOperatorName(args.callback);
    }
  };

  /**
   * 获得网络类型：2G、3G、4G、5G、Wifi
   * @param  {[type]} cb    [回调函数]
   */
  this.getNetState = function (cb) {
    var args = {};
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientGetNetState";
        window.onTMClientGetNetState = function (ret) {
          if (cb) cb(ret);
          window.onTMClientGetNetState = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      window.webkit.messageHandlers.GetNetState.postMessage(JSON.stringify(args));
    } else if (this.clientOSType == "Android") {
      return window.TMAndroidClient.getNetState(args.callback);
    }
  };

  /**
   * 获得Wifi信息
   * @param {[type]} cb     [回调函数]
   */
  this.getWifiInfo = function (cb) {
    var args = {};
    args.inUse = true;
    if (cb) {
      if (typeof cb == "function") {
        args.callback = "onTMClientGetWifiInfo";
        window.onTMClientGetWifiInfo = function (ret) {
          if (cb) cb(ret);
          window.onTMClientGetWifiInfo = null;
        }
      } else {
        args.callback = cb;
      }
    }
    if (this.clientOSType == "iOS") {
      if (this.TMiOSClientIsInit) {
        window.webkit.messageHandlers.GetWifiInfo.postMessage(JSON.stringify(args));
      } else {
        this.iOSClientInitScript.push("window.webkit.messageHandlers.GetWifiInfo.postMessage('" + JSON.stringify(args) + "')");
      }
    } else if (this.clientOSType == "Android") {
      window.TMAndroidClient.getWifiInfo(args.inUse, args.callback);
    }
  };

  // 支付生成订单
  this.confirmOrder = function (obj, cb) {
    var args = {};
    var service = new TaskMsgService();
    args.total_fee = obj.total_fee;//支付总额
    args.out_trade_no = obj.out_trade_no;//商户订单号
    args.filepath = window.location.pathname.split('/')[2];
    args.serverUrl = location.href.split('#')[0].split('/app/')[0]; //获取路径
    service.path = "sys/service/wxPayPhone/payOrder";
    service.request(args, function (req, res) {
      if (res.code == 0) {
        window.location = res.h5_url;
        cb(res);
      } else {
        this.showError("支付错误!");
        cb(false);
      }
    });
  }

  /**
   * 【非扩展 工具函数】转换回调函数
   * @param {Function | String} callback 回调函数
   * @returns {String}
   */
  this.convertCallBack = function (_window, callback) {
    // 当回调函数为函数时，在top或window中添加递增编号方法名的方法
    if (typeof callback == "function") {
      const callbackName = 'tmClientCallBack' + (top.tmClient ? top.tmClient.tmClientCallBackFuncIndex++ : this.tmClientCallBackFuncIndex++);
      top[callbackName] = function (...args) {
        callback.call(_window, ...args);
        delete top[callbackName];
      };
      return callbackName;
    }

    // 当回调函数为字符串时，在当前window对象中查找方法名，没有则返回空。
    if (typeof callback == "string") {
      if (typeof top[callback] == "function") return callback;
      else return '';
    }

    // 如果不满足上述条件则返回空。
    return '';
  }

}

// if ((navigator.userAgent + "").indexOf("Electron") < 0) {
// 	window.tmClient = new TaskMsgClient();
// 	window.tmClient.init();
// }
window.tmClient = new TaskMsgClient();
window.tmClient.init();


/***************************************************************************************
 * 为JavaScript默认对象添加扩展方法
***************************************************************************************/

/**
 * 将日期格式化为字符串
 * @param  {[type]} style [description]
 * @return {[type]}       [description]
 */
Date.prototype.format = function (style) {
  var y = this.getFullYear();
  var M = "0" + (this.getMonth() + 1);
  M = M.substring(M.length - 2);
  var d = "0" + this.getDate();
  d = d.substring(d.length - 2);
  var h = "0" + this.getHours();
  h = h.substring(h.length - 2);
  var m = "0" + this.getMinutes();
  m = m.substring(m.length - 2);
  var s = "0" + this.getSeconds();
  s = s.substring(s.length - 2);
  return style.replace('yyyy', y).replace('yy', (y + '').substring(2)).replace('MM', M).replace('dd', d).replace('hh', h).replace('mm', m).replace('ss', s).replace('S', this.getMilliseconds());
};

/**
 * 为日期增加指定的值
 * @param  {[type]} style [description]
 * @return {[type]}       [description]
 */
Date.prototype.add = function (strInterval, Number) {
  var dtTmp = this;
  switch (strInterval) {
    case 's': return new Date(Date.parse(dtTmp) + (1000 * Number));
    case 'n': return new Date(Date.parse(dtTmp) + (60000 * Number));
    case 'h': return new Date(Date.parse(dtTmp) + (3600000 * Number));
    case 'd': return new Date(Date.parse(dtTmp) + (86400000 * Number));
    case 'w': return new Date(Date.parse(dtTmp) + ((86400000 * 7) * Number));
    case 'q': return new Date(dtTmp.getFullYear(), (dtTmp.getMonth()) + Number * 3, dtTmp.getDate(), dtTmp.getHours(), dtTmp.getMinutes(), dtTmp.getSeconds());
    case 'm': return new Date(dtTmp.getFullYear(), (dtTmp.getMonth()) + Number, dtTmp.getDate(), dtTmp.getHours(), dtTmp.getMinutes(), dtTmp.getSeconds());
    case 'y': return new Date((dtTmp.getFullYear() + Number), dtTmp.getMonth(), dtTmp.getDate(), dtTmp.getHours(), dtTmp.getMinutes(), dtTmp.getSeconds());
  }
};

/**
 * 计算两个日期之间的间隔
 * @param  {[type]} endTime  [description]
 * @param  {[type]} diffType [description]
 * @return {[type]}          [description]
 */
Date.prototype.diff = function (endTime, diffType) {
  //将计算间隔类性字符转换为小写
  diffType = diffType.toLowerCase();
  var sTime = new Date(this); //开始时间
  var eTime = new Date(endTime); //结束时间
  //作为除数的数字
  var divNum = 1;
  switch (diffType) {
    case "second":
      divNum = 1000;
      break;
    case "minute":
      divNum = 1000 * 60;
      break;
    case "hour":
      divNum = 1000 * 3600;
      break;
    case "day":
      divNum = 1000 * 3600 * 24;
      break;
    default:
      break;
  }
  return parseInt((eTime.getTime() - sTime.getTime()) / parseInt(divNum));
};

/**
 * 日期对象转换为JSON值
 * @return {[type]} [description]
 */
Date.prototype.toJSON = function () {
  return this.format('yyyy-MM-dd hh:mm:ss');
};

/**
 * 判断字符串是否以指定的子字符串开头
 * @param  {[type]} prefix [description]
 * @return {[type]}        [description]
 */
String.prototype.startWith = String.prototype.startsWith = function (prefix) {
  return this.indexOf(prefix) === 0;
};

/**
 * 判断字符串是否以指定的子字符串结尾
 * @param  {[type]} suffix [description]
 * @return {[type]}        [description]
 */
String.prototype.endWith = String.prototype.endsWith = function (suffix) {
  return this.match(suffix + "$") == suffix;
};

//计算字符串长度(英文占1个字符，中文汉字占2个字符)
String.prototype.gblen = function () {
  var len = 0;
  for (var i = 0; i < this.length; i++) {
    if (this.charCodeAt(i) > 127 || this.charCodeAt(i) == 94) {
      len += 2;
    } else {
      len++;
    }
  }
  return len;
};

/**
 * 全部替换
 * @param  {[type]} s1 [description]
 * @param  {[type]} s2 [description]
 * @return {[type]}    [description]
 */
String.prototype.replaceAll = function (s1, s2) {
  // return this.replace(new RegExp(s1, "gm"), s2);
  var s1 = s1.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
  return this.replace(new RegExp(s1, 'g'), s2);
};

/**
 * 删除字符串两端的空格
 * @return {[type]} [description]
 */
String.prototype.trim = function () {
  return this.replace(/(^\s*)|(\s*$)/g, "");
};

/**
 * 将字符串转换为日期
 * @return {[type]} [description]
 */
String.prototype.toDate = function () {
  return new Date(this.replace(/-/g, '/'));
};

/**
 * 判断数组中是否存在指定的元素
 * @param  {[type]} obj [description]
 * @return {[type]}     [description]
 */
Array.prototype.contains = function (obj) {
  var i = this.length;
  while (i--) {
    if (this[i] === obj) {
      return true;
    }
  }
  return false;
};

/**
 * 删除数组中指定的元素
 * @param  {[type]} obj [description]
 * @return {[type]}     [description]
 */
Array.prototype.remove = Array.prototype.deleteMember = function (obj) {
  for (var i = 0; i < this.length; i++) {
    if (this[i] === obj) {
      this.splice(i, 1);
      return;
    }
  }
};

/**
 * 获得URL中的指定参数的值
 * @param  {[type]} argName [description]
 * @return {[type]}         [description]
 */
function getUrlArg(argName) {
  var url = window.location.href;
  var start = url.indexOf("?");
  if (start < 0) return null;
  var str = url.substr(start + 1);
  var strArr = str.split("&");
  for (var i = 0; i < strArr.length; i++) {
    let aname = strArr[i].substr(0, strArr[i].indexOf("="));
    if (aname == argName) return decodeURIComponent(strArr[i].substr(strArr[i].indexOf("=") + 1));
  }
  return null;
};

/**
 * 获得URL中的所有参数
 * @param  {[type]} url [description]
 * @return {[type]}     [description]
 */
getUrlArgs = function (url) {
  var args = {};
  var start = url.indexOf("?");
  if (start < 0) return args;
  var str = url.substr(start + 1);
  if (str.indexOf("&") < 0) {
    var strArr = str.split("=");
    args[strArr[0]] = strArr[1];
    return args;
  }
  var strArr = str.split("&");
  for (var i = 0; i < strArr.length; i++) {
    var strArr2 = strArr[i].split("=");
    args[strArr2[0]] = strArr2[1];
  }
  return args;
};

/**
 * 获得样式中的像素值，将px字母删掉，转换为整数
 * @param  {[type]} value [description]
 * @return {[type]}       [description]
 */
getPixel = function (value) {
  return parseInt((new String(value)).replace("px", ""));
};

isNull = function (val) {
  return val == null || val == undefined || (typeof val == "string" && val.trim() == "");
};

/**
 * 替换数据绑定字段
 * @param  {[type]} obj [description]
 * @param  {[type]} str [description]
 * @return {[type]}     [description]
 */
replaceDataField = function (obj, str) {
  if (!obj || (!str && str != 0)) return "";

  //为了忽略大小写，需要将数据对象的属性名变成小写
  let objTmp = {};
  for (let p in obj) {
    objTmp[p.toLowerCase()] = obj[p];
  }

  var patt = new RegExp("{([\\w|\.|\\u4E00-\\u9FA5]*)}", "ig");
  var result = patt.exec(str);
  while (result != null) {
    let fieldStr = result[0];
    fieldStr = fieldStr.substring(1, fieldStr.length - 1);
    var fieldName = fieldStr;
    var format = "";
    if (fieldStr.indexOf(",") > 0) {
      format = fieldStr.substr(fieldStr.indexOf(",") + 1);
      fieldName = fieldStr.substr(0, fieldStr.indexOf(","));
    }
    fieldName = fieldName.replace(/ /g, "").toLowerCase();
    let fieldVal = objTmp[fieldName];
    if (fieldVal || fieldVal == 0) {
      if (typeof (fieldVal) == "object") {
        if (str == "{" + fieldName + "}") {
          return fieldVal;
        } else {
          str = str.replace("{" + fieldStr + "}", JSON.stringify(fieldVal));
        }
      } else if (format == "datetime") {
        str = str.replace("{" + fieldStr + "}", new Date(fieldVal).format("yyyy-MM-dd hh:mm:ss"));
      } else if (format == "date") {
        str = str.replace("{" + fieldStr + "}", new Date(fieldVal).format("yyyy-MM-dd"));
      } else if (format == "time") {
        str = str.replace("{" + fieldStr + "}", new Date(fieldVal).format("hh:mm:ss"));
      } else if ((format.indexOf("\"") >= 0 || format.indexOf("'") >= 0)
        && (format.indexOf("yy") >= 0 || format.indexOf("MM") >= 0
          || format.indexOf("dd") >= 0 || format.indexOf("hh") >= 0
          || format.indexOf("ss") >= 0)) {
        format = format.replace(/"/g, "").replace(/'/g, "");
        var dateStr = fieldVal + '';
        //if (dateStr.indexOf("T") < 0) dateStr = dateStr.replace(/-/g, '/');
        str = str.replace("{" + fieldStr + "}", new Date(dateStr).format(format));
      } else if (format == "money") {
        str = str.replace("{" + fieldStr + "}", this.formatMoney(fieldVal, 2));
      } else if (format == "filesize") {
        str = str.replace("{" + fieldStr + "}", this.formatFileSize(fieldVal));
      } else {
        str = str.replace("{" + fieldStr + "}", (fieldVal + "").replace(/\{/g, "`(`").replace(/\}/g, "`)`"));
      }
    } else {
      str = str.replace("{" + fieldStr + "}", "");
    }

    result = patt.exec(str);
  }

  return str;
}

/**
 * 执行表达式
 * @param  {[type]} str [description]
 * @return {[type]}     [description]
 */
exeExpress = function (str) {
  if (isNull(str) || typeof (str) != "string") return str;
  var start = str.indexOf("#[");
  if (start < 0) return str.replace(/\`\(\`/g, "{").replace(/\`\)\`/g, "}");
  var end = str.indexOf("]", start);
  if (end < 0) return str;
  var express = str.substr(start + 2, end - start - 2);
  var val = "";
  try {
    val = eval(express);
  } catch (err) {
    console.log(err);
  }
  var newStr = "";
  if (start > 0) newStr += str.substr(0, start);
  newStr += val;
  if (end < str.length - 1) newStr += str.substr(end + 1);
  return exeExpress(newStr);
}

/**
 * 返回传递给他的任意对象的类
 * @param {*} o 
 * @returns 
 */
getClass = function (o) {
  if (o === null) return "Null";
  if (o === undefined) return "Undefined";
  return Object.prototype.toString.call(o).slice(8, -1);
};

/**
 * 克隆对象
 * @param {*} obj 
 * @returns 
 */
cloneObj = function (obj) {
  var result, oClass = getClass(obj);
  //确定result的类型
  if (oClass === "Object") {
    result = {};
  } else if (oClass === "Array") {
    result = [];
  } else {
    return obj;
  }
  for (key in obj) {
    if (getClass(obj[key]) == "Object") {
      result[key] = cloneObj(obj[key]);
    } else if (getClass(obj[key]) == "Array") {
      result[key] = cloneObj(obj[key]);
    } else {
      result[key] = obj[key];
    }
  }
  return result;
};

/**
 * 任讯服务对象
 */
function TaskMsgService() {
  this.onError = null;      //处理错误的回调函数
  this.autoShowErr = true;  //是否自动显示错误提示
  this.srcElement = null;   //请求服务的源节点
  this.path = null;         //服务的路径
  this.onResponse = null;   //服务器端返回响应信息之后执行的回调函数

  /**
   * 显示错误信息
   * @param  {[type]} msg [description]
   * @return {[type]}     [description]
   */
  this.showError = function (msg) {
    if (this.autoShowErr) alert(msg);
    if (this.onError) this.onError(msg);
  };

  /**
   * 请求
   * @param  {[type]} args       [description]
   * @param  {[type]} onResponse [description]
   * @return {[type]}            [description]
   */
  this.request = function (args, onResponse) {
    if (!this.path) {
      this.showError("请提供服务路径！");
      return;
    }

    if (window.event) this.srcElement = window.event.srcElement;
    if (onResponse) this.onResponse = onResponse;

    if (!args) args = {};
    this.args = args;

    this.encryptRequestArgs = this.args.encryptRequestArgs;
    this.encryptResponseArgs = this.args.encryptResponseArgs;
    delete this.args.encryptRequestArgs;
    delete this.args.encryptResponseArgs;

    //设置身份验证信息
    //如果嵌入到第三方系统，会出现跨域错误，需要捕获一下，否则无法执行后续代码
    let haveSetAuth = false;
    //先判断是否有top对象，且top对象中是否有身份验证对象
    try {
      if (typeof (top) != "undefined" && top.taskMsgAuthObj) {
        let authObj = {
          args: {}
        };
        top.taskMsgAuthObj.setAuthData(authObj);

        top.taskMsgAuthObj.encryptRequestData({
          "encryptRequestArgs": this.encryptRequestArgs,
          "_auth_ts": authObj.args._auth_ts
        }, this.args);

        for (let arg in authObj.args) {
          this.args[arg] = authObj.args[arg];
        }
        haveSetAuth = true;
      }
    } catch (err) { }
    //判断是否有window.parent对象，且window.parent对象中是否有身份验证对象
    if (!haveSetAuth) {
      try {
        if (typeof (window.parent) != "undefined" && window.parent.taskMsgAuthObj) {
          let authObj = {
            args: {}
          };
          window.parent.taskMsgAuthObj.setAuthData(authObj);

          window.parent.taskMsgAuthObj.encryptRequestData({
            "encryptRequestArgs": this.encryptRequestArgs,
            "_auth_ts": authObj.args._auth_ts
          }, this.args);

          for (let arg in authObj.args) {
            this.args[arg] = authObj.args[arg];
          }
          haveSetAuth = true;
        }
      } catch (err2) { }
    }
    if (!haveSetAuth) {
      if (typeof (tmClient) != "undefined" && tmClient.mobileType == "dingding") {
        let authObj = {
          args: {}
        };
        window.tmClient.setAuthData(authObj);

        window.tmClient.encryptRequestData({
          "encryptRequestArgs": this.encryptRequestArgs,
          "_auth_ts": authObj.args._auth_ts
        }, args);

        for (let arg in authObj.args) {
          args[arg] = authObj.args[arg];
        }
        haveSetAuth = true;
      }
      else if (typeof (tmClient) != "undefined" && tmClient.mobileType == "workwx") {
        let authObj = {
          args: {}
        };
        window.tmClient.setAuthData(authObj);

        window.tmClient.encryptRequestData({
          "encryptRequestArgs": this.encryptRequestArgs,
          "_auth_ts": authObj.args._auth_ts
        }, args);

        for (let arg in authObj.args) {
          args[arg] = authObj.args[arg];
        }
        haveSetAuth = true;
      }
      else if (typeof (tmClient) != "undefined"
        && ((tmClient.clientOSType == "iOS" && typeof (window.webkit) != "undefined")
          || (tmClient.clientOSType == "Android" && typeof (window.TMAndroidClient) != "undefined"))) {
        var that = this;
        tmClient.getAuthData(function (authData) {
          //TODO
          if (authData.auth_org) that.args._auth_org = authData.auth_org;
          that.args._auth_ts = authData._auth_ts;
          that.args._auth_data = authData._auth_data;

          that.sendRequest();
        });
        return;
      } else {
        if (getUrlArg("_auth_org")) args._auth_org = getUrlArg("_auth_org");
        if (getUrlArg("_auth_ts")) args._auth_ts = getUrlArg("_auth_ts");
        if (getUrlArg("_auth_data")) args._auth_data = getUrlArg("_auth_data");
      }
    }

    this.sendRequest();
  };

  /**
   * 获取请求对象
   * @return {[type]}         [description]
   */
  this.getHttpRequest = function () {
    var httpRequest;
    if (window.XMLHttpRequest) {
      httpRequest = new XMLHttpRequest();
    } else if (window.ActiveXObject) {
      httpRequest = new ActiveXObject("Msxml2.XMLHTTP");
      if (!httpRequest) {
        httpRequest = new ActiveXObject("Microsoft.XMLHTTP");
      }
    }
    if (!httpRequest) {
      alert("您的浏览器不支持Ajax，无法执行该操作！");
      return null;
    }
    return httpRequest;
  }

  /**
   * 是否是移动端
   * @return {Boolean} [description]
   */
  this.isMobile = function () {
    return /Android|webOS|iPhone|iPad|Windows Phone|iPod|BlackBerry|SymbianOS|Nokia|Mobile/i.test(navigator.userAgent);
  }

  /**
   * 发送请求
   * @return {[type]} [description]
   */
  this.sendRequest = function () {
    this.args.service = this.path;

    var httpRequest = this.getHttpRequest();
    try {
      var that = this;
      httpRequest.onreadystatechange = function () {
        if (httpRequest.readyState == 4) {
          if (httpRequest.status == 200) {
            var response = JSON.parse(httpRequest.responseText);

            if (that.encryptResponseArgs) {
              let haveSetAuth = false;
              try {
                if (typeof (top) != "undefined" && top.taskMsgAuthObj) {
                  top.taskMsgAuthObj.decryptResponseData({
                    "encryptResponseArgs": that.encryptResponseArgs,
                    "_auth_ts": that.args._auth_ts
                  }, response);
                  haveSetAuth = true;
                }
              }
              catch (err) { }
              if (!haveSetAuth) {
                try {
                  if (typeof (window.parent) != "undefined" && window.parent.taskMsgAuthObj) {
                    window.parent.taskMsgAuthObj.decryptResponseData({
                      "encryptResponseArgs": that.encryptResponseArgs,
                      "_auth_ts": that.args._auth_ts
                    }, response);
                    haveSetAuth = true;
                  }
                } catch (err2) { }
              }

              if (!haveSetAuth) {
                if (typeof (tmClient) != "undefined" && tmClient.mobileType == "dingding") {
                  window.tmClient.decryptResponseData({
                    "encryptResponseArgs": that.encryptResponseArgs,
                    "_auth_ts": that.args._auth_ts
                  }, response);
                  haveSetAuth = true;
                }
                else if (typeof (tmClient) != "undefined" && tmClient.mobileType == "workwx") {
                  window.tmClient.decryptResponseData({
                    "encryptResponseArgs": that.encryptResponseArgs,
                    "_auth_ts": that.args._auth_ts
                  }, response);
                  haveSetAuth = true;
                }
                else if (typeof (tmClient) != "undefined"
                  && ((tmClient.clientOSType == "iOS" && typeof (window.webkit) != "undefined")
                    || (tmClient.clientOSType == "Android" && typeof (window.TMAndroidClient) != "undefined"))) {
                  //TODO
                }
              }
            }

            if (response.code === 0) {
              if (that.onResponse) {
                if (that.srcElement) that.args.srcElement = that.srcElement;
                if (typeof that.onResponse == "function") {
                  that.onResponse(that.args, response);
                } else {
                  if (that.onResponse.indexOf(".") < 0 && that.onResponse.indexOf(" ") < 0
                    && that.onResponse.indexOf("=") < 0 && that.onResponse.indexOf("(") < 0
                    && that.onResponse.indexOf(")") < 0) {
                    eval(that.onResponse + "(that.args, response)");
                  } else {
                    eval(that.onResponse);
                  }
                }
              }
            } else {
              if (response.code == 501) {
                if (that.isMobile()) {
                  alert("请提供有效的身份验证信息！");
                } else {
                  try {
                    //top.location = "/";
                  } catch (err) { }
                }
                return;
              }
              that.showError(response.message);
            }
          } else if (httpRequest.status == 404) {
            that.showError("请求的服务不存在！");
          } else {
            if (httpRequest.status !== 0)
              that.showError("向服务器发送请求时发生意外错误！\r\n错误代码：" + httpRequest.status);
          }
        }
      };

      var serverPath = location.toString();
      serverPath = serverPath.substr(0, serverPath.indexOf("/", 8) + 1);
      httpRequest.open("POST", serverPath + "Service", true);
      httpRequest.setRequestHeader("ServicePath", (function () {
        if (that.args.app) return that.args.app + '/service/' + that.args.service;
        else return that.args.service;
      })());
      httpRequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
      httpRequest.send(JSON.stringify(this.args));
    } catch (e) {
      this.showError("向服务器发送请求时发生意外错误！\r\n错误描述：" + e.message);
    }
  };
}