/**
 * 钉钉客户端浏览器扩展对象
 * @type {TaskMsgClient}
 */

// 获取登录类型
var loginType = localStorage.getItem('loginType') ? localStorage.getItem('loginType') : "mobile"

function TaskMsgClient() {
  this.TMiOSClientIsInit = false; //iOS客户端是否已初始化
  this.isDisableGoBack = false; //是否禁止退回
  this.AndroidClientCallBackFuncIndex = 1000; //安卓客户端回调函数索引
  this.clientOSType = ""; //客户端类型
  this.mobileType = 'dingding';

  /**
   * 初始化客户端对象
   * @return {[type]} [description]
   */
  this.init = function () {
    // alert(navigator.userAgent)
    //获得客户端类型
    if (navigator.userAgent.indexOf("iPhone") > 0) {
      if (navigator.userAgent.indexOf("Safari") > 0) {
        this.clientOSType = "web";
      } else {
        this.clientOSType = "iOS";
      }
    } else if (
      navigator.userAgent.indexOf("Windows") > 0 ||
      navigator.userAgent.indexOf("Mac OS") > 0) {
      this.clientOSType = "PC";
    } else {
      this.clientOSType = "Android";
    }
  };

  //以下变量为私有变量，不能暴露在外面
  this._sessionId;
  this._loginname;
  this._orgCode;
  this._orgKey;
  this._userId;
  this._datatype;
  this._pwd;
  this.haveLoad = false;
  /**
   * 获取authData
   */
  this.loadAuthData = function () {
    this._sessionId = localStorage.getItem("s");
    if (localStorage.getItem("loginType") == 'mobile') {
      this._loginname = localStorage.getItem("mobile");
    } else {
      this._loginname = localStorage.getItem("l");
    }
    this._pwd = localStorage.getItem("p");
    var authData = localStorage.getItem("d");
    var authTs = localStorage.getItem("t");
    if (authData) {
      var ivData = [this._loginname, this._pwd, 'web', parseInt(authTs)];
      var iv = CryptoJS.MD5(JSON.stringify(ivData)).toString().substr(0, 16);
      ivData.push(iv);
      var key = CryptoJS.MD5(JSON.stringify(ivData)).toString();

      var data = CryptoJS.AES.decrypt(authData,
        CryptoJS.enc.Utf8.parse(key), {
        iv: CryptoJS.enc.Utf8.parse(iv),
        mode: CryptoJS.mode.CBC
      }).toString(CryptoJS.enc.Utf8);
      var arr = JSON.parse(data);
      this._orgCode = arr[0];
      this._userId = arr[1];
      this._orgKey = arr[2];
      if (arr.length >= 4) _datatype = arr[3];

      arr = null;
      data = null;
      ivData = null;
      this.haveLoad = true;
    }
  };

  this.setAuthData = function (service) {
    if (!this._orgCode || !this._orgKey) {
      return;
    }
    if (!service.args) service.args = {};
    service.args.sessionId = this._sessionId;
    service.args._auth_ts = (new Date()).getTime();
    service.args._auth_org = this._orgCode;
    var signData = [this._orgCode, this._orgKey, service.args._auth_ts];
    var iv = CryptoJS.MD5(JSON.stringify(signData)).toString().substr(0, 16);
    signData.push(iv);
    var key = CryptoJS.MD5(JSON.stringify(signData)).toString();
    var loginData = "";
    if (_datatype && _datatype == 'accountcode') {
      loginData = ['accountcode', _userId, 'web'];
    }
    else if (this._userId && this._userId != "") {
      loginData = ['userid', this._userId, 'web'];
    } else {
      loginData = ['loginname', this._loginname, 'web'];
    }
    signData.push(this._pwd);
    //暂时不对请求参数进行签名，因为服务器端怎么校验还没想清楚
    //for(p in msg) {
    //signData.push(msg[p]);
    //}
    loginData.push(CryptoJS.MD5(JSON.stringify(signData)).toString());
    signData = null;
    if (service.encArgs) loginData.push(JSON.stringify(service.encArgs));
    service.args._auth_data = CryptoJS.AES.encrypt(JSON.stringify(loginData),
      CryptoJS.enc.Utf8.parse(key), {
      iv: CryptoJS.enc.Utf8.parse(iv),
      mode: CryptoJS.mode.CBC
    }).toString();
    return service;
  };

  this.encryptRequestData = function (p, args) {
    if (p.encryptRequestArgs) {
      var eniv = "";
      var enkey = "";
      if (p._auth_ts) {
        var ensign = [p._orgCode || _orgCode, p._orgKey || _orgKey, p._auth_ts];
        eniv = CryptoJS.MD5(JSON.stringify(ensign)).toString().substr(0, 16);
        ensign.push(eniv);
        enkey = CryptoJS.MD5(JSON.stringify(ensign)).toString();
      }
      else {
        eniv = CryptoJS.MD5('1234567890abcdef1234567890abcdef').toString().substr(0, 16);
        enkey = CryptoJS.MD5('tasgine-meanssoft').toString();
      }

      var enargs = p.encryptRequestArgs.split(',');
      for (let i = 0; i < enargs.length; i++) {
        var arg = args[enargs[i]];
        if (arg !== null && typeof arg !== 'undefined') {
          if (typeof arg === 'object') {
            args[enargs[i]] = CryptoJS.AES.encrypt(JSON.stringify(arg),
              CryptoJS.enc.Utf8.parse(enkey), {
              iv: CryptoJS.enc.Utf8.parse(eniv),
              mode: CryptoJS.mode.CBC
            }).toString();
          }
          else {
            args[enargs[i]] = CryptoJS.AES.encrypt(arg.toString(),
              CryptoJS.enc.Utf8.parse(enkey), {
              iv: CryptoJS.enc.Utf8.parse(eniv),
              mode: CryptoJS.mode.CBC
            }).toString();
          }
        }
      }
    }
  };

  this.decryptResponseData = function (p, args) {
    if (p.encryptResponseArgs) {
      var eniv = "";
      var enkey = "";
      if (p._auth_ts) {
        var ensign = [p._orgCode || _orgCode, p._orgKey || _orgKey, p._auth_ts];
        eniv = CryptoJS.MD5(JSON.stringify(ensign)).toString().substr(0, 16);
        ensign.push(eniv);
        enkey = CryptoJS.MD5(JSON.stringify(ensign)).toString();
      }
      else {
        eniv = CryptoJS.MD5('1234567890abcdef1234567890abcdef').toString().substr(0, 16);
        enkey = CryptoJS.MD5('tasgine-meanssoft').toString();
      }

      var enargs = p.encryptResponseArgs.split(',');
      for (let i = 0; i < enargs.length; i++) {
        var arg = args[enargs[i]];
        if (arg) {
          args[enargs[i]] = CryptoJS.AES.decrypt(arg,
            CryptoJS.enc.Utf8.parse(enkey), {
            iv: CryptoJS.enc.Utf8.parse(eniv),
            mode: CryptoJS.mode.CBC
          }).toString(CryptoJS.enc.Utf8);
          try {
            args[enargs[i]] = JSON.parse(args[enargs[i]]);
          } catch (e) { }
        }
      }
    }
  };

  var authLogin = false;
  var code = ''
  var tsDiff = 0;
  var dUserId = ''
  var mobile = '';

  // 登录页初始化加载
  this.checkLogin = function (loadobj, cb) {
    var that = this;
    localStorage.setItem('loginType', loginType);
    dUserId = localStorage.getItem('u');
    var loginInfo = localStorage.getItem('l') || localStorage.getItem('mobile');
    var pwd = localStorage.getItem('p');
    if (dUserId && pwd && loginInfo) {
      authLogin = true;
      return cb(true)
    } else {
      authLogin = false;
    }
    that.getloginData(cb);
  }


  this.getloginData = function (cb) {
    var args = {};
    var that = this;
    args.notAuth = true;
    var service = new TaskMsgService();
    service.path = "sys/service/getSysData";
    service.request(args, function (req, res) {
      localStorage.setItem('orgcode', res.orgcode);
      if (res.ts) tsDiff = new Date().getTime() - res.ts;
      var getAny = { dd: "corpid,agentid,directLogin,realmName,home,login" };
      that.getddInfo(getAny, function () {
        that.getCode(function () {
          // 如果已经登录过则直接登录
          if (authLogin) {
            that.tologin({}, cb);
          } else {
            that.getUserinfo(cb);
          }
        });
      });
    });
  }

  // 放入钉钉设置内容
  this.getddInfo = function (getAny, cb) {
    var args = {};
    var that = this;
    args.filepath = window.location.pathname.split('/')[2];
    args.getAny = getAny;
    var service = new TaskMsgService();
    service.path = "dev/service/proj/getPro";
    service.request(args, function (req, res) {
      if (res.data) {
        if (getAny.dd) {
          getAny.dd = getAny.dd.split(',');
          for (var x = 0; x < getAny.dd.length; x++) {
            that[getAny.dd[x]] = res.data.dd[getAny.dd[x]];
            localStorage.setItem(getAny.dd[x], res.data.dd[getAny.dd[x]]);
          }
        }
        cb(res.data);
      } else {
        cb(false)
      }
    });
  }

  this.getCode = function (cb) {
    var that = this;
    try {
      dd.ready(function () {
        dd.runtime.permission.requestAuthCode({
          corpId: that.corpid,
          // 企业id
          onSuccess: function (info) {
            code = info.code; // 通过该免登授权码可以获取用户身份
            cb()
          },
          onFail: function (err) {
            alert(JSON.stringify(err));
            cb(false)
          }
        });
      });
    } catch (error) {
      cb(false);
    }
  }

  //获取钉钉用户信息
  this.getUserinfo = function (cb) {
    var that = this;
    let args = {};
    args.notAuth = true;
    args.filepath = window.location.pathname.split('/')[2];
    args.code = code;
    var service = new TaskMsgService();
    service.path = "sys/service/dingding/getOauth2Dingtalk";
    service.request(args,
      function (req, res) {
        dUserId = res.userid;
        mobile = res.userinfo.mobile;
        localStorage.setItem("mobile", mobile);
        localStorage.setItem('u', dUserId);
        localStorage.setItem('ddunionid', res.userinfo.unionid);
        // 手机号直接登录 开启 
        // if (that.directLogin) {
        //     that.tologin({
        //         loginType: 'mobile',
        //         mobile: mobile
        //     }, cb);
        // } else {
        tfp.gotoPage(that.login);
        cb(false)
        // location = that.login;
        // }
      });

  }

  // 登录
  this.tologin = function (loginobj, cb) {
    var that = this;
    var args = {};
    // 未登录过
    if (!authLogin) {
      // 手机号直接登录 没加
      if (loginType == 'mobile') {
        args.mobile = $("#mobile").val();
        if (!args.mobile) {
          alert('请输入手机号！');
          $("#mobile").focus();
          return cb(false)
        }
      } else {
        args.loginname = $("#loginname").val();
        if (!args.loginname) {
          alert('请输入个人账号！');
          $("#loginname").focus();
          return cb(false)
        }
      }
      var pwd = $("#password").val();
      if (!pwd) {
        alert('请输入登录密码！');
        $("#password").focus();
        return cb(false)
      }
    } else {
      // 已登陆过
      // location = that.home;
      return cb(true)
    }
    args.clientType = 'web';
    args.ts = new Date().getTime() - tsDiff;
    pwd = CryptoJS.MD5(pwd).toString();
    var ivData;
    if (loginType == 'mobile') {
      ivData = [args.mobile, pwd, args.clientType, args.ts];
    } else {
      ivData = [args.loginname, pwd, args.clientType, args.ts];
    }
    var iv = CryptoJS.MD5(JSON.stringify(ivData)).toString().substr(0, 16);
    ivData.push(iv);
    var key = CryptoJS.MD5(JSON.stringify(ivData)).toString();
    args.data = CryptoJS.AES.encrypt(JSON.stringify(ivData), CryptoJS.enc.Utf8.parse(key), {
      iv: CryptoJS.enc.Utf8.parse(iv),
      mode: CryptoJS.mode.CBC
    }).toString();
    args.dts = new Date().getTime();
    args.keycode = code;
    args.otherdata = that.handlerOtherCode(dUserId, args.keycode, args.dts);
    args.otherlogin = authLogin;
    args.loginType = loginType;
    args.notAuth = true;
    ivData = null;
    var service = new TaskMsgService();
    service.path = "sys/service/login";
    service.request(args, function (req, res) {
      if (res.code == 0) {
        localStorage.setItem("s", res.sessionId);
        localStorage.setItem("l", req.loginname);
        localStorage.setItem("mobile", req.mobile);
        localStorage.setItem("p", pwd);
        localStorage.setItem("d", res.data);
        localStorage.setItem("t", res.ts);
        localStorage.setItem("sex", res.userSex);
        localStorage.setItem("orgname", res.orgName);
        localStorage.setItem('f', tsDiff);
        localStorage.setItem("loginType", loginType)
        authLogin = false;
        // location = localStorage.getItem("home");
        tfp.gotoPage(localStorage.getItem("home"));
        return cb(true);
      } else {
        cb(false)
      }
    });
  }
  //加密
  this.handlerOtherCode = function (othercode, keycode, dts) {
    var keytmp = [keycode, "mini", dts];
    var iv = CryptoJS.MD5(JSON.stringify(keytmp)).toString().substr(0, 16);
    keytmp.push(iv);
    var key = CryptoJS.MD5(JSON.stringify(keytmp)).toString();
    var text = [othercode, "mini", dts];
    var otherdata = CryptoJS.AES.encrypt(JSON.stringify(text), CryptoJS.enc.Utf8.parse(key), {
      iv: CryptoJS.enc.Utf8.parse(iv),
      mode: CryptoJS.mode.CBC,
    }).toString();
    return otherdata;
  };

  // 钉钉组件授权
  this.empower = function (cb) {
    var that = this;
    dd.device.notification.showPreloader({
      text: "使劲加载中..", //loading显示的字符，空表示不显示文字
      showIcon: true, //是否显示icon，默认true
      onSuccess: function (result) {
        let args = {};
        args.timestamp = new Date().getTime();
        args.url = location.href.split('#')[0];
        args.noTmClient = true;
        args.filepath = window.location.pathname.split('/')[2];
        var service = new TaskMsgService();
        service.path = "sys/service/dingding/getConfigDingtalk";
        service.request(args, function (req, res) {
          if (res.code == 0) {
            dd.device.notification.hidePreloader({
              onSuccess: function (result) {
                // console("获取鉴权信息成功：" + JSON.stringify(res));
                that.afterEmpower(res, cb);
              },
              onFail: function (err) {
                dd.device.notification.hidePreloader()
              }
            });
          } else {
            alert(res.message);
            dd.device.notification.hidePreloader()
          }
        });
      },
      onFail: function (err) {
        alert(JSON.stringify(err));
        dd.device.notification.hidePreloader()
      }
    })
  }

  this.afterEmpower = function (info, cb) {
    var that = this;
    that.agentid = info.agentid;
    that.corpid = info.corpid;
    that.realmName = info.realmName;
    dd.config({
      agentId: info.agentid, // 必填，微应用ID
      corpId: info.corpid,//必填，企业ID
      timeStamp: info.time_stamp, // 必填，生成签名的时间戳
      nonceStr: info.nonceStr, // 必填，自定义固定字符串。
      signature: info.sign, // 必填，签名
      type: 0,   //选填。0表示微应用的jsapi,1表示服务窗的jsapi；不填默认为0。该参数从dingtalk.js的0.8.3版本开始支持
      jsApiList: [
        'biz.util.chooseImage', //选择图片
        'device.geolocation.get', //获取当前地理位置信息（单次定位）
        'biz.map.search', //地图页面支持搜索
        'biz.map.view', //地图展示位置
        'biz.util.scan',
        'biz.util.scanCard',  //扫名片
        'device.base.getUUID', //获取UUID
        'device.base.getInterface', //获取热点接入信息
        'biz.contact.complexPicker', //选择部门和人
        'biz.contact.departmentsPicker', //选择部门信息
        'biz.contact.rolesPicker', //选择角色信息
        'device.audio.startRecord', //开始录音
        'biz.util.uploadAttachment',//上传附件到钉盘
      ] // 必填，需要使用的jsapi列表，注意：不要带dd。
    });
    dd.error(function (err) {
      alert('dd error: ' + JSON.stringify(err));
      return cb(false)
    })//该方法必须带上，用来捕获鉴权出现的异常信息，否则不方便排查出现的问题
    cb()
  }

  /**
   * 显示图片选择窗口
   * @param  {[type]}  cb [回调函数]
   * @param  {Boolean} maxCount [最大可选照片数]
   * @param  {Boolean} sourceType   [相册选取或者拍照,默认 ['camera','album'] ]
   * @param  {[type]}  position     [机拍照默认使用的摄像头'front'或'back']
   */
  this.showImagePicker = function (args, cb) {
    if (!args.sourceType) args.sourceType = ['camera', 'album'];
    if (!args.position) args.position = ['back'];
    if (!args.maxCount) args.maxCount = 1;
    dd.ready(function () {
      dd.biz.util.chooseImage({
        count: args.maxCount, //最大可选照片数，默认1张。当sourceType参数内只有camera时，该参数只能传1。
        secret: false, //相机拍照生成的图片，是否存储到私有目录。仅Android端并且钉钉客户端是6.5.27及以上版本支持。
        sourceType: args.sourceType, //相册选取或者拍照，默认 ['camera','album']。
        position: args.position, //相机拍照默认使用的摄像头'front'或'back'。仅Android端并且钉钉客户端是6.5.27及以上版本支持。
        onSuccess: (res) => {
          cb(res)
          /*
          {
              filePaths:['xxxx'],  //图片的虚拟路径列表。
              files:[
                  {
                      path:'xxx',  //图片的虚拟路径。
                      size:100,  //文件大小，单位Byte。
                      fileType:'jpg'  //文件类型。
                  }
              ]
          }
          */
          // alert(JSON.stringify(res));
        },
        onFail: (err) => {
          cb(false)
          // alert(JSON.stringify(err));
        }
      })
    });
  };

  /**
   * 显示图片
   * @param  {[type]} imagePath [description]
   * @param  {[type]} imageCode [description]
   * @return {[type]}           [description]
   */
  this.showImage = function (args, cb) {
    var that = this;
    var beforesrc = '/Download?showImage=true&fileCode=';
    if (!args.imageCode) return cb(false);
    if (args.imageCode.indexOf('http') == -1 || args.imageCode.indexOf('Download') == -1) {
      args.imageCode = that.realmName + beforesrc + args.imageCode;
    }
    var list = [];
    var index = 0;
    if (typeof args.imageList == 'string') args.imageList = JSON.parse(args.imageList);
    for (var x = args.imageList.length - 1; x >= 0; x--) {
      if (args.imageList[x].indexOf('http') == -1) {
        args.imageList[x] = that.realmName + beforesrc + args.imageList[x];
      }
      list[index] = args.imageList[x];
      index++;
    }
    //图片预览
    dd.ready(function () {
      dd.biz.util.previewImage({
        urls: list,//图片地址列表
        current: args.imageCode,//当前显示的图片链接，建议使用png、jpg格式图片
        onSuccess: function (result) {
          /**/
          cb(true)
        },
        onFail: function (err) {
          alert(JSON.stringify(err));
          cb(false)
        }
      });
    })
  };


  /**
   * 上传文件 仅支持安卓
   * @param {*} args 
   * @param {*} cb 
   */
  this.uploadAttach = function (args, cb) {
    dd.ready(function () {
      var topurl = location.href.split('#')[0].split('/app/')[0];
      dd.biz.util.uploadFile({
        // url: 'http://om.taskmsg.com:7112/TaskMsgUpload?appCode=' + args.appCode,
        url: args.topurl + '/TaskMsgUpload?appCode=' + args.appCode,
        filePath: args.filePaths,
        name: args.appCode,
        onSuccess: (res) => {
          cb(res)
        },
        onFail: (err) => {
          alert("上传失败" + JSON.stringify(err))
          cb(false)
        }
      });
    })
  }

  /**
   * 扫码
   * @param {*} args 
   * @param {*} cb 
   */
  this.showCodeScanner = function (cb) {
    dd.ready(function () {
      dd.biz.util.scan({
        type: 'all', // type 为 all、qrCode、barCode，默认是all。
        onSuccess: function (data) {
          /* data结构
              { 'text': String}
          */
          cb(data.text)
        },
        onFail: function (err) {
          // 调用失败时回调
          cb(false)
        }
      });
    });
  }

  /**
   * 分享
   * @param {*} args 
   * @param {*} cb 
   */
  this.share = function (args, cb) {
    dd.ready(function () {
      dd.biz.util.share({
        type: 0, //分享类型，0:全部组件 默认；1:只能分享到钉钉；2:不能分享，只有刷新按钮
        url: args.url ? args.url : '', //url地址
        title: args.title ? args.title : '', //分享标题
        content: args.content ? args.content : '', //分享内容
        image: args.imageUrl ? args.imageUrl : '', //分享的图片url地址
        onSuccess: function () {
          //onSuccess将在调起分享组件成功之后回调
          /**/
          // alert('分享成功！');
          cb(true)
        },
        onFail: function (err) {
          cb(false)
        }
      })
    });
  }


  /**
   * 获取当前地理位置信息（单次定位）
   * @param {*} args 
   * @param {*} cb 
   */
  this.getLocation = function (cb) {
    dd.ready(function () {
      dd.device.geolocation.get({
        targetAccuracy: 200, //期望定位精度半径(单位米); 推荐采用200m
        coordinate: 1, //1：获取高德坐标  0：获取标准坐标
        withReGeocode: true, //是否需要带有逆地理编码信息。
        useCache: true, //默认是true，如果需要频繁获取地理位置，请设置false
        onSuccess: function (result) {
          /* 高德坐标 result 结构
          {
              longitude : Number,
              latitude : Number,
              accuracy : Number,
              address : String,
              province : String,
              city : String,
              district : String,
              road : String,
              netType : String,
              operatorType : String,
              locationType：1,
              errorMessage : String,
              errorCode : Number,
              isWifiEnabled : Boolean,
              isGpsEnabled : Boolean,
              isFromMock : Boolean,
              provider : wifi|lbs|gps,
              isMobileEnabled : Boolean
          }
          */
          cb(result)
          // alert(JSON.stringify(result));
        },
        onFail: function (err) {
          cb(false)
        }
      });
    });
  }

  /**
   * 地图页面支持搜索
   * @param {*} latitude 纬度
   * @param {*} longitude 经度
   * @param {*} scope 搜索半径
   * @param {*} cb 
   */
  this.search = function (latitude, longitude, scope, cb) {
    dd.ready(function () {
      dd.biz.map.search({
        latitude: latitude ? latitude : 0, // 纬度
        longitude: longitude ? longitude : 0, // 经度
        scope: scope ? scope : 500, // 限制搜索POI的范围；设备位置为中心，scope为搜索半径(默认500)
        onSuccess: function (poi) {
          /* poi 结构
          {
              province: 'xxx', // POI所在省会，可能为空
              provinceCode: 'xxx', // POI所在省会编码，可能为空
              city: 'xxx', // POI所在城市，可能为空
              cityCode: 'xxx', // POI所在城市，可能为空
              adName: 'xxx', // POI所在区名称，可能为空
              adCode: 'xxx', // POI所在区编码，可能为空
              distance: 'xxx', // POI与设备位置的距离
              postCode: 'xxx', // POI的邮编，可能为空
              snippet: 'xxx', // POI的街道地址，可能为空
              title: 'xxx', // POI的名称
              latitude: 39.903578, // POI的纬度
              longitude: 116.473565, // POI的经度
          }
          */
          // alert(JSON.stringify(poi));
          cb(poi)
        },
        onFail: function (err) {
          cb(false)
        }
      });
    });
  }

  /**
   * 展示位置
   * @param {*} args
   * @param {*} cb 
   */
  this.showLocation = function (args, cb) {
    dd.ready(function () {
      dd.biz.map.view({
        latitude: args.latitude, // 纬度
        longitude: args.longitude, // 经度
        title: args.address // 地址/POI名称
      });
      cb(true)
    });
  }

  /**
   * 扫名片
   * @param {*} args 
   * @param {*} cb 
   */
  this.scanCard = function (cb) {
    dd.ready(function () {
      dd.biz.util.scanCard({ // 无需传参数
        onSuccess: function (data) {
          //onSuccess将在扫码成功之后回调
          /* data结构
           {
             "ADDRESS": "深圳市南山区软件产业基地", 
             "COMPANY": "深圳市李乔科技有限公司", 
             "NAME": "李乔",
             "MPHONE": "861333567890",  
             "PHONE": "01087654321", 
             "POSITION": "CEO", 
             "IMAGE": "http://www.taobao.com/xxx.jpg", 
             "dt_tranfer": "BusinessCard", 
             "request_id": "20161206144554_efd40582d477a29df2e3bc62c260cdae"
          }
          */
          // alert(JSON.stringify(data));
          cb(data)
        },
        onFail: function (err) {
          cb(false)
        }
      })
    });
  }

  /**
   * 日期选择器
   * 默认格式 'yyyy-MM-dd'
   * @param {*} args {默认显示日期dataValue}
   * @param {*} cb 
   */
  this.datepicker = function (args, cb) {
    dd.ready(function () {
      dd.biz.util.datepicker({
        format: 'yyyy-MM-dd',//注意：format只支持android系统规范，即2015-03-31格式为yyyy-MM-dd
        value: args.dataValue, //默认显示日期
        onSuccess: function (result) {
          //onSuccess将在点击完成之后回调
          /*{
              value: "2015-02-10"
          }
          */
          // alert(JSON.stringify(result));
          cb(result)
        },
        onFail: function (err) {
          cb(false)
        }
      })
    });
  }

  /**
   * 时间选择器
   * 默认格式 'HH:mm'
   * @param {*} args {默认显示时间timeValue}
   * @param {*} cb 
   */
  this.timepicker = function (args, cb) {
    dd.ready(function () {
      dd.biz.util.timepicker({
        format: 'HH:mm',
        value: args.timeValue, //默认显示时间  0.0.3
        onSuccess: function (result) {
          //onSuccess将在点击完成之后回调
          /*{
              value: "10:00"
          }
          */
          // alert(JSON.stringify(result));
          cb(result)
        },
        onFail: function (err) {
          cb(false)
        }
      })
    });
  }

  /**
   * 日期及时间选择器
   * 默认格式 'yyyy-MM-dd HH:mm'
   * @param {*} args {默认显示时间datatimeValue}
   * @param {*} cb 
   */
  this.datetimepicker = function (args, cb) {
    dd.ready(function () {
      dd.biz.util.datetimepicker({
        format: 'yyyy-MM-dd HH:mm',
        value: args.datatimeValue, //默认显示
        onSuccess: function (result) {
          //onSuccess将在点击完成之后回调
          /*{
              value: "2015-06-10 09:50"
          }
          */
          // alert(JSON.stringify(result));
          cb(result)
        },
        onFail: function (err) {
          cb(false)
        }
      })
    });
  }

  /**
   * 获取手机基础信息
   * @param {*} args 
   * @param {*} cb 
   */
  this.getPhoneInfo = function (cb) {
    dd.ready(function () {
      dd.device.base.getPhoneInfo({
        onSuccess: function (data) {
          /*
          {
              screenWidth: 1080, // 手机屏幕宽度
              screenHeight: 1920, // 手机屏幕高度
              brand:'Mi', // 手机品牌
              model:'Note4', // 手机型号
              version:'7.0', // 版本
              netInfo:'wifi', // 网络类型 wifi／4g／3g 
              operatorType:'xx' // 运营商信息
          }
          */
          // alert(JSON.stringify(data));
          cb(data)
        },
        onFail: function (err) {
          cb(false)
        }
      });
    });
  }
  /**
   * 获取uuid
   * @param {*} args 
   * @param {*} cb 
   */
  this.getUUID = function (cb) {
    dd.ready(function () {
      dd.device.base.getUUID({
        onSuccess: function (data) {
          /*
          {
              uuid: '3udbhg98ddlljokkkl' //
          }
          */
          // alert(data.uuid);
          cb(data.uuid)
        },
        onFail: function (err) {
          cb(false)
        }
      });
    });
  }

  /**
  * 获取热点接入信息
  * @param {*} args 
  * @param {*} cb 
  */
  this.getInterface = function (cb) {
    dd.ready(function () {
      dd.device.base.getInterface({
        onSuccess: function (data) {
          /*
          {
              ssid: 'alibaba-inc',
              macIp: '3c:12:aa:09'
          }
          */
          // alert(JSON.stringify(data));
          cb(data)
        },
        onFail: function (err) {
          cb(false)
        }
      });
    });
  }

  /**
   * 获取wifi状态
   * @param {*} args 
   * @param {*} cb 
   */
  this.getWifiInfo = function (cb) {
    dd.ready(function () {
      dd.device.base.getWifiStatus({
        onSuccess: function (data) {
          /*
          {
              status: 1 // 1 ：enable；0 : disable
          }
          */
          // alert(JSON.stringify(data));
          cb(data)
        },
        onFail: function (err) {
          cb(false)
        }
      });
    });
  }
  /**
  * 获取网络类型
  * @param {*} args 
  * @param {*} cb 
  */
  this.getNetState = function (args, cb) {
    dd.ready(function () {
      dd.device.connection.getNetworkType({
        onSuccess: function (data) {
          /*
          {
              result: 'wifi' // result值: wifi 2g 3g 4g unknown none   none表示离线
          }
          */
          // alert(JSON.stringify(data));
          cb(data)
        },
        onFail: function (err) {
          cb(false)
        }
      });
    });
  }

  /**
   * 创建钉盘文件夹
   * @param {*} args 
   * @param {*} cb 
   */
  this.addspaces = function (cb) {
    var that = this;
    var getAny = { dd: "corpid,agentid,directLogin,realmName,home,login" };
    that.getddInfo(getAny, function () {
      that.getCode(function () {
        let args = {};
        args.notAuth = true;
        args.filepath = window.location.pathname.split('/')[2];
        args.code = code;
        args.unionid = localStorage.getItem('ddunionid');
        var service = new TaskMsgService();
        service.path = "sys/service/dingding/addspaces";
        service.request(args, function (req, res) {
          var spaceid = res.space.spaceId;
          cb(spaceid)
        });
      });
    });
  }

  // 上传附件到钉盘/从钉盘选择文件
  this.uploadAttachment = function (obj, cb) {
    var that = this;
    if (!obj.types) {
      obj.types = ["photo", "camera"];
    }
    if (!obj.multiple) {
      obj.multiple = false;
    }
    if (!obj.maxCount) {
      return
    }
    if (!obj.spaceid) {
      return
    }
    if (Number(obj.maxCount) > 9) {
      obj.maxCount = 9;
    }
    dd.ready(function () {
      dd.biz.util.uploadAttachment({
        types: obj.types,
        image: { "multiple": obj.multiple, "compress": false, "max": Number(obj.maxCount), "spaceId": obj.spaceid.toString() },
        compress: true,
        multiple: obj.multiple,
        max: Number(obj.maxCount),
        isCopy: 1,
        spaceId: obj.spaceid.toString(),
        space: { "spaceId": obj.spaceid.toString(), "isCopy": 1, "max": Number(obj.maxCount) },
        file: { "spaceId": obj.spaceid.toString(), "max": Number(obj.maxCount) },
        onSuccess: function (res) {
          // 调用成功时回调
          if (res.data) {
            cb(res)
          } else {
            cb(false)
          }
        },
        onFail: function (err) {
          // 调用失败时回调
          alert(JSON.stringify(err))
          cb(false)
        }
      });
    });
  }

  /**
   * 上传钉盘结束后 上传到后台 删除钉盘文件夹及其下文件
   * @param {*} args 
   * @param {*} cb 
   */
  this.endupload = function (obj, cb) {
    var that = this;
    that.getCode(function () {
      let args = {};
      args.notAuth = true;
      args.filepath = window.location.pathname.split('/')[2];
      args.code = code;
      args.unionid = localStorage.getItem('ddunionid');
      var service = new TaskMsgService();
      args.spaceid = obj.data[obj.index].spaceId;
      args.dentryId = obj.data[obj.index].fileId;
      // 获取url
      service.path = "sys/service/dingding/endupload";
      service.request(args, function (req, res) {
        // alert(JSON.stringify(res))
        cb(true)
      });
    });
  }

  // 弹出提示
  this.toast = function (obj, cb) {
    dd.ready(function () {
      dd.device.notification.toast({
        icon: obj.icon ? obj.icon : '', //icon样式，不同客户端参数不同，请参考参数说明
        text: obj.text, //提示信息
        duration: 2, //显示持续时间，单位秒，默认按系统规范[android只有两种(<=2s >2s)]
        delay: 0, //延迟显示，单位秒，默认0
        onSuccess: function (result) {
          cb(true)
        },
        onFail: function (err) {
          cb(false)
        }
      })
    })
  }

  // 显示加载
  this.showPreloader = function (obj, cb) {
    dd.ready(function () {
      dd.device.notification.showPreloader({
        text: obj.text ? obj.text : "使劲加载中..", //loading显示的字符，空表示不显示文字
        showIcon: obj.showIcon ? obj.showIcon : true, //是否显示icon，默认true
        onSuccess: function (result) {
          cb(true)
        },
        onFail: function (err) {
          cb(false)
        }
      })
    })
  }

  // 隐藏加载
  this.hidePreloader = function (cb) {
    dd.ready(function () {
      dd.device.notification.hidePreloader({
        onSuccess: function (result) {
          cb(true)
        },
        onFail: function (err) {
          cb(false)
        }
      })
    })
  }


  // 支付生成订单
  this.confirmOrder = function (obj, cb) {
    var args = {};
    var service = new TaskMsgService();
    args.total_fee = obj.total_fee;//支付总额
    args.out_trade_no = obj.out_trade_no;//商户订单号
    args.filepath = window.location.pathname.split('/')[2];
    args.serverUrl = location.href.split('#')[0].split('/app/')[0]; //获取路径
    service.path = "sys/service/wxPayPhone/payOrder";
    service.request(args, function (req, res) {
      if (res.code == 0) {
        window.location = res.h5_url;
        cb(res);
      } else {
        this.showError("支付错误!");
        cb(false);
      }
    });
  }

}


if ((navigator.userAgent + "").indexOf("Electron") < 0) {
  window.tmClient = new TaskMsgClient();
  window.tmClient.init();
  window.tmClient.loadAuthData();
}