
//身份验证对象
var taskMsgAuthObj = null;

/**
 * 任讯权限管理类
 */
function TaskMsgAuthClass() {
  //以下变量为私有变量，不能暴露在外面
  var _sessionId;
  var _loginname;
  var _orgCode;
  var _orgKey;
  var _userId; //_accountcode
  var _datatype;
  var _pwd;
  this.haveLoad = false;

  this.loadAuthData = function () {
    _sessionId = sessionStorage.getItem("s");
    _loginname = sessionStorage.getItem("l");
    _pwd = sessionStorage.getItem("p");
    var authData = sessionStorage.getItem("d");
    var authTs = sessionStorage.getItem("t");
    if (authData) {
      var ivData = [_loginname, _pwd, 'web', parseInt(authTs)];
      var iv = CryptoJS.MD5(JSON.stringify(ivData)).toString().substr(0, 16);
      ivData.push(iv);
      var key = CryptoJS.MD5(JSON.stringify(ivData)).toString();

      var data = CryptoJS.AES.decrypt(authData,
        CryptoJS.enc.Utf8.parse(key), {
        iv: CryptoJS.enc.Utf8.parse(iv),
        mode: CryptoJS.mode.CBC
      }).toString(CryptoJS.enc.Utf8);
      var arr = JSON.parse(data);
      _orgCode = arr[0];
      _userId = arr[1];
      _orgKey = arr[2];
      if (arr.length >= 4) _datatype = arr[3];

      arr = null;
      data = null;
      ivData = null;
      this.haveLoad = true;
    }
  };

  this.setAuthData = function (service) {
    if(_sessionId) service.args.sessionId = _sessionId;
    if (!_orgCode || !_orgKey) {
      return;
    }
    if (!service.args) service.args = {};
    service.args._auth_ts = (new Date()).getTime();
    service.args._auth_org = _orgCode;
    var signData = [_orgCode, _orgKey, service.args._auth_ts];
    var iv = CryptoJS.MD5(JSON.stringify(signData)).toString().substr(0, 16);
    signData.push(iv);
    var key = CryptoJS.MD5(JSON.stringify(signData)).toString();
    var loginData = "";
    if (_datatype && _datatype == 'accountcode') {
      loginData = ['accountcode', _userId, 'web'];
    }
    else if (_userId && _userId != "") {
      loginData = ['userid', _userId, 'web'];
    }
    else {
      loginData = ['loginname', _loginname, 'web'];
    }
    signData.push(_pwd);
    //暂时不对请求参数进行签名，因为服务器端怎么校验还没想清楚
    //for(p in msg) {
    //signData.push(msg[p]);
    //}
    loginData.push(CryptoJS.MD5(JSON.stringify(signData)).toString());
    signData = null;
    if (service.encArgs) loginData.push(JSON.stringify(service.encArgs));
    service.args._auth_data = CryptoJS.AES.encrypt(JSON.stringify(loginData),
      CryptoJS.enc.Utf8.parse(key), {
      iv: CryptoJS.enc.Utf8.parse(iv),
      mode: CryptoJS.mode.CBC
    }).toString();
  };

  this.getAuthUrl = function (url) {
    if (!_orgCode || !_orgKey) {
      return url;
    }
    var ret = url;
    if (ret.indexOf('?') < 0) ret += "?";
    if (ret.indexOf('sessionId') < 0) ret += "&sessionId=" + _sessionId;
    var ts = (new Date()).getTime();
    ret += "&_auth_ts=" + ts + "&_auth_org=" + _orgCode;
    var signData = [_orgCode, _orgKey, ts];
    var iv = CryptoJS.MD5(JSON.stringify(signData)).toString().substr(0, 16);
    signData.push(iv);
    var key = CryptoJS.MD5(JSON.stringify(signData)).toString();
    var loginData = "";
    if (_datatype && _datatype == 'accountcode') {
      loginData = ['accountcode', _userId, 'web'];
    }
    else if (_userId && _userId != "") {
      loginData = ['userid', _userId, 'web'];
    }
    else {
      loginData = ['loginname', _loginname, 'web'];
    }
    signData.push(_pwd);
    //暂时不对请求参数进行签名，因为服务器端怎么校验还没想清楚
    //for(p in msg) {
    //signData.push(msg[p]);
    //}
    loginData.push(CryptoJS.MD5(JSON.stringify(signData)).toString());
    signData = null;
    var auth_data = CryptoJS.AES.encrypt(JSON.stringify(loginData),
      CryptoJS.enc.Utf8.parse(key), {
      iv: CryptoJS.enc.Utf8.parse(iv),
      mode: CryptoJS.mode.CBC
    }).toString();
    ret += "&_auth_data=" + encodeURIComponent(auth_data);
    return ret;
  };

  this.getWSLoginData = function () {
    var loginMsg = {
      service: 'login',
      orgCode: _orgCode,
      ts: (new Date()).getTime()
    };
    var ivData = _orgCode + "," + _orgKey + "," + loginMsg.ts;
    var iv = CryptoJS.MD5(ivData).toString().substr(0, 16);
    var key = CryptoJS.MD5(ivData + "," + iv).toString();
    ivData = null;
    loginMsg.data = CryptoJS.AES.encrypt(_userId + ",websocket," + _sessionId,
      CryptoJS.enc.Utf8.parse(key), {
      iv: CryptoJS.enc.Utf8.parse(iv),
      mode: CryptoJS.mode.CBC
    }).toString();
    return loginMsg;
  };

  this.getAuthData = function (orgCode, orgKey, loginname, password) {
    let ret = {};
    ret._auth_ts = (new Date()).getTime();
    ret._auth_org = orgCode;
    var signData = [orgCode, orgKey, ret._auth_ts];
    var iv = CryptoJS.MD5(JSON.stringify(signData)).toString().substr(0, 16);
    signData.push(iv);
    var key = CryptoJS.MD5(JSON.stringify(signData)).toString();
    var loginData = ['loginname', loginname, 'web'];
    signData.push(CryptoJS.MD5(pwd).toString());
    loginData.push(CryptoJS.MD5(JSON.stringify(signData)).toString());
    signData = null;
    ret._auth_data = CryptoJS.AES.encrypt(JSON.stringify(loginData),
      CryptoJS.enc.Utf8.parse(key), {
      iv: CryptoJS.enc.Utf8.parse(iv),
      mode: CryptoJS.mode.CBC
    }).toString();

    return ret;
  };

  this.encryptRequestData = function (p, args) {
    if (p.encryptRequestArgs) {
      var eniv = "";
      var enkey = "";
      if (p._auth_ts) {
        var ensign = [p._orgCode || _orgCode, p._orgKey || _orgKey, p._auth_ts];
        eniv = CryptoJS.MD5(JSON.stringify(ensign)).toString().substr(0, 16);
        ensign.push(eniv);
        enkey = CryptoJS.MD5(JSON.stringify(ensign)).toString();
      }
      else {
        eniv = CryptoJS.MD5('1234567890abcdef1234567890abcdef').toString().substr(0, 16);
        enkey = CryptoJS.MD5('tasgine-meanssoft').toString();
      }

      var enargs = p.encryptRequestArgs.split(',');
      /*args["_enc_args"] = CryptoJS.AES.encrypt(p.encryptRequestArgs,
        CryptoJS.enc.Utf8.parse(enkey), {
        iv: CryptoJS.enc.Utf8.parse(eniv),
        mode: CryptoJS.mode.CBC
      }).toString();*/
      for (let i = 0; i < enargs.length; i++) {
        var arg = args[enargs[i]];
        if (arg !== null && typeof arg !== 'undefined') {
          if (typeof arg === 'object') {
            args[enargs[i]] = CryptoJS.AES.encrypt(JSON.stringify(arg),
              CryptoJS.enc.Utf8.parse(enkey), {
              iv: CryptoJS.enc.Utf8.parse(eniv),
              mode: CryptoJS.mode.CBC
            }).toString();
          }
          else {
            args[enargs[i]] = CryptoJS.AES.encrypt(arg.toString(),
              CryptoJS.enc.Utf8.parse(enkey), {
              iv: CryptoJS.enc.Utf8.parse(eniv),
              mode: CryptoJS.mode.CBC
            }).toString();
          }
        }
      }
    }
  };

  this.decryptResponseData = function (p, args) {
    if (p.encryptResponseArgs) {
      var eniv = "";
      var enkey = "";
      if (p._auth_ts) {
        var ensign = [p._orgCode || _orgCode, p._orgKey || _orgKey, p._auth_ts];
        eniv = CryptoJS.MD5(JSON.stringify(ensign)).toString().substr(0, 16);
        ensign.push(eniv);
        enkey = CryptoJS.MD5(JSON.stringify(ensign)).toString();
      }
      else {
        eniv = CryptoJS.MD5('1234567890abcdef1234567890abcdef').toString().substr(0, 16);
        enkey = CryptoJS.MD5('tasgine-meanssoft').toString();
      }

      let encArgs = CryptoJS.AES.decrypt(p.encryptResponseArgs,
        CryptoJS.enc.Utf8.parse(enkey), {
        iv: CryptoJS.enc.Utf8.parse(eniv),
        mode: CryptoJS.mode.CBC
      }).toString(CryptoJS.enc.Utf8);
      var enargs = encArgs.split(',');
      for (let i = 0; i < enargs.length; i++) {
        var arg = args[enargs[i]];
        if (arg) {
          args[enargs[i]] = CryptoJS.AES.decrypt(arg,
            CryptoJS.enc.Utf8.parse(enkey), {
            iv: CryptoJS.enc.Utf8.parse(eniv),
            mode: CryptoJS.mode.CBC
          }).toString(CryptoJS.enc.Utf8);
          try {
            args[enargs[i]] = JSON.parse(args[enargs[i]]);
          } catch (e) { }
        }
      }
    }
  };
};

taskMsgAuthObj = new TaskMsgAuthClass();
taskMsgAuthObj.loadAuthData();