function createToc() {
	let bodyWidth = document.body.clientWidth;
	$("body").append("<div id='divTocList' style='position: absolute; z-index:9999; display:none;"
		+"top: 20px; right:20px; width:220px; border:1px solid #cccccc; background-color:#eeeeee;"
		+"padding-top:10px;padding-bottom:10px;flex-direction:column;align-items:flex-start;'></div>");

	$("#divTocList").append("<div style=\"font-size:12px; line-height:30px; padding-left:10px; "
		+"padding-right:10px;font-weight:bold; width:90%; border-bottom:1px solid #ccc; color:#333;text-align:center;\">内容索引</div>");

	parseNode($("body"));
	window.addEventListener('scroll',(event) => {
		let scrollTop = $("body").get(0).scrollTop;
		if(!scrollTop || scrollTop<0) scrollTop = 0;
		if($("#divTocList").height()>$("body").get(0).clientHeight) return;
		$("#divTocList").css("top", (scrollTop+20)+"px");
	});
	window.addEventListener('resize',(event) => {
		resizeToc();
	});
	resizeToc();
	$("img").each(function(){
		if($(this).width()>800) {
			$(this).parent().attr("align", "center");
			$(this).css("width", "800px");
			$(this).css("height", "auto");
		}
	});
}

function resizeToc() {
	let bodyWidth = document.body.clientWidth;
	if(bodyWidth<1080) {
	    $("#divTop").css("right", "0");
		$("#divTocList").hide();
		return;
	}
	$("#divTop").css("right", "240px");
	if($("#divTocList").children().length>1) $("#divTocList").css("display", "flex");
}

function getIndent(tagName) {
	let num = parseInt(tagName.substr(1));
	let indent = 10;
	for(let i=3;i<num;i++) {
		indent += 20;
	}
	return indent;
}

function gotoHead(headId) {
	$("body").get(0).scrollTop = $("#"+headId).offset().top;
}

function parseNode(node) {
	let tagName = node[0].tagName;
	var patt1 = new RegExp("^H[1-9]+$");
	if(tagName!="H1" && patt1.test(tagName)) {
		$("#divTocList").append("<div style=\"font-size:12px; line-height:30px; padding-left:"+getIndent(tagName)
			+"px; padding-right:10px;font-weight:bold; color:#666;cursor:pointer;\" "
			+"onclick=\"gotoHead('"+node.attr("id")+"')\">- "+node.text()+"</div>");
	}
	if(node.children().length>0) {
		for(var i=0;i<node.children().length;i++) {
			parseNode($(node.children()[i]));
		}
	}
}