/**
 * 获得URL中的指定参数的值
 * @param  {[type]} argName [description]
 * @return {[type]}         [description]
 */
function getUrlArg(argName) {
    var url = window.location.href;
    var start = url.indexOf("?");
    if (start < 0) return null;
    var str = url.substr(start + 1);
    var strArr = str.split("&");
    for (var i = 0; i < strArr.length; i++) {
        let aname = strArr[i].substr(0, strArr[i].indexOf("="));
        if (aname == argName) return decodeURIComponent(strArr[i].substr(strArr[i].indexOf("=") + 1));
    }
    return null;
};

/**
 * 该方法由TaskBuilder在主进程中调用，以便传输当前用户的身份信息
 * @return {[type]} [description]
 */
function openTFP() {
    const url = getUrlArg("url");
    if (!url) return;
    openWindow({ url });
}

/**
 * 打开页面
 * @param {Object} args 参数
 * @param {String} args.url 地址
 * @param {String} [args.title] 页面标题
 * @param {String | Function} [args.callback] 执行当前页面回调，配合invokeOpenerCallbackFunc扩展使用
 */
function openWindow(args) {
    const { url, title, callback } = args;
    if (!url) return;
    setTitle(title || '加载中', true);
    const divPhonePageContent = $('#divPhonePageContent');
    const pageUrl = url + (url.indexOf('?') > 0 ? '&_isDebug=true' : '?_isDebug=true');
    const iframe = $('<iframe>', {
        src: pageUrl,
        scrolling: 'auto',
        marginheight: '0',
        marginwidth: '0',
        frameborder: '0',
    }).on('load', function () {
        const iframeWindow = this.contentWindow;
        if (callback) {
            if (!top.tmClientCallBackNames) top.tmClientCallBackNames = [];
            top.tmClientCallBackNames.push(callback);
        }
        setTitle(title || iframeWindow.tfp.curPage.dataModel.title);
    });
    divPhonePageContent.find('iframe').hide();
    divPhonePageContent.append(iframe);
}

/**
 * 关闭当前页面
 */
function closeWindow() {
    const divPhonePageContent = $('#divPhonePageContent');
    if (divPhonePageContent.find('iframe').length <= 1) window.close();
    const thisIframe = getThisIframe();
    $(thisIframe).remove();
    const beforeIframe = getThisIframe();
    $(beforeIframe).show();
    const { title, menuInfo } = beforeIframe.dataset;
    if (title) setTitle(title);
    if (menuInfo) setMoreMenu(JSON.parse(menuInfo));
}

/**
 * 打开的页面关闭回调调用方法
 * @param {String} tmClientCallBackName 回调方法名称
 * @param {Any} arg 数据
 * @returns 
 */
function invokeCallback(tmClientCallBackName, arg) {
    top.closeWindow();
    if (typeof top[tmClientCallBackName] == "function") top[tmClientCallBackName](arg);

}

/**
 * 设置标题
 * @param {String} title 标题
 * @param {Boolean} [notCacheTitle] 不缓存标题
 */
function setTitle(title, notCacheTitle) {
    const thisIframe = getThisIframe();
    const divPhonePageTitle = $("#divPhonePageTitle .title");
    if (!notCacheTitle && thisIframe) thisIframe.dataset.title = title;
    divPhonePageTitle.text(title);
}

/**
 * 设置右上角的更多菜单
 * @param  {Object[]} menuInfo 菜单数组
 */
function setMoreMenu(menuInfo) {
    const thisIframe = getThisIframe();
    const thisWindow = getThisWindow();
    if (!Array.isArray(menuInfo) || !thisIframe || !thisWindow) return;
    thisIframe.dataset.menuInfo = JSON.stringify(menuInfo);
    if (menuInfo.length == 1) {
        const item = menuInfo[0];
        if (!item.text) return;
        $('#toolBtnRight').html(item.text).off('click').on('click', () => {
            if (item.jsStatement) top.eval(item.jsStatement);
        });
    }
    else {
        $('#toolBtnRight').html('<img src="./images/more.png">');
        $('#toolBtnRight').css('visibility', 'visible').off('click').on('click', showMoreMenu);
        $('.more-menu-popup-shade').off('click').on('click', hideMoreMenu);
        $('.more-menu-popup').empty();
        menuInfo.forEach((item) => {
            if (!item.text) return true;
            const _item = $('<div class="item"></div>').text(item.text).on('click', () => {
                if (item.jsStatement) top.eval(item.jsStatement);
                hideMoreMenu();
            });
            $('.more-menu-popup').append(_item);
        });
    }
}

/**
 * 显示更多菜单
 */
function showMoreMenu() {
    $('.more-menu-popup').show();
    $('.more-menu-popup-shade').show();
}

/**
 * 隐藏更多菜单
 */
function hideMoreMenu() {
    $('.more-menu-popup').hide();
    $('.more-menu-popup-shade').hide();
}

/**
 * 获取当前页面iframe对象
 * @returns {Window|Null}
 */
function getThisIframe() {
    const divPhonePageContent = $('#divPhonePageContent');
    const lastIframe = divPhonePageContent.find('iframe').last();
    if (lastIframe.length) return lastIframe[0];
    else return null;
}

/**
 * 获取当前页面window对象
 * @returns {Window|Null}
 */
function getThisWindow() {
    const thisIframe = getThisIframe();
    if (thisIframe) return thisIframe.contentWindow;
    else return null;
}

/**
 * 判断是否为Electron开发环境
 * @returns {boolean} 
 */
function isDev() {
    return window.navigator.userAgent.toString().indexOf("Electron") > 0;
}