/**
 * 系统选项卡页面
 */
function SysTabPage() {
    //本页面的ID
    this.id = null;
    //本页面的标题
    this.title = null;
    //本页面的URL路径
    this.url = null;
    //打开本页面的前置页面的window对象
    this.opener = null;
    //打开本页面的前置页面的页面ID
    this.openerPageId = null;
    //本页面的应用ID，只有从系统菜单里打开时才会有该属性
    this.appId = null;
    //本页面标题栏对应的jQuery对象
    this.tabTitleEl = null;
    //本页面内容区对应的jQuery对象
    this.tabPageEl = null;
    //显示本页面内容的iframe页的window对象
    this.contentWindow = null;

    this.init = function (options) {
        this.id = options.id;
        this.title = options.title;
        if(!this.title) this.title = "未命名";

        this.url = options.url;
        if (this.url.indexOf("/") != 0 && this.url.indexOf("../") != 0 && this.url.indexOf("http") != 0)
            this.url = "/" + this.url;

        this.opener = options.opener;

        let tabTitleWidth = 95;
        let titleLen = this.title.gblen();
        if (titleLen > 8 && titleLen < 11) tabTitleWidth = 110;
        if (titleLen > 10) tabTitleWidth = 120;
        let tabTitleHtml = "<div id=\"sysTab_" + this.id + "\" data-value=\"" + this.id+ "\" class=\"sys-tab-title\" "
            +"style=\"width:" + tabTitleWidth + "px; border-top:2px solid " + top.curMainThemeColor + "\">"
            + "  <label style=\"width:" + (tabTitleWidth - 35) + "px;font-weight:bold;\">" + this.title + "</label>"
            + "  <div><img title=\"关闭\" src=\"/app/sys/console/images/icons/close.png\" /></div></div>";
        $("#sysTabBar").append(tabTitleHtml);
        this.tabTitleEl = $("#sysTab_" + this.id);
        $("#panelPages").append("<div id=\"tabPage_" + this.id + "\" class=\"sys-tab-page\">"
            + "  <iframe id=\"tabPage_frame_" + this.id + "\" frameborder=\"0\" height=\"100%\" width=\"100%\" "
            + "marginheight=\"0\" marginwidth=\"0\" src=\"" + this.url + "\" scrolling=\"auto\"></iframe></div>");
        this.tabPageEl = $("#tabPage_" + this.id);
        this.contentWindow = this.tabPageEl.children("iframe").get(0).contentWindow;
        this.tabTitleEl.click(function () {
            let pageId = $(this).attr("data-value");
            showTabPage(pageId);
        });
        this.tabTitleEl.find("img").click(function () {
            let pageId = $(this).parent().parent().attr("data-value");
            closeTabPage(pageId);
            event.stopPropagation();
        });
    }

    this.gotoPage = function (url) {
        this.contentWindow.location = url;
    }

    this.reload = function () {
        this.contentWindow.location.reload();
    }

    this.setTitle = function (title) {
        this.tabTitleEl.children("label").text(title);
    }

    this.close = function () {
        top.closeTabPage(this.id);
    }

    this.show = function () {
        top.showTabPage(this.id);
    }

    this.hide = function () {
        top.hideTabPage(this.id);
    }
}