//对话框列表
var dialogList = {};
//当前z坐标
var curZIndex = 10000;
//当前对话框id
var curDialogId = 0;
//当前抽屉框，同时只能有一个
var curDrawer = null;
//是否在显示Toast
var isShowToast = false;
//是否在显示系统提示框
var isShowMsgHint = false;
//当前系统提示id
var curMsgHintId = 1;
//消息提示回调函数列表
var msgHintCbList = {};
//当前获得焦点的对话框按钮
var curDialogFocusButton = null;

(function ($) {
    //拖拽插件,参数:id或object
    $.MoveDialog = function (_this) {
        if (typeof (_this) == 'object') {
            _this = _this;
        } else {
            _this = $("#" + _this);
        }
        if (!_this) { return false; }

        _this.css({ 'position': 'fixed' }).hover(function () { $(this).css("cursor", "move"); }, function () { $(this).css("cursor", "default"); })
        _this.mousedown(function (e) {//e鼠标事件
            var offset = $(this).offset();
            var x = e.pageX - offset.left;
            var y = e.pageY - offset.top;
            _this.css({ 'box-shadow': '' });
            //_this.css({ 'opacity': '0.3' });
            $(document).bind("mousemove", function (ev) {//绑定鼠标的移动事件，因为光标在DIV元素外面也要有效果，所以要用doucment的事件，而不用DIV元素的事件
                _this.bind('selectstart', function () { return false; });
                var _x = ev.pageX - x;//获得X轴方向移动的值
                var _y = ev.pageY - y;//获得Y轴方向移动的值
                _this.css({ 'left': _x + "px", 'top': _y + "px" });
            });
        });

        $(document).mouseup(function () {
            $(this).unbind("mousemove");
            _this.css({ 'opacity': '', 'box-shadow': '3px 3px 10px 0px #666' });
        })
    };
})(jQuery);

//初始化页面
$(function() {
    //添加遮罩层
    $("body").append("<div id=\"divMask\"></div>");
    $("body").append("<div id=\"divImageViewer\"><img src=\"/app/sys/console/images/icons/close32-white.png\" title=\"关闭\" onclick=\"closeImageViewer()\">"
      +"<iframe frameborder=\"0\" height=\"100%\" width=\"100%\" class=\"frameForm\" marginheight=\"0\" "
      +"marginwidth=\"0\" src=\"\" scrolling=\"auto\"></iframe></div>");
    $("body").append("<div id=\"divToast\"></div>");
    $("body").append(
        `<div tabindex="-1" id="divSysHint">
            <div class="sys-hint-title">
                <label>提示</label>
                <img src="/app/sys/console/images/icons/close.png" title="关闭" onclick="closeSysHint(false)" />
            </div>
            <div class="sys-hint-top">
                <div class="sys-hint-icon" >
                    <img src="/app/sys/console/images/icons/hint.png" >
                </div>
                <div class="sys-hint-content" >
                    <pre id="sysHintContent"></pre>
                </div>
            </div>
            <div class="sys-hint-bottom">
                <input type="button" id="buttonSysHintOK" style="background-color:var(--sys-theme-color);color:#ffffff;outline:0;border:0;border-radius:4px;width:56px;height:28px;line-height:26px;" onclick="closeSysHint(true)" value="确定">
                <input type="button" id="buttonSysHintCancel" style="display:none;margin-left:10px;background-color:#CCCCCC;color:#666666;outline:0;border:0;border-radius:4px;width:56px;height:28px;line-height:26px;" onclick="closeSysHint(false)" value="取消">
            </div>
        </div>`);
});

function getMainThemeColor() {
    var mainThemeColor = "#6666FF";
    if(localStorage.getItem("TaskAdminMainThemeColor")) {
        mainThemeColor = localStorage.getItem("TaskAdminMainThemeColor");
    } else {
        try {
            if(top.local.theme.color.theme_color) mainThemeColor = top.local.theme.color.theme_color;
        } catch(err) {
            //
        }
    }
    return mainThemeColor;
}

function gblen(str) {
    var len = 0;
    for (var i = 0; i < str.length; i++) {
        if (str.charCodeAt(i) > 127 || str.charCodeAt(i) == 94) {
            len += 2;
        } else {
            len++;
        }
    }
    return len;
}

function showMask() {
    let h = document.documentElement.clientHeight;
    let h2 = document.documentElement.scrollHeight;
    if(h<h2) {
        h = h2;
        $("#divMask").css("bottom", "");
        $("#divMask").css("height", h+"px");
    } else {
        $("#divMask").css("bottom", "0");
        $("#divMask").css("height", "");
    }
    let w = document.documentElement.clientWidth;
    let w2 = document.documentElement.scrollWidth;
    if(w<w2) {
        w = w2;
        $("#divMask").css("right", "");
        $("#divMask").css("width", w+"px");
    } else {
        $("#divMask").css("right", "0");
        $("#divMask").css("width", "");
    }
    $("#divMask").show();
}

/**
 * 显示提示信息
 * @param {*} msg 
 * @param {*} cb 
 * @returns 
 */
function showMsg(msg , cb) {
    if(isShowMsgHint) return;
    isShowMsgHint = true;
    curMsgHintId++;
    if(cb) msgHintCbList[curMsgHintId] = cb;
    $("#sysHintContent").html(msg);
    let top = (document.documentElement.clientHeight - $("#divSysHint").height())/2;
    if(top<0) top = 0;
    $("#divSysHint").css("top", top+"px");
    var left = (document.documentElement.clientWidth - $("#divSysHint").width())/2;
    if(left<0) left = 0;
    $("#divMask").css("z-index", 99999);
    showMask();
    let curMainThemeColor = getMainThemeColor();
    $("#buttonSysHintOK").css("background-color", curMainThemeColor);
    $("#buttonSysHintOK").css("border-color", curMainThemeColor);
    $("#buttonSysHintCancel").hide();
    $("#divSysHint").css("left", left+"px");
    $("#divSysHint").show();
    setTimeout(()=>{
        $("#buttonSysHintOK").focus();
    }, 100);
}

function topPageOnKeyDown() {
    if(event.keyCode==37) {
        if(curDialogFocusButton!="OK") {
            $("#buttonSysHintOK").css("outline", "1px solid #0066ff"); 
            $("#buttonSysHintCancel").css("outline", "0"); 
            $("#buttonSysHintOK").focus();
            curDialogFocusButton = "OK";
        }
    } else if(event.keyCode==39) {
        if(curDialogFocusButton=="OK") {
            $("#buttonSysHintOK").css("outline", "0"); 
            $("#buttonSysHintCancel").css("outline", "1px solid #0066ff"); 
            $("#buttonSysHintCancel").focus();
            curDialogFocusButton = "CANCEL";
        }
    }
}

/**
 * 显示确认对话框
 * @param {*} msg 
 * @param {*} cb 
 * @returns 
 */
function showConfirm(msg , cb) {
    if(isShowMsgHint) return;
    isShowMsgHint = true;
    curMsgHintId++;
    if(cb) msgHintCbList[curMsgHintId] = cb;
    $("#sysHintContent").html(msg);
    let top = (document.documentElement.clientHeight-$("#divSysHint").height())/2;
    if(top<0) top = 0;
    $("#divSysHint").css("top", top+"px");
    var left = (document.documentElement.clientWidth-$("#divSysHint").width())/2;
    if(left<0) left = 0;
    $("#divMask").css("z-index", 99999);
    showMask();
    //$("#divMask").show();
    let curMainThemeColor = getMainThemeColor();
    $("#buttonSysHintOK").css("background-color", curMainThemeColor);
    $("#buttonSysHintOK").css("border-color", curMainThemeColor);
    $("#buttonSysHintOK").css("outline", "1px solid #0066ff"); 
    $("#buttonSysHintCancel").css("outline", "0"); 
    $("#buttonSysHintCancel").show();
    $("#divSysHint").css("left", left+"px");
    $("#divSysHint").show();
    curDialogFocusButton = "OK";
    document.addEventListener("keydown", topPageOnKeyDown);
    setTimeout(()=>{
        $("#buttonSysHintOK").focus();
    }, 100);

}

/**
 * 关闭系统提示框
 * @param {*} ret 
 */
function closeSysHint(ret) {
    //如果是在抽屉页或对话框中弹出提示框，则关闭提示框时，不要隐藏遮罩层
    if(curDialogId) {
        $("#divMask").css("z-index", parseInt(curDialogId.replace("dialog_", ""))-1);
    } else if(curDrawer) {
        $("#divMask").css("z-index", curDrawer.css("zIndex")-1);
    } else {
        $("#divMask").css("z-index", 999);
        $("#divMask").hide();
    }
    $("#sysHintContent").html("");
    $("#divSysHint").hide();
    isShowMsgHint = false;
    if(curDialogFocusButton) {
        document.removeEventListener("keydown", topPageOnKeyDown);
        curDialogFocusButton = null;
    }
    let cb = msgHintCbList[curMsgHintId];
    if(cb) {
        delete msgHintCbList[curMsgHintId];
        cb(ret);
        cb = null;
    }
}

/**
 * 显示自动隐藏的提示
 * @param {*} msg 
 * @returns 
 */
function showToast(msg) {
  $("#divToast").html(msg);
  if(isShowToast) return;
  isShowToast = true;
  $("#divToast").show();

  setTimeout(function() {
    $("#divToast").hide();
    isShowToast = false; 
  }, 3000);
}

function showImageViewer(url) {
    curZIndex++;
    $("#divImageViewer").css("zIndex", curZIndex);
    curZIndex++;
    $("#divImageViewer").find("iframe").attr("src", url);
    $("#divImageViewer").show();
}

function closeImageViewer() {
    $("#divImageViewer").hide();
    $("#divImageViewer").find("iframe").attr("src", "");
}

/**
 * 获得对话框html模板
 * @returns 
 */
function getNewDialog() {
    return $(
        `<div class="divDialog">
            <div class="divDialogHeader">
                <div class="divDialogTitle"></div>
                <div class="divDialogClose" title="关闭">
                    <img src="/app/sys/console/images/icons/close.png" style="margin:4px; cursor: pointer;" title="关闭">
                </div>
            </div>
            <div class="divDialogContent">
                <iframe frameborder="0" height="100%" width="100%" class="frameForm" marginheight="0" marginwidth="0" src="" scrolling="auto"></iframe>
            </div>
        </div>`);
}

/**
 * 获得相对父窗口的URL路径
 */
function getUrlByOpener(opener, url) {
    if (!url) return null;
    if (url.indexOf(":/") > 0 || url.indexOf("/") == 0) return url;

    //下面这行代码是为了兼容一些老的系统，原来只支持绝对路径，不是/开头会自动加/
    //将来可能不再支持这种方式
    if (url.indexOf("app/") == 0) return "/" + url;

    let openerPath = opener.location.pathname;
    //如果是TaskBuilder内打开页面
    if (openerPath.indexOf("/resources/app/node_modules/") > 0) return url;
    openerPath = openerPath.substr(0, openerPath.lastIndexOf("/"));
    if (url.indexOf("../") == 0) {
        let arrPath = openerPath.substr(1).split("/");
        let urlTmp = url;
        let pathIndex = 0;
        while (urlTmp.indexOf("../") == 0) {
            if (arrPath.length == 0) break;
            arrPath.length = arrPath.length - 1;
            if (urlTmp.length == 3) break;
            urlTmp = urlTmp.substr(3);
        }
        let urlDest = "/";
        if (arrPath.length > 0) urlDest += arrPath.join("/");
        if(!urlDest.endsWith("/")) urlDest += "/";
        urlDest += urlTmp;
        url = urlDest;
    } else if(openerPath.indexOf("/node_modules/taskbuilder-")>=0 
        && url.indexOf("taskbuilder-")==0) {
        url = "/node_modules/"+url;
    } else {
        url = openerPath + "/" + url;
    }
    return url;
}

/**
 * 获得像素的整数值
 * @param {*} value 
 * @returns 
 */
function getPx(value) {
    if (this.isNull(value)) return 0;
    return parseInt(new String(value + "").replace("px", ""));
}

/**
	 * 是否是对象，不包括null、数组
	 * @param {*} obj 
	 * @returns 
	 */
function isObj(obj) {
    return typeof(obj) == "object" && Object.prototype.toString.call(obj).toLowerCase() == "[object object]" && !obj.length;
}

/**
 * 打开对话框
 * @param {*} title 
 * @param {*} url 
 * @param {*} width 
 * @param {*} height 
 * @param {*} srcElement 
 * @param {*} opener 
 * @param {*} args 
 * @param {*} cb 
 * @returns 
 */
function openDialog(title, url, width, height, srcElement, opener, args, cb) {
    if (arguments.length == 0) {
        showToast("请提供必要的参数！");
        return;
    }
    let options;
    if (arguments.length == 1) {
        options = arguments[0];
        if (!isObj(options)) {
            showToast("请提供正确的参数！");
            return;
        }
    } else {
        options = {};
        options.title = arguments[0];
        options.url = arguments[1];
        if (arguments.length > 2) options.width = arguments[2];
        if (arguments.length > 3) options.height = arguments[3];
        if (arguments.length > 4) options.srcElement = arguments[4];
        if (arguments.length > 5) options.opener = arguments[5];
        if (arguments.length > 6) options.args = arguments[6];
        if (arguments.length > 7) options.cb = arguments[7];
    }
    if (!options.url) {
        showToast("请设置窗口URL路径！");
        return;
    }
    //克隆对话框模板
    var dialog = getNewDialog();
    //设置遮罩层z坐标
    $("#divMask").css("zIndex", curZIndex);
    curZIndex++;
    //id
    curDialogId = "dialog_" + curZIndex;
    curZIndex++;
    dialog.id = curDialogId;
    dialog.attr("id", curDialogId);
    dialog.css("zIndex", curZIndex);
    if(options.fullScreen) {
        setDialogFullScreen(dialog);
    } else {
        //宽度
        let _width = options.width;
        if (!_width) _width = "480px";
        if (_width && (_width + "").indexOf("px") < 0 && (_width + "").indexOf("%") < 0) _width += "px";
        dialog.css("width", _width);
        //高度
        let _height = options.height;
        if (!_height) _height = "320px";
        if (_height && (_height + "").indexOf("px") < 0 && (_height + "").indexOf("%") < 0) _height += "px";
        dialog.css("height", _height);
        //纵坐标
        let top = (document.documentElement.clientHeight - getPx(_height)) / 2;
        if (top < 0) top = 0;
        if (options.top || options.top == 0) top = options.top;
        dialog.css("top", top + "px");
        //横坐标
        var left = (document.documentElement.clientWidth - getPx(_width)) / 2;
        if (left < 0) left = 0;
        if (options.left || options.left == 0) left = options.left;
        dialog.css("left", left + "px");
    }
    //标题
    if(options.hideTitle) {
        dialog.find(".divDialogTitle").hide();
        dialog.find(".divDialogContent").css("padding-top", 0);
    } else {
        title = "";
        if (options.title) title = options.title;
        dialog.find(".divDialogTitle").text(title);
    }
    //隐藏关闭按钮
    if (options.hideCloseButton) dialog.find(".divDialogClose").hide();

    dialog.appendTo("body");
    showMask();
    dialog.show();
    //dialog.animate({ height: _height });

    dialog.fullScreen = function() {
        setDialogFullScreen(dialog);
    };

    //设置对话框可以拖拽移动
    if (!options.disableMove) $.MoveDialog(dialog);

    //解析对话框url路径，支持绝对路径和相对路径
    options.url = getUrlByOpener(options.opener, options.url);
    //原来通过top.curDialogId得到的当前对话框id是最后打开的对话框的id
    //如果打开了多个对话框，并关闭了后打开的，则再通过这个函数获得的当前对话框id就不对了
    //为此，在url内附加当前对话框的id，以便在对话框中获取
    if (options.url.indexOf("?") < 0) {
        options.url += "?";
    } else {
        options.url += "&";
    }
    options.url += "_curDialogId=" + curDialogId;
    //如果是在tb中预览，则加上调试标志，让任擎编译tfp页面时不压缩代码，以便调试
    let thisPagePath = location.pathname;
    if(thisPagePath.indexOf("/dev/pc/console.html")>=0) {
        if (options.url.indexOf("?") < 0) {
            options.url += "?";
        } else {
            options.url += "&";
        }
        options.url += "&_isDebug=true";
    }
    console.log(options.url);
    dialog.find("iframe").attr("src", options.url);

    //if(icon) {
    //if(icon.indexOf("http:")<0 && icon.indexOf("/")!=0) icon = "/"+icon;
    //dialog.find("div.divFormIcon").css("backgroundImage", "url("+icon+")");
    //}

    if (options.srcElement) dialog.srcElement = $(options.srcElement);
    if (options.opener) dialog.opener = options.opener;
    if (options.args) {
        dialog.args = options.args;
        /*if (typeof (options.args) == "string") {
            sessionStorage.setItem("_OpenDialogArgs", options.args);
        } else {
            sessionStorage.setItem("_OpenDialogArgs", JSON.stringify(options.args));
        }*/
    }
    if (options.cb) dialog.cb = options.cb;
    dialogList[curDialogId] = dialog;
    dialog.show();

    dialog.find(".divDialogClose").click(function () {
        let dialogId = $(this).parent().parent().attr("id");
        let dialogTmp = dialogList[dialogId];
        if (dialogTmp) {
            //如果是打开的外部系统页面，会出现跨域错误，导致无法关闭，需要捕获例外
            try {
                let winFrame = dialogTmp.find("iframe").get(0).contentWindow;
                if (winFrame && winFrame.tfp) {
                    let cptFramePage = winFrame.tfp.curPage;
                    if (cptFramePage && cptFramePage.dataModel.onClose) {
                        try {
                            winFrame.eval(cptFramePage.dataModel.onClose);
                        } catch (err) {
                            console.log(err);
                        }
                    }
                }
            } catch(e) {}
        }
        closeDialog(dialogId);
    });
}

/**
 * 关闭对话框
 * @param {*} dialogId 
 * @returns 
 */
function closeDialog(dialogId) {
    let dialog = dialogList[dialogId];
    if (!dialog) return;
    delete dialogList[dialogId];
    $("#" + dialogId).remove();

    if (curDialogId != dialogId) return;

    let maxDialogId = "";
    let maxZIndex = 0;
    for (id in dialogList) {
        let zIndex = $("#" + id).css("z-index");
        if (zIndex > maxZIndex) {
            maxZIndex = zIndex;
            maxDialogId = id;
        }
    }
    if (maxDialogId != "") {
        curDialogId = maxDialogId;
        $("#divMask").css("z-index", maxZIndex - 1);
    } else if(curDrawer) {  //如果有抽屉式对话框没有关闭，则显示该对话框
        curDialogId = null;
        $("#divMask").css("z-index", curDrawer.css("zIndex")-1);
    } else {
        $("#divMask").hide();
        $("#divMask").css("z-index", "10000");
        curDialogId = null;
    }
}

function setDialogFullScreen(dialog) {
    dialog.css("width", document.documentElement.clientWidth+"px");
    dialog.css("height", document.documentElement.clientHeight+"px");
    dialog.css("top", "0");
    dialog.css("left", "0");
    dialog.css("bottom", "0");
    dialog.css("right", "0");
}

/**
 * 获得指定id的对话框
 * @param {*} id 
 * @returns 
 */
function getDialog(id) {
    return dialogList[id];
}

/**
 * 下面这些方法都被淘汰了，因为这些方法里所说的当前对话框有歧义
 * 并不是指调用这些方法的代码所在页面的对话框，而是指最后打开的对话框
 * 但为了兼容老版本的页面，暂时保留这些方法
*/

function closeCurDialog() {
    closeDialog(curDialogId);
}

function getCurDialog() {
    return dialogList[curDialogId];
}

function getDialogArgs() {
    return getCurDialog().args;
}

function getCurDialogId() {
    return curDialogId;
}

function onDialogOK(ret) {
    let curDialog = getCurDialog();
    if (curDialog && curDialog.cb) curDialog.cb(ret);
}

/**
 * 获得抽屉框html模板
 * @returns 
 */
function getNewDrawer() {
    let curMainThemeColor = getMainThemeColor();
    return $(
        `<div class="divDrawer">
            <div class="divDrawerHeader">
                <img class="divDrawerIcon" src="/app/sys/console/images/icons/edit.png" />
                <div class="divDrawerTitle"></div>
                <div class="divDrawerButtons">
                    <div class="divDrawerButtonOK" style="background-color:${curMainThemeColor};border-color:${curMainThemeColor};">确定</div>
                    <div class="divDrawerButtonCancel">关闭</div>
                </div>
                <div class="divDrawerClose" title="关闭">
                    <img src="/app/sys/console/images/icons/close.png" style="margin:4px; cursor: pointer;" title="关闭">
                </div>
            </div>
            <div class="divDrawerContent">
                <iframe frameborder="0" height="100%" width="100%" class="frameForm" marginheight="0" marginwidth="0" src="" scrolling="auto"></iframe>
            </div>
        </div>`);
}

/**
 * 打开抽屉框
 * @param {*} title 
 * @param {*} url 
 * @param {*} width 
 * @param {*} srcElement 
 * @param {*} opener 
 * @param {*} args 
 * @param {*} cb 
 * @returns 
 */
function openDrawer(title, url, srcElement, opener, args, cb) {
    if(curDrawer) {
        showToast("不支持同时显示多个抽屉式对话框！");
        return;
    }
    if(curDialogId) {
        showToast("有弹出对话框显示时，不支持再显示抽屉式对话框！");
        return;
    }
    if (arguments.length == 0) {
        showToast("请提供必要的参数！");
        return;
    }
    let options;
    if (arguments.length == 1) {
        options = arguments[0];
        if (!isObj(options)) {
            showToast("请提供正确的参数！");
            return;
        }
    } else {
        options = {};
        options.title = arguments[0];
        options.url = arguments[1];
        if (arguments.length > 2) options.srcElement = arguments[2];
        if (arguments.length > 3) options.opener = arguments[3];
        if (arguments.length > 4) options.args = arguments[4];
        if (arguments.length > 5) options.cb = arguments[5];
    }
    if (!options.url) {
        showToast("请设置抽屉框页面URL路径！");
        return;
    }
    //克隆抽屉框模板
    curDrawer = getNewDrawer();
    //设置遮罩层z坐标
    $("#divMask").css("zIndex", curZIndex);
    curZIndex++;
    //id
    let curDrawerId = "drawer_" + curZIndex;
    curZIndex++;
    curDrawer.id = curDrawerId;
    curDrawer.attr("id", curDrawerId);
    curDrawer.css("zIndex", curZIndex);
    //宽度
    let _width = options.width;
    if (!_width) _width = "960px";
    if (_width && (_width + "").indexOf("px") < 0 && (_width + "").indexOf("%") < 0) _width += "px";
    curDrawer.css("width", _width);
    curDrawer.css("right", "-"+_width);
    //标题
    title = "";
    if (options.title) title = options.title;
    curDrawer.find(".divDrawerTitle").text(title);
    curDrawer.closeOnClickMask = true;
    //是否隐藏确定按钮
    let hideOKButton = false;
    if(options.hideOKButton) hideOKButton = true; 
    //如果设置了回调函数，则显示确定按钮，则将关闭按钮改成取消
    if (!hideOKButton && options.cb) {
        curDrawer.find(".divDrawerButtonCancel").html("取消");
        curDrawer.closeOnClickMask = false;
    }

    if(options.okButtonText) curDrawer.find(".divDrawerButtonOK").html(options.okButtonText);
    if(options.exButtons) {
        for(let i=0;i<options.exButtons.length;i++) {
            let exButton = options.exButtons[i];
            let buttonHtml = "<div style=\"";
            if(exButton.bgColor) buttonHtml += "background-color:"+exButton.bgColor+";border:1px solid "+exButton.bgColor+";"
            if(exButton.color) buttonHtml += "color:"+exButton.color+";"
            buttonHtml += "\" class=\"exbutton-"+i+"\">"+exButton.text+"</div>";
            $(buttonHtml).insertBefore(curDrawer.find(".divDrawerButtonOK")).click(function() {
                if(exButton.onClick) {
                    //如果是打开的外部系统页面，会出现跨域错误，导致无法关闭，需要捕获例外
                    try {
                        let winFrame = curDrawer.find("iframe").get(0).contentWindow;
                        exButton.onClick(winFrame);
                    } catch(e) {}
                }
            });
        }
    }

    curDrawer.appendTo("body");
    showMask();

    //解析抽屉框url路径，支持绝对路径和相对路径
    options.url = getUrlByOpener(options.opener, options.url);
    //如果是在tb中预览，则加上调试标志，让任擎编译tfp页面时不压缩代码，以便调试
    let thisPagePath = location.pathname;
    if (options.url.indexOf("?") < 0) {
        options.url += "?";
    } else {
        options.url += "&";
    }
    //通过_isDrawer参数告诉打开的页面，是以抽屉页形式打开的
    options.url += "_isDrawer=true";
    if(thisPagePath.indexOf("/dev/pc/console.html")>=0) {
        options.url += "&_isDebug=true";
    }
    curDrawer.find("iframe").attr("src", options.url);

    if (options.srcElement) curDrawer.srcElement = $(options.srcElement);
    if (options.opener) curDrawer.opener = options.opener;
    if (options.args) curDrawer.args = options.args;
    if (options.closeOnClickMask || options.closeOnClickMask == false) curDrawer.closeOnClickMask = options.closeOnClickMask;

    if(!hideOKButton) {
        curDrawer.find(".divDrawerButtonOK").show();
    }
    if(!hideOKButton && options.cb) {
        curDrawer.cb = options.cb;
        curDrawer.find(".divDrawerButtonOK").click(function () {
            //如果是打开的外部系统页面，会出现跨域错误，导致无法关闭，需要捕获例外
            try {
                let winFrame = curDrawer.find("iframe").get(0).contentWindow;
                curDrawer.cb(winFrame);
            } catch(e) {}
        });
    }

    curDrawer.find(".divDrawerButtonCancel").click(function () {
        closeDrawer();
    });

    curDrawer.animate({ right: 0 });

    if(curDrawer.closeOnClickMask) {
        $("#divMask").bind("click", function() {
            closeDrawer();
        });
    }
}

/**
 * 关闭抽屉框
 * @param {*} drawerId 
 * @returns 
 */
function closeDrawer() {
    curDrawer.animate({right: "-"+curDrawer.css("width")}, function() {
        curDrawer.remove();
        $("#divMask").hide();
        $("#divMask").css("z-index", "10000");
        $("#divMask").unbind("click");
        //如果是打开的外部系统页面，会出现跨域错误，导致无法关闭，需要捕获例外
        try {
            let winFrame = curDrawer.find("iframe").get(0).contentWindow;
            if (winFrame && winFrame.tfp) {
                let cptFramePage = winFrame.tfp.curPage;
                if (cptFramePage && cptFramePage.dataModel.onClose) {
                    try {
                        winFrame.eval(cptFramePage.dataModel.onClose);
                    } catch (err) {
                        console.log(err);
                    }
                }
            }
        } catch(e) {}
        curDrawer = null;
    });
}

/**
 * 动态加载JS
 * @param {string} url 脚本地址
 * @param {function} callback  回调函数
 */
function dynamicLoadJs(url, cb) {
    var head = document.getElementsByTagName('head')[0];
    var script = document.createElement('script');
    script.type = 'text/javascript';
    script.src = url;
    if (typeof (cb) == 'function') {
        script.onload = script.onreadystatechange = function () {
            if (!this.readyState || this.readyState === "loaded" || this.readyState === "complete") {
                cb();
                script.onload = script.onreadystatechange = null;
            }
        };
    }
    head.appendChild(script);
}

/**
* 动态加载CSS
* @param {string} url 样式地址
*/
function dynamicLoadCss(url) {
    var head = document.getElementsByTagName('head')[0];
    var link = document.createElement('link');
    link.type = 'text/css';
    link.rel = 'stylesheet';
    link.href = url;
    head.appendChild(link);
}