import { ICrypto, SignedHttpRequestParameters } from "./ICrypto";
/**
 * See eSTS docs for more info.
 * - A kid element, with the value containing an RFC 7638-compliant JWK thumbprint that is base64 encoded.
 * -  xms_ksl element, representing the storage location of the key's secret component on the client device. One of two values:
 *      - sw: software storage
 *      - uhw: hardware storage
 */
declare type ReqCnf = {
    kid: string;
    xms_ksl: KeyLocation;
};
declare enum KeyLocation {
    SW = "sw",
    UHW = "uhw"
}
export declare class PopTokenGenerator {
    private cryptoUtils;
    constructor(cryptoUtils: ICrypto);
    generateCnf(request: SignedHttpRequestParameters): Promise<string>;
    generateKid(request: SignedHttpRequestParameters): Promise<ReqCnf>;
    signPopToken(accessToken: string, request: SignedHttpRequestParameters): Promise<string>;
    signPayload(payload: string, kid: string, request: SignedHttpRequestParameters, claims?: object): Promise<string>;
}
export {};
//# sourceMappingURL=PopTokenGenerator.d.ts.map