/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
import { KeyCreateParameters as KeyCreateParametersMapper, KeyImportParameters as KeyImportParametersMapper, KeyUpdateParameters as KeyUpdateParametersMapper, KeyRestoreParameters as KeyRestoreParametersMapper, KeyOperationsParameters as KeyOperationsParametersMapper, KeySignParameters as KeySignParametersMapper, KeyVerifyParameters as KeyVerifyParametersMapper } from "../models/mappers";
export const contentType = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
export const accept = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
export const kty = {
    parameterPath: "kty",
    mapper: KeyCreateParametersMapper
};
export const keySize = {
    parameterPath: ["options", "keySize"],
    mapper: KeyCreateParametersMapper
};
export const publicExponent = {
    parameterPath: ["options", "publicExponent"],
    mapper: KeyCreateParametersMapper
};
export const keyOps = {
    parameterPath: ["options", "keyOps"],
    mapper: KeyCreateParametersMapper
};
export const keyAttributes = {
    parameterPath: ["options", "keyAttributes"],
    mapper: KeyCreateParametersMapper
};
export const tags = {
    parameterPath: ["options", "tags"],
    mapper: KeyCreateParametersMapper
};
export const curve = {
    parameterPath: ["options", "curve"],
    mapper: KeyCreateParametersMapper
};
export const vaultBaseUrl = {
    parameterPath: "vaultBaseUrl",
    mapper: {
        serializedName: "vaultBaseUrl",
        required: true,
        type: {
            name: "String"
        }
    },
    skipEncoding: true
};
export const keyName = {
    parameterPath: "keyName",
    mapper: {
        constraints: {
            Pattern: new RegExp("^[0-9a-zA-Z-]+$")
        },
        serializedName: "key-name",
        required: true,
        type: {
            name: "String"
        }
    }
};
export const apiVersion = {
    parameterPath: "apiVersion",
    mapper: {
        serializedName: "api-version",
        required: true,
        type: {
            name: "String"
        }
    }
};
export const hsm = {
    parameterPath: ["options", "hsm"],
    mapper: KeyImportParametersMapper
};
export const key = {
    parameterPath: "key",
    mapper: KeyImportParametersMapper
};
export const keyAttributes1 = {
    parameterPath: ["options", "keyAttributes"],
    mapper: KeyImportParametersMapper
};
export const tags1 = {
    parameterPath: ["options", "tags"],
    mapper: KeyImportParametersMapper
};
export const keyName1 = {
    parameterPath: "keyName",
    mapper: {
        serializedName: "key-name",
        required: true,
        type: {
            name: "String"
        }
    }
};
export const keyOps1 = {
    parameterPath: ["options", "keyOps"],
    mapper: KeyUpdateParametersMapper
};
export const keyAttributes2 = {
    parameterPath: ["options", "keyAttributes"],
    mapper: KeyUpdateParametersMapper
};
export const tags2 = {
    parameterPath: ["options", "tags"],
    mapper: KeyUpdateParametersMapper
};
export const keyVersion = {
    parameterPath: "keyVersion",
    mapper: {
        serializedName: "key-version",
        required: true,
        type: {
            name: "String"
        }
    }
};
export const maxresults = {
    parameterPath: ["options", "maxresults"],
    mapper: {
        constraints: {
            InclusiveMaximum: 25,
            InclusiveMinimum: 1
        },
        serializedName: "maxresults",
        type: {
            name: "Number"
        }
    }
};
export const keyBundleBackup = {
    parameterPath: "keyBundleBackup",
    mapper: KeyRestoreParametersMapper
};
export const algorithm = {
    parameterPath: "algorithm",
    mapper: KeyOperationsParametersMapper
};
export const value = {
    parameterPath: "value",
    mapper: KeyOperationsParametersMapper
};
export const iv = {
    parameterPath: ["options", "iv"],
    mapper: KeyOperationsParametersMapper
};
export const additionalAuthenticatedData = {
    parameterPath: ["options", "additionalAuthenticatedData"],
    mapper: KeyOperationsParametersMapper
};
export const authenticationTag = {
    parameterPath: ["options", "authenticationTag"],
    mapper: KeyOperationsParametersMapper
};
export const algorithm1 = {
    parameterPath: "algorithm",
    mapper: KeySignParametersMapper
};
export const value1 = {
    parameterPath: "value",
    mapper: KeySignParametersMapper
};
export const algorithm2 = {
    parameterPath: "algorithm",
    mapper: KeyVerifyParametersMapper
};
export const digest = {
    parameterPath: "digest",
    mapper: KeyVerifyParametersMapper
};
export const signature = {
    parameterPath: "signature",
    mapper: KeyVerifyParametersMapper
};
export const nextLink = {
    parameterPath: "nextLink",
    mapper: {
        serializedName: "nextLink",
        required: true,
        type: {
            name: "String"
        }
    },
    skipEncoding: true
};
//# sourceMappingURL=parameters.js.map