// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
import { createEmptyPipeline } from "./pipeline";
import { decompressResponsePolicy } from "./policies/decompressResponsePolicy";
import { formDataPolicy } from "./policies/formDataPolicy";
import { logPolicy } from "./policies/logPolicy";
import { proxyPolicy } from "./policies/proxyPolicy";
import { redirectPolicy } from "./policies/redirectPolicy";
import { setClientRequestIdPolicy } from "./policies/setClientRequestIdPolicy";
import { tracingPolicy } from "./policies/tracingPolicy";
import { userAgentPolicy } from "./policies/userAgentPolicy";
import { defaultRetryPolicy } from "./policies/defaultRetryPolicy";
import { isNode } from "./util/helpers";
/**
 * Create a new pipeline with a default set of customizable policies.
 * @param options - Options to configure a custom pipeline.
 */
export function createPipelineFromOptions(options) {
    const pipeline = createEmptyPipeline();
    if (isNode) {
        pipeline.addPolicy(proxyPolicy(options.proxyOptions));
        pipeline.addPolicy(decompressResponsePolicy());
    }
    pipeline.addPolicy(formDataPolicy());
    pipeline.addPolicy(userAgentPolicy(options.userAgentOptions));
    pipeline.addPolicy(setClientRequestIdPolicy());
    pipeline.addPolicy(defaultRetryPolicy(options.retryOptions), { phase: "Retry" });
    pipeline.addPolicy(tracingPolicy(options.userAgentOptions), { afterPhase: "Retry" });
    pipeline.addPolicy(redirectPolicy(options.redirectOptions), { afterPhase: "Retry" });
    pipeline.addPolicy(logPolicy(options.loggingOptions), { afterPhase: "Retry" });
    return pipeline;
}
//# sourceMappingURL=createPipelineFromOptions.js.map